"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtNetwork, except for defaults which are replaced by "...".
"""
from enum import Enum
from typing import List, Union, overload
import PySide6.QtCore
import PySide6.QtNetwork

bytes = str


class QNetworkCookie(object):
    """
    https://doc.qt.io/qt-6/qnetworkcookie.html

    **Detailed Description**

    Cookies are small bits of information that stateless protocols like HTTP use
    to maintain some persistent information across requests.

    A cookie is set by a remote server when it replies to a request and it
    expects the same cookie to be sent back when further requests are sent.

    QNetworkCookie holds one such cookie as received from the network. A cookie
    has a name and a value, but those are opaque to the application (that is,
    the information stored in them has no meaning to the application). A cookie
    has an associated path name and domain, which indicate when the cookie
    should be sent again to the server.

    A cookie can also have an expiration date, indicating its validity. If the
    expiration date is not present, the cookie is considered a "session cookie"
    and should be discarded when the application exits (or when its concept of
    session is over).

    QNetworkCookie provides a way of parsing a cookie from the HTTP header
    format using the **QNetworkCookie::parseCookies** () function. However, when
    received in a **QNetworkReply** , the cookie is already parsed.

    This class implements cookies as described by the **initial cookie
    specification by Netscape** , which is somewhat similar to the **RFC 2109**
    specification, plus the **"HttpOnly" extension** . The more recent **RFC
    2965**  specification (which uses the Set-Cookie2 header) is not supported.

    **See also** **QNetworkCookieJar** , **QNetworkRequest** , and
    **QNetworkReply** .
    """

    NameAndValueOnly: QNetworkCookie.RawForm = ...
    Full: QNetworkCookie.RawForm = ...

    class RawForm(Enum):
        NameAndValueOnly: QNetworkCookie.RawForm = ...
        Full: QNetworkCookie.RawForm = ...

    class SameSite(Enum):
        Default: QNetworkCookie.SameSite = ...
        None_: QNetworkCookie.SameSite = ...
        Lax: QNetworkCookie.SameSite = ...
        Strict: QNetworkCookie.SameSite = ...

    @overload
    def __init__(
        self,
        name: Union[PySide6.QtCore.QByteArray, bytes] = ...,
        value: Union[PySide6.QtCore.QByteArray, bytes] = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qnetworkcookie.html#QNetworkCookie

        **QNetworkCookie::QNetworkCookie(const QByteArray & name = QByteArray(),
        const QByteArray & value = QByteArray())**

        Create a new QNetworkCookie object, initializing the cookie name to
        **name** and its value to **value**.

        A cookie is only valid if it has a name. However, the value is opaque to
        the application and being empty may have significance to the remote
        server.
        """
        ...

    @overload
    def __init__(self, other: PySide6.QtNetwork.QNetworkCookie) -> None:
        """
        https://doc.qt.io/qt-6/qnetworkcookie.html#QNetworkCookie-1

        **QNetworkCookie::QNetworkCookie(const QNetworkCookie & other )**

        Creates a new QNetworkCookie object by copying the contents of
        **other**.
        """
        ...

    @staticmethod
    def __copy__() -> None:
        ...

    def domain(self) -> str:
        """
        https://doc.qt.io/qt-6/qnetworkcookie.html#domain

        **QString QNetworkCookie::domain() const**

        Returns the domain this cookie is associated with. This corresponds to
        the "domain" field of the cookie string.

        Note that the domain here may start with a dot, which is not a valid
        hostname. However, it means this cookie matches all hostnames ending
        with that domain name.

        **See also** **setDomain** ().
        """
        ...

    def expirationDate(self) -> PySide6.QtCore.QDateTime:
        """
        https://doc.qt.io/qt-6/qnetworkcookie.html#expirationDate

        **QDateTime QNetworkCookie::expirationDate() const**

        Returns the expiration date for this cookie. If this cookie is a session
        cookie, the **QDateTime**  returned will not be valid. If the date is in
        the past, this cookie has already expired and should not be sent again
        back to a remote server.

        The expiration date corresponds to the parameters of the "expires" entry
        in the cookie string.

        **See also** **isSessionCookie** () and **setExpirationDate** ().
        """
        ...

    def hasSameIdentifier(self, other: PySide6.QtNetwork.QNetworkCookie) -> bool:
        """
        https://doc.qt.io/qt-6/qnetworkcookie.html#hasSameIdentifier

        **bool QNetworkCookie::hasSameIdentifier(const QNetworkCookie & other )
        const**

        Returns `true` if this cookie has the same identifier tuple as
        **other**. The identifier tuple is composed of the name, domain and
        path.

        **See also** **operator==** ().
        """
        ...

    def isHttpOnly(self) -> bool:
        """
        https://doc.qt.io/qt-6/qnetworkcookie.html#isHttpOnly

        **bool QNetworkCookie::isHttpOnly() const**

        Returns `true` if the "HttpOnly" flag is enabled for this cookie.

        A cookie that is "HttpOnly" is only set and retrieved by the network
        requests and replies; i.e., the HTTP protocol. It is not accessible from
        scripts running on browsers.

        **See also** **isSecure** ().
        """
        ...

    def isSecure(self) -> bool:
        """
        https://doc.qt.io/qt-6/qnetworkcookie.html#isSecure

        **bool QNetworkCookie::isSecure() const**

        Returns `true` if the "secure" option was specified in the cookie
        string, false otherwise.

        Secure cookies may contain private information and should not be resent
        over unencrypted connections.

        **See also** **setSecure** ().
        """
        ...

    def isSessionCookie(self) -> bool:
        """
        https://doc.qt.io/qt-6/qnetworkcookie.html#isSessionCookie

        **bool QNetworkCookie::isSessionCookie() const**

        Returns `true` if this cookie is a session cookie. A session cookie is a
        cookie which has no expiration date, which means it should be discarded
        when the application's concept of session is over (usually, when the
        application exits).

        **See also** **expirationDate** () and **setExpirationDate** ().
        """
        ...

    def name(self) -> PySide6.QtCore.QByteArray:
        """
        https://doc.qt.io/qt-6/qnetworkcookie.html#name

        **QByteArray QNetworkCookie::name() const**

        Returns the name of this cookie. The only mandatory field of a cookie is
        its name, without which it is not considered valid.

        **See also** **setName** () and **value** ().
        """
        ...

    def normalize(self, url: Union[PySide6.QtCore.QUrl, str]) -> None:
        """
        https://doc.qt.io/qt-6/qnetworkcookie.html#normalize

        **[since 5.0] void QNetworkCookie::normalize(const QUrl & url )**

        This functions normalizes the path and domain of the cookie if they were
        previously empty. The **url** parameter is used to determine the correct
        domain and path.

        This function was introduced in Qt 5.0.
        """
        ...

    @staticmethod
    def parseCookies(
        cookieString: Union[PySide6.QtCore.QByteArray, bytes]
    ) -> List[PySide6.QtNetwork.QNetworkCookie]:
        """
        https://doc.qt.io/qt-6/qnetworkcookie.html#parseCookies

        **[static] QList<QNetworkCookie> QNetworkCookie::parseCookies(const
        QByteArray & cookieString )**

        Parses the cookie string **cookieString** as received from a server
        response in the "Set-Cookie:" header. If there's a parsing error, this
        function returns an empty list.

        Since the HTTP header can set more than one cookie at the same time,
        this function returns a **QList** <**QNetworkCookie** >, one for each
        cookie that is parsed.

        **See also** **toRawForm** ().
        """
        ...

    def path(self) -> str:
        """
        https://doc.qt.io/qt-6/qnetworkcookie.html#path

        **QString QNetworkCookie::path() const**

        Returns the path associated with this cookie. This corresponds to the
        "path" field of the cookie string.

        **See also** **setPath** ().
        """
        ...

    def sameSitePolicy(self) -> PySide6.QtNetwork.QNetworkCookie.SameSite:
        """
        https://doc.qt.io/qt-6/qnetworkcookie.html#sameSitePolicy

        **[since 6.1] QNetworkCookie::SameSite QNetworkCookie::sameSitePolicy()
        const**

        Returns the "**SameSite** " option if specified in the cookie string,
        `SameSite::Default` if not present.

        This function was introduced in Qt 6.1.

        **See also** **setSameSitePolicy** ().
        """
        ...

    def setDomain(self, domain: str) -> None:
        """
        https://doc.qt.io/qt-6/qnetworkcookie.html#setDomain

        **void QNetworkCookie::setDomain(const QString & domain )**

        Sets the domain associated with this cookie to be **domain**.

        **See also** **domain** ().
        """
        ...

    def setExpirationDate(self, date: PySide6.QtCore.QDateTime) -> None:
        """
        https://doc.qt.io/qt-6/qnetworkcookie.html#setExpirationDate

        **void QNetworkCookie::setExpirationDate(const QDateTime & date )**

        Sets the expiration date of this cookie to **date**. Setting an invalid
        expiration date to this cookie will mean it's a session cookie.

        **See also** **isSessionCookie** () and **expirationDate** ().
        """
        ...

    def setHttpOnly(self, enable: bool) -> None:
        """
        https://doc.qt.io/qt-6/qnetworkcookie.html#setHttpOnly

        **void QNetworkCookie::setHttpOnly(bool enable )**

        Sets this cookie's "HttpOnly" flag to **enable**.

        **See also** **isHttpOnly** ().
        """
        ...

    def setName(self, cookieName: Union[PySide6.QtCore.QByteArray, bytes]) -> None:
        """
        https://doc.qt.io/qt-6/qnetworkcookie.html#setName

        **void QNetworkCookie::setName(const QByteArray & cookieName )**

        Sets the name of this cookie to be **cookieName**. Note that setting a
        cookie name to an empty **QByteArray**  will make this cookie invalid.

        **See also** **name** () and **value** ().
        """
        ...

    def setPath(self, path: str) -> None:
        """
        https://doc.qt.io/qt-6/qnetworkcookie.html#setPath

        **void QNetworkCookie::setPath(const QString & path )**

        Sets the path associated with this cookie to be **path**.

        **See also** **path** ().
        """
        ...

    def setSameSitePolicy(
        self, sameSite: PySide6.QtNetwork.QNetworkCookie.SameSite
    ) -> None:
        """
        https://doc.qt.io/qt-6/qnetworkcookie.html#setSameSitePolicy

        **[since 6.1] void
        QNetworkCookie::setSameSitePolicy(QNetworkCookie::SameSite sameSite )**

        Sets the "**SameSite** " option of this cookie to **sameSite**.

        This function was introduced in Qt 6.1.

        **See also** **sameSitePolicy** ().
        """
        ...

    def setSecure(self, enable: bool) -> None:
        """
        https://doc.qt.io/qt-6/qnetworkcookie.html#setSecure

        **void QNetworkCookie::setSecure(bool enable )**

        Sets the secure flag of this cookie to **enable**.

        Secure cookies may contain private information and should not be resent
        over unencrypted connections.

        **See also** **isSecure** ().
        """
        ...

    def setValue(self, value: Union[PySide6.QtCore.QByteArray, bytes]) -> None:
        """
        https://doc.qt.io/qt-6/qnetworkcookie.html#setValue

        **void QNetworkCookie::setValue(const QByteArray & value )**

        Sets the value of this cookie to be **value**.

        **See also** **value** () and **name** ().
        """
        ...

    def swap(self, other: PySide6.QtNetwork.QNetworkCookie) -> None:
        """
        https://doc.qt.io/qt-6/qnetworkcookie.html#swap

        **[since 5.0] void QNetworkCookie::swap(QNetworkCookie & other )**

        Swaps this cookie with **other**. This function is very fast and never
        fails.

        This function was introduced in Qt 5.0.
        """
        ...

    def toRawForm(
        self, form: PySide6.QtNetwork.QNetworkCookie.RawForm = ...
    ) -> PySide6.QtCore.QByteArray:
        """
        https://doc.qt.io/qt-6/qnetworkcookie.html#toRawForm

        **QByteArray QNetworkCookie::toRawForm(QNetworkCookie::RawForm form =
        Full) const**

        Returns the raw form of this **QNetworkCookie** . The **QByteArray**
        returned by this function is suitable for an HTTP header, either in a
        server response (the Set-Cookie header) or the client request (the
        Cookie header). You can choose from one of two formats, using **form**.

        **See also** **parseCookies** ().
        """
        ...

    def value(self) -> PySide6.QtCore.QByteArray:
        """
        https://doc.qt.io/qt-6/qnetworkcookie.html#value

        **QByteArray QNetworkCookie::value() const**

        Returns this cookies value, as specified in the cookie string. Note that
        a cookie is still valid if its value is empty.

        Cookie name-value pairs are considered opaque to the application: that
        is, their values don't mean anything.

        **See also** **setValue** () and **name** ().
        """
        ...
