"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtMultimedia, except for defaults which are replaced by "...".
"""
from enum import Enum
from typing import Union, overload
import PySide6.QtCore
import PySide6.QtGui
import PySide6.QtMultimedia

bytes = str


class QVideoFrameFormat(object):
    """
    https://doc.qt.io/qt-6/qvideoframeformat.html

    **Detailed Description**

    A video sink presents a stream of video frames. QVideoFrameFormat describes
    the type of the frames and determines how they should be presented.

    The core properties of a video stream required to setup a video sink are the
    pixel format given by **pixelFormat** (), and the frame dimensions given by
    **frameSize** ().

    The region of a frame that is actually displayed on a video surface is given
    by the **viewport** (). A stream may have a viewport less than the entire
    region of a frame to allow for videos smaller than the nearest optimal size
    of a video frame. For example the width of a frame may be extended so that
    the start of each scan line is eight byte aligned.

    Other common properties are the **scanLineDirection** (), **frameRate** ()
    and the yCrCbColorSpace().
    """

    TopToBottom: QVideoFrameFormat.Direction = ...
    BottomToTop: QVideoFrameFormat.Direction = ...
    Format_Invalid: QVideoFrameFormat.PixelFormat = ...
    Format_ARGB8888: QVideoFrameFormat.PixelFormat = ...
    Format_ARGB8888_Premultiplied: QVideoFrameFormat.PixelFormat = ...
    Format_XRGB8888: QVideoFrameFormat.PixelFormat = ...
    Format_BGRA8888: QVideoFrameFormat.PixelFormat = ...
    Format_BGRA8888_Premultiplied: QVideoFrameFormat.PixelFormat = ...
    Format_BGRX8888: QVideoFrameFormat.PixelFormat = ...
    Format_ABGR8888: QVideoFrameFormat.PixelFormat = ...
    Format_XBGR8888: QVideoFrameFormat.PixelFormat = ...
    Format_RGBA8888: QVideoFrameFormat.PixelFormat = ...
    Format_RGBX8888: QVideoFrameFormat.PixelFormat = ...
    Format_AYUV: QVideoFrameFormat.PixelFormat = ...
    Format_AYUV_Premultiplied: QVideoFrameFormat.PixelFormat = ...
    Format_YUV420P: QVideoFrameFormat.PixelFormat = ...
    Format_YUV422P: QVideoFrameFormat.PixelFormat = ...
    Format_YV12: QVideoFrameFormat.PixelFormat = ...
    Format_UYVY: QVideoFrameFormat.PixelFormat = ...
    Format_YUYV: QVideoFrameFormat.PixelFormat = ...
    Format_NV12: QVideoFrameFormat.PixelFormat = ...
    Format_NV21: QVideoFrameFormat.PixelFormat = ...
    Format_IMC1: QVideoFrameFormat.PixelFormat = ...
    Format_IMC2: QVideoFrameFormat.PixelFormat = ...
    Format_IMC3: QVideoFrameFormat.PixelFormat = ...
    Format_IMC4: QVideoFrameFormat.PixelFormat = ...
    Format_Y8: QVideoFrameFormat.PixelFormat = ...
    Format_Y16: QVideoFrameFormat.PixelFormat = ...
    Format_P010: QVideoFrameFormat.PixelFormat = ...
    Format_P016: QVideoFrameFormat.PixelFormat = ...
    Format_SamplerExternalOES: QVideoFrameFormat.PixelFormat = ...
    Format_Jpeg: QVideoFrameFormat.PixelFormat = ...
    Format_SamplerRect: QVideoFrameFormat.PixelFormat = ...
    YCbCr_Undefined: QVideoFrameFormat.YCbCrColorSpace = ...
    YCbCr_BT601: QVideoFrameFormat.YCbCrColorSpace = ...
    YCbCr_BT709: QVideoFrameFormat.YCbCrColorSpace = ...
    YCbCr_xvYCC601: QVideoFrameFormat.YCbCrColorSpace = ...
    YCbCr_xvYCC709: QVideoFrameFormat.YCbCrColorSpace = ...
    YCbCr_JPEG: QVideoFrameFormat.YCbCrColorSpace = ...

    class Direction(Enum):
        TopToBottom: QVideoFrameFormat.Direction = ...
        BottomToTop: QVideoFrameFormat.Direction = ...

    class PixelFormat(Enum):
        Format_Invalid: QVideoFrameFormat.PixelFormat = ...
        Format_ARGB8888: QVideoFrameFormat.PixelFormat = ...
        Format_ARGB8888_Premultiplied: QVideoFrameFormat.PixelFormat = ...
        Format_XRGB8888: QVideoFrameFormat.PixelFormat = ...
        Format_BGRA8888: QVideoFrameFormat.PixelFormat = ...
        Format_BGRA8888_Premultiplied: QVideoFrameFormat.PixelFormat = ...
        Format_BGRX8888: QVideoFrameFormat.PixelFormat = ...
        Format_ABGR8888: QVideoFrameFormat.PixelFormat = ...
        Format_XBGR8888: QVideoFrameFormat.PixelFormat = ...
        Format_RGBA8888: QVideoFrameFormat.PixelFormat = ...
        Format_RGBX8888: QVideoFrameFormat.PixelFormat = ...
        Format_AYUV: QVideoFrameFormat.PixelFormat = ...
        Format_AYUV_Premultiplied: QVideoFrameFormat.PixelFormat = ...
        Format_YUV420P: QVideoFrameFormat.PixelFormat = ...
        Format_YUV422P: QVideoFrameFormat.PixelFormat = ...
        Format_YV12: QVideoFrameFormat.PixelFormat = ...
        Format_UYVY: QVideoFrameFormat.PixelFormat = ...
        Format_YUYV: QVideoFrameFormat.PixelFormat = ...
        Format_NV12: QVideoFrameFormat.PixelFormat = ...
        Format_NV21: QVideoFrameFormat.PixelFormat = ...
        Format_IMC1: QVideoFrameFormat.PixelFormat = ...
        Format_IMC2: QVideoFrameFormat.PixelFormat = ...
        Format_IMC3: QVideoFrameFormat.PixelFormat = ...
        Format_IMC4: QVideoFrameFormat.PixelFormat = ...
        Format_Y8: QVideoFrameFormat.PixelFormat = ...
        Format_Y16: QVideoFrameFormat.PixelFormat = ...
        Format_P010: QVideoFrameFormat.PixelFormat = ...
        Format_P016: QVideoFrameFormat.PixelFormat = ...
        Format_SamplerExternalOES: QVideoFrameFormat.PixelFormat = ...
        Format_Jpeg: QVideoFrameFormat.PixelFormat = ...
        Format_SamplerRect: QVideoFrameFormat.PixelFormat = ...

    class YCbCrColorSpace(Enum):
        YCbCr_Undefined: QVideoFrameFormat.YCbCrColorSpace = ...
        YCbCr_BT601: QVideoFrameFormat.YCbCrColorSpace = ...
        YCbCr_BT709: QVideoFrameFormat.YCbCrColorSpace = ...
        YCbCr_xvYCC601: QVideoFrameFormat.YCbCrColorSpace = ...
        YCbCr_xvYCC709: QVideoFrameFormat.YCbCrColorSpace = ...
        YCbCr_JPEG: QVideoFrameFormat.YCbCrColorSpace = ...

    @overload
    def __init__(self) -> None:
        """
        https://doc.qt.io/qt-6/qvideoframeformat.html#QVideoFrameFormat

        **QVideoFrameFormat::QVideoFrameFormat()**

        Constructs a null video stream format.
        """
        ...

    @overload
    def __init__(self, format: PySide6.QtMultimedia.QVideoFrameFormat) -> None:
        """
        https://doc.qt.io/qt-6/qvideoframeformat.html#QVideoFrameFormat-1

        **QVideoFrameFormat::QVideoFrameFormat(const QSize & size ,
        QVideoFrameFormat::PixelFormat format )**

        Constructs a video stream with the given frame **size** and pixel
        **format**.
        """
        ...

    @overload
    def __init__(
        self,
        size: PySide6.QtCore.QSize,
        pixelFormat: PySide6.QtMultimedia.QVideoFrameFormat.PixelFormat,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qvideoframeformat.html#QVideoFrameFormat-2

        **QVideoFrameFormat::QVideoFrameFormat(const QVideoFrameFormat & other
        )**

        Constructs a copy of **other**.
        """
        ...

    @staticmethod
    def __copy__() -> None:
        ...

    def fragmentShaderFileName(self) -> str:
        ...

    def frameHeight(self) -> int:
        """
        https://doc.qt.io/qt-6/qvideoframeformat.html#frameHeight

        **int QVideoFrameFormat::frameHeight() const**

        Returns the height of frame in a video stream.
        """
        ...

    def frameRate(self) -> float:
        """
        https://doc.qt.io/qt-6/qvideoframeformat.html#frameRate

        **qreal QVideoFrameFormat::frameRate() const**

        Returns the frame rate of a video stream in frames per second.

        **See also** **setFrameRate** ().
        """
        ...

    def frameSize(self) -> PySide6.QtCore.QSize:
        """
        https://doc.qt.io/qt-6/qvideoframeformat.html#frameSize

        **QSize QVideoFrameFormat::frameSize() const**

        Returns the dimensions of frames in a video stream.

        **See also** **setFrameSize** (), **frameWidth** (), and **frameHeight**
        ().
        """
        ...

    def frameWidth(self) -> int:
        """
        https://doc.qt.io/qt-6/qvideoframeformat.html#frameWidth

        **int QVideoFrameFormat::frameWidth() const**

        Returns the width of frames in a video stream.

        **See also** **frameSize** () and **frameHeight** ().
        """
        ...

    @staticmethod
    def imageFormatFromPixelFormat(
        format: PySide6.QtMultimedia.QVideoFrameFormat.PixelFormat,
    ) -> PySide6.QtGui.QImage.Format:
        """
        https://doc.qt.io/qt-6/qvideoframeformat.html#imageFormatFromPixelFormat

        **[static] QImage::Format QVideoFrameFormat::imageFormatFromPixelFormat(
        QVideoFrameFormat::PixelFormat format )**

        Returns an image format equivalent to a video frame pixel **format**. If
        there is no equivalent format **QImage::Format_Invalid**  is returned
        instead.

        **Note:** In general **QImage**  does not handle YUV formats.
        """
        ...

    def isMirrored(self) -> bool:
        """
        https://doc.qt.io/qt-6/qvideoframeformat.html#isMirrored

        **bool QVideoFrameFormat::isMirrored() const**

        Returns `true` if the surface is mirrored around its vertical axis. This
        is typically needed for video frames coming from a front camera of a
        mobile device.

        **Note:** The mirroring here differs from **QImage::mirrored** , as a
        vertically mirrored **QImage**  will be mirrored around its x-axis.
        """
        ...

    def isValid(self) -> bool:
        """
        https://doc.qt.io/qt-6/qvideoframeformat.html#isValid

        **bool QVideoFrameFormat::isValid() const**

        Identifies if a video surface format has a valid pixel format and frame
        size.

        Returns true if the format is valid, and false otherwise.
        """
        ...

    def pixelFormat(self) -> PySide6.QtMultimedia.QVideoFrameFormat.PixelFormat:
        """
        https://doc.qt.io/qt-6/qvideoframeformat.html#pixelFormat

        **QVideoFrameFormat::PixelFormat QVideoFrameFormat::pixelFormat()
        const**

        Returns the pixel format of frames in a video stream.
        """
        ...

    @staticmethod
    def pixelFormatFromImageFormat(
        format: PySide6.QtGui.QImage.Format,
    ) -> PySide6.QtMultimedia.QVideoFrameFormat.PixelFormat:
        """
        https://doc.qt.io/qt-6/qvideoframeformat.html#pixelFormatFromImageFormat

        **[static] QVideoFrameFormat::PixelFormat
        QVideoFrameFormat::pixelFormatFromImageFormat(QImage::Format format )**

        Returns a video pixel format equivalent to an image **format**. If there
        is no equivalent format **QVideoFrameFormat::Format_Invalid**  is
        returned instead.

        **Note:** In general **QImage**  does not handle YUV formats.
        """
        ...

    @staticmethod
    def pixelFormatToString(
        pixelFormat: PySide6.QtMultimedia.QVideoFrameFormat.PixelFormat,
    ) -> str:
        """
        https://doc.qt.io/qt-6/qvideoframeformat.html#pixelFormatToString

        **[static] QString
        QVideoFrameFormat::pixelFormatToString(QVideoFrameFormat::PixelFormat
        pixelFormat )**

        Returns a string representation of the given **pixelFormat**.
        """
        ...

    def planeCount(self) -> int:
        """
        https://doc.qt.io/qt-6/qvideoframeformat.html#planeCount

        **int QVideoFrameFormat::planeCount() const**

        Returns the number of planes used. This number is depending on the pixel
        format and is 1 for RGB based formats, and a number between 1 and 3 for
        YUV based formats.
        """
        ...

    def scanLineDirection(self) -> PySide6.QtMultimedia.QVideoFrameFormat.Direction:
        """
        https://doc.qt.io/qt-6/qvideoframeformat.html#scanLineDirection

        **QVideoFrameFormat::Direction QVideoFrameFormat::scanLineDirection()
        const**

        Returns the direction of scan lines.

        **See also** **setScanLineDirection** ().
        """
        ...

    def setFrameRate(self, rate: float) -> None:
        """
        https://doc.qt.io/qt-6/qvideoframeformat.html#setFrameRate

        **void QVideoFrameFormat::setFrameRate(qreal rate )**

        Sets the frame **rate** of a video stream in frames per second.

        **See also** **frameRate** ().
        """
        ...

    @overload
    def setFrameSize(self, size: PySide6.QtCore.QSize) -> None:
        """
        https://doc.qt.io/qt-6/qvideoframeformat.html#setFrameSize

        **void QVideoFrameFormat::setFrameSize(const QSize & size )**

        Sets the size of frames in a video stream to **size**.

        This will reset the **viewport** () to fill the entire frame.

        **See also** **frameSize** ().
        """
        ...

    @overload
    def setFrameSize(self, width: int, height: int) -> None:
        """
        https://doc.qt.io/qt-6/qvideoframeformat.html#setFrameSize-1

        **void QVideoFrameFormat::setFrameSize(int width , int height )**

        This is an overloaded function.

        Sets the **width** and **height** of frames in a video stream.

        This will reset the **viewport** () to fill the entire frame.
        """
        ...

    def setMirrored(self, mirrored: bool) -> None:
        """
        https://doc.qt.io/qt-6/qvideoframeformat.html#setMirrored

        **void QVideoFrameFormat::setMirrored(bool mirrored )**

        Sets if the surface is **mirrored** around its vertical axis. This is
        typically needed for video frames coming from a front camera of a mobile
        device. Default value is false.

        **Note:** The mirroring here differs from **QImage::mirrored** , as a
        vertically mirrored **QImage**  will be mirrored around its x-axis.

        **See also** **isMirrored** ().
        """
        ...

    def setScanLineDirection(
        self, direction: PySide6.QtMultimedia.QVideoFrameFormat.Direction
    ) -> None:
        """
        https://doc.qt.io/qt-6/qvideoframeformat.html#setScanLineDirection

        **void
        QVideoFrameFormat::setScanLineDirection(QVideoFrameFormat::Direction
        direction )**

        Sets the **direction** of scan lines.

        **See also** **scanLineDirection** ().
        """
        ...

    def setViewport(self, viewport: PySide6.QtCore.QRect) -> None:
        """
        https://doc.qt.io/qt-6/qvideoframeformat.html#setViewport

        **void QVideoFrameFormat::setViewport(const QRect & viewport )**

        Sets the viewport of a video stream to **viewport**.

        **See also** **viewport** ().
        """
        ...

    def setYCbCrColorSpace(
        self, colorSpace: PySide6.QtMultimedia.QVideoFrameFormat.YCbCrColorSpace
    ) -> None:
        """
        https://doc.qt.io/qt-6/qvideoframeformat.html#setYCbCrColorSpace

        **void
        QVideoFrameFormat::setYCbCrColorSpace(QVideoFrameFormat::YCbCrColorSpace
        space )**

        Sets the Y'CbCr color **space** of a video stream. It is only used with
        raw YUV frame types.

        **See also** **yCbCrColorSpace** ().
        """
        ...

    def swap(self, other: PySide6.QtMultimedia.QVideoFrameFormat) -> None:
        ...

    def updateUniformData(
        self,
        dst: Union[PySide6.QtCore.QByteArray, bytes],
        frame: Union[
            PySide6.QtMultimedia.QVideoFrame, PySide6.QtMultimedia.QVideoFrameFormat
        ],
        transform: Union[PySide6.QtGui.QMatrix4x4, PySide6.QtGui.QTransform],
        opacity: float,
    ) -> None:
        ...

    def vertexShaderFileName(self) -> str:
        ...

    def viewport(self) -> PySide6.QtCore.QRect:
        """
        https://doc.qt.io/qt-6/qvideoframeformat.html#viewport

        **QRect QVideoFrameFormat::viewport() const**

        Returns the viewport of a video stream.

        The viewport is the region of a video frame that is actually displayed.

        By default the viewport covers an entire frame.

        **See also** **setViewport** ().
        """
        ...

    def yCbCrColorSpace(self) -> PySide6.QtMultimedia.QVideoFrameFormat.YCbCrColorSpace:
        """
        https://doc.qt.io/qt-6/qvideoframeformat.html#yCbCrColorSpace

        **QVideoFrameFormat::YCbCrColorSpace
        QVideoFrameFormat::yCbCrColorSpace() const**

        Returns the Y'CbCr color space of a video stream.

        **See also** **setYCbCrColorSpace** ().
        """
        ...
