"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtMultimedia, except for defaults which are replaced by "...".
"""
from enum import Enum
from typing import List, Optional, Union
import PySide6.QtCore
import PySide6.QtGui
import PySide6.QtMultimedia

bytes = str


class QMediaPlayer(PySide6.QtCore.QObject):
    """
    https://doc.qt.io/qt-6/qmediaplayer.html

    **Detailed Description**

    The QMediaPlayer class is a high level media playback class. It can be used
    to playback audio of video media files. The content to playback is specified
    as a **QUrl**  object.

    player = new **QMediaPlayer** ;
        audioOutput = new **QAudioOutput** ;
    player->setAudioOutput(audioOutput);
        connect(player,
    SIGNAL(positionChanged(**qint64** )), this, SLOT(positionChanged(**qint64**
    )));
        player->setSource(**QUrl**
    ::fromLocalFile("/Users/me/Music/coolsong.mp3"));
    audioOutput->setVolume(50);
        player->play();

    **QVideoWidget**  can be used with QMediaPlayer for video rendering.

    **See also** **QVideoWidget** .
    """

    NoError: QMediaPlayer.Error = ...
    ResourceError: QMediaPlayer.Error = ...
    FormatError: QMediaPlayer.Error = ...
    NetworkError: QMediaPlayer.Error = ...
    AccessDeniedError: QMediaPlayer.Error = ...
    NoMedia: QMediaPlayer.MediaStatus = ...
    LoadingMedia: QMediaPlayer.MediaStatus = ...
    LoadedMedia: QMediaPlayer.MediaStatus = ...
    StalledMedia: QMediaPlayer.MediaStatus = ...
    BufferingMedia: QMediaPlayer.MediaStatus = ...
    BufferedMedia: QMediaPlayer.MediaStatus = ...
    EndOfMedia: QMediaPlayer.MediaStatus = ...
    InvalidMedia: QMediaPlayer.MediaStatus = ...
    StoppedState: QMediaPlayer.PlaybackState = ...
    PlayingState: QMediaPlayer.PlaybackState = ...
    PausedState: QMediaPlayer.PlaybackState = ...

    class Error(Enum):
        NoError: QMediaPlayer.Error = ...
        ResourceError: QMediaPlayer.Error = ...
        FormatError: QMediaPlayer.Error = ...
        NetworkError: QMediaPlayer.Error = ...
        AccessDeniedError: QMediaPlayer.Error = ...

    class MediaStatus(Enum):
        NoMedia: QMediaPlayer.MediaStatus = ...
        LoadingMedia: QMediaPlayer.MediaStatus = ...
        LoadedMedia: QMediaPlayer.MediaStatus = ...
        StalledMedia: QMediaPlayer.MediaStatus = ...
        BufferingMedia: QMediaPlayer.MediaStatus = ...
        BufferedMedia: QMediaPlayer.MediaStatus = ...
        EndOfMedia: QMediaPlayer.MediaStatus = ...
        InvalidMedia: QMediaPlayer.MediaStatus = ...

    class PlaybackState(Enum):
        StoppedState: QMediaPlayer.PlaybackState = ...
        PlayingState: QMediaPlayer.PlaybackState = ...
        PausedState: QMediaPlayer.PlaybackState = ...

    def __init__(self, parent: Optional[PySide6.QtCore.QObject] = ...) -> None:
        """
        https://doc.qt.io/qt-6/qmediaplayer.html#QMediaPlayer

        **QMediaPlayer::QMediaPlayer(QObject * parent = nullptr)**

        Constructs a QMediaPlayer instance as a child of **parent**.
        """
        ...

    def activeAudioTrack(self) -> int:
        """
        https://doc.qt.io/qt-6/qmediaplayer.html#activeAudioTrack-prop

        **activeAudioTrack : int**

        Returns the currently active audio track.

        By default, the first available audio track will be chosen.

        Set **index** to `-1` to disable all audio tracks.

        **Access functions:**

        int **activeAudioTrack** () const
        void **setActiveAudioTrack** (int
        **index** )

        **Notifier signal:**

        void ****activeTracksChanged** ** ()
        """
        ...

    def activeSubtitleTrack(self) -> int:
        """
        https://doc.qt.io/qt-6/qmediaplayer.html#activeSubtitleTrack-prop

        **activeSubtitleTrack : int**

        Returns the currently active subtitle track.

        Set **index** to `-1` to disable subtitles.

        Subtitles are disabled by default.

        **Access functions:**

        int **activeSubtitleTrack** () const
        void **setActiveSubtitleTrack**
        (int **index** )

        **Notifier signal:**

        void ****activeTracksChanged** ** ()
        """
        ...

    def activeVideoTrack(self) -> int:
        """
        https://doc.qt.io/qt-6/qmediaplayer.html#activeVideoTrack-prop

        **activeVideoTrack : int**

        Returns the currently active video track.

        By default, the first available audio track will be chosen.

        Set **index** to `-1` to disable all video tracks.

        **Access functions:**

        int **activeVideoTrack** () const
        void **setActiveVideoTrack** (int
        **index** )

        **Notifier signal:**

        void ****activeTracksChanged** ** ()
        """
        ...

    def audioOutput(self) -> PySide6.QtMultimedia.QAudioOutput:
        """
        https://doc.qt.io/qt-6/qmediaplayer.html#audioOutput-prop

        **audioOutput : QAudioOutput***

        This property holds the audio output device used by the media player.

        The current audio output to be used when playing back media. Setting a
        new audio output will replace the currently used output.

        Setting this property to `nullptr` will disable any audio output.

        **Access functions:**

        QAudioOutput * **audioOutput** () const
        void **setAudioOutput**
        (QAudioOutput * **output** )

        **Notifier signal:**

        void **audioOutputChanged** ()
        """
        ...

    def audioTracks(self) -> List[PySide6.QtMultimedia.QMediaMetaData]:
        """
        https://doc.qt.io/qt-6/qmediaplayer.html#audioTracks

        **QList<QMediaMetaData> QMediaPlayer::audioTracks() const**

        Lists the set of available audio tracks inside the media.

        The **QMediaMetaData**  returned describes the properties of individual
        tracks.

        Different audio tracks can for example contain audio in different
        languages.

        **Note:** Getter function for property audioTracks.
        """
        ...

    def bufferProgress(self) -> float:
        """
        https://doc.qt.io/qt-6/qmediaplayer.html#bufferProgress

        **float QMediaPlayer::bufferProgress() const**

        Returns a number betwee 0 and 1 when buffering data.

        0 means that there is no buffered data available, playback is usually
        stalled in this case. Playback will resume once the buffer reaches 1,
        meaning enough data has been buffered to be able to resume playback.

        bufferProgress() will always return 1 for local files.

        **Note:** Getter function for property bufferProgress.
        """
        ...

    def bufferedTimeRange(self) -> PySide6.QtMultimedia.QMediaTimeRange:
        """
        https://doc.qt.io/qt-6/qmediaplayer.html#bufferedTimeRange

        **QMediaTimeRange QMediaPlayer::bufferedTimeRange() const**

        Returns a **QMediaTimeRange**  describing the currently buffered data.

        When streaming media from a remote source, different parts of the media
        file can be available locally. The returned **QMediaTimeRange**  object
        describes the time ranges that are buffered and available for immediate
        playback.

        **See also** **QMediaTimeRange** .
        """
        ...

    def duration(self) -> int:
        """
        https://doc.qt.io/qt-6/qmediaplayer.html#duration

        **qint64 QMediaPlayer::duration() const**

        Returns the duration of the current media in ms.

        Returns 0 if the media player doesn't have a valid media file or stream.
        For live streams, the duration usually changes during playback as more
        data becomes available.

        **Note:** Getter function for property duration.
        """
        ...

    def error(self) -> PySide6.QtMultimedia.QMediaPlayer.Error:
        """
        https://doc.qt.io/qt-6/qmediaplayer.html#error

        **QMediaPlayer::Error QMediaPlayer::error() const**

        Returns the current error state.

        **Note:** Getter function for property error.
        """
        ...

    def errorString(self) -> str:
        """
        https://doc.qt.io/qt-6/qmediaplayer.html#errorString-prop

        **[read-only] errorString : const QString**

        This property holds a string describing the current error condition in
        more detail.

        **Access functions:**

        QString **errorString** () const

        **Notifier signal:**

        void ****errorChanged** ** ()
        """
        ...

    def hasAudio(self) -> bool:
        """
        https://doc.qt.io/qt-6/qmediaplayer.html#hasAudio-prop

        **[read-only] hasAudio : const bool**

        This property holds whether the media contains audio.

        **Access functions:**

        bool **hasAudio** () const

        **Notifier signal:**

        void ****hasAudioChanged** ** (bool **available** )
        """
        ...

    def hasVideo(self) -> bool:
        """
        https://doc.qt.io/qt-6/qmediaplayer.html#hasVideo-prop

        **[read-only] hasVideo : const bool**

        This property holds whether the media contains video.

        **Access functions:**

        bool **hasVideo** () const

        **Notifier signal:**

        void ****hasVideoChanged** ** (bool **videoAvailable** )
        """
        ...

    def isAvailable(self) -> bool:
        """
        https://doc.qt.io/qt-6/qmediaplayer.html#isAvailable

        **bool QMediaPlayer::isAvailable() const**

        Returns true if the media player is supported on this platform.
        """
        ...

    def isSeekable(self) -> bool:
        """
        https://doc.qt.io/qt-6/qmediaplayer.html#isSeekable

        **bool QMediaPlayer::isSeekable() const**

        Returns true if the media is seekable. Most file based media files are
        seekable, but live streams usually are not.

        **Note:** Getter function for property **seekable** .

        **See also** **position** .
        """
        ...

    def loops(self) -> int:
        """
        https://doc.qt.io/qt-6/qmediaplayer.html#loops-prop

        **loops : int**

        Determines how often the media is played before the player stops. Set to
        **QMediaPlayer::Infinite**  to loop the current media file forever.

        The default value is `1`. Setting this property to `0` has no effect.

        **Access functions:**

        int **loops** () const
        void **setLoops** (int **loops** )

        **Notifier signal:**

        void **loopsChanged** ()
        """
        ...

    def mediaStatus(self) -> PySide6.QtMultimedia.QMediaPlayer.MediaStatus:
        """
        https://doc.qt.io/qt-6/qmediaplayer.html#mediaStatus-prop

        **[read-only] mediaStatus : const MediaStatus**

        This property holds the status of the current media stream.

        The stream status describes how the playback of the current stream is
        progressing.

        By default this property is **QMediaPlayer::NoMedia**

        **Access functions:**

        QMediaPlayer::MediaStatus **mediaStatus** () const

        **Notifier signal:**

        void ****mediaStatusChanged** ** (QMediaPlayer::MediaStatus **status** )
        """
        ...

    def metaData(self) -> PySide6.QtMultimedia.QMediaMetaData:
        """
        https://doc.qt.io/qt-6/qmediaplayer.html#metaData

        **QMediaMetaData QMediaPlayer::metaData() const**

        Returns meta data for the current media used by the media player.

        Meta data can contain information such as the title of the video or its
        creation date.

        **Note:** The Windows implementation provides metadata only for media
        located on the local file system.

        **Note:** Getter function for property metaData.
        """
        ...

    def pause(self) -> None:
        """
        https://doc.qt.io/qt-6/qmediaplayer.html#pause

        **[slot] void QMediaPlayer::pause()**

        Pause playing the current source.

        **See also** **play** () and **stop** ().
        """
        ...

    def play(self) -> None:
        """
        https://doc.qt.io/qt-6/qmediaplayer.html#play

        **[slot] void QMediaPlayer::play()**

        Start or resume playing the current source.

        **See also** **pause** () and **stop** ().
        """
        ...

    def playbackRate(self) -> float:
        """
        https://doc.qt.io/qt-6/qmediaplayer.html#playbackRate

        **qreal QMediaPlayer::playbackRate() const**

        Returns the current playback rate.

        **Note:** Getter function for property playbackRate.

        **See also** **setPlaybackRate** ().
        """
        ...

    def playbackState(self) -> PySide6.QtMultimedia.QMediaPlayer.PlaybackState:
        ...

    def position(self) -> int:
        """
        https://doc.qt.io/qt-6/qmediaplayer.html#position

        **qint64 QMediaPlayer::position() const**

        Returns the current position inside the media being played back in ms.

        Returns 0 if the media player doesn't have a valid media file or stream.
        For live streams, the duration usually changes during playback as more
        data becomes available.

        **Note:** Getter function for property position.

        **See also** **setPosition** ().
        """
        ...

    def setActiveAudioTrack(self, index: int) -> None:
        """
        https://doc.qt.io/qt-6/qmediaplayer.html#activeAudioTrack-prop

        **activeAudioTrack : int**

        Returns the currently active audio track.

        By default, the first available audio track will be chosen.

        Set **index** to `-1` to disable all audio tracks.

        **Access functions:**

        int **activeAudioTrack** () const
        void **setActiveAudioTrack** (int
        **index** )

        **Notifier signal:**

        void ****activeTracksChanged** ** ()
        """
        ...

    def setActiveSubtitleTrack(self, index: int) -> None:
        """
        https://doc.qt.io/qt-6/qmediaplayer.html#activeSubtitleTrack-prop

        **activeSubtitleTrack : int**

        Returns the currently active subtitle track.

        Set **index** to `-1` to disable subtitles.

        Subtitles are disabled by default.

        **Access functions:**

        int **activeSubtitleTrack** () const
        void **setActiveSubtitleTrack**
        (int **index** )

        **Notifier signal:**

        void ****activeTracksChanged** ** ()
        """
        ...

    def setActiveVideoTrack(self, index: int) -> None:
        """
        https://doc.qt.io/qt-6/qmediaplayer.html#activeVideoTrack-prop

        **activeVideoTrack : int**

        Returns the currently active video track.

        By default, the first available audio track will be chosen.

        Set **index** to `-1` to disable all video tracks.

        **Access functions:**

        int **activeVideoTrack** () const
        void **setActiveVideoTrack** (int
        **index** )

        **Notifier signal:**

        void ****activeTracksChanged** ** ()
        """
        ...

    def setAudioOutput(self, output: PySide6.QtMultimedia.QAudioOutput) -> None:
        """
        https://doc.qt.io/qt-6/qmediaplayer.html#audioOutput-prop

        **audioOutput : QAudioOutput***

        This property holds the audio output device used by the media player.

        The current audio output to be used when playing back media. Setting a
        new audio output will replace the currently used output.

        Setting this property to `nullptr` will disable any audio output.

        **Access functions:**

        QAudioOutput * **audioOutput** () const
        void **setAudioOutput**
        (QAudioOutput * **output** )

        **Notifier signal:**

        void **audioOutputChanged** ()
        """
        ...

    def setLoops(self, loops: int) -> None:
        """
        https://doc.qt.io/qt-6/qmediaplayer.html#loops-prop

        **loops : int**

        Determines how often the media is played before the player stops. Set to
        **QMediaPlayer::Infinite**  to loop the current media file forever.

        The default value is `1`. Setting this property to `0` has no effect.

        **Access functions:**

        int **loops** () const
        void **setLoops** (int **loops** )

        **Notifier signal:**

        void **loopsChanged** ()
        """
        ...

    def setPlaybackRate(self, rate: float) -> None:
        """
        https://doc.qt.io/qt-6/qmediaplayer.html#playbackRate-prop

        **playbackRate : qreal**

        This property holds the playback rate of the current media.

        This value is a multiplier applied to the media's standard play rate. By
        default this value is 1.0, indicating that the media is playing at the
        standard pace. Values higher than 1.0 will increase the rate of play.
        Values less than zero can be set and indicate the media should rewind at
        the multiplier of the standard pace.

        Not all playback services support change of the playback rate. It is
        framework defined as to the status and quality of audio and video while
        fast forwarding or rewinding.

        **Access functions:**

        qreal ****playbackRate** ** () const
        void **setPlaybackRate** (qreal
        **rate** )

        **Notifier signal:**

        void ****playbackRateChanged** ** (qreal **rate** )
        """
        ...

    def setPosition(self, position: int) -> None:
        """
        https://doc.qt.io/qt-6/qmediaplayer.html#position-prop

        **position : qint64**

        This property holds the playback position of the current media.

        The value is the current playback position, expressed in milliseconds
        since the beginning of the media. Periodically changes in the position
        will be indicated with the **positionChanged** () signal.

        If the **seekable**  property is true, this property can be set to
        milliseconds.

        **Access functions:**

        qint64 ****position** ** () const
        void **setPosition** (qint64
        **position** )

        **Notifier signal:**

        void ****positionChanged** ** (qint64 **position** )
        """
        ...

    def setSource(self, source: Union[PySide6.QtCore.QUrl, str]) -> None:
        """
        https://doc.qt.io/qt-6/qmediaplayer.html#setSource

        **[slot] void QMediaPlayer::setSource(const QUrl & source )**

        Sets the current **source**.

        Setting the media to a null **QUrl**  will cause the player to discard
        all information relating to the current media source and to cease all
        I/O operations related to that media.

        **Note:** This function returns immediately after recording the
        specified source of the media. It does not wait for the media to finish
        loading and does not check for errors. Listen for the
        **mediaStatusChanged** () and **error** () signals to be notified when
        the media is loaded and when an error occurs during loading.

        **Note:** Setter function for property **source** .

        **See also** **source** ().
        """
        ...

    def setSourceDevice(
        self,
        device: PySide6.QtCore.QIODevice,
        sourceUrl: Union[PySide6.QtCore.QUrl, str] = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qmediaplayer.html#setSourceDevice

        **[slot] void QMediaPlayer::setSourceDevice(QIODevice * device , const
        QUrl & sourceUrl = QUrl())**

        Sets the current source **device**.

        The media data will be read from **device**. The **sourceUrl** can be
        provided to resolve additional information about the media, mime type
        etc. The **device** must be open and readable.

        For macOS the **device** should also be seek-able.

        **Note:** This function returns immediately after recording the
        specified source of the media. It does not wait for the media to finish
        loading and does not check for errors. Listen for the
        **mediaStatusChanged** () and **error** () signals to be notified when
        the media is loaded, and if an error occurs during loading.

        **See also** **sourceDevice** ().
        """
        ...

    def setVideoOutput(self, arg__1: PySide6.QtCore.QObject) -> None:
        """
        https://doc.qt.io/qt-6/qmediaplayer.html#videoOutput-prop

        **videoOutput : QObject***

        This property holds the video output to be used by the media player.

        A media player can only have one video output attached, so setting this
        property will replace the previously connected video output.

        Setting this property to `nullptr` will disable video output.

        **Access functions:**

        QObject * **videoOutput** () const
        void **setVideoOutput** (QObject *)

        **Notifier signal:**

        void **videoOutputChanged** ()

        **Member Function Documentation**
        """
        ...

    def setVideoSink(self, sink: PySide6.QtMultimedia.QVideoSink) -> None:
        ...

    def source(self) -> PySide6.QtCore.QUrl:
        """
        https://doc.qt.io/qt-6/qmediaplayer.html#source-prop

        **source : QUrl**

        This property holds the active media source being used by the player
        object.

        The player object will use the **QUrl**  for selection of the content to
        be played.

        By default this property has a null **QUrl** .

        Setting this property to a null **QUrl**  will cause the player to
        discard all information relating to the current media source and to
        cease all I/O operations related to that media.

        **Access functions:**

        QUrl **source** () const
        void ****setSource** ** (const QUrl &
        **source** )

        **Notifier signal:**

        void ****sourceChanged** ** (const QUrl & **media** )

        **See also** **QUrl** .
        """
        ...

    def sourceDevice(self) -> PySide6.QtCore.QIODevice:
        """
        https://doc.qt.io/qt-6/qmediaplayer.html#sourceDevice

        **const QIODevice *QMediaPlayer::sourceDevice() const**

        Returns the stream source of media data.

        This is only valid if a stream was passed to **setSource** ().

        **See also** **setSourceDevice** () and **setSource** ().
        """
        ...

    def stop(self) -> None:
        """
        https://doc.qt.io/qt-6/qmediaplayer.html#stop

        **[slot] void QMediaPlayer::stop()**

        Stop playing, and reset the play position to the beginning.

        **See also** **play** () and **pause** ().
        """
        ...

    def subtitleTracks(self) -> List[PySide6.QtMultimedia.QMediaMetaData]:
        """
        https://doc.qt.io/qt-6/qmediaplayer.html#subtitleTracks

        **QList<QMediaMetaData> QMediaPlayer::subtitleTracks() const**

        Lists the set of available subtitle tracks inside the media.

        The **QMediaMetaData**  returned describes the properties of individual
        tracks.

        **Note:** Getter function for property subtitleTracks.
        """
        ...

    def videoOutput(self) -> PySide6.QtCore.QObject:
        """
        https://doc.qt.io/qt-6/qmediaplayer.html#videoOutput-prop

        **videoOutput : QObject***

        This property holds the video output to be used by the media player.

        A media player can only have one video output attached, so setting this
        property will replace the previously connected video output.

        Setting this property to `nullptr` will disable video output.

        **Access functions:**

        QObject * **videoOutput** () const
        void **setVideoOutput** (QObject *)

        **Notifier signal:**

        void **videoOutputChanged** ()

        **Member Function Documentation**
        """
        ...

    def videoSink(self) -> PySide6.QtMultimedia.QVideoSink:
        ...

    def videoTracks(self) -> List[PySide6.QtMultimedia.QMediaMetaData]:
        """
        https://doc.qt.io/qt-6/qmediaplayer.html#videoTracks

        **QList<QMediaMetaData> QMediaPlayer::videoTracks() const**

        Lists the set of available video tracks inside the media.

        The **QMediaMetaData**  returned describes the properties of individual
        tracks.

        **Note:** Getter function for property videoTracks.
        """
        ...

    @property
    def audioOutputChanged(self) -> PySide6.QtCore.SignalInstance:
        ...

    @property
    def bufferProgressChanged(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qmediaplayer.html#bufferProgressChanged

        **[signal] void QMediaPlayer::bufferProgressChanged(float filled )**

        Signals the amount of the local buffer **filled** as a number between 0
        and 1.

        **Note:** Notifier signal for property **bufferProgress** .
        """
        ...

    @property
    def durationChanged(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qmediaplayer.html#durationChanged

        **[signal] void QMediaPlayer::durationChanged(qint64 duration )**

        Signals the duration of the content has changed to **duration** ,
        expressed in milliseconds.

        **Note:** Notifier signal for property **duration** .
        """
        ...

    @property
    def errorOccurred(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qmediaplayer.html#errorOccurred

        **[signal] void QMediaPlayer::errorOccurred(QMediaPlayer::Error error ,
        const QString & errorString )**

        Signals that an **error** condition has occurred, with **errorString**
        containing a description of the error.

        **See also** **errorString** ().
        """
        ...

    @property
    def hasAudioChanged(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qmediaplayer.html#hasAudioChanged

        **[signal] void QMediaPlayer::hasAudioChanged(bool available )**

        Signals the availability of audio content has changed to **available**.

        **Note:** Notifier signal for property **hasAudio** .
        """
        ...

    @property
    def hasVideoChanged(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qmediaplayer.html#hasVideoChanged

        **[signal] void QMediaPlayer::hasVideoChanged(bool videoAvailable )**

        Signals the availability of visual content has changed to
        **videoAvailable**.

        **Note:** Notifier signal for property **hasVideo** .
        """
        ...

    @property
    def loopsChanged(self) -> PySide6.QtCore.SignalInstance:
        ...

    @property
    def mediaStatusChanged(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qmediaplayer.html#mediaStatusChanged

        **[signal] void
        QMediaPlayer::mediaStatusChanged(QMediaPlayer::MediaStatus status )**

        Signals that the **status** of the current media has changed.

        **Note:** Notifier signal for property **mediaStatus** .

        **See also** **mediaStatus** ().
        """
        ...

    @property
    def playbackRateChanged(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qmediaplayer.html#playbackRateChanged

        **[signal] void QMediaPlayer::playbackRateChanged(qreal rate )**

        Signals the **playbackRate**  has changed to **rate**.

        **Note:** Notifier signal for property **playbackRate** .
        """
        ...

    @property
    def playbackStateChanged(self) -> PySide6.QtCore.SignalInstance:
        ...

    @property
    def positionChanged(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qmediaplayer.html#positionChanged

        **[signal] void QMediaPlayer::positionChanged(qint64 position )**

        Signals the position of the content has changed to **position** ,
        expressed in milliseconds.

        **Note:** Notifier signal for property **position** .
        """
        ...

    @property
    def seekableChanged(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qmediaplayer.html#seekableChanged

        **[signal] void QMediaPlayer::seekableChanged(bool seekable )**

        Signals the **seekable** status of the player object has changed.

        **Note:** Notifier signal for property **seekable** .
        """
        ...

    @property
    def sourceChanged(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qmediaplayer.html#sourceChanged

        **[signal] void QMediaPlayer::sourceChanged(const QUrl & media )**

        Signals that the media source has been changed to **media**.

        **Note:** Notifier signal for property **source** .
        """
        ...

    @property
    def videoOutputChanged(self) -> PySide6.QtCore.SignalInstance:
        ...
