"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtHelp, except for defaults which are replaced by "...".
"""
from typing import List, Sequence, overload
import PySide6.QtCore
import PySide6.QtGui
import PySide6.QtWidgets
import PySide6.QtHelp

bytes = str


class QHelpFilterData(object):
    """
    https://doc.qt.io/qt-6/qhelpfilterdata.html

    **Detailed Description**

    By using **setComponents** () you may constrain the search results to
    documents that belong only to components specified on the given list. By
    using **setVersions** () you may constrain the search results to documents
    that belong only to versions specified on the given list.

    **See also** **QHelpFilterEngine** .
    """

    @overload
    def __init__(self) -> None:
        """
        https://doc.qt.io/qt-6/qhelpfilterdata.html#QHelpFilterData

        **QHelpFilterData::QHelpFilterData()**

        Constructs the empty filter.
        """
        ...

    @overload
    def __init__(self, other: PySide6.QtHelp.QHelpFilterData) -> None:
        """
        https://doc.qt.io/qt-6/qhelpfilterdata.html#QHelpFilterData-1

        **QHelpFilterData::QHelpFilterData(const QHelpFilterData & other )**

        Constructs a copy of **other**.
        """
        ...

    @staticmethod
    def __copy__() -> None:
        ...

    def components(self) -> List[str]:
        """
        https://doc.qt.io/qt-6/qhelpfilterdata.html#components

        **QStringList QHelpFilterData::components() const**

        Returns the component list that is used for filtering the search
        results.

        **See also** **setComponents** ().
        """
        ...

    def setComponents(self, components: Sequence[str]) -> None:
        """
        https://doc.qt.io/qt-6/qhelpfilterdata.html#setComponents

        **void QHelpFilterData::setComponents(const QStringList & components )**

        Specifies the component list that is used for filtering the search
        results. Only results from components in the list **components** shall
        be returned.

        **See also** **components** ().
        """
        ...

    def setVersions(self, versions: Sequence[PySide6.QtCore.QVersionNumber]) -> None:
        """
        https://doc.qt.io/qt-6/qhelpfilterdata.html#setVersions

        **void QHelpFilterData::setVersions(const QList<QVersionNumber> &
        versions )**

        Specifies the version list that is used for filtering the search
        results. Only results from versions in the list **versions** shall be
        returned.

        **See also** **versions** ().
        """
        ...

    def swap(self, other: PySide6.QtHelp.QHelpFilterData) -> None:
        """
        https://doc.qt.io/qt-6/qhelpfilterdata.html#swap

        **void QHelpFilterData::swap(QHelpFilterData & other )**

        Swaps the filter **other** with this filter. This operation is very fast
        and never fails.
        """
        ...

    def versions(self) -> List[PySide6.QtCore.QVersionNumber]:
        """
        https://doc.qt.io/qt-6/qhelpfilterdata.html#versions

        **QList<QVersionNumber> QHelpFilterData::versions() const**

        Returns the version list that is used for filtering the search results.

        **See also** **setVersions** ().
        """
        ...
