"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtHelp, except for defaults which are replaced by "...".
"""
from typing import Any, Union, overload
import PySide6.QtCore
import PySide6.QtGui
import PySide6.QtWidgets
import PySide6.QtHelp

bytes = str


class QHelpContentModel(PySide6.QtCore.QAbstractItemModel):
    """
    https://doc.qt.io/qt-6/qhelpcontentmodel.html

    **Detailed Description**
    """

    def columnCount(
        self,
        parent: Union[
            PySide6.QtCore.QModelIndex, PySide6.QtCore.QPersistentModelIndex
        ] = ...,
    ) -> int:
        """
        https://doc.qt.io/qt-6/qhelpcontentmodel.html#columnCount

        **[override virtual] int QHelpContentModel::columnCount(const
        QModelIndex & parent = QModelIndex()) const**

        Reimplements: **QAbstractItemModel::columnCount(const QModelIndex
        &parent) const** .

        Returns the number of columns under the given **parent**. Currently
        returns always 1.
        """
        ...

    def contentItemAt(
        self,
        index: Union[PySide6.QtCore.QModelIndex, PySide6.QtCore.QPersistentModelIndex],
    ) -> PySide6.QtHelp.QHelpContentItem:
        """
        https://doc.qt.io/qt-6/qhelpcontentmodel.html#contentItemAt

        **QHelpContentItem *QHelpContentModel::contentItemAt(const QModelIndex &
        index ) const**

        Returns the help content item at the model index position **index**.
        """
        ...

    def createContents(self, customFilterName: str) -> None:
        """
        https://doc.qt.io/qt-6/qhelpcontentmodel.html#createContents

        **void QHelpContentModel::createContents(const QString &
        customFilterName )**

        Creates new contents by querying the help system for contents specified
        for the **customFilterName**.
        """
        ...

    def data(
        self,
        index: Union[PySide6.QtCore.QModelIndex, PySide6.QtCore.QPersistentModelIndex],
        role: int,
    ) -> Any:
        """
        https://doc.qt.io/qt-6/qhelpcontentmodel.html#data

        **[override virtual] QVariant QHelpContentModel::data(const QModelIndex
        & index , int role ) const**

        Reimplements: **QAbstractItemModel::data(const QModelIndex &index, int
        role) const** .

        Returns the data stored under the given **role** for the item referred
        to by the **index**.
        """
        ...

    def index(
        self,
        row: int,
        column: int,
        parent: Union[
            PySide6.QtCore.QModelIndex, PySide6.QtCore.QPersistentModelIndex
        ] = ...,
    ) -> PySide6.QtCore.QModelIndex:
        """
        https://doc.qt.io/qt-6/qhelpcontentmodel.html#index

        **[override virtual] QModelIndex QHelpContentModel::index(int row , int
        column , const QModelIndex & parent = QModelIndex()) const**

        Reimplements: **QAbstractItemModel::index(int row, int column, const
        QModelIndex &parent) const** .

        Returns the index of the item in the model specified by the given
        **row** , **column** and **parent** index.
        """
        ...

    def isCreatingContents(self) -> bool:
        """
        https://doc.qt.io/qt-6/qhelpcontentmodel.html#isCreatingContents

        **bool QHelpContentModel::isCreatingContents() const**

        Returns true if the contents are currently rebuilt, otherwise false.
        """
        ...

    @overload
    def parent(self) -> PySide6.QtCore.QObject:
        """
        https://doc.qt.io/qt-6/qhelpcontentmodel.html#parent

        **[override virtual] QModelIndex QHelpContentModel::parent(const
        QModelIndex & index ) const**

        Reimplements: **QAbstractItemModel::parent(const QModelIndex &index)
        const** .

        Returns the parent of the model item with the given **index** , or
        QModelIndex() if it has no parent.
        """
        ...

    @overload
    def parent(
        self,
        index: Union[PySide6.QtCore.QModelIndex, PySide6.QtCore.QPersistentModelIndex],
    ) -> PySide6.QtCore.QModelIndex:
        """
        https://doc.qt.io/qt-6/qhelpcontentmodel.html#parent

        **[override virtual] QModelIndex QHelpContentModel::parent(const
        QModelIndex & index ) const**

        Reimplements: **QAbstractItemModel::parent(const QModelIndex &index)
        const** .

        Returns the parent of the model item with the given **index** , or
        QModelIndex() if it has no parent.
        """
        ...

    def rowCount(
        self,
        parent: Union[
            PySide6.QtCore.QModelIndex, PySide6.QtCore.QPersistentModelIndex
        ] = ...,
    ) -> int:
        """
        https://doc.qt.io/qt-6/qhelpcontentmodel.html#rowCount

        **[override virtual] int QHelpContentModel::rowCount(const QModelIndex &
        parent = QModelIndex()) const**

        Reimplements: **QAbstractItemModel::rowCount(const QModelIndex &parent)
        const** .

        Returns the number of rows under the given **parent**.
        """
        ...

    @property
    def contentsCreated(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qhelpcontentmodel.html#contentsCreated

        **[signal] void QHelpContentModel::contentsCreated()**

        This signal is emitted when the contents have been created.
        """
        ...

    @property
    def contentsCreationStarted(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qhelpcontentmodel.html#contentsCreationStarted

        **[signal] void QHelpContentModel::contentsCreationStarted()**

        This signal is emitted when the creation of the contents has started.
        The current contents are invalid from this point on until the signal
        **contentsCreated** () is emitted.

        **See also** **isCreatingContents** ().
        """
        ...
