"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtGui, except for defaults which are replaced by "...".
"""
from enum import Enum
from typing import Sequence, Tuple, Union, overload
import PySide6.QtCore
import PySide6.QtGui

bytes = str


class QTransform(object):
    """
    https://doc.qt.io/qt-6/qtransform.html

    **Detailed Description**

    A transformation specifies how to translate, scale, shear, rotate or project
    the coordinate system, and is typically used when rendering graphics.

    A QTransform object can be built using the **setMatrix** (), **scale** (),
    **rotate** (), **translate** () and **shear** () functions. Alternatively,
    it can be built by applying **basic matrix operations** . The matrix can
    also be defined when constructed, and it can be reset to the identity matrix
    (the default) using the **reset** () function.

    The QTransform class supports mapping of graphic primitives: A given point,
    line, polygon, region, or painter path can be mapped to the coordinate
    system defined by **this** matrix using the **map** () function. In case of
    a rectangle, its coordinates can be transformed using the **mapRect** ()
    function. A rectangle can also be transformed into a **polygon** (mapped to
    the coordinate system defined by **this** matrix), using the
    **mapToPolygon** () function.

    QTransform provides the **isIdentity** () function which returns `true` if
    the matrix is the identity matrix, and the **isInvertible** () function
    which returns `true` if the matrix is non-singular (i.e. AB = BA = I). The
    **inverted** () function returns an inverted copy of **this** matrix if it
    is invertible (otherwise it returns the identity matrix), and **adjoint** ()
    returns the matrix's classical adjoint. In addition, QTransform provides the
    **determinant** () function which returns the matrix's determinant.

    Finally, the QTransform class supports matrix multiplication, addition and
    subtraction, and objects of the class can be streamed as well as compared.

    **Rendering Graphics**

    When rendering graphics, the matrix defines the transformations but the
    actual transformation is performed by the drawing routines in **QPainter** .

    By default, **QPainter**  operates on the associated device's own coordinate
    system. The standard coordinate system of a **QPaintDevice**  has its origin
    located at the top-left position. The **x** values increase to the right;
    **y** values increase downward. For a complete description, see the
    **coordinate system**  documentation.

    **QPainter**  has functions to translate, scale, shear and rotate the
    coordinate system without using a QTransform. For example:

    ![](images/qtransform-simpletransformation.png)



        void
    SimpleTransformation::paintEvent(**QPaintEvent**  *)
        {
    **QPainter**  painter(this);
            painter.setPen(**QPen** (Qt::blue, 1,
    Qt::DashLine));
            painter.drawRect(0, 0, 100, 100);
    painter.rotate(45);

            painter.setFont(**QFont** ("Helvetica",
    24));
            painter.setPen(**QPen** (Qt::black, 1));
    painter.drawText(20, 10, "QTransform");
        }

    Although these functions are very convenient, it can be more efficient to
    build a QTransform and call **QPainter::setTransform** () if you want to
    perform more than a single transform operation. For example:

    ![](images/qtransform-combinedtransformation.png)



        void
    CombinedTransformation::paintEvent(**QPaintEvent**  *)
        {
    **QPainter**  painter(this);
            painter.setPen(**QPen** (Qt::blue, 1,
    Qt::DashLine));
            painter.drawRect(0, 0, 100, 100);
    QTransform transform;
            transform.translate(50, 50);
    transform.rotate(45);
            transform.scale(0.5, 1.0);
    painter.setTransform(transform);

            painter.setFont(**QFont**
    ("Helvetica", 24));
            painter.setPen(**QPen** (Qt::black, 1));
    painter.drawText(20, 10, "QTransform");
        }

    **Basic Matrix Operations**

    ![](images/qtransform-representation.png)

    A QTransform object contains a 3 x 3 matrix. The `m31` (`dx`) and `m32`
    (`dy`) elements specify horizontal and vertical translation. The `m11` and
    `m22` elements specify horizontal and vertical scaling. The `m21` and `m12`
    elements specify horizontal and vertical **shearing**. And finally, the
    `m13` and `m23` elements specify horizontal and vertical projection, with
    `m33` as an additional projection factor.

    QTransform transforms a point in the plane to another point using the
    following formulas:

    x' = m11*x + m21*y + dx
        y' = m22*y + m12*x + dy
        if (!isAffine()) {
    w' = m13*x + m23*y + m33
            x' /= w'
            y' /= w'
        }

    The point **(x, y)** is the original point, and **(x', y')** is the
    transformed point. **(x', y')** can be transformed back to **(x, y)** by
    performing the same operation on the **inverted** () matrix.

    The various matrix elements can be set when constructing the matrix, or by
    using the **setMatrix** () function later on. They can also be manipulated
    using the **translate** (), **rotate** (), **scale** () and **shear** ()
    convenience functions. The currently set values can be retrieved using the
    **m11** (), **m12** (), **m13** (), **m21** (), **m22** (), **m23** (),
    **m31** (), **m32** (), **m33** (), **dx** () and **dy** () functions.

    Translation is the simplest transformation. Setting `dx` and `dy` will move
    the coordinate system `dx` units along the X axis and `dy` units along the Y
    axis. Scaling can be done by setting `m11` and `m22`. For example, setting
    `m11` to 2 and `m22` to 1.5 will double the height and increase the width by
    50%. The identity matrix has `m11`, `m22`, and `m33` set to 1 (all others
    are set to 0) mapping a point to itself. Shearing is controlled by `m12` and
    `m21`. Setting these elements to values different from zero will twist the
    coordinate system. Rotation is achieved by setting both the shearing factors
    and the scaling factors. Perspective transformation is achieved by setting
    both the projection factors and the scaling factors.

    **Combining Transforms**

    Here's the combined transformations example using basic matrix operations:

    ![](images/qtransform-combinedtransformation2.png)



        void
    BasicOperations::paintEvent(**QPaintEvent**  *)
        {
            const double a
    = qDegreesToRadians(45.0);
            double sina = sin(a);
            double cosa
    = cos(a);

            QTransform scale(0.5, 0, 0, 1.0, 0, 0);
    QTransform rotate(cosa, sina, -sina, cosa, 0, 0);
            QTransform
    translate(1, 0, 0, 1, 50.0, 50.0);

            QTransform transform = scale
    * rotate * translate;

            **QPainter**  painter(this);
    painter.setPen(**QPen** (Qt::blue, 1, Qt::DashLine));
    painter.drawRect(0, 0, 100, 100);
    painter.setTransform(transform);

            painter.setFont(**QFont**
    ("Helvetica", 24));
            painter.setPen(**QPen** (Qt::black, 1));
    painter.drawText(20, 10, "QTransform");
        }

    The combined transform first scales each operand, then rotates it, and
    finally translates it, just as in the order in which the product of its
    factors is written. This means the point to which the transforms are applied
    is implicitly multiplied on the left with the transform to its right.

    **Relation to Matrix Notation**

    The matrix notation in QTransform is the transpose of a commonly-taught
    convention which represents transforms and points as matrices and vectors.
    That convention multiplies its matrix on the left and column vector to the
    right. In other words, when several transforms are applied to a point, the
    right-most matrix acts directly on the vector first. Then the next matrix to
    the left acts on the result of the first operation - and so on. As a result,
    that convention multiplies the matrices that make up a composite transform
    in the reverse of the order in QTransform, as you can see in **Combining
    Transforms** . Transposing the matrices, and combining them to the right of
    a row vector that represents the point, lets the matrices of transforms
    appear, in their product, in the order in which we think of the transforms
    being applied to the point.

    **See also** **QPainter** , **Coordinate System** , **Affine Transformations
    Example** , and **Transformations Example** .
    """

    TxNone: QTransform.TransformationType = ...
    TxTranslate: QTransform.TransformationType = ...
    TxScale: QTransform.TransformationType = ...
    TxRotate: QTransform.TransformationType = ...
    TxShear: QTransform.TransformationType = ...
    TxProject: QTransform.TransformationType = ...

    class TransformationType(Enum):
        TxNone: QTransform.TransformationType = ...
        TxTranslate: QTransform.TransformationType = ...
        TxScale: QTransform.TransformationType = ...
        TxRotate: QTransform.TransformationType = ...
        TxShear: QTransform.TransformationType = ...
        TxProject: QTransform.TransformationType = ...

    @overload
    def __init__(self) -> None:
        """
        https://doc.qt.io/qt-6/qtransform.html#QTransform-1

        **QTransform::QTransform()**

        Constructs an identity matrix.

        All elements are set to zero except `m11` and `m22` (specifying the
        scale) and `m33` which are set to 1.

        **See also** **reset** ().
        """
        ...

    @overload
    def __init__(
        self,
        h11: float,
        h12: float,
        h13: float,
        h21: float,
        h22: float,
        h23: float,
        h31: float,
        h32: float,
        h33: float,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qtransform.html#QTransform-2

        **QTransform::QTransform(qreal m11 , qreal m12 , qreal m13 , qreal m21 ,
        qreal m22 , qreal m23 , qreal m31 , qreal m32 , qreal m33 )**

        Constructs a matrix with the elements, **m11** , **m12** , **m13** ,
        **m21** , **m22** , **m23** , **m31** , **m32** , **m33**.

        **See also** **setMatrix** ().
        """
        ...

    @overload
    def __init__(
        self, h11: float, h12: float, h21: float, h22: float, dx: float, dy: float
    ) -> None:
        """
        https://doc.qt.io/qt-6/qtransform.html#QTransform-3

        **QTransform::QTransform(qreal m11 , qreal m12 , qreal m21 , qreal m22 ,
        qreal dx , qreal dy )**

        Constructs a matrix with the elements, **m11** , **m12** , **m21** ,
        **m22** , **dx** and **dy**.

        **See also** **setMatrix** ().
        """
        ...

    @overload
    def __init__(self, other: PySide6.QtGui.QTransform) -> None:
        """
        https://doc.qt.io/qt-6/qtransform.html#QTransform-1

        **QTransform::QTransform()**

        Constructs an identity matrix.

        All elements are set to zero except `m11` and `m22` (specifying the
        scale) and `m33` which are set to 1.

        **See also** **reset** ().
        """
        ...

    def __add__(self, n: float) -> PySide6.QtGui.QTransform:
        ...

    @staticmethod
    def __copy__() -> None:
        ...

    def __iadd__(self, div: float) -> PySide6.QtGui.QTransform:
        ...

    @overload
    def __imul__(self, arg__1: PySide6.QtGui.QTransform) -> PySide6.QtGui.QTransform:
        ...

    @overload
    def __imul__(self, div: float) -> PySide6.QtGui.QTransform:
        ...

    def __isub__(self, div: float) -> PySide6.QtGui.QTransform:
        ...

    def __lshift__(
        self, arg__1: PySide6.QtCore.QDataStream
    ) -> PySide6.QtCore.QDataStream:
        ...

    @overload
    def __mul__(self, l: PySide6.QtCore.QLine) -> PySide6.QtCore.QLine:
        ...

    @overload
    def __mul__(
        self, l: Union[PySide6.QtCore.QLineF, PySide6.QtCore.QLine]
    ) -> PySide6.QtCore.QLineF:
        ...

    @overload
    def __mul__(self, n: float) -> PySide6.QtGui.QTransform:
        ...

    @overload
    def __mul__(self, o: PySide6.QtGui.QTransform) -> PySide6.QtGui.QTransform:
        ...

    @overload
    def __mul__(self, p: PySide6.QtCore.QPoint) -> PySide6.QtCore.QPoint:
        ...

    @overload
    def __mul__(
        self,
        p: Union[
            PySide6.QtCore.QPointF,
            PySide6.QtCore.QPoint,
            PySide6.QtGui.QPainterPath.Element,
        ],
    ) -> PySide6.QtCore.QPointF:
        ...

    def __reduce__(self) -> object:
        ...

    def __repr__(self) -> object:
        ...

    def __rshift__(
        self, arg__1: PySide6.QtCore.QDataStream
    ) -> PySide6.QtCore.QDataStream:
        ...

    def __sub__(self, n: float) -> PySide6.QtGui.QTransform:
        ...

    def adjoint(self) -> PySide6.QtGui.QTransform:
        """
        https://doc.qt.io/qt-6/qtransform.html#adjoint

        **QTransform QTransform::adjoint() const**

        Returns the adjoint of this matrix.
        """
        ...

    def determinant(self) -> float:
        """
        https://doc.qt.io/qt-6/qtransform.html#determinant

        **qreal QTransform::determinant() const**

        Returns the matrix's determinant.
        """
        ...

    def dx(self) -> float:
        """
        https://doc.qt.io/qt-6/qtransform.html#dx

        **qreal QTransform::dx() const**

        Returns the horizontal translation factor.

        **See also** **m31** (), **translate** (), and **Basic Matrix
        Operations** .
        """
        ...

    def dy(self) -> float:
        """
        https://doc.qt.io/qt-6/qtransform.html#dy

        **qreal QTransform::dy() const**

        Returns the vertical translation factor.

        **See also** **translate** () and **Basic Matrix Operations** .
        """
        ...

    @staticmethod
    def fromScale(dx: float, dy: float) -> PySide6.QtGui.QTransform:
        """
        https://doc.qt.io/qt-6/qtransform.html#fromScale

        **[static] QTransform QTransform::fromScale(qreal sx , qreal sy )**

        Creates a matrix which corresponds to a scaling of **sx** horizontally
        and **sy** vertically. This is the same as **QTransform** ().scale(sx,
        sy) but slightly faster.
        """
        ...

    @staticmethod
    def fromTranslate(dx: float, dy: float) -> PySide6.QtGui.QTransform:
        """
        https://doc.qt.io/qt-6/qtransform.html#fromTranslate

        **[static] QTransform QTransform::fromTranslate(qreal dx , qreal dy )**

        Creates a matrix which corresponds to a translation of **dx** along the
        x axis and **dy** along the y axis. This is the same as **QTransform**
        ().translate(dx, dy) but slightly faster.
        """
        ...

    def inverted(self) -> Tuple[Tuple, bool]:
        """
        https://doc.qt.io/qt-6/qtransform.html#inverted

        **QTransform QTransform::inverted(bool * invertible = nullptr) const**

        Returns an inverted copy of this matrix.

        If the matrix is singular (not invertible), the returned matrix is the
        identity matrix. If **invertible** is valid (i.e. not 0), its value is
        set to true if the matrix is invertible, otherwise it is set to false.

        **See also** **isInvertible** ().
        """
        ...

    def isAffine(self) -> bool:
        """
        https://doc.qt.io/qt-6/qtransform.html#isAffine

        **bool QTransform::isAffine() const**

        Returns `true` if the matrix represent an affine transformation,
        otherwise returns `false`.
        """
        ...

    def isIdentity(self) -> bool:
        """
        https://doc.qt.io/qt-6/qtransform.html#isIdentity

        **bool QTransform::isIdentity() const**

        Returns `true` if the matrix is the identity matrix, otherwise returns
        `false`.

        **See also** **reset** ().
        """
        ...

    def isInvertible(self) -> bool:
        """
        https://doc.qt.io/qt-6/qtransform.html#isInvertible

        **bool QTransform::isInvertible() const**

        Returns `true` if the matrix is invertible, otherwise returns `false`.

        **See also** **inverted** ().
        """
        ...

    def isRotating(self) -> bool:
        """
        https://doc.qt.io/qt-6/qtransform.html#isRotating

        **bool QTransform::isRotating() const**

        Returns `true` if the matrix represents some kind of a rotating
        transformation, otherwise returns `false`.

        **Note:** A rotation transformation of 180 degrees and/or 360 degrees is
        treated as a scaling transformation.

        **See also** **reset** ().
        """
        ...

    def isScaling(self) -> bool:
        """
        https://doc.qt.io/qt-6/qtransform.html#isScaling

        **bool QTransform::isScaling() const**

        Returns `true` if the matrix represents a scaling transformation,
        otherwise returns `false`.

        **See also** **reset** ().
        """
        ...

    def isTranslating(self) -> bool:
        """
        https://doc.qt.io/qt-6/qtransform.html#isTranslating

        **bool QTransform::isTranslating() const**

        Returns `true` if the matrix represents a translating transformation,
        otherwise returns `false`.

        **See also** **reset** ().
        """
        ...

    def m11(self) -> float:
        """
        https://doc.qt.io/qt-6/qtransform.html#m11

        **qreal QTransform::m11() const**

        Returns the horizontal scaling factor.

        **See also** **scale** () and **Basic Matrix Operations** .
        """
        ...

    def m12(self) -> float:
        """
        https://doc.qt.io/qt-6/qtransform.html#m12

        **qreal QTransform::m12() const**

        Returns the vertical shearing factor.

        **See also** **shear** () and **Basic Matrix Operations** .
        """
        ...

    def m13(self) -> float:
        """
        https://doc.qt.io/qt-6/qtransform.html#m13

        **qreal QTransform::m13() const**

        Returns the horizontal projection factor.

        **See also** **translate** () and **Basic Matrix Operations** .
        """
        ...

    def m21(self) -> float:
        """
        https://doc.qt.io/qt-6/qtransform.html#m21

        **qreal QTransform::m21() const**

        Returns the horizontal shearing factor.

        **See also** **shear** () and **Basic Matrix Operations** .
        """
        ...

    def m22(self) -> float:
        """
        https://doc.qt.io/qt-6/qtransform.html#m22

        **qreal QTransform::m22() const**

        Returns the vertical scaling factor.

        **See also** **scale** () and **Basic Matrix Operations** .
        """
        ...

    def m23(self) -> float:
        """
        https://doc.qt.io/qt-6/qtransform.html#m23

        **qreal QTransform::m23() const**

        Returns the vertical projection factor.

        **See also** **translate** () and **Basic Matrix Operations** .
        """
        ...

    def m31(self) -> float:
        """
        https://doc.qt.io/qt-6/qtransform.html#m31

        **qreal QTransform::m31() const**

        Returns the horizontal translation factor.

        **See also** **dx** (), **translate** (), and **Basic Matrix
        Operations** .
        """
        ...

    def m32(self) -> float:
        """
        https://doc.qt.io/qt-6/qtransform.html#m32

        **qreal QTransform::m32() const**

        Returns the vertical translation factor.

        **See also** **dy** (), **translate** (), and **Basic Matrix
        Operations** .
        """
        ...

    def m33(self) -> float:
        """
        https://doc.qt.io/qt-6/qtransform.html#m33

        **qreal QTransform::m33() const**

        Returns the division factor.

        **See also** **translate** () and **Basic Matrix Operations** .
        """
        ...

    @overload
    def map(
        self,
        a: Union[
            PySide6.QtGui.QPolygon,
            Sequence[PySide6.QtCore.QPoint],
            PySide6.QtCore.QRect,
        ],
    ) -> PySide6.QtGui.QPolygon:
        """
        https://doc.qt.io/qt-6/qtransform.html#map

        **void QTransform::map(qreal x , qreal y , qreal * tx , qreal * ty )
        const**

        Maps the given coordinates **x** and **y** into the coordinate system
        defined by this matrix. The resulting values are put in * **tx** and *
        **ty** , respectively.

        The coordinates are transformed using the following formulas:

        x' = m11*x + m21*y + dx
            y' = m22*y + m12*x + dy
            if (!isAffine())
        {
                w' = m13*x + m23*y + m33
                x' /= w'
                y' /= w'
        }

        The point (x, y) is the original point, and (x', y') is the transformed
        point.

        **See also** **Basic Matrix Operations** .
        """
        ...

    @overload
    def map(
        self,
        a: Union[
            PySide6.QtGui.QPolygonF,
            Sequence[PySide6.QtCore.QPointF],
            PySide6.QtGui.QPolygon,
            PySide6.QtCore.QRectF,
        ],
    ) -> PySide6.QtGui.QPolygonF:
        """
        https://doc.qt.io/qt-6/qtransform.html#map-1

        **QPoint QTransform::map(const QPoint & point ) const**

        This is an overloaded function.

        Creates and returns a **QPoint**  object that is a copy of the given
        **point** , mapped into the coordinate system defined by this matrix.
        Note that the transformed coordinates are rounded to the nearest
        integer.
        """
        ...

    @overload
    def map(self, l: PySide6.QtCore.QLine) -> PySide6.QtCore.QLine:
        """
        https://doc.qt.io/qt-6/qtransform.html#map-2

        **QPointF QTransform::map(const QPointF & p ) const**

        This is an overloaded function.

        Creates and returns a **QPointF**  object that is a copy of the given
        point, **p** , mapped into the coordinate system defined by this matrix.
        """
        ...

    @overload
    def map(
        self, l: Union[PySide6.QtCore.QLineF, PySide6.QtCore.QLine]
    ) -> PySide6.QtCore.QLineF:
        """
        https://doc.qt.io/qt-6/qtransform.html#map-3

        **QLine QTransform::map(const QLine & l ) const**

        This is an overloaded function.

        Creates and returns a **QLineF**  object that is a copy of the given
        line, **l** , mapped into the coordinate system defined by this matrix.
        """
        ...

    @overload
    def map(self, p: PySide6.QtCore.QPoint) -> PySide6.QtCore.QPoint:
        """
        https://doc.qt.io/qt-6/qtransform.html#map-4

        **QLineF QTransform::map(const QLineF & line ) const**

        This is an overloaded function.

        Creates and returns a **QLine**  object that is a copy of the given
        **line** , mapped into the coordinate system defined by this matrix.
        Note that the transformed coordinates are rounded to the nearest
        integer.
        """
        ...

    @overload
    def map(self, p: PySide6.QtGui.QPainterPath) -> PySide6.QtGui.QPainterPath:
        """
        https://doc.qt.io/qt-6/qtransform.html#map-5

        **QPolygonF QTransform::map(const QPolygonF & polygon ) const**

        This is an overloaded function.

        Creates and returns a **QPolygonF**  object that is a copy of the given
        **polygon** , mapped into the coordinate system defined by this matrix.
        """
        ...

    @overload
    def map(
        self,
        p: Union[
            PySide6.QtCore.QPointF,
            PySide6.QtCore.QPoint,
            PySide6.QtGui.QPainterPath.Element,
        ],
    ) -> PySide6.QtCore.QPointF:
        """
        https://doc.qt.io/qt-6/qtransform.html#map-6

        **QPolygon QTransform::map(const QPolygon & polygon ) const**

        This is an overloaded function.

        Creates and returns a **QPolygon**  object that is a copy of the given
        **polygon** , mapped into the coordinate system defined by this matrix.
        Note that the transformed coordinates are rounded to the nearest
        integer.
        """
        ...

    @overload
    def map(
        self,
        r: Union[
            PySide6.QtGui.QRegion,
            PySide6.QtGui.QBitmap,
            PySide6.QtGui.QPolygon,
            PySide6.QtCore.QRect,
        ],
    ) -> PySide6.QtGui.QRegion:
        """
        https://doc.qt.io/qt-6/qtransform.html#map-7

        **QRegion QTransform::map(const QRegion & region ) const**

        This is an overloaded function.

        Creates and returns a **QRegion**  object that is a copy of the given
        **region** , mapped into the coordinate system defined by this matrix.

        Calling this method can be rather expensive if rotations or shearing are
        used.
        """
        ...

    @overload
    def map(self, x: float, y: float) -> Tuple[float, float]:
        """
        https://doc.qt.io/qt-6/qtransform.html#map-8

        **QPainterPath QTransform::map(const QPainterPath & path ) const**

        This is an overloaded function.

        Creates and returns a **QPainterPath**  object that is a copy of the
        given **path** , mapped into the coordinate system defined by this
        matrix.
        """
        ...

    @overload
    def mapRect(self, arg__1: PySide6.QtCore.QRect) -> PySide6.QtCore.QRect:
        """
        https://doc.qt.io/qt-6/qtransform.html#mapRect

        **QRectF QTransform::mapRect(const QRectF & rectangle ) const**

        Creates and returns a **QRectF**  object that is a copy of the given
        **rectangle** , mapped into the coordinate system defined by this
        matrix.

        The rectangle's coordinates are transformed using the following
        formulas:

        x' = m11*x + m21*y + dx
            y' = m22*y + m12*x + dy
            if (!isAffine())
        {
                w' = m13*x + m23*y + m33
                x' /= w'
                y' /= w'
        }

        If rotation or shearing has been specified, this function returns the
        **bounding** rectangle. To retrieve the exact region the given
        **rectangle** maps to, use the **mapToPolygon** () function instead.

        **See also** **mapToPolygon** () and **Basic Matrix Operations** .
        """
        ...

    @overload
    def mapRect(
        self, arg__1: Union[PySide6.QtCore.QRectF, PySide6.QtCore.QRect]
    ) -> PySide6.QtCore.QRectF:
        """
        https://doc.qt.io/qt-6/qtransform.html#mapRect-1

        **QRect QTransform::mapRect(const QRect & rectangle ) const**

        This is an overloaded function.

        Creates and returns a **QRect**  object that is a copy of the given
        **rectangle** , mapped into the coordinate system defined by this
        matrix. Note that the transformed coordinates are rounded to the nearest
        integer.
        """
        ...

    def mapToPolygon(self, r: PySide6.QtCore.QRect) -> PySide6.QtGui.QPolygon:
        """
        https://doc.qt.io/qt-6/qtransform.html#mapToPolygon

        **QPolygon QTransform::mapToPolygon(const QRect & rectangle ) const**

        Creates and returns a **QPolygon**  representation of the given
        **rectangle** , mapped into the coordinate system defined by this
        matrix.

        The rectangle's coordinates are transformed using the following
        formulas:

        x' = m11*x + m21*y + dx
            y' = m22*y + m12*x + dy
            if (!isAffine())
        {
                w' = m13*x + m23*y + m33
                x' /= w'
                y' /= w'
        }

        Polygons and rectangles behave slightly differently when transformed
        (due to integer rounding), so `matrix.map(QPolygon(rectangle))` is not
        always the same as `matrix.mapToPolygon(rectangle)`.

        **See also** **mapRect** () and **Basic Matrix Operations** .
        """
        ...

    @overload
    @staticmethod
    def quadToQuad(
        arg__1: Union[
            PySide6.QtGui.QPolygonF,
            Sequence[PySide6.QtCore.QPointF],
            PySide6.QtGui.QPolygon,
            PySide6.QtCore.QRectF,
        ],
        arg__2: Union[
            PySide6.QtGui.QPolygonF,
            Sequence[PySide6.QtCore.QPointF],
            PySide6.QtGui.QPolygon,
            PySide6.QtCore.QRectF,
        ],
    ) -> object:
        """
        https://doc.qt.io/qt-6/qtransform.html#quadToQuad

        **[static] bool QTransform::quadToQuad(const QPolygonF & one , const
        QPolygonF & two , QTransform & trans )**

        Creates a transformation matrix, **trans** , that maps a four-sided
        polygon, **one** , to another four-sided polygon, **two**. Returns
        `true` if the transformation is possible; otherwise returns false.

        This is a convenience method combining **quadToSquare** () and
        **squareToQuad** () methods. It allows the input quad to be transformed
        into any other quad.

        **See also** **squareToQuad** () and **quadToSquare** ().
        """
        ...

    @overload
    @staticmethod
    def quadToQuad(
        one: Union[
            PySide6.QtGui.QPolygonF,
            Sequence[PySide6.QtCore.QPointF],
            PySide6.QtGui.QPolygon,
            PySide6.QtCore.QRectF,
        ],
        two: Union[
            PySide6.QtGui.QPolygonF,
            Sequence[PySide6.QtCore.QPointF],
            PySide6.QtGui.QPolygon,
            PySide6.QtCore.QRectF,
        ],
        result: PySide6.QtGui.QTransform,
    ) -> bool:
        """
        https://doc.qt.io/qt-6/qtransform.html#quadToQuad

        **[static] bool QTransform::quadToQuad(const QPolygonF & one , const
        QPolygonF & two , QTransform & trans )**

        Creates a transformation matrix, **trans** , that maps a four-sided
        polygon, **one** , to another four-sided polygon, **two**. Returns
        `true` if the transformation is possible; otherwise returns false.

        This is a convenience method combining **quadToSquare** () and
        **squareToQuad** () methods. It allows the input quad to be transformed
        into any other quad.

        **See also** **squareToQuad** () and **quadToSquare** ().
        """
        ...

    @overload
    @staticmethod
    def quadToSquare(
        arg__1: Union[
            PySide6.QtGui.QPolygonF,
            Sequence[PySide6.QtCore.QPointF],
            PySide6.QtGui.QPolygon,
            PySide6.QtCore.QRectF,
        ]
    ) -> object:
        """
        https://doc.qt.io/qt-6/qtransform.html#quadToSquare

        **[static] bool QTransform::quadToSquare(const QPolygonF & quad ,
        QTransform & trans )**

        Creates a transformation matrix, **trans** , that maps a four-sided
        polygon, **quad** , to a unit square. Returns `true` if the
        transformation is constructed or false if such a transformation does not
        exist.

        **See also** **squareToQuad** () and **quadToQuad** ().
        """
        ...

    @overload
    @staticmethod
    def quadToSquare(
        quad: Union[
            PySide6.QtGui.QPolygonF,
            Sequence[PySide6.QtCore.QPointF],
            PySide6.QtGui.QPolygon,
            PySide6.QtCore.QRectF,
        ],
        result: PySide6.QtGui.QTransform,
    ) -> bool:
        """
        https://doc.qt.io/qt-6/qtransform.html#quadToSquare

        **[static] bool QTransform::quadToSquare(const QPolygonF & quad ,
        QTransform & trans )**

        Creates a transformation matrix, **trans** , that maps a four-sided
        polygon, **quad** , to a unit square. Returns `true` if the
        transformation is constructed or false if such a transformation does not
        exist.

        **See also** **squareToQuad** () and **quadToQuad** ().
        """
        ...

    def reset(self) -> None:
        """
        https://doc.qt.io/qt-6/qtransform.html#reset

        **void QTransform::reset()**

        Resets the matrix to an identity matrix, i.e. all elements are set to
        zero, except `m11` and `m22` (specifying the scale) and `m33` which are
        set to 1.

        **See also** **QTransform** (), **isIdentity** (), and **Basic Matrix
        Operations** .
        """
        ...

    def rotate(
        self, a: float, axis: PySide6.QtCore.Qt.Axis = ...
    ) -> PySide6.QtGui.QTransform:
        """
        https://doc.qt.io/qt-6/qtransform.html#rotate

        **QTransform &QTransform::rotate(qreal angle , Qt::Axis axis =
        Qt::ZAxis)**

        Rotates the coordinate system counterclockwise by the given **angle**
        about the specified **axis** and returns a reference to the matrix.

        Note that if you apply a **QTransform**  to a point defined in widget
        coordinates, the direction of the rotation will be clockwise because the
        y-axis points downwards.

        The angle is specified in degrees.

        **See also** **setMatrix** ().
        """
        ...

    def rotateRadians(
        self, a: float, axis: PySide6.QtCore.Qt.Axis = ...
    ) -> PySide6.QtGui.QTransform:
        """
        https://doc.qt.io/qt-6/qtransform.html#rotateRadians

        **QTransform &QTransform::rotateRadians(qreal angle , Qt::Axis axis =
        Qt::ZAxis)**

        Rotates the coordinate system counterclockwise by the given **angle**
        about the specified **axis** and returns a reference to the matrix.

        Note that if you apply a **QTransform**  to a point defined in widget
        coordinates, the direction of the rotation will be clockwise because the
        y-axis points downwards.

        The angle is specified in radians.

        **See also** **setMatrix** ().
        """
        ...

    def scale(self, sx: float, sy: float) -> PySide6.QtGui.QTransform:
        """
        https://doc.qt.io/qt-6/qtransform.html#scale

        **QTransform &QTransform::scale(qreal sx , qreal sy )**

        Scales the coordinate system by **sx** horizontally and **sy**
        vertically, and returns a reference to the matrix.

        **See also** **setMatrix** ().
        """
        ...

    def setMatrix(
        self,
        m11: float,
        m12: float,
        m13: float,
        m21: float,
        m22: float,
        m23: float,
        m31: float,
        m32: float,
        m33: float,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qtransform.html#setMatrix

        **void QTransform::setMatrix(qreal m11 , qreal m12 , qreal m13 , qreal
        m21 , qreal m22 , qreal m23 , qreal m31 , qreal m32 , qreal m33 )**

        Sets the matrix elements to the specified values, **m11** , **m12** ,
        **m13** **m21** , **m22** , **m23** **m31** , **m32** and **m33**. Note
        that this function replaces the previous values. **QTransform**
        provides the **translate** (), **rotate** (), **scale** () and **shear**
        () convenience functions to manipulate the various matrix elements based
        on the currently defined coordinate system.

        **See also** **QTransform** ().
        """
        ...

    def shear(self, sh: float, sv: float) -> PySide6.QtGui.QTransform:
        """
        https://doc.qt.io/qt-6/qtransform.html#shear

        **QTransform &QTransform::shear(qreal sh , qreal sv )**

        Shears the coordinate system by **sh** horizontally and **sv**
        vertically, and returns a reference to the matrix.

        **See also** **setMatrix** ().
        """
        ...

    @overload
    @staticmethod
    def squareToQuad(
        arg__1: Union[
            PySide6.QtGui.QPolygonF,
            Sequence[PySide6.QtCore.QPointF],
            PySide6.QtGui.QPolygon,
            PySide6.QtCore.QRectF,
        ]
    ) -> object:
        """
        https://doc.qt.io/qt-6/qtransform.html#squareToQuad

        **[static] bool QTransform::squareToQuad(const QPolygonF & quad ,
        QTransform & trans )**

        Creates a transformation matrix, **trans** , that maps a unit square to
        a four-sided polygon, **quad**. Returns `true` if the transformation is
        constructed or false if such a transformation does not exist.

        **See also** **quadToSquare** () and **quadToQuad** ().
        """
        ...

    @overload
    @staticmethod
    def squareToQuad(
        square: Union[
            PySide6.QtGui.QPolygonF,
            Sequence[PySide6.QtCore.QPointF],
            PySide6.QtGui.QPolygon,
            PySide6.QtCore.QRectF,
        ],
        result: PySide6.QtGui.QTransform,
    ) -> bool:
        """
        https://doc.qt.io/qt-6/qtransform.html#squareToQuad

        **[static] bool QTransform::squareToQuad(const QPolygonF & quad ,
        QTransform & trans )**

        Creates a transformation matrix, **trans** , that maps a unit square to
        a four-sided polygon, **quad**. Returns `true` if the transformation is
        constructed or false if such a transformation does not exist.

        **See also** **quadToSquare** () and **quadToQuad** ().
        """
        ...

    def translate(self, dx: float, dy: float) -> PySide6.QtGui.QTransform:
        """
        https://doc.qt.io/qt-6/qtransform.html#translate

        **QTransform &QTransform::translate(qreal dx , qreal dy )**

        Moves the coordinate system **dx** along the x axis and **dy** along the
        y axis, and returns a reference to the matrix.

        **See also** **setMatrix** ().
        """
        ...

    def transposed(self) -> PySide6.QtGui.QTransform:
        """
        https://doc.qt.io/qt-6/qtransform.html#transposed

        **QTransform QTransform::transposed() const**

        Returns the transpose of this matrix.
        """
        ...

    def type(self) -> PySide6.QtGui.QTransform.TransformationType:
        """
        https://doc.qt.io/qt-6/qtransform.html#type

        **QTransform::TransformationType QTransform::type() const**

        Returns the transformation type of this matrix.

        The transformation type is the highest enumeration value capturing all
        of the matrix's transformations. For example, if the matrix both scales
        and shears, the type would be `TxShear`, because `TxShear` has a higher
        enumeration value than `TxScale`.

        Knowing the transformation type of a matrix is useful for optimization:
        you can often handle specific types more optimally than handling the
        generic case.
        """
        ...
