"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtGui, except for defaults which are replaced by "...".
"""
from enum import Enum
from typing import Any, Dict, List, Sequence, Union, overload
import PySide6.QtCore
import PySide6.QtGui

bytes = str


class QTextFormat(object):
    """
    https://doc.qt.io/qt-6/qtextformat.html

    **Detailed Description**

    A QTextFormat is a generic class used for describing the format of parts of
    a **QTextDocument** . The derived classes **QTextCharFormat** ,
    **QTextBlockFormat** , **QTextListFormat** , and **QTextTableFormat**  are
    usually more useful, and describe the formatting that is applied to specific
    parts of the document.

    A format has a `FormatType` which specifies the kinds of text item it can
    format; e.g. a block of text, a list, a table, etc. A format also has
    various properties (some specific to particular format types), as described
    by the Property enum. Every property has a corresponding Property.

    The format type is given by **type** (), and the format can be tested with
    **isCharFormat** (), **isBlockFormat** (), **isListFormat** (),
    **isTableFormat** (), **isFrameFormat** (), and **isImageFormat** (). If the
    type is determined, it can be retrieved with **toCharFormat** (),
    **toBlockFormat** (), **toListFormat** (), **toTableFormat** (),
    **toFrameFormat** (), and **toImageFormat** ().

    A format's properties can be set with the **setProperty** () functions, and
    retrieved with **boolProperty** (), **intProperty** (), **doubleProperty**
    (), and **stringProperty** () as appropriate. All the property IDs used in
    the format can be retrieved with allPropertyIds(). One format can be merged
    into another using **merge** ().

    A format's object index can be set with **setObjectIndex** (), and retrieved
    with **objectIndex** (). These methods can be used to associate the format
    with a **QTextObject** . It is used to represent lists, frames, and tables
    inside the document.

    **See also** **Rich Text Processing** .
    """

    InvalidFormat: QTextFormat.FormatType = ...
    BlockFormat: QTextFormat.FormatType = ...
    CharFormat: QTextFormat.FormatType = ...
    ListFormat: QTextFormat.FormatType = ...
    FrameFormat: QTextFormat.FormatType = ...
    UserFormat: QTextFormat.FormatType = ...
    NoObject: QTextFormat.ObjectTypes = ...
    ImageObject: QTextFormat.ObjectTypes = ...
    TableObject: QTextFormat.ObjectTypes = ...
    TableCellObject: QTextFormat.ObjectTypes = ...
    UserObject: QTextFormat.ObjectTypes = ...
    PageBreak_Auto: QTextFormat.PageBreakFlag = ...
    PageBreak_AlwaysBefore: QTextFormat.PageBreakFlag = ...
    PageBreak_AlwaysAfter: QTextFormat.PageBreakFlag = ...
    ObjectIndex: QTextFormat.Property = ...
    CssFloat: QTextFormat.Property = ...
    LayoutDirection: QTextFormat.Property = ...
    OutlinePen: QTextFormat.Property = ...
    BackgroundBrush: QTextFormat.Property = ...
    ForegroundBrush: QTextFormat.Property = ...
    BackgroundImageUrl: QTextFormat.Property = ...
    BlockAlignment: QTextFormat.Property = ...
    BlockTopMargin: QTextFormat.Property = ...
    BlockBottomMargin: QTextFormat.Property = ...
    BlockLeftMargin: QTextFormat.Property = ...
    BlockRightMargin: QTextFormat.Property = ...
    TextIndent: QTextFormat.Property = ...
    TabPositions: QTextFormat.Property = ...
    BlockIndent: QTextFormat.Property = ...
    LineHeight: QTextFormat.Property = ...
    LineHeightType: QTextFormat.Property = ...
    BlockNonBreakableLines: QTextFormat.Property = ...
    BlockTrailingHorizontalRulerWidth: QTextFormat.Property = ...
    HeadingLevel: QTextFormat.Property = ...
    BlockQuoteLevel: QTextFormat.Property = ...
    BlockCodeLanguage: QTextFormat.Property = ...
    BlockCodeFence: QTextFormat.Property = ...
    BlockMarker: QTextFormat.Property = ...
    FirstFontProperty: QTextFormat.Property = ...
    FontCapitalization: QTextFormat.Property = ...
    FontLetterSpacing: QTextFormat.Property = ...
    FontWordSpacing: QTextFormat.Property = ...
    FontStyleHint: QTextFormat.Property = ...
    FontStyleStrategy: QTextFormat.Property = ...
    FontKerning: QTextFormat.Property = ...
    FontHintingPreference: QTextFormat.Property = ...
    FontFamilies: QTextFormat.Property = ...
    FontStyleName: QTextFormat.Property = ...
    FontLetterSpacingType: QTextFormat.Property = ...
    FontStretch: QTextFormat.Property = ...
    FontFamily: QTextFormat.Property = ...
    FontPointSize: QTextFormat.Property = ...
    FontSizeAdjustment: QTextFormat.Property = ...
    FontSizeIncrement: QTextFormat.Property = ...
    FontWeight: QTextFormat.Property = ...
    FontItalic: QTextFormat.Property = ...
    FontUnderline: QTextFormat.Property = ...
    FontOverline: QTextFormat.Property = ...
    FontStrikeOut: QTextFormat.Property = ...
    FontFixedPitch: QTextFormat.Property = ...
    FontPixelSize: QTextFormat.Property = ...
    LastFontProperty: QTextFormat.Property = ...
    OldTextUnderlineColor: QTextFormat.Property = ...
    TextUnderlineColor: QTextFormat.Property = ...
    TextVerticalAlignment: QTextFormat.Property = ...
    TextOutline: QTextFormat.Property = ...
    TextUnderlineStyle: QTextFormat.Property = ...
    TextToolTip: QTextFormat.Property = ...
    TextSuperScriptBaseline: QTextFormat.Property = ...
    TextSubScriptBaseline: QTextFormat.Property = ...
    TextBaselineOffset: QTextFormat.Property = ...
    IsAnchor: QTextFormat.Property = ...
    AnchorHref: QTextFormat.Property = ...
    AnchorName: QTextFormat.Property = ...
    OldFontLetterSpacingType: QTextFormat.Property = ...
    OldFontStretch: QTextFormat.Property = ...
    ObjectType: QTextFormat.Property = ...
    ListStyle: QTextFormat.Property = ...
    ListIndent: QTextFormat.Property = ...
    ListNumberPrefix: QTextFormat.Property = ...
    ListNumberSuffix: QTextFormat.Property = ...
    FrameBorder: QTextFormat.Property = ...
    FrameMargin: QTextFormat.Property = ...
    FramePadding: QTextFormat.Property = ...
    FrameWidth: QTextFormat.Property = ...
    FrameHeight: QTextFormat.Property = ...
    FrameTopMargin: QTextFormat.Property = ...
    FrameBottomMargin: QTextFormat.Property = ...
    FrameLeftMargin: QTextFormat.Property = ...
    FrameRightMargin: QTextFormat.Property = ...
    FrameBorderBrush: QTextFormat.Property = ...
    FrameBorderStyle: QTextFormat.Property = ...
    TableColumns: QTextFormat.Property = ...
    TableColumnWidthConstraints: QTextFormat.Property = ...
    TableCellSpacing: QTextFormat.Property = ...
    TableCellPadding: QTextFormat.Property = ...
    TableHeaderRowCount: QTextFormat.Property = ...
    TableBorderCollapse: QTextFormat.Property = ...
    TableCellRowSpan: QTextFormat.Property = ...
    TableCellColumnSpan: QTextFormat.Property = ...
    TableCellTopPadding: QTextFormat.Property = ...
    TableCellBottomPadding: QTextFormat.Property = ...
    TableCellLeftPadding: QTextFormat.Property = ...
    TableCellRightPadding: QTextFormat.Property = ...
    TableCellTopBorder: QTextFormat.Property = ...
    TableCellBottomBorder: QTextFormat.Property = ...
    TableCellLeftBorder: QTextFormat.Property = ...
    TableCellRightBorder: QTextFormat.Property = ...
    TableCellTopBorderStyle: QTextFormat.Property = ...
    TableCellBottomBorderStyle: QTextFormat.Property = ...
    TableCellLeftBorderStyle: QTextFormat.Property = ...
    TableCellRightBorderStyle: QTextFormat.Property = ...
    TableCellTopBorderBrush: QTextFormat.Property = ...
    TableCellBottomBorderBrush: QTextFormat.Property = ...
    TableCellLeftBorderBrush: QTextFormat.Property = ...
    TableCellRightBorderBrush: QTextFormat.Property = ...
    ImageName: QTextFormat.Property = ...
    ImageTitle: QTextFormat.Property = ...
    ImageAltText: QTextFormat.Property = ...
    ImageWidth: QTextFormat.Property = ...
    ImageHeight: QTextFormat.Property = ...
    ImageQuality: QTextFormat.Property = ...
    FullWidthSelection: QTextFormat.Property = ...
    PageBreakPolicy: QTextFormat.Property = ...
    UserProperty: QTextFormat.Property = ...

    class FormatType(Enum):
        InvalidFormat: QTextFormat.FormatType = ...
        BlockFormat: QTextFormat.FormatType = ...
        CharFormat: QTextFormat.FormatType = ...
        ListFormat: QTextFormat.FormatType = ...
        FrameFormat: QTextFormat.FormatType = ...
        UserFormat: QTextFormat.FormatType = ...

    class ObjectTypes(Enum):
        NoObject: QTextFormat.ObjectTypes = ...
        ImageObject: QTextFormat.ObjectTypes = ...
        TableObject: QTextFormat.ObjectTypes = ...
        TableCellObject: QTextFormat.ObjectTypes = ...
        UserObject: QTextFormat.ObjectTypes = ...

    class PageBreakFlag(Enum):
        PageBreak_Auto: QTextFormat.PageBreakFlag = ...
        PageBreak_AlwaysBefore: QTextFormat.PageBreakFlag = ...
        PageBreak_AlwaysAfter: QTextFormat.PageBreakFlag = ...

    class PageBreakFlags(object):
        ...

    class Property(Enum):
        ObjectIndex: QTextFormat.Property = ...
        CssFloat: QTextFormat.Property = ...
        LayoutDirection: QTextFormat.Property = ...
        OutlinePen: QTextFormat.Property = ...
        BackgroundBrush: QTextFormat.Property = ...
        ForegroundBrush: QTextFormat.Property = ...
        BackgroundImageUrl: QTextFormat.Property = ...
        BlockAlignment: QTextFormat.Property = ...
        BlockTopMargin: QTextFormat.Property = ...
        BlockBottomMargin: QTextFormat.Property = ...
        BlockLeftMargin: QTextFormat.Property = ...
        BlockRightMargin: QTextFormat.Property = ...
        TextIndent: QTextFormat.Property = ...
        TabPositions: QTextFormat.Property = ...
        BlockIndent: QTextFormat.Property = ...
        LineHeight: QTextFormat.Property = ...
        LineHeightType: QTextFormat.Property = ...
        BlockNonBreakableLines: QTextFormat.Property = ...
        BlockTrailingHorizontalRulerWidth: QTextFormat.Property = ...
        HeadingLevel: QTextFormat.Property = ...
        BlockQuoteLevel: QTextFormat.Property = ...
        BlockCodeLanguage: QTextFormat.Property = ...
        BlockCodeFence: QTextFormat.Property = ...
        BlockMarker: QTextFormat.Property = ...
        FirstFontProperty: QTextFormat.Property = ...
        FontCapitalization: QTextFormat.Property = ...
        FontLetterSpacing: QTextFormat.Property = ...
        FontWordSpacing: QTextFormat.Property = ...
        FontStyleHint: QTextFormat.Property = ...
        FontStyleStrategy: QTextFormat.Property = ...
        FontKerning: QTextFormat.Property = ...
        FontHintingPreference: QTextFormat.Property = ...
        FontFamilies: QTextFormat.Property = ...
        FontStyleName: QTextFormat.Property = ...
        FontLetterSpacingType: QTextFormat.Property = ...
        FontStretch: QTextFormat.Property = ...
        FontFamily: QTextFormat.Property = ...
        FontPointSize: QTextFormat.Property = ...
        FontSizeAdjustment: QTextFormat.Property = ...
        FontSizeIncrement: QTextFormat.Property = ...
        FontWeight: QTextFormat.Property = ...
        FontItalic: QTextFormat.Property = ...
        FontUnderline: QTextFormat.Property = ...
        FontOverline: QTextFormat.Property = ...
        FontStrikeOut: QTextFormat.Property = ...
        FontFixedPitch: QTextFormat.Property = ...
        FontPixelSize: QTextFormat.Property = ...
        LastFontProperty: QTextFormat.Property = ...
        OldTextUnderlineColor: QTextFormat.Property = ...
        TextUnderlineColor: QTextFormat.Property = ...
        TextVerticalAlignment: QTextFormat.Property = ...
        TextOutline: QTextFormat.Property = ...
        TextUnderlineStyle: QTextFormat.Property = ...
        TextToolTip: QTextFormat.Property = ...
        TextSuperScriptBaseline: QTextFormat.Property = ...
        TextSubScriptBaseline: QTextFormat.Property = ...
        TextBaselineOffset: QTextFormat.Property = ...
        IsAnchor: QTextFormat.Property = ...
        AnchorHref: QTextFormat.Property = ...
        AnchorName: QTextFormat.Property = ...
        OldFontLetterSpacingType: QTextFormat.Property = ...
        OldFontStretch: QTextFormat.Property = ...
        ObjectType: QTextFormat.Property = ...
        ListStyle: QTextFormat.Property = ...
        ListIndent: QTextFormat.Property = ...
        ListNumberPrefix: QTextFormat.Property = ...
        ListNumberSuffix: QTextFormat.Property = ...
        FrameBorder: QTextFormat.Property = ...
        FrameMargin: QTextFormat.Property = ...
        FramePadding: QTextFormat.Property = ...
        FrameWidth: QTextFormat.Property = ...
        FrameHeight: QTextFormat.Property = ...
        FrameTopMargin: QTextFormat.Property = ...
        FrameBottomMargin: QTextFormat.Property = ...
        FrameLeftMargin: QTextFormat.Property = ...
        FrameRightMargin: QTextFormat.Property = ...
        FrameBorderBrush: QTextFormat.Property = ...
        FrameBorderStyle: QTextFormat.Property = ...
        TableColumns: QTextFormat.Property = ...
        TableColumnWidthConstraints: QTextFormat.Property = ...
        TableCellSpacing: QTextFormat.Property = ...
        TableCellPadding: QTextFormat.Property = ...
        TableHeaderRowCount: QTextFormat.Property = ...
        TableBorderCollapse: QTextFormat.Property = ...
        TableCellRowSpan: QTextFormat.Property = ...
        TableCellColumnSpan: QTextFormat.Property = ...
        TableCellTopPadding: QTextFormat.Property = ...
        TableCellBottomPadding: QTextFormat.Property = ...
        TableCellLeftPadding: QTextFormat.Property = ...
        TableCellRightPadding: QTextFormat.Property = ...
        TableCellTopBorder: QTextFormat.Property = ...
        TableCellBottomBorder: QTextFormat.Property = ...
        TableCellLeftBorder: QTextFormat.Property = ...
        TableCellRightBorder: QTextFormat.Property = ...
        TableCellTopBorderStyle: QTextFormat.Property = ...
        TableCellBottomBorderStyle: QTextFormat.Property = ...
        TableCellLeftBorderStyle: QTextFormat.Property = ...
        TableCellRightBorderStyle: QTextFormat.Property = ...
        TableCellTopBorderBrush: QTextFormat.Property = ...
        TableCellBottomBorderBrush: QTextFormat.Property = ...
        TableCellLeftBorderBrush: QTextFormat.Property = ...
        TableCellRightBorderBrush: QTextFormat.Property = ...
        ImageName: QTextFormat.Property = ...
        ImageTitle: QTextFormat.Property = ...
        ImageAltText: QTextFormat.Property = ...
        ImageWidth: QTextFormat.Property = ...
        ImageHeight: QTextFormat.Property = ...
        ImageQuality: QTextFormat.Property = ...
        FullWidthSelection: QTextFormat.Property = ...
        PageBreakPolicy: QTextFormat.Property = ...
        UserProperty: QTextFormat.Property = ...

    @overload
    def __init__(self) -> None:
        """
        https://doc.qt.io/qt-6/qtextformat.html#QTextFormat

        **QTextFormat::QTextFormat()**

        Creates a new text format with an `InvalidFormat`.

        **See also** **FormatType** .
        """
        ...

    @overload
    def __init__(self, rhs: PySide6.QtGui.QTextFormat) -> None:
        """
        https://doc.qt.io/qt-6/qtextformat.html#QTextFormat-1

        **QTextFormat::QTextFormat(int type )**

        Creates a new text format of the given **type**.

        **See also** **FormatType** .
        """
        ...

    @overload
    def __init__(self, type: int) -> None:
        """
        https://doc.qt.io/qt-6/qtextformat.html#QTextFormat-2

        **QTextFormat::QTextFormat(const QTextFormat & other )**

        Creates a new text format with the same attributes as the **other** text
        format.
        """
        ...

    @staticmethod
    def __copy__() -> None:
        ...

    def __lshift__(
        self, arg__1: PySide6.QtCore.QDataStream
    ) -> PySide6.QtCore.QDataStream:
        ...

    def __rshift__(
        self, arg__1: PySide6.QtCore.QDataStream
    ) -> PySide6.QtCore.QDataStream:
        ...

    def background(self) -> PySide6.QtGui.QBrush:
        """
        https://doc.qt.io/qt-6/qtextformat.html#background

        **QBrush QTextFormat::background() const**

        Returns the brush used to paint the document's background.

        **See also** **setBackground** (), **clearBackground** (), and
        **foreground** ().
        """
        ...

    def boolProperty(self, propertyId: int) -> bool:
        """
        https://doc.qt.io/qt-6/qtextformat.html#boolProperty

        **bool QTextFormat::boolProperty(int propertyId ) const**

        Returns the value of the property specified by **propertyId**. If the
        property isn't of QTextFormat::Bool type, false is returned instead.

        **See also** **setProperty** (), **intProperty** (), **doubleProperty**
        (), **stringProperty** (), **colorProperty** (), **lengthProperty** (),
        **lengthVectorProperty** (), and **Property** .
        """
        ...

    def brushProperty(self, propertyId: int) -> PySide6.QtGui.QBrush:
        """
        https://doc.qt.io/qt-6/qtextformat.html#brushProperty

        **QBrush QTextFormat::brushProperty(int propertyId ) const**

        Returns the value of the property given by **propertyId** ; if the
        property isn't of **QMetaType::QBrush**  type, **Qt::NoBrush**  is
        returned instead.

        **See also** **setProperty** (), **boolProperty** (), **intProperty**
        (), **doubleProperty** (), **stringProperty** (), **lengthProperty** (),
        **lengthVectorProperty** (), and **Property** .
        """
        ...

    def clearBackground(self) -> None:
        """
        https://doc.qt.io/qt-6/qtextformat.html#clearBackground

        **void QTextFormat::clearBackground()**

        Clears the brush used to paint the document's background. The default
        brush will be used.

        **See also** **background** (), **setBackground** (), and
        **clearForeground** ().
        """
        ...

    def clearForeground(self) -> None:
        """
        https://doc.qt.io/qt-6/qtextformat.html#clearForeground

        **void QTextFormat::clearForeground()**

        Clears the brush used to paint the document's foreground. The default
        brush will be used.

        **See also** **foreground** (), **setForeground** (), and
        **clearBackground** ().
        """
        ...

    def clearProperty(self, propertyId: int) -> None:
        """
        https://doc.qt.io/qt-6/qtextformat.html#clearProperty

        **void QTextFormat::clearProperty(int propertyId )**

        Clears the value of the property given by **propertyId**

        **See also** **Property** .
        """
        ...

    def colorProperty(self, propertyId: int) -> PySide6.QtGui.QColor:
        """
        https://doc.qt.io/qt-6/qtextformat.html#colorProperty

        **QColor QTextFormat::colorProperty(int propertyId ) const**

        Returns the value of the property given by **propertyId** ; if the
        property isn't of **QMetaType::QColor**  type, an invalid color is
        returned instead.

        **See also** **setProperty** (), **boolProperty** (), **intProperty**
        (), **doubleProperty** (), **stringProperty** (), **lengthProperty** (),
        **lengthVectorProperty** (), and **Property** .
        """
        ...

    def doubleProperty(self, propertyId: int) -> float:
        """
        https://doc.qt.io/qt-6/qtextformat.html#doubleProperty

        **qreal QTextFormat::doubleProperty(int propertyId ) const**

        Returns the value of the property specified by **propertyId**. If the
        property isn't of **QMetaType::Double**  or **QMetaType::Float**  type,
        0 is returned instead.

        **See also** **setProperty** (), **boolProperty** (), **intProperty**
        (), **stringProperty** (), **colorProperty** (), **lengthProperty** (),
        **lengthVectorProperty** (), and **Property** .
        """
        ...

    def foreground(self) -> PySide6.QtGui.QBrush:
        """
        https://doc.qt.io/qt-6/qtextformat.html#foreground

        **QBrush QTextFormat::foreground() const**

        Returns the brush used to render foreground details, such as text, frame
        outlines, and table borders.

        **See also** **setForeground** (), **clearForeground** (), and
        **background** ().
        """
        ...

    def hasProperty(self, propertyId: int) -> bool:
        """
        https://doc.qt.io/qt-6/qtextformat.html#hasProperty

        **bool QTextFormat::hasProperty(int propertyId ) const**

        Returns `true` if the text format has a property with the given
        **propertyId** ; otherwise returns `false`.

        **See also** **properties** () and **Property** .
        """
        ...

    def intProperty(self, propertyId: int) -> int:
        """
        https://doc.qt.io/qt-6/qtextformat.html#intProperty

        **int QTextFormat::intProperty(int propertyId ) const**

        Returns the value of the property specified by **propertyId**. If the
        property is not of QTextFormat::Integer type, 0 is returned instead.

        **See also** **setProperty** (), **boolProperty** (), **doubleProperty**
        (), **stringProperty** (), **colorProperty** (), **lengthProperty** (),
        **lengthVectorProperty** (), and **Property** .
        """
        ...

    def isBlockFormat(self) -> bool:
        """
        https://doc.qt.io/qt-6/qtextformat.html#isBlockFormat

        **bool QTextFormat::isBlockFormat() const**

        Returns `true` if this text format is a `BlockFormat`; otherwise returns
        `false`.
        """
        ...

    def isCharFormat(self) -> bool:
        """
        https://doc.qt.io/qt-6/qtextformat.html#isCharFormat

        **bool QTextFormat::isCharFormat() const**

        Returns `true` if this text format is a `CharFormat`; otherwise returns
        `false`.
        """
        ...

    def isEmpty(self) -> bool:
        """
        https://doc.qt.io/qt-6/qtextformat.html#isEmpty

        **[since 5.3] bool QTextFormat::isEmpty() const**

        Returns true if the format does not store any properties; false
        otherwise.

        This function was introduced in Qt 5.3.

        **See also** **propertyCount** () and **properties** ().
        """
        ...

    def isFrameFormat(self) -> bool:
        """
        https://doc.qt.io/qt-6/qtextformat.html#isFrameFormat

        **bool QTextFormat::isFrameFormat() const**

        Returns `true` if this text format is a `FrameFormat`; otherwise returns
        `false`.
        """
        ...

    def isImageFormat(self) -> bool:
        """
        https://doc.qt.io/qt-6/qtextformat.html#isImageFormat

        **bool QTextFormat::isImageFormat() const**

        Returns `true` if this text format is an image format; otherwise returns
        `false`.
        """
        ...

    def isListFormat(self) -> bool:
        """
        https://doc.qt.io/qt-6/qtextformat.html#isListFormat

        **bool QTextFormat::isListFormat() const**

        Returns `true` if this text format is a `ListFormat`; otherwise returns
        `false`.
        """
        ...

    def isTableCellFormat(self) -> bool:
        """
        https://doc.qt.io/qt-6/qtextformat.html#isTableCellFormat

        **bool QTextFormat::isTableCellFormat() const**

        Returns `true` if this text format is a `TableCellFormat`; otherwise
        returns `false`.
        """
        ...

    def isTableFormat(self) -> bool:
        """
        https://doc.qt.io/qt-6/qtextformat.html#isTableFormat

        **bool QTextFormat::isTableFormat() const**

        Returns `true` if this text format is a `TableFormat`; otherwise returns
        `false`.
        """
        ...

    def isValid(self) -> bool:
        """
        https://doc.qt.io/qt-6/qtextformat.html#isValid

        **bool QTextFormat::isValid() const**

        Returns `true` if the format is valid (i.e. is not **InvalidFormat** );
        otherwise returns `false`.
        """
        ...

    def layoutDirection(self) -> PySide6.QtCore.Qt.LayoutDirection:
        """
        https://doc.qt.io/qt-6/qtextformat.html#layoutDirection

        **Qt::LayoutDirection QTextFormat::layoutDirection() const**

        Returns the document's layout direction.

        **See also** **setLayoutDirection** ().
        """
        ...

    def lengthProperty(self, propertyId: int) -> PySide6.QtGui.QTextLength:
        """
        https://doc.qt.io/qt-6/qtextformat.html#lengthProperty

        **QTextLength QTextFormat::lengthProperty(int propertyId ) const**

        Returns the value of the property given by **propertyId**.

        **See also** **setProperty** (), **boolProperty** (), **intProperty**
        (), **doubleProperty** (), **stringProperty** (), **colorProperty** (),
        **lengthVectorProperty** (), and **Property** .
        """
        ...

    def lengthVectorProperty(self, propertyId: int) -> List[PySide6.QtGui.QTextLength]:
        """
        https://doc.qt.io/qt-6/qtextformat.html#lengthVectorProperty

        **QList<QTextLength> QTextFormat::lengthVectorProperty(int propertyId )
        const**

        Returns the value of the property given by **propertyId**. If the
        property isn't of QTextFormat::LengthVector type, an empty list is
        returned instead.

        **See also** **setProperty** (), **boolProperty** (), **intProperty**
        (), **doubleProperty** (), **stringProperty** (), **colorProperty** (),
        **lengthProperty** (), and **Property** .
        """
        ...

    def merge(self, other: PySide6.QtGui.QTextFormat) -> None:
        """
        https://doc.qt.io/qt-6/qtextformat.html#merge

        **void QTextFormat::merge(const QTextFormat & other )**

        Merges the **other** format with this format; where there are conflicts
        the **other** format takes precedence.
        """
        ...

    def objectIndex(self) -> int:
        """
        https://doc.qt.io/qt-6/qtextformat.html#objectIndex

        **int QTextFormat::objectIndex() const**

        Returns the index of the format object, or -1 if the format object is
        invalid.

        **See also** **setObjectIndex** ().
        """
        ...

    def objectType(self) -> int:
        """
        https://doc.qt.io/qt-6/qtextformat.html#objectType

        **int QTextFormat::objectType() const**

        Returns the text format's object type.

        **See also** **ObjectTypes**  and **setObjectType** ().
        """
        ...

    def penProperty(self, propertyId: int) -> PySide6.QtGui.QPen:
        """
        https://doc.qt.io/qt-6/qtextformat.html#penProperty

        **QPen QTextFormat::penProperty(int propertyId ) const**

        Returns the value of the property given by **propertyId** ; if the
        property isn't of **QMetaType::QPen**  type, **Qt::NoPen**  is returned
        instead.

        **See also** **setProperty** (), **boolProperty** (), **intProperty**
        (), **doubleProperty** (), **stringProperty** (), **lengthProperty** (),
        **lengthVectorProperty** (), and **Property** .
        """
        ...

    def properties(self) -> Dict[int, Any]:
        """
        https://doc.qt.io/qt-6/qtextformat.html#properties

        **QMap<int, QVariant> QTextFormat::properties() const**

        Returns a map with all properties of this text format.
        """
        ...

    def property(self, propertyId: int) -> Any:
        """
        https://doc.qt.io/qt-6/qtextformat.html#property

        **QVariant QTextFormat::property(int propertyId ) const**

        Returns the property specified by the given **propertyId**.

        **See also** **setProperty** () and **Property** .
        """
        ...

    def propertyCount(self) -> int:
        """
        https://doc.qt.io/qt-6/qtextformat.html#propertyCount

        **int QTextFormat::propertyCount() const**

        Returns the number of properties stored in the format.
        """
        ...

    def setBackground(
        self,
        brush: Union[
            PySide6.QtGui.QBrush,
            PySide6.QtCore.Qt.BrushStyle,
            PySide6.QtCore.Qt.GlobalColor,
            PySide6.QtGui.QColor,
            PySide6.QtGui.QGradient,
            PySide6.QtGui.QImage,
            PySide6.QtGui.QPixmap,
        ],
    ) -> None:
        """
        https://doc.qt.io/qt-6/qtextformat.html#setBackground

        **void QTextFormat::setBackground(const QBrush & brush )**

        Sets the brush use to paint the document's background to the **brush**
        specified.

        **See also** **background** (), **clearBackground** (), and
        **setForeground** ().
        """
        ...

    def setForeground(
        self,
        brush: Union[
            PySide6.QtGui.QBrush,
            PySide6.QtCore.Qt.BrushStyle,
            PySide6.QtCore.Qt.GlobalColor,
            PySide6.QtGui.QColor,
            PySide6.QtGui.QGradient,
            PySide6.QtGui.QImage,
            PySide6.QtGui.QPixmap,
        ],
    ) -> None:
        """
        https://doc.qt.io/qt-6/qtextformat.html#setForeground

        **void QTextFormat::setForeground(const QBrush & brush )**

        Sets the foreground brush to the specified **brush**. The foreground
        brush is mostly used to render text.

        **See also** **foreground** (), **clearForeground** (), and
        **setBackground** ().
        """
        ...

    def setLayoutDirection(self, direction: PySide6.QtCore.Qt.LayoutDirection) -> None:
        """
        https://doc.qt.io/qt-6/qtextformat.html#setLayoutDirection

        **void QTextFormat::setLayoutDirection(Qt::LayoutDirection direction )**

        Sets the document's layout direction to the specified **direction**.

        **See also** **layoutDirection** ().
        """
        ...

    def setObjectIndex(self, object: int) -> None:
        """
        https://doc.qt.io/qt-6/qtextformat.html#setObjectIndex

        **void QTextFormat::setObjectIndex(int index )**

        Sets the format object's object **index**.

        **See also** **objectIndex** ().
        """
        ...

    def setObjectType(self, type: int) -> None:
        """
        https://doc.qt.io/qt-6/qtextformat.html#setObjectType

        **void QTextFormat::setObjectType(int type )**

        Sets the text format's object type to **type**.

        **See also** **ObjectTypes**  and **objectType** ().
        """
        ...

    @overload
    def setProperty(
        self, propertyId: int, lengths: Sequence[PySide6.QtGui.QTextLength]
    ) -> None:
        """
        https://doc.qt.io/qt-6/qtextformat.html#setProperty

        **void QTextFormat::setProperty(int propertyId , const QVariant & value
        )**

        Sets the property specified by the **propertyId** to the given
        **value**.

        **See also** **property** () and **Property** .
        """
        ...

    @overload
    def setProperty(self, propertyId: int, value: Any) -> None:
        """
        https://doc.qt.io/qt-6/qtextformat.html#setProperty-1

        **void QTextFormat::setProperty(int propertyId , const
        QList<QTextLength> & value )**

        Sets the value of the property given by **propertyId** to **value**.

        **See also** **lengthVectorProperty** () and **Property** .
        """
        ...

    def stringProperty(self, propertyId: int) -> str:
        """
        https://doc.qt.io/qt-6/qtextformat.html#stringProperty

        **QString QTextFormat::stringProperty(int propertyId ) const**

        Returns the value of the property given by **propertyId** ; if the
        property isn't of **QMetaType::QString**  type, an empty string is
        returned instead.

        **See also** **setProperty** (), **boolProperty** (), **intProperty**
        (), **doubleProperty** (), **colorProperty** (), **lengthProperty** (),
        **lengthVectorProperty** (), and **Property** .
        """
        ...

    def swap(self, other: PySide6.QtGui.QTextFormat) -> None:
        """
        https://doc.qt.io/qt-6/qtextformat.html#swap

        **[since 5.0] void QTextFormat::swap(QTextFormat & other )**

        Swaps this text format with **other**. This function is very fast and
        never fails.

        This function was introduced in Qt 5.0.
        """
        ...

    def toBlockFormat(self) -> PySide6.QtGui.QTextBlockFormat:
        """
        https://doc.qt.io/qt-6/qtextformat.html#toBlockFormat

        **QTextBlockFormat QTextFormat::toBlockFormat() const**

        Returns this format as a block format.
        """
        ...

    def toCharFormat(self) -> PySide6.QtGui.QTextCharFormat:
        """
        https://doc.qt.io/qt-6/qtextformat.html#toCharFormat

        **QTextCharFormat QTextFormat::toCharFormat() const**

        Returns this format as a character format.
        """
        ...

    def toFrameFormat(self) -> PySide6.QtGui.QTextFrameFormat:
        """
        https://doc.qt.io/qt-6/qtextformat.html#toFrameFormat

        **QTextFrameFormat QTextFormat::toFrameFormat() const**

        Returns this format as a frame format.
        """
        ...

    def toImageFormat(self) -> PySide6.QtGui.QTextImageFormat:
        """
        https://doc.qt.io/qt-6/qtextformat.html#toImageFormat

        **QTextImageFormat QTextFormat::toImageFormat() const**

        Returns this format as an image format.
        """
        ...

    def toListFormat(self) -> PySide6.QtGui.QTextListFormat:
        """
        https://doc.qt.io/qt-6/qtextformat.html#toListFormat

        **QTextListFormat QTextFormat::toListFormat() const**

        Returns this format as a list format.
        """
        ...

    def toTableCellFormat(self) -> PySide6.QtGui.QTextTableCellFormat:
        """
        https://doc.qt.io/qt-6/qtextformat.html#toTableCellFormat

        **QTextTableCellFormat QTextFormat::toTableCellFormat() const**

        Returns this format as a table cell format.
        """
        ...

    def toTableFormat(self) -> PySide6.QtGui.QTextTableFormat:
        """
        https://doc.qt.io/qt-6/qtextformat.html#toTableFormat

        **QTextTableFormat QTextFormat::toTableFormat() const**

        Returns this format as a table format.
        """
        ...

    def type(self) -> int:
        """
        https://doc.qt.io/qt-6/qtextformat.html#type

        **int QTextFormat::type() const**

        Returns the type of this format.

        **See also** **FormatType** .
        """
        ...
