"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtGui, except for defaults which are replaced by "...".
"""
from typing import overload
import PySide6.QtCore
import PySide6.QtGui

bytes = str


class QStatusTipEvent(PySide6.QtCore.QEvent):
    """
    https://doc.qt.io/qt-6/qstatustipevent.html

    **Detailed Description**

    Status tips can be set on a widget using the **QWidget::setStatusTip** ()
    function. They are shown in the status bar when the mouse cursor enters the
    widget. For example:

    MainWindow::MainWindow(**QWidget**  *parent)
            : **QMainWindow**
    (parent)
        {
            **QWidget**  *myWidget = new **QWidget** ;
    myWidget->setStatusTip(tr("This is my widget."));
    setCentralWidget(myWidget);
            ...
        }

    ![Widget with status
    tip.](images/qstatustipevent-widget.png)

    Status tips can also be set on actions using the **QAction::setStatusTip**
    () function:

    MainWindow::MainWindow(**QWidget**  *parent)
            : **QMainWindow**
    (parent)
        {
            **QMenu**  *fileMenu =
    menuBar()->addMenu(tr("File"));

            **QAction**  *newAct = new
    **QAction** (tr("&New"), this);
            newAct->setStatusTip(tr("Create a
    new file."));
            fileMenu->addAction(newAct);
            ...
        }
    ![Action with status tip.](images/qstatustipevent-action.png)

    Finally, status tips are supported for the item view classes through the
    **Qt::StatusTipRole**  enum value.

    **See also** **QStatusBar** , **QHelpEvent** , and
    **QWhatsThisClickedEvent** .
    """

    @overload
    def __init__(self, arg__1: PySide6.QtGui.QStatusTipEvent) -> None:
        """
        https://doc.qt.io/qt-6/qstatustipevent.html#QStatusTipEvent-2

        **QStatusTipEvent::QStatusTipEvent(const QString & tip )**

        Constructs a status tip event with the text specified by **tip**.

        **See also** **tip** ().
        """
        ...

    @overload
    def __init__(self, tip: str) -> None:
        """
        https://doc.qt.io/qt-6/qstatustipevent.html#QStatusTipEvent-2

        **QStatusTipEvent::QStatusTipEvent(const QString & tip )**

        Constructs a status tip event with the text specified by **tip**.

        **See also** **tip** ().
        """
        ...

    def clone(self) -> PySide6.QtGui.QStatusTipEvent:
        ...

    def tip(self) -> str:
        """
        https://doc.qt.io/qt-6/qstatustipevent.html#tip

        **QString QStatusTipEvent::tip() const**

        Returns the message to show in the status bar.

        **See also** **QStatusBar::showMessage** ().
        """
        ...
