"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtGui, except for defaults which are replaced by "...".
"""
from typing import overload
import PySide6.QtCore
import PySide6.QtGui

bytes = str


class QQuaternion(object):
    """
    https://doc.qt.io/qt-6/qquaternion.html

    **Detailed Description**

    Quaternions are used to represent rotations in 3D space, and consist of a 3D
    rotation axis specified by the x, y, and z coordinates, and a scalar
    representing the rotation angle.
    """

    @overload
    def __init__(self) -> None:
        """
        https://doc.qt.io/qt-6/qquaternion.html#QQuaternion

        **QQuaternion::QQuaternion()**

        Constructs an identity quaternion (1, 0, 0, 0), i.e. with the vector (0,
        0, 0) and scalar 1.
        """
        ...

    @overload
    def __init__(self, scalar: float, vector: PySide6.QtGui.QVector3D) -> None:
        """
        https://doc.qt.io/qt-6/qquaternion.html#QQuaternion-2

        **QQuaternion::QQuaternion(float scalar , float xpos , float ypos ,
        float zpos )**

        Constructs a quaternion with the vector ( **xpos** , **ypos** , **zpos**
        ) and **scalar**.
        """
        ...

    @overload
    def __init__(self, scalar: float, xpos: float, ypos: float, zpos: float) -> None:
        """
        https://doc.qt.io/qt-6/qquaternion.html#QQuaternion-3

        **QQuaternion::QQuaternion(float scalar , const QVector3D & vector )**

        Constructs a quaternion vector from the specified **vector** and
        **scalar**.

        **See also** **vector** () and **scalar** ().
        """
        ...

    @overload
    def __init__(self, vector: PySide6.QtGui.QVector4D) -> None:
        """
        https://doc.qt.io/qt-6/qquaternion.html#QQuaternion-4

        **QQuaternion::QQuaternion(const QVector4D & vector )**

        Constructs a quaternion from the components of **vector**.
        """
        ...

    def __add__(self, q2: PySide6.QtGui.QQuaternion) -> PySide6.QtGui.QQuaternion:
        ...

    @staticmethod
    def __copy__() -> None:
        ...

    def __iadd__(
        self, quaternion: PySide6.QtGui.QQuaternion
    ) -> PySide6.QtGui.QQuaternion:
        ...

    @overload
    def __imul__(self, factor: float) -> PySide6.QtGui.QQuaternion:
        ...

    @overload
    def __imul__(
        self, quaternion: PySide6.QtGui.QQuaternion
    ) -> PySide6.QtGui.QQuaternion:
        ...

    def __isub__(
        self, quaternion: PySide6.QtGui.QQuaternion
    ) -> PySide6.QtGui.QQuaternion:
        ...

    def __lshift__(
        self, arg__1: PySide6.QtCore.QDataStream
    ) -> PySide6.QtCore.QDataStream:
        ...

    @overload
    def __mul__(self, factor: float) -> PySide6.QtGui.QQuaternion:
        ...

    @overload
    def __mul__(self, q2: PySide6.QtGui.QQuaternion) -> PySide6.QtGui.QQuaternion:
        ...

    def __neg__(self) -> PySide6.QtGui.QQuaternion:
        ...

    def __reduce__(self) -> object:
        ...

    def __repr__(self) -> object:
        ...

    def __rshift__(
        self, arg__1: PySide6.QtCore.QDataStream
    ) -> PySide6.QtCore.QDataStream:
        ...

    def __sub__(self, q2: PySide6.QtGui.QQuaternion) -> PySide6.QtGui.QQuaternion:
        ...

    def conjugated(self) -> PySide6.QtGui.QQuaternion:
        """
        https://doc.qt.io/qt-6/qquaternion.html#conjugated

        **[since 5.5] QQuaternion QQuaternion::conjugated() const**

        Returns the conjugate of this quaternion, which is (-x, -y, -z, scalar).

        This function was introduced in Qt 5.5.
        """
        ...

    @staticmethod
    def dotProduct(
        q1: PySide6.QtGui.QQuaternion, q2: PySide6.QtGui.QQuaternion
    ) -> float:
        """
        https://doc.qt.io/qt-6/qquaternion.html#dotProduct

        **[static, since 5.5] float QQuaternion::dotProduct(const QQuaternion &
        q1 , const QQuaternion & q2 )**

        Returns the dot product of **q1** and **q2**.

        This function was introduced in Qt 5.5.

        **See also** **length** ().
        """
        ...

    @staticmethod
    def fromAxes(
        xAxis: PySide6.QtGui.QVector3D,
        yAxis: PySide6.QtGui.QVector3D,
        zAxis: PySide6.QtGui.QVector3D,
    ) -> PySide6.QtGui.QQuaternion:
        """
        https://doc.qt.io/qt-6/qquaternion.html#fromAxes

        **[static, since 5.5] QQuaternion QQuaternion::fromAxes(const QVector3D
        & xAxis , const QVector3D & yAxis , const QVector3D & zAxis )**

        Constructs the quaternion using 3 axes ( **xAxis** , **yAxis** ,
        **zAxis** ).

        **Note:** The axes are assumed to be orthonormal.

        This function was introduced in Qt 5.5.

        **See also** **getAxes** () and **fromRotationMatrix** ().
        """
        ...

    @overload
    @staticmethod
    def fromAxisAndAngle(
        axis: PySide6.QtGui.QVector3D, angle: float
    ) -> PySide6.QtGui.QQuaternion:
        """
        https://doc.qt.io/qt-6/qquaternion.html#fromAxisAndAngle

        **[static] QQuaternion QQuaternion::fromAxisAndAngle(const QVector3D &
        axis , float angle )**

        Creates a normalized quaternion that corresponds to rotating through
        **angle** degrees about the specified 3D **axis**.

        **See also** **getAxisAndAngle** ().
        """
        ...

    @overload
    @staticmethod
    def fromAxisAndAngle(
        x: float, y: float, z: float, angle: float
    ) -> PySide6.QtGui.QQuaternion:
        """
        https://doc.qt.io/qt-6/qquaternion.html#fromAxisAndAngle-1

        **[static] QQuaternion QQuaternion::fromAxisAndAngle(float x , float y ,
        float z , float angle )**

        Creates a normalized quaternion that corresponds to rotating through
        **angle** degrees about the 3D axis ( **x** , **y** , **z** ).

        **See also** **getAxisAndAngle** ().
        """
        ...

    @staticmethod
    def fromDirection(
        direction: PySide6.QtGui.QVector3D, up: PySide6.QtGui.QVector3D
    ) -> PySide6.QtGui.QQuaternion:
        """
        https://doc.qt.io/qt-6/qquaternion.html#fromDirection

        **[static, since 5.5] QQuaternion QQuaternion::fromDirection(const
        QVector3D & direction , const QVector3D & up )**

        Constructs the quaternion using specified forward direction
        **direction** and upward direction **up**. If the upward direction was
        not specified or the forward and upward vectors are collinear, a new
        orthonormal upward direction will be generated.

        This function was introduced in Qt 5.5.

        **See also** **fromAxes** () and **rotationTo** ().
        """
        ...

    @overload
    @staticmethod
    def fromEulerAngles(
        eulerAngles: PySide6.QtGui.QVector3D,
    ) -> PySide6.QtGui.QQuaternion:
        """
        https://doc.qt.io/qt-6/qquaternion.html#fromEulerAngles

        **[static, since 5.5] QQuaternion QQuaternion::fromEulerAngles(float
        pitch , float yaw , float roll )**

        Creates a quaternion that corresponds to a rotation of **roll** degrees
        around the z axis, **pitch** degrees around the x axis, and **yaw**
        degrees around the y axis (in that order).

        This function was introduced in Qt 5.5.

        **See also** **getEulerAngles** ().
        """
        ...

    @overload
    @staticmethod
    def fromEulerAngles(
        pitch: float, yaw: float, roll: float
    ) -> PySide6.QtGui.QQuaternion:
        """
        https://doc.qt.io/qt-6/qquaternion.html#fromEulerAngles-1

        **[static, since 5.5] QQuaternion QQuaternion::fromEulerAngles(const
        QVector3D & eulerAngles )**

        This is an overloaded function.

        Creates a quaternion that corresponds to a rotation of **eulerAngles** :
        eulerAngles.**z** () degrees around the z axis, eulerAngles.**x** ()
        degrees around the x axis, and eulerAngles.**y** () degrees around the y
        axis (in that order).

        This function was introduced in Qt 5.5.

        **See also** **toEulerAngles** ().
        """
        ...

    @staticmethod
    def fromRotationMatrix(
        rot3x3: PySide6.QtGui.QMatrix3x3,
    ) -> PySide6.QtGui.QQuaternion:
        """
        https://doc.qt.io/qt-6/qquaternion.html#fromRotationMatrix

        **[static, since 5.5] QQuaternion QQuaternion::fromRotationMatrix(const
        QMatrix3x3 & rot3x3 )**

        Creates a quaternion that corresponds to a rotation matrix **rot3x3**.

        **Note:** If a given rotation matrix is not normalized, the resulting
        quaternion will contain scaling information.

        This function was introduced in Qt 5.5.

        **See also** **toRotationMatrix** () and **fromAxes** ().
        """
        ...

    def getAxes(
        self,
        xAxis: PySide6.QtGui.QVector3D,
        yAxis: PySide6.QtGui.QVector3D,
        zAxis: PySide6.QtGui.QVector3D,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qquaternion.html#getAxes

        **[since 5.5] void QQuaternion::getAxes(QVector3D * xAxis , QVector3D *
        yAxis , QVector3D * zAxis ) const**

        Returns the 3 orthonormal axes ( **xAxis** , **yAxis** , **zAxis** )
        defining the quaternion.

        This function was introduced in Qt 5.5.

        **See also** **fromAxes** () and **toRotationMatrix** ().
        """
        ...

    def inverted(self) -> PySide6.QtGui.QQuaternion:
        """
        https://doc.qt.io/qt-6/qquaternion.html#inverted

        **[since 5.5] QQuaternion QQuaternion::inverted() const**

        Returns the inverse of this quaternion. If this quaternion is null, then
        a null quaternion is returned.

        This function was introduced in Qt 5.5.

        **See also** **isNull** () and **length** ().
        """
        ...

    def isIdentity(self) -> bool:
        """
        https://doc.qt.io/qt-6/qquaternion.html#isIdentity

        **bool QQuaternion::isIdentity() const**

        Returns `true` if the x, y, and z components of this quaternion are set
        to 0.0, and the scalar component is set to 1.0; otherwise returns
        `false`.
        """
        ...

    def isNull(self) -> bool:
        """
        https://doc.qt.io/qt-6/qquaternion.html#isNull

        **bool QQuaternion::isNull() const**

        Returns `true` if the x, y, z, and scalar components of this quaternion
        are set to 0.0; otherwise returns `false`.
        """
        ...

    def length(self) -> float:
        """
        https://doc.qt.io/qt-6/qquaternion.html#length

        **float QQuaternion::length() const**

        Returns the length of the quaternion. This is also called the "norm".

        **See also** **lengthSquared** (), **normalized** (), and **dotProduct**
        ().
        """
        ...

    def lengthSquared(self) -> float:
        """
        https://doc.qt.io/qt-6/qquaternion.html#lengthSquared

        **float QQuaternion::lengthSquared() const**

        Returns the squared length of the quaternion.

        **Note:** Though cheap to compute, this is susceptible to overflow and
        underflow that **length** () avoids in many cases.

        **See also** **length** () and **dotProduct** ().
        """
        ...

    @staticmethod
    def nlerp(
        q1: PySide6.QtGui.QQuaternion, q2: PySide6.QtGui.QQuaternion, t: float
    ) -> PySide6.QtGui.QQuaternion:
        """
        https://doc.qt.io/qt-6/qquaternion.html#nlerp

        **[static] QQuaternion QQuaternion::nlerp(const QQuaternion & q1 , const
        QQuaternion & q2 , float t )**

        Interpolates along the shortest linear path between the rotational
        positions **q1** and **q2**. The value **t** should be between 0 and 1,
        indicating the distance to travel between **q1** and **q2**. The result
        will be **normalized** ().

        If **t** is less than or equal to 0, then **q1** will be returned. If
        **t** is greater than or equal to 1, then **q2** will be returned.

        The nlerp() function is typically faster than **slerp** () and will give
        approximate results to spherical interpolation that are good enough for
        some applications.

        **See also** **slerp** ().
        """
        ...

    def normalize(self) -> None:
        """
        https://doc.qt.io/qt-6/qquaternion.html#normalize

        **void QQuaternion::normalize()**

        Normalizes the current quaternion in place. Nothing happens if this is a
        null quaternion or the length of the quaternion is very close to 1.

        **See also** **length** () and **normalized** ().
        """
        ...

    def normalized(self) -> PySide6.QtGui.QQuaternion:
        """
        https://doc.qt.io/qt-6/qquaternion.html#normalized

        **QQuaternion QQuaternion::normalized() const**

        Returns the normalized unit form of this quaternion.

        If this quaternion is null, then a null quaternion is returned. If the
        length of the quaternion is very close to 1, then the quaternion will be
        returned as-is. Otherwise the normalized form of the quaternion of
        length 1 will be returned.

        **See also** **normalize** (), **length** (), and **dotProduct** ().
        """
        ...

    def rotatedVector(self, vector: PySide6.QtGui.QVector3D) -> PySide6.QtGui.QVector3D:
        """
        https://doc.qt.io/qt-6/qquaternion.html#rotatedVector

        **QVector3D QQuaternion::rotatedVector(const QVector3D & vector )
        const**

        Rotates **vector** with this quaternion to produce a new vector in 3D
        space. The following code:

        QVector3D result = q.rotatedVector(vector);

        is equivalent to the following:

        QVector3D result = (q * **QQuaternion** (0, vector) *
        q.conjugated()).vector();
        """
        ...

    @staticmethod
    def rotationTo(
        from_: PySide6.QtGui.QVector3D, to: PySide6.QtGui.QVector3D
    ) -> PySide6.QtGui.QQuaternion:
        """
        https://doc.qt.io/qt-6/qquaternion.html#rotationTo

        **[static, since 5.5] QQuaternion QQuaternion::rotationTo(const
        QVector3D & from , const QVector3D & to )**

        Returns the shortest arc quaternion to rotate from the direction
        described by the vector **from** to the direction described by the
        vector **to**.

        This function was introduced in Qt 5.5.

        **See also** **fromDirection** ().
        """
        ...

    def scalar(self) -> float:
        """
        https://doc.qt.io/qt-6/qquaternion.html#scalar

        **float QQuaternion::scalar() const**

        Returns the scalar component of this quaternion.

        **See also** **setScalar** (), **x** (), **y** (), and **z** ().
        """
        ...

    def setScalar(self, scalar: float) -> None:
        """
        https://doc.qt.io/qt-6/qquaternion.html#setScalar

        **void QQuaternion::setScalar(float scalar )**

        Sets the scalar component of this quaternion to **scalar**.

        **See also** **scalar** (), **setX** (), **setY** (), and **setZ** ().
        """
        ...

    @overload
    def setVector(self, vector: PySide6.QtGui.QVector3D) -> None:
        """
        https://doc.qt.io/qt-6/qquaternion.html#setVector

        **void QQuaternion::setVector(const QVector3D & vector )**

        Sets the vector component of this quaternion to **vector**.

        **See also** **vector** () and **setScalar** ().
        """
        ...

    @overload
    def setVector(self, x: float, y: float, z: float) -> None:
        """
        https://doc.qt.io/qt-6/qquaternion.html#setVector-1

        **void QQuaternion::setVector(float x , float y , float z )**

        Sets the vector component of this quaternion to ( **x** , **y** , **z**
        ).

        **See also** **vector** () and **setScalar** ().
        """
        ...

    def setX(self, x: float) -> None:
        """
        https://doc.qt.io/qt-6/qquaternion.html#setX

        **void QQuaternion::setX(float x )**

        Sets the x coordinate of this quaternion's vector to the given **x**
        coordinate.

        **See also** **x** (), **setY** (), **setZ** (), and **setScalar** ().
        """
        ...

    def setY(self, y: float) -> None:
        """
        https://doc.qt.io/qt-6/qquaternion.html#setY

        **void QQuaternion::setY(float y )**

        Sets the y coordinate of this quaternion's vector to the given **y**
        coordinate.

        **See also** **y** (), **setX** (), **setZ** (), and **setScalar** ().
        """
        ...

    def setZ(self, z: float) -> None:
        """
        https://doc.qt.io/qt-6/qquaternion.html#setZ

        **void QQuaternion::setZ(float z )**

        Sets the z coordinate of this quaternion's vector to the given **z**
        coordinate.

        **See also** **z** (), **setX** (), **setY** (), and **setScalar** ().
        """
        ...

    @staticmethod
    def slerp(
        q1: PySide6.QtGui.QQuaternion, q2: PySide6.QtGui.QQuaternion, t: float
    ) -> PySide6.QtGui.QQuaternion:
        """
        https://doc.qt.io/qt-6/qquaternion.html#slerp

        **[static] QQuaternion QQuaternion::slerp(const QQuaternion & q1 , const
        QQuaternion & q2 , float t )**

        Interpolates along the shortest spherical path between the rotational
        positions **q1** and **q2**. The value **t** should be between 0 and 1,
        indicating the spherical distance to travel between **q1** and **q2**.

        If **t** is less than or equal to 0, then **q1** will be returned. If
        **t** is greater than or equal to 1, then **q2** will be returned.

        **See also** **nlerp** ().
        """
        ...

    def toEulerAngles(self) -> PySide6.QtGui.QVector3D:
        """
        https://doc.qt.io/qt-6/qquaternion.html#toEulerAngles

        **[since 5.5] QVector3D QQuaternion::toEulerAngles() const**

        This is an overloaded function.

        Calculates roll, pitch, and yaw Euler angles (in degrees) that
        corresponds to this quaternion.

        This function was introduced in Qt 5.5.

        **See also** **fromEulerAngles** ().
        """
        ...

    def toRotationMatrix(self) -> PySide6.QtGui.QMatrix3x3:
        """
        https://doc.qt.io/qt-6/qquaternion.html#toRotationMatrix

        **[since 5.5] QMatrix3x3 QQuaternion::toRotationMatrix() const**

        Creates a rotation matrix that corresponds to this quaternion.

        **Note:** If this quaternion is not normalized, the resulting rotation
        matrix will contain scaling information.

        This function was introduced in Qt 5.5.

        **See also** **fromRotationMatrix** () and **getAxes** ().
        """
        ...

    def toVector4D(self) -> PySide6.QtGui.QVector4D:
        """
        https://doc.qt.io/qt-6/qquaternion.html#toVector4D

        **QVector4D QQuaternion::toVector4D() const**

        Returns this quaternion as a 4D vector.
        """
        ...

    def vector(self) -> PySide6.QtGui.QVector3D:
        """
        https://doc.qt.io/qt-6/qquaternion.html#vector

        **QVector3D QQuaternion::vector() const**

        Returns the vector component of this quaternion.

        **See also** **setVector** () and **scalar** ().
        """
        ...

    def x(self) -> float:
        """
        https://doc.qt.io/qt-6/qquaternion.html#x

        **float QQuaternion::x() const**

        Returns the x coordinate of this quaternion's vector.

        **See also** **setX** (), **y** (), **z** (), and **scalar** ().
        """
        ...

    def y(self) -> float:
        """
        https://doc.qt.io/qt-6/qquaternion.html#y

        **float QQuaternion::y() const**

        Returns the y coordinate of this quaternion's vector.

        **See also** **setY** (), **x** (), **z** (), and **scalar** ().
        """
        ...

    def z(self) -> float:
        """
        https://doc.qt.io/qt-6/qquaternion.html#z

        **float QQuaternion::z() const**

        Returns the z coordinate of this quaternion's vector.

        **See also** **setZ** (), **x** (), **y** (), and **scalar** ().
        """
        ...
