"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtGui, except for defaults which are replaced by "...".
"""
from typing import List, Sequence, Union, overload
import PySide6.QtCore
import PySide6.QtGui

bytes = str


class QPolygonF(object):
    """
    https://doc.qt.io/qt-6/qpolygonf.html

    **Detailed Description**

    A QPolygonF is a **QList** <**QPointF** >. The easiest way to add points to
    a QPolygonF is to use its streaming operator, as illustrated below:

    **QPolygonF**  polygon;
        polygon << **QPointF** (10.4, 20.5) <<
    **QPointF** (20.2, 30.2);

    In addition to the functions provided by **QList** , QPolygonF provides the
    **boundingRect** () and **translate** () functions for geometry operations.
    Use the **QTransform::map** () function for more general transformations of
    QPolygonFs.

    QPolygonF also provides the **isClosed** () function to determine whether a
    polygon's start and end points are the same, and the **toPolygon** ()
    function returning an integer precision copy of this polygon.

    The QPolygonF class is **implicitly shared** .

    **See also** **QList** , **QPolygon** , and **QLineF** .
    """

    @overload
    def __init__(self) -> None:
        """
        https://doc.qt.io/qt-6/qpolygonf.html#QPolygonF

        **QPolygonF::QPolygonF()**

        Constructs a polygon with no points.

        **See also** **QList::isEmpty** ().
        """
        ...

    @overload
    def __init__(
        self,
        QPolygonF: Union[
            PySide6.QtGui.QPolygonF,
            Sequence[PySide6.QtCore.QPointF],
            PySide6.QtGui.QPolygon,
            PySide6.QtCore.QRectF,
        ],
    ) -> None:
        """
        https://doc.qt.io/qt-6/qpolygonf.html#QPolygonF-1

        **QPolygonF::QPolygonF(const QList<QPointF> & points )**

        Constructs a polygon containing the specified **points**.
        """
        ...

    @overload
    def __init__(
        self,
        a: Union[
            PySide6.QtGui.QPolygon,
            Sequence[PySide6.QtCore.QPoint],
            PySide6.QtCore.QRect,
        ],
    ) -> None:
        """
        https://doc.qt.io/qt-6/qpolygonf.html#QPolygonF-3

        **QPolygonF::QPolygonF(const QRectF & rectangle )**

        Constructs a closed polygon from the specified **rectangle**.

        The polygon contains the four vertices of the rectangle in clockwise
        order starting and ending with the top-left vertex.

        **See also** **isClosed** ().
        """
        ...

    @overload
    def __init__(self, r: Union[PySide6.QtCore.QRectF, PySide6.QtCore.QRect]) -> None:
        """
        https://doc.qt.io/qt-6/qpolygonf.html#QPolygonF-4

        **QPolygonF::QPolygonF(const QPolygon & polygon )**

        Constructs a float based polygon from the specified integer based
        **polygon**.

        **See also** **toPolygon** ().
        """
        ...

    @overload
    def __init__(self, v: Sequence[PySide6.QtCore.QPointF]) -> None:
        """
        https://doc.qt.io/qt-6/qpolygonf.html#QPolygonF

        **QPolygonF::QPolygonF()**

        Constructs a polygon with no points.

        **See also** **QList::isEmpty** ().
        """
        ...

    def __add__(
        self, l: Sequence[PySide6.QtCore.QPointF]
    ) -> List[PySide6.QtCore.QPointF]:
        ...

    @staticmethod
    def __copy__() -> None:
        ...

    def __lshift__(
        self, stream: PySide6.QtCore.QDataStream
    ) -> PySide6.QtCore.QDataStream:
        ...

    def __mul__(self, m: PySide6.QtGui.QTransform) -> PySide6.QtGui.QPolygonF:
        ...

    def __rshift__(
        self, stream: PySide6.QtCore.QDataStream
    ) -> PySide6.QtCore.QDataStream:
        ...

    @overload
    def append(
        self,
        arg__1: Union[
            PySide6.QtCore.QPointF,
            PySide6.QtCore.QPoint,
            PySide6.QtGui.QPainterPath.Element,
        ],
    ) -> None:
        ...

    @overload
    def append(self, l: Sequence[PySide6.QtCore.QPointF]) -> None:
        ...

    def at(self, i: int) -> PySide6.QtCore.QPointF:
        ...

    def back(self) -> PySide6.QtCore.QPointF:
        ...

    def boundingRect(self) -> PySide6.QtCore.QRectF:
        """
        https://doc.qt.io/qt-6/qpolygonf.html#boundingRect

        **QRectF QPolygonF::boundingRect() const**

        Returns the bounding rectangle of the polygon, or **QRectF** (0,0,0,0)
        if the polygon is empty.

        **See also** **QList::isEmpty** ().
        """
        ...

    def capacity(self) -> int:
        ...

    def clear(self) -> None:
        ...

    def constData(self) -> PySide6.QtCore.QPointF:
        ...

    def constFirst(self) -> PySide6.QtCore.QPointF:
        ...

    def constLast(self) -> PySide6.QtCore.QPointF:
        ...

    def containsPoint(
        self,
        pt: Union[
            PySide6.QtCore.QPointF,
            PySide6.QtCore.QPoint,
            PySide6.QtGui.QPainterPath.Element,
        ],
        fillRule: PySide6.QtCore.Qt.FillRule,
    ) -> bool:
        """
        https://doc.qt.io/qt-6/qpolygonf.html#containsPoint

        **bool QPolygonF::containsPoint(const QPointF & point , Qt::FillRule
        fillRule ) const**

        Returns `true` if the given **point** is inside the polygon according to
        the specified **fillRule** ; otherwise returns `false`.
        """
        ...

    def count(self) -> int:
        ...

    def data(self) -> PySide6.QtCore.QPointF:
        ...

    def empty(self) -> bool:
        ...

    @overload
    def first(self) -> PySide6.QtCore.QPointF:
        ...

    @overload
    def first(self, n: int) -> List[PySide6.QtCore.QPointF]:
        ...

    @staticmethod
    def fromList(
        list: Sequence[PySide6.QtCore.QPointF],
    ) -> List[PySide6.QtCore.QPointF]:
        ...

    @staticmethod
    def fromVector(
        vector: Sequence[PySide6.QtCore.QPointF],
    ) -> List[PySide6.QtCore.QPointF]:
        ...

    def front(self) -> PySide6.QtCore.QPointF:
        ...

    def insert(
        self,
        arg__1: int,
        arg__2: Union[
            PySide6.QtCore.QPointF,
            PySide6.QtCore.QPoint,
            PySide6.QtGui.QPainterPath.Element,
        ],
    ) -> None:
        ...

    def intersected(
        self,
        r: Union[
            PySide6.QtGui.QPolygonF,
            Sequence[PySide6.QtCore.QPointF],
            PySide6.QtGui.QPolygon,
            PySide6.QtCore.QRectF,
        ],
    ) -> PySide6.QtGui.QPolygonF:
        """
        https://doc.qt.io/qt-6/qpolygonf.html#intersected

        **QPolygonF QPolygonF::intersected(const QPolygonF & r ) const**

        Returns a polygon which is the intersection of this polygon and **r**.

        Set operations on polygons will treat the polygons as areas. Non-closed
        polygons will be treated as implicitly closed.

        **See also** **intersects** ().
        """
        ...

    def intersects(
        self,
        r: Union[
            PySide6.QtGui.QPolygonF,
            Sequence[PySide6.QtCore.QPointF],
            PySide6.QtGui.QPolygon,
            PySide6.QtCore.QRectF,
        ],
    ) -> bool:
        """
        https://doc.qt.io/qt-6/qpolygonf.html#intersects

        **[since 5.10] bool QPolygonF::intersects(const QPolygonF & p ) const**

        Returns `true` if the current polygon intersects at any point the given
        polygon **p**. Also returns `true` if the current polygon contains or is
        contained by any part of **p**.

        Set operations on polygons will treat the polygons as areas. Non-closed
        polygons will be treated as implicitly closed.

        This function was introduced in Qt 5.10.

        **See also** **intersected** ().
        """
        ...

    def isClosed(self) -> bool:
        """
        https://doc.qt.io/qt-6/qpolygonf.html#isClosed

        **bool QPolygonF::isClosed() const**

        Returns `true` if the polygon is closed; otherwise returns `false`.

        A polygon is said to be closed if its start point and end point are
        equal.

        **See also** **QList::first** () and **QList::last** ().
        """
        ...

    def isEmpty(self) -> bool:
        ...

    def isSharedWith(self, other: Sequence[PySide6.QtCore.QPointF]) -> bool:
        ...

    @overload
    def last(self) -> PySide6.QtCore.QPointF:
        ...

    @overload
    def last(self, n: int) -> List[PySide6.QtCore.QPointF]:
        ...

    def length(self) -> int:
        ...

    def mid(self, pos: int, len: int = ...) -> List[PySide6.QtCore.QPointF]:
        ...

    def move(self, from_: int, to: int) -> None:
        ...

    def pop_back(self) -> None:
        ...

    def pop_front(self) -> None:
        ...

    def prepend(
        self,
        arg__1: Union[
            PySide6.QtCore.QPointF,
            PySide6.QtCore.QPoint,
            PySide6.QtGui.QPainterPath.Element,
        ],
    ) -> None:
        ...

    def push_back(
        self,
        arg__1: Union[
            PySide6.QtCore.QPointF,
            PySide6.QtCore.QPoint,
            PySide6.QtGui.QPainterPath.Element,
        ],
    ) -> None:
        ...

    def push_front(
        self,
        arg__1: Union[
            PySide6.QtCore.QPointF,
            PySide6.QtCore.QPoint,
            PySide6.QtGui.QPainterPath.Element,
        ],
    ) -> None:
        ...

    def remove(self, i: int, n: int = ...) -> None:
        ...

    def removeAll(
        self,
        arg__1: Union[
            PySide6.QtCore.QPointF,
            PySide6.QtCore.QPoint,
            PySide6.QtGui.QPainterPath.Element,
        ],
    ) -> None:
        ...

    def removeAt(self, i: int) -> None:
        ...

    def removeFirst(self) -> None:
        ...

    def removeLast(self) -> None:
        ...

    def removeOne(
        self,
        arg__1: Union[
            PySide6.QtCore.QPointF,
            PySide6.QtCore.QPoint,
            PySide6.QtGui.QPainterPath.Element,
        ],
    ) -> None:
        ...

    def reserve(self, size: int) -> None:
        ...

    def resize(self, size: int) -> None:
        ...

    def shrink_to_fit(self) -> None:
        ...

    def size(self) -> int:
        ...

    @overload
    def sliced(self, pos: int) -> List[PySide6.QtCore.QPointF]:
        ...

    @overload
    def sliced(self, pos: int, n: int) -> List[PySide6.QtCore.QPointF]:
        ...

    def squeeze(self) -> None:
        ...

    def subtracted(
        self,
        r: Union[
            PySide6.QtGui.QPolygonF,
            Sequence[PySide6.QtCore.QPointF],
            PySide6.QtGui.QPolygon,
            PySide6.QtCore.QRectF,
        ],
    ) -> PySide6.QtGui.QPolygonF:
        """
        https://doc.qt.io/qt-6/qpolygonf.html#subtracted

        **QPolygonF QPolygonF::subtracted(const QPolygonF & r ) const**

        Returns a polygon which is **r** subtracted from this polygon.

        Set operations on polygons will treat the polygons as areas. Non-closed
        polygons will be treated as implicitly closed.
        """
        ...

    def swap(
        self,
        other: Union[
            PySide6.QtGui.QPolygonF,
            Sequence[PySide6.QtCore.QPointF],
            PySide6.QtGui.QPolygon,
            PySide6.QtCore.QRectF,
        ],
    ) -> None:
        """
        https://doc.qt.io/qt-6/qpolygonf.html#swap

        **void QPolygonF::swap(QPolygonF & other )**

        Swaps polygon **other** with this polygon. This operation is very fast
        and never fails.
        """
        ...

    def swapItemsAt(self, i: int, j: int) -> None:
        ...

    def takeAt(self, i: int) -> PySide6.QtCore.QPointF:
        ...

    def toList(self) -> List[PySide6.QtCore.QPointF]:
        ...

    def toPolygon(self) -> PySide6.QtGui.QPolygon:
        """
        https://doc.qt.io/qt-6/qpolygonf.html#toPolygon

        **QPolygon QPolygonF::toPolygon() const**

        Creates and returns a **QPolygon**  by converting each **QPointF**  to a
        **QPoint** .

        **See also** **QPointF::toPoint** ().
        """
        ...

    def toVector(self) -> List[PySide6.QtCore.QPointF]:
        ...

    @overload
    def translate(self, dx: float, dy: float) -> None:
        """
        https://doc.qt.io/qt-6/qpolygonf.html#translate

        **void QPolygonF::translate(const QPointF & offset )**

        Translate all points in the polygon by the given **offset**.

        **See also** **translated** ().
        """
        ...

    @overload
    def translate(
        self,
        offset: Union[
            PySide6.QtCore.QPointF,
            PySide6.QtCore.QPoint,
            PySide6.QtGui.QPainterPath.Element,
        ],
    ) -> None:
        """
        https://doc.qt.io/qt-6/qpolygonf.html#translate-1

        **void QPolygonF::translate(qreal dx , qreal dy )**

        This is an overloaded function.

        Translates all points in the polygon by ( **dx** , **dy** ).

        **See also** **translated** ().
        """
        ...

    @overload
    def translated(self, dx: float, dy: float) -> PySide6.QtGui.QPolygonF:
        """
        https://doc.qt.io/qt-6/qpolygonf.html#translated

        **QPolygonF QPolygonF::translated(const QPointF & offset ) const**

        Returns a copy of the polygon that is translated by the given
        **offset**.

        **See also** **translate** ().
        """
        ...

    @overload
    def translated(
        self,
        offset: Union[
            PySide6.QtCore.QPointF,
            PySide6.QtCore.QPoint,
            PySide6.QtGui.QPainterPath.Element,
        ],
    ) -> PySide6.QtGui.QPolygonF:
        """
        https://doc.qt.io/qt-6/qpolygonf.html#translated-1

        **QPolygonF QPolygonF::translated(qreal dx , qreal dy ) const**

        This is an overloaded function.

        Returns a copy of the polygon that is translated by ( **dx** , **dy** ).

        **See also** **translate** ().
        """
        ...

    def united(
        self,
        r: Union[
            PySide6.QtGui.QPolygonF,
            Sequence[PySide6.QtCore.QPointF],
            PySide6.QtGui.QPolygon,
            PySide6.QtCore.QRectF,
        ],
    ) -> PySide6.QtGui.QPolygonF:
        """
        https://doc.qt.io/qt-6/qpolygonf.html#united

        **QPolygonF QPolygonF::united(const QPolygonF & r ) const**

        Returns a polygon which is the union of this polygon and **r**.

        Set operations on polygons will treat the polygons as areas. Non-closed
        polygons will be treated as implicitly closed.

        **See also** **intersected** () and **subtracted** ().
        """
        ...

    def value(self, i: int) -> PySide6.QtCore.QPointF:
        ...
