"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtGui, except for defaults which are replaced by "...".
"""
from typing import Union, overload
import PySide6.QtCore
import PySide6.QtGui

bytes = str


class QPaintEvent(PySide6.QtCore.QEvent):
    """
    https://doc.qt.io/qt-6/qpaintevent.html

    **Detailed Description**

    Paint events are sent to widgets that need to update themselves, for
    instance when part of a widget is exposed because a covering widget was
    moved.

    The event contains a **region** () that needs to be updated, and a **rect**
    () that is the bounding rectangle of that region. Both are provided because
    many widgets cannot make much use of **region** (), and **rect** () can be
    much faster than **region** ().boundingRect().

    **Automatic Clipping**

    Painting is clipped to **region** () during the processing of a paint event.
    This clipping is performed by Qt's paint system and is independent of any
    clipping that may be applied to a **QPainter**  used to draw on the paint
    device.

    As a result, the value returned by **QPainter::clipRegion** () on a newly-
    constructed **QPainter**  will not reflect the clip region that is used by
    the paint system.

    **See also** **QPainter** , **QWidget::update** (), **QWidget::repaint** (),
    and **QWidget::paintEvent** ().
    """

    @overload
    def __init__(self, arg__1: PySide6.QtGui.QPaintEvent) -> None:
        """
        https://doc.qt.io/qt-6/qpaintevent.html#QPaintEvent-2

        **QPaintEvent::QPaintEvent(const QRegion & paintRegion )**

        Constructs a paint event object with the region that needs to be
        updated. The region is specified by **paintRegion**.
        """
        ...

    @overload
    def __init__(self, paintRect: PySide6.QtCore.QRect) -> None:
        """
        https://doc.qt.io/qt-6/qpaintevent.html#QPaintEvent-3

        **QPaintEvent::QPaintEvent(const QRect & paintRect )**

        Constructs a paint event object with the rectangle that needs to be
        updated. The region is specified by **paintRect**.
        """
        ...

    @overload
    def __init__(
        self,
        paintRegion: Union[
            PySide6.QtGui.QRegion,
            PySide6.QtGui.QBitmap,
            PySide6.QtGui.QPolygon,
            PySide6.QtCore.QRect,
        ],
    ) -> None:
        """
        https://doc.qt.io/qt-6/qpaintevent.html#QPaintEvent-2

        **QPaintEvent::QPaintEvent(const QRegion & paintRegion )**

        Constructs a paint event object with the region that needs to be
        updated. The region is specified by **paintRegion**.
        """
        ...

    def clone(self) -> PySide6.QtGui.QPaintEvent:
        ...

    def rect(self) -> PySide6.QtCore.QRect:
        """
        https://doc.qt.io/qt-6/qpaintevent.html#rect

        **const QRect &QPaintEvent::rect() const**

        Returns the rectangle that needs to be updated.

        **See also** **region** () and **QPainter::setClipRect** ().
        """
        ...

    def region(self) -> PySide6.QtGui.QRegion:
        """
        https://doc.qt.io/qt-6/qpaintevent.html#region

        **const QRegion &QPaintEvent::region() const**

        Returns the region that needs to be updated.

        **See also** **rect** () and **QPainter::setClipRegion** ().
        """
        ...
