"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtGui, except for defaults which are replaced by "...".
"""
from typing import Sequence, overload
import PySide6.QtCore
import PySide6.QtGui

bytes = str


class QOpenGLExtraFunctions(PySide6.QtGui.QOpenGLFunctions):
    """
    https://doc.qt.io/qt-6/qopenglextrafunctions.html

    **Detailed Description**

    This subclass of **QOpenGLFunctions**  includes the OpenGL ES 3.0, 3.1 and
    3.2 functions. These will only work when an OpenGL ES 3.x context, or an
    OpenGL context of a version containing the functions in question either in
    core or as extension, is in use. This allows developing GLES 3.x
    applications in a cross-platform manner: development can happen on a desktop
    platform with OpenGL 3.x or 4.x, deploying to a true GLES 3.x device later
    on will require no or minimal changes to the application.

    **Note:** This class is different from the versioned OpenGL wrappers, for
    instance **QOpenGLFunctions_3_2_Core** . The versioned function wrappers
    target a given version and profile of OpenGL. They are therefore not
    suitable for cross-OpenGL-OpenGLES development.
    """

    @overload
    def __init__(self) -> None:
        """
        https://doc.qt.io/qt-6/qopenglextrafunctions.html#QOpenGLExtraFunctions

        **QOpenGLExtraFunctions::QOpenGLExtraFunctions()**

        Constructs a default function resolver. The resolver cannot be used
        until **initializeOpenGLFunctions** () is called to specify the context.
        """
        ...

    @overload
    def __init__(self, context: PySide6.QtGui.QOpenGLContext) -> None:
        """
        https://doc.qt.io/qt-6/qopenglextrafunctions.html#QOpenGLExtraFunctions-
        1

        **QOpenGLExtraFunctions::QOpenGLExtraFunctions(QOpenGLContext * context
        )**

        Constructs a function resolver for context. If **context** is `nullptr`,
        then the resolver will be created for the current **QOpenGLContext** .

        The context or another context in the group must be current.

        An object constructed in this way can only be used with context and
        other contexts that share with it. Use **initializeOpenGLFunctions** ()
        to change the object's context association.
        """
        ...

    def glActiveShaderProgram(self, pipeline: int, program: int) -> None:
        """
        https://doc.qt.io/qt-6/qopenglextrafunctions.html#glActiveShaderProgram

        **void QOpenGLExtraFunctions::glActiveShaderProgram(GLuint pipeline ,
        GLuint program )**

        Convenience function that calls glActiveShaderProgram( **pipeline** ,
        **program** ).

        This function is only available in OpenGL ES 3.x, or OpenGL 3.x or 4.x
        contexts. When running with plain OpenGL, the function is only usable
        when the given profile and version contains the function either in core
        or as an extension.

        For more information, see the OpenGL ES 3.x documentation for
        **glActiveShaderProgram()** .
        """
        ...

    def glBeginQuery(self, target: int, id: int) -> None:
        """
        https://doc.qt.io/qt-6/qopenglextrafunctions.html#glBeginQuery

        **void QOpenGLExtraFunctions::glBeginQuery(GLenum target , GLuint id )**

        Convenience function that calls glBeginQuery( **target** , **id** ).

        This function is only available in OpenGL ES 3.x, or OpenGL 3.x or 4.x
        contexts. When running with plain OpenGL, the function is only usable
        when the given profile and version contains the function either in core
        or as an extension.

        For more information, see the OpenGL ES 3.x documentation for
        **glBeginQuery()** .
        """
        ...

    def glBeginTransformFeedback(self, primitiveMode: int) -> None:
        """
        https://doc.qt.io/qt-6/qopenglextrafunctions.html#glBeginTransformFeedba
        ck

        **void QOpenGLExtraFunctions::glBeginTransformFeedback(GLenum
        primitiveMode )**

        Convenience function that calls glBeginTransformFeedback(
        **primitiveMode** ).

        This function is only available in OpenGL ES 3.x, or OpenGL 3.x or 4.x
        contexts. When running with plain OpenGL, the function is only usable
        when the given profile and version contains the function either in core
        or as an extension.

        For more information, see the OpenGL ES 3.x documentation for
        **glBeginTransformFeedback()** .
        """
        ...

    def glBindBufferBase(self, target: int, index: int, buffer: int) -> None:
        """
        https://doc.qt.io/qt-6/qopenglextrafunctions.html#glBindBufferBase

        **void QOpenGLExtraFunctions::glBindBufferBase(GLenum target , GLuint
        index , GLuint buffer )**

        Convenience function that calls glBindBufferBase( **target** , **index**
        , **buffer** ).

        This function is only available in OpenGL ES 3.x, or OpenGL 3.x or 4.x
        contexts. When running with plain OpenGL, the function is only usable
        when the given profile and version contains the function either in core
        or as an extension.

        For more information, see the OpenGL ES 3.x documentation for
        **glBindBufferBase()** .
        """
        ...

    def glBindImageTexture(
        self,
        unit: int,
        texture: int,
        level: int,
        layered: int,
        layer: int,
        access: int,
        format: int,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qopenglextrafunctions.html#glBindImageTexture

        **void QOpenGLExtraFunctions::glBindImageTexture(GLuint unit , GLuint
        texture , GLint level , GLboolean layered , GLint layer , GLenum access
        , GLenum format )**

        Convenience function that calls glBindImageTexture( **unit** ,
        **texture** , **level** , **layered** , **layer** , **access** ,
        **format** ).

        This function is only available in OpenGL ES 3.x, or OpenGL 3.x or 4.x
        contexts. When running with plain OpenGL, the function is only usable
        when the given profile and version contains the function either in core
        or as an extension.

        For more information, see the OpenGL ES 3.x documentation for
        **glBindImageTexture()** .
        """
        ...

    def glBindProgramPipeline(self, pipeline: int) -> None:
        """
        https://doc.qt.io/qt-6/qopenglextrafunctions.html#glBindProgramPipeline

        **void QOpenGLExtraFunctions::glBindProgramPipeline(GLuint pipeline )**

        Convenience function that calls glBindProgramPipeline( **pipeline** ).

        This function is only available in OpenGL ES 3.x, or OpenGL 3.x or 4.x
        contexts. When running with plain OpenGL, the function is only usable
        when the given profile and version contains the function either in core
        or as an extension.

        For more information, see the OpenGL ES 3.x documentation for
        **glBindProgramPipeline()** .
        """
        ...

    def glBindSampler(self, unit: int, sampler: int) -> None:
        """
        https://doc.qt.io/qt-6/qopenglextrafunctions.html#glBindSampler

        **void QOpenGLExtraFunctions::glBindSampler(GLuint unit , GLuint sampler
        )**

        Convenience function that calls glBindSampler( **unit** , **sampler** ).

        This function is only available in OpenGL ES 3.x, or OpenGL 3.x or 4.x
        contexts. When running with plain OpenGL, the function is only usable
        when the given profile and version contains the function either in core
        or as an extension.

        For more information, see the OpenGL ES 3.x documentation for
        **glBindSampler()** .
        """
        ...

    def glBindTransformFeedback(self, target: int, id: int) -> None:
        """
        https://doc.qt.io/qt-6/qopenglextrafunctions.html#glBindTransformFeedbac
        k

        **void QOpenGLExtraFunctions::glBindTransformFeedback(GLenum target ,
        GLuint id )**

        Convenience function that calls glBindTransformFeedback( **target** ,
        **id** ).

        This function is only available in OpenGL ES 3.x, or OpenGL 3.x or 4.x
        contexts. When running with plain OpenGL, the function is only usable
        when the given profile and version contains the function either in core
        or as an extension.

        For more information, see the OpenGL ES 3.x documentation for
        **glBindTransformFeedback()** .
        """
        ...

    def glBindVertexArray(self, array: int) -> None:
        """
        https://doc.qt.io/qt-6/qopenglextrafunctions.html#glBindVertexArray

        **void QOpenGLExtraFunctions::glBindVertexArray(GLuint array )**

        Convenience function that calls glBindVertexArray( **array** ).

        This function is only available in OpenGL ES 3.x, or OpenGL 3.x or 4.x
        contexts. When running with plain OpenGL, the function is only usable
        when the given profile and version contains the function either in core
        or as an extension.

        For more information, see the OpenGL ES 3.x documentation for
        **glBindVertexArray()** .
        """
        ...

    def glBlendBarrier(self) -> None:
        """
        https://doc.qt.io/qt-6/qopenglextrafunctions.html#glBlendBarrier

        **void QOpenGLExtraFunctions::glBlendBarrier()**

        Convenience function that calls glBlendBarrier().

        This function is only available in OpenGL ES 3.x, or OpenGL 3.x or 4.x
        contexts. When running with plain OpenGL, the function is only usable
        when the given profile and version contains the function either in core
        or as an extension.

        For more information, see the OpenGL ES 3.X documentation for
        **glBlendBarrier()** .
        """
        ...

    def glBlendEquationSeparatei(self, buf: int, modeRGB: int, modeAlpha: int) -> None:
        """
        https://doc.qt.io/qt-6/qopenglextrafunctions.html#glBlendEquationSeparat
        ei

        **void QOpenGLExtraFunctions::glBlendEquationSeparatei(GLuint buf ,
        GLenum modeRGB , GLenum modeAlpha )**

        Convenience function that calls glBlendEquationSeparatei( **buf** ,
        **modeRGB** , **modeAlpha** ).

        This function is only available in OpenGL ES 3.x, or OpenGL 3.x or 4.x
        contexts. When running with plain OpenGL, the function is only usable
        when the given profile and version contains the function either in core
        or as an extension.

        For more information, see the OpenGL ES 3.X documentation for
        **glBlendEquationSeparatei()** .
        """
        ...

    def glBlendEquationi(self, buf: int, mode: int) -> None:
        """
        https://doc.qt.io/qt-6/qopenglextrafunctions.html#glBlendEquationi

        **void QOpenGLExtraFunctions::glBlendEquationi(GLuint buf , GLenum mode
        )**

        Convenience function that calls glBlendEquationi( **buf** , **mode** ).

        This function is only available in OpenGL ES 3.x, or OpenGL 3.x or 4.x
        contexts. When running with plain OpenGL, the function is only usable
        when the given profile and version contains the function either in core
        or as an extension.

        For more information, see the OpenGL ES 3.X documentation for
        **glBlendEquationi()** .
        """
        ...

    def glBlendFuncSeparatei(
        self, buf: int, srcRGB: int, dstRGB: int, srcAlpha: int, dstAlpha: int
    ) -> None:
        """
        https://doc.qt.io/qt-6/qopenglextrafunctions.html#glBlendFuncSeparatei

        **void QOpenGLExtraFunctions::glBlendFuncSeparatei(GLuint buf , GLenum
        srcRGB , GLenum dstRGB , GLenum srcAlpha , GLenum dstAlpha )**

        Convenience function that calls glBlendFuncSeparatei( **buf** ,
        **srcRGB** , **dstRGB** , **srcAlpha** , **dstAlpha** ).

        This function is only available in OpenGL ES 3.x, or OpenGL 3.x or 4.x
        contexts. When running with plain OpenGL, the function is only usable
        when the given profile and version contains the function either in core
        or as an extension.

        For more information, see the OpenGL ES 3.X documentation for
        **glBlendFuncSeparatei()** .
        """
        ...

    def glBlendFunci(self, buf: int, src: int, dst: int) -> None:
        """
        https://doc.qt.io/qt-6/qopenglextrafunctions.html#glBlendFunci

        **void QOpenGLExtraFunctions::glBlendFunci(GLuint buf , GLenum src ,
        GLenum dst )**

        Convenience function that calls glBlendFunci( **buf** , **src** ,
        **dst** ).

        This function is only available in OpenGL ES 3.x, or OpenGL 3.x or 4.x
        contexts. When running with plain OpenGL, the function is only usable
        when the given profile and version contains the function either in core
        or as an extension.

        For more information, see the OpenGL ES 3.X documentation for
        **glBlendFunci()** .
        """
        ...

    def glBlitFramebuffer(
        self,
        srcX0: int,
        srcY0: int,
        srcX1: int,
        srcY1: int,
        dstX0: int,
        dstY0: int,
        dstX1: int,
        dstY1: int,
        mask: int,
        filter: int,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qopenglextrafunctions.html#glBlitFramebuffer

        **void QOpenGLExtraFunctions::glBlitFramebuffer(GLint srcX0 , GLint
        srcY0 , GLint srcX1 , GLint srcY1 , GLint dstX0 , GLint dstY0 , GLint
        dstX1 , GLint dstY1 , GLbitfield mask , GLenum filter )**

        Convenience function that calls glBlitFramebuffer( **srcX0** , **srcY0**
        , **srcX1** , **srcY1** , **dstX0** , **dstY0** , **dstX1** , **dstY1**
        , **mask** , **filter** ).

        This function is only available in OpenGL ES 3.x, or OpenGL 3.x or 4.x
        contexts. When running with plain OpenGL, the function is only usable
        when the given profile and version contains the function either in core
        or as an extension.

        For more information, see the OpenGL ES 3.x documentation for
        **glBlitFramebuffer()** .
        """
        ...

    def glClearBufferfi(
        self, buffer: int, drawbuffer: int, depth: float, stencil: int
    ) -> None:
        """
        https://doc.qt.io/qt-6/qopenglextrafunctions.html#glClearBufferfi

        **void QOpenGLExtraFunctions::glClearBufferfi(GLenum buffer , GLint
        drawbuffer , GLfloat depth , GLint stencil )**

        Convenience function that calls glClearBufferfi( **buffer** ,
        **drawbuffer** , **depth** , **stencil** ).

        This function is only available in OpenGL ES 3.x, or OpenGL 3.x or 4.x
        contexts. When running with plain OpenGL, the function is only usable
        when the given profile and version contains the function either in core
        or as an extension.

        For more information, see the OpenGL ES 3.x documentation for
        **glClearBufferfi()** .
        """
        ...

    def glClearBufferfv(
        self, buffer: int, drawbuffer: int, value: Sequence[float]
    ) -> None:
        """
        https://doc.qt.io/qt-6/qopenglextrafunctions.html#glClearBufferfv

        **void QOpenGLExtraFunctions::glClearBufferfv(GLenum buffer , GLint
        drawbuffer , const GLfloat * value )**

        Convenience function that calls glClearBufferfv( **buffer** ,
        **drawbuffer** , **value** ).

        This function is only available in OpenGL ES 3.x, or OpenGL 3.x or 4.x
        contexts. When running with plain OpenGL, the function is only usable
        when the given profile and version contains the function either in core
        or as an extension.

        For more information, see the OpenGL ES 3.x documentation for
        **glClearBufferfv()** .
        """
        ...

    def glClearBufferiv(
        self, buffer: int, drawbuffer: int, value: Sequence[int]
    ) -> None:
        """
        https://doc.qt.io/qt-6/qopenglextrafunctions.html#glClearBufferiv

        **void QOpenGLExtraFunctions::glClearBufferiv(GLenum buffer , GLint
        drawbuffer , const GLint * value )**

        Convenience function that calls glClearBufferiv( **buffer** ,
        **drawbuffer** , **value** ).

        This function is only available in OpenGL ES 3.x, or OpenGL 3.x or 4.x
        contexts. When running with plain OpenGL, the function is only usable
        when the given profile and version contains the function either in core
        or as an extension.

        For more information, see the OpenGL ES 3.x documentation for
        **glClearBufferiv()** .
        """
        ...

    def glClearBufferuiv(
        self, buffer: int, drawbuffer: int, value: Sequence[int]
    ) -> None:
        """
        https://doc.qt.io/qt-6/qopenglextrafunctions.html#glClearBufferuiv

        **void QOpenGLExtraFunctions::glClearBufferuiv(GLenum buffer , GLint
        drawbuffer , const GLuint * value )**

        Convenience function that calls glClearBufferuiv( **buffer** ,
        **drawbuffer** , **value** ).

        This function is only available in OpenGL ES 3.x, or OpenGL 3.x or 4.x
        contexts. When running with plain OpenGL, the function is only usable
        when the given profile and version contains the function either in core
        or as an extension.

        For more information, see the OpenGL ES 3.x documentation for
        **glClearBufferuiv()** .
        """
        ...

    def glColorMaski(self, index: int, r: int, g: int, b: int, a: int) -> None:
        """
        https://doc.qt.io/qt-6/qopenglextrafunctions.html#glColorMaski

        **void QOpenGLExtraFunctions::glColorMaski(GLuint index , GLboolean r ,
        GLboolean g , GLboolean b , GLboolean a )**

        Convenience function that calls glColorMaski( **index** , **r** , **g**
        , **b** , **a** ).

        This function is only available in OpenGL ES 3.x, or OpenGL 3.x or 4.x
        contexts. When running with plain OpenGL, the function is only usable
        when the given profile and version contains the function either in core
        or as an extension.

        For more information, see the OpenGL ES 3.X documentation for
        **glColorMaski()** .
        """
        ...

    def glCompressedTexImage3D(
        self,
        target: int,
        level: int,
        internalformat: int,
        width: int,
        height: int,
        depth: int,
        border: int,
        imageSize: int,
        data: int,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qopenglextrafunctions.html#glCompressedTexImage3D

        **void QOpenGLExtraFunctions::glCompressedTexImage3D(GLenum target ,
        GLint level , GLenum internalformat , GLsizei width , GLsizei height ,
        GLsizei depth , GLint border , GLsizei imageSize , const void * data )**

        Convenience function that calls glCompressedTexImage3D( **target** ,
        **level** , **internalformat** , **width** , **height** , **depth** ,
        **border** , **imageSize** , **data** ).

        This function is only available in OpenGL ES 3.x, or OpenGL 3.x or 4.x
        contexts. When running with plain OpenGL, the function is only usable
        when the given profile and version contains the function either in core
        or as an extension.

        For more information, see the OpenGL ES 3.x documentation for
        **glCompressedTexImage3D()** .
        """
        ...

    def glCompressedTexSubImage3D(
        self,
        target: int,
        level: int,
        xoffset: int,
        yoffset: int,
        zoffset: int,
        width: int,
        height: int,
        depth: int,
        format: int,
        imageSize: int,
        data: int,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qopenglextrafunctions.html#glCompressedTexSubImag
        e3D

        **void QOpenGLExtraFunctions::glCompressedTexSubImage3D(GLenum target ,
        GLint level , GLint xoffset , GLint yoffset , GLint zoffset , GLsizei
        width , GLsizei height , GLsizei depth , GLenum format , GLsizei
        imageSize , const void * data )**

        Convenience function that calls glCompressedTexSubImage3D( **target** ,
        **level** , **xoffset** , **yoffset** , **zoffset** , **width** ,
        **height** , **depth** , **format** , **imageSize** , **data** ).

        This function is only available in OpenGL ES 3.x, or OpenGL 3.x or 4.x
        contexts. When running with plain OpenGL, the function is only usable
        when the given profile and version contains the function either in core
        or as an extension.

        For more information, see the OpenGL ES 3.x documentation for
        **glCompressedTexSubImage3D()** .
        """
        ...

    def glCopyImageSubData(
        self,
        srcName: int,
        srcTarget: int,
        srcLevel: int,
        srcX: int,
        srcY: int,
        srcZ: int,
        dstName: int,
        dstTarget: int,
        dstLevel: int,
        dstX: int,
        dstY: int,
        dstZ: int,
        srcWidth: int,
        srcHeight: int,
        srcDepth: int,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qopenglextrafunctions.html#glCopyImageSubData

        **void QOpenGLExtraFunctions::glCopyImageSubData(GLuint srcName , GLenum
        srcTarget , GLint srcLevel , GLint srcX , GLint srcY , GLint srcZ ,
        GLuint dstName , GLenum dstTarget , GLint dstLevel , GLint dstX , GLint
        dstY , GLint dstZ , GLsizei srcWidth , GLsizei srcHeight , GLsizei
        srcDepth )**

        Convenience function that calls glCopyImageSubData( **srcName** ,
        **srcTarget** , **srcLevel** , **srcX** , **srcY** , **srcZ** ,
        **dstName** , **dstTarget** , **dstLevel** , **dstX** , **dstY** ,
        **dstZ** , **srcWidth** , **srcHeight** , **srcDepth** ).

        This function is only available in OpenGL ES 3.x, or OpenGL 3.x or 4.x
        contexts. When running with plain OpenGL, the function is only usable
        when the given profile and version contains the function either in core
        or as an extension.

        For more information, see the OpenGL ES 3.X documentation for
        **glCopyImageSubData()** .
        """
        ...

    def glCopyTexSubImage3D(
        self,
        target: int,
        level: int,
        xoffset: int,
        yoffset: int,
        zoffset: int,
        x: int,
        y: int,
        width: int,
        height: int,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qopenglextrafunctions.html#glCopyTexSubImage3D

        **void QOpenGLExtraFunctions::glCopyTexSubImage3D(GLenum target , GLint
        level , GLint xoffset , GLint yoffset , GLint zoffset , GLint x , GLint
        y , GLsizei width , GLsizei height )**

        Convenience function that calls glCopyTexSubImage3D( **target** ,
        **level** , **xoffset** , **yoffset** , **zoffset** , **x** , **y** ,
        **width** , **height** ).

        This function is only available in OpenGL ES 3.x, or OpenGL 3.x or 4.x
        contexts. When running with plain OpenGL, the function is only usable
        when the given profile and version contains the function either in core
        or as an extension.

        For more information, see the OpenGL ES 3.x documentation for
        **glCopyTexSubImage3D()** .
        """
        ...

    def glDebugMessageControl(
        self,
        source: int,
        type: int,
        severity: int,
        count: int,
        ids: Sequence[int],
        enabled: int,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qopenglextrafunctions.html#glDebugMessageControl

        **void QOpenGLExtraFunctions::glDebugMessageControl(GLenum source ,
        GLenum type , GLenum severity , GLsizei count , const GLuint * ids ,
        GLboolean enabled )**

        Convenience function that calls glDebugMessageControl( **source** ,
        **type** , **severity** , **count** , **ids** , **enabled** ).

        This function is only available in OpenGL ES 3.x, or OpenGL 3.x or 4.x
        contexts. When running with plain OpenGL, the function is only usable
        when the given profile and version contains the function either in core
        or as an extension.

        For more information, see the OpenGL ES 3.X documentation for
        **glDebugMessageContro()** .
        """
        ...

    def glDebugMessageInsert(
        self, source: int, type: int, id: int, severity: int, length: int, buf: bytes
    ) -> None:
        """
        https://doc.qt.io/qt-6/qopenglextrafunctions.html#glDebugMessageInsert

        **void QOpenGLExtraFunctions::glDebugMessageInsert(GLenum source ,
        GLenum type , GLuint id , GLenum severity , GLsizei length , const
        GLchar * buf )**

        Convenience function that calls glDebugMessageInsert( **source** ,
        **type** , **id** , **severity** , **length** , **buf** ).

        This function is only available in OpenGL ES 3.x, or OpenGL 3.x or 4.x
        contexts. When running with plain OpenGL, the function is only usable
        when the given profile and version contains the function either in core
        or as an extension.

        For more information, see the OpenGL ES 3.X documentation for
        **glDebugMessageInsert()** .
        """
        ...

    def glDeleteProgramPipelines(self, n: int, pipelines: Sequence[int]) -> None:
        """
        https://doc.qt.io/qt-6/qopenglextrafunctions.html#glDeleteProgramPipelin
        es

        **void QOpenGLExtraFunctions::glDeleteProgramPipelines(GLsizei n , const
        GLuint * pipelines )**

        Convenience function that calls glDeleteProgramPipelines( **n** ,
        **pipelines** ).

        This function is only available in OpenGL ES 3.x, or OpenGL 3.x or 4.x
        contexts. When running with plain OpenGL, the function is only usable
        when the given profile and version contains the function either in core
        or as an extension.

        For more information, see the OpenGL ES 3.x documentation for
        **glDeleteProgramPipelines()** .
        """
        ...

    def glDeleteQueries(self, n: int, ids: Sequence[int]) -> None:
        """
        https://doc.qt.io/qt-6/qopenglextrafunctions.html#glDeleteQueries

        **void QOpenGLExtraFunctions::glDeleteQueries(GLsizei n , const GLuint *
        ids )**

        Convenience function that calls glDeleteQueries( **n** , **ids** ).

        This function is only available in OpenGL ES 3.x, or OpenGL 3.x or 4.x
        contexts. When running with plain OpenGL, the function is only usable
        when the given profile and version contains the function either in core
        or as an extension.

        For more information, see the OpenGL ES 3.x documentation for
        **glDeleteQueries()** .
        """
        ...

    def glDeleteSamplers(self, count: int, samplers: Sequence[int]) -> None:
        """
        https://doc.qt.io/qt-6/qopenglextrafunctions.html#glDeleteSamplers

        **void QOpenGLExtraFunctions::glDeleteSamplers(GLsizei count , const
        GLuint * samplers )**

        Convenience function that calls glDeleteSamplers( **count** ,
        **samplers** ).

        This function is only available in OpenGL ES 3.x, or OpenGL 3.x or 4.x
        contexts. When running with plain OpenGL, the function is only usable
        when the given profile and version contains the function either in core
        or as an extension.

        For more information, see the OpenGL ES 3.x documentation for
        **glDeleteSamplers()** .
        """
        ...

    def glDeleteTransformFeedbacks(self, n: int, ids: Sequence[int]) -> None:
        """
        https://doc.qt.io/qt-6/qopenglextrafunctions.html#glDeleteTransformFeedb
        acks

        **void QOpenGLExtraFunctions::glDeleteTransformFeedbacks(GLsizei n ,
        const GLuint * ids )**

        Convenience function that calls glDeleteTransformFeedbacks( **n** ,
        **ids** ).

        This function is only available in OpenGL ES 3.x, or OpenGL 3.x or 4.x
        contexts. When running with plain OpenGL, the function is only usable
        when the given profile and version contains the function either in core
        or as an extension.

        For more information, see the OpenGL ES 3.x documentation for
        **glDeleteTransformFeedbacks()** .
        """
        ...

    def glDeleteVertexArrays(self, n: int, arrays: Sequence[int]) -> None:
        """
        https://doc.qt.io/qt-6/qopenglextrafunctions.html#glDeleteVertexArrays

        **void QOpenGLExtraFunctions::glDeleteVertexArrays(GLsizei n , const
        GLuint * arrays )**

        Convenience function that calls glDeleteVertexArrays( **n** , **arrays**
        ).

        This function is only available in OpenGL ES 3.x, or OpenGL 3.x or 4.x
        contexts. When running with plain OpenGL, the function is only usable
        when the given profile and version contains the function either in core
        or as an extension.

        For more information, see the OpenGL ES 3.x documentation for
        **glDeleteVertexArrays()** .
        """
        ...

    def glDisablei(self, target: int, index: int) -> None:
        """
        https://doc.qt.io/qt-6/qopenglextrafunctions.html#glDisablei

        **void QOpenGLExtraFunctions::glDisablei(GLenum target , GLuint index
        )**

        Convenience function that calls glDisablei( **target** , **index** ).

        This function is only available in OpenGL ES 3.x, or OpenGL 3.x or 4.x
        contexts. When running with plain OpenGL, the function is only usable
        when the given profile and version contains the function either in core
        or as an extension.

        For more information, see the OpenGL ES 3.X documentation for
        **glDisablei()** .
        """
        ...

    def glDispatchCompute(
        self, num_groups_x: int, num_groups_y: int, num_groups_z: int
    ) -> None:
        """
        https://doc.qt.io/qt-6/qopenglextrafunctions.html#glDispatchCompute

        **void QOpenGLExtraFunctions::glDispatchCompute(GLuint num_groups_x ,
        GLuint num_groups_y , GLuint num_groups_z )**

        Convenience function that calls glDispatchCompute( **num_groups_x** ,
        **num_groups_y** , **num_groups_z** ).

        This function is only available in OpenGL ES 3.x, or OpenGL 3.x or 4.x
        contexts. When running with plain OpenGL, the function is only usable
        when the given profile and version contains the function either in core
        or as an extension.

        For more information, see the OpenGL ES 3.x documentation for
        **glDispatchCompute()** .
        """
        ...

    def glDrawArraysIndirect(self, mode: int, indirect: int) -> None:
        """
        https://doc.qt.io/qt-6/qopenglextrafunctions.html#glDrawArraysIndirect

        **void QOpenGLExtraFunctions::glDrawArraysIndirect(GLenum mode , const
        void * indirect )**

        Convenience function that calls glDrawArraysIndirect( **mode** ,
        **indirect** ).

        This function is only available in OpenGL ES 3.x, or OpenGL 3.x or 4.x
        contexts. When running with plain OpenGL, the function is only usable
        when the given profile and version contains the function either in core
        or as an extension.

        For more information, see the OpenGL ES 3.x documentation for
        **glDrawArraysIndirect()** .
        """
        ...

    def glDrawArraysInstanced(
        self, mode: int, first: int, count: int, instancecount: int
    ) -> None:
        """
        https://doc.qt.io/qt-6/qopenglextrafunctions.html#glDrawArraysInstanced

        **void QOpenGLExtraFunctions::glDrawArraysInstanced(GLenum mode , GLint
        first , GLsizei count , GLsizei instancecount )**

        Convenience function that calls glDrawArraysInstanced( **mode** ,
        **first** , **count** , **instancecount** ).

        This function is only available in OpenGL ES 3.x, or OpenGL 3.x or 4.x
        contexts. When running with plain OpenGL, the function is only usable
        when the given profile and version contains the function either in core
        or as an extension.

        For more information, see the OpenGL ES 3.x documentation for
        **glDrawArraysInstanced()** .
        """
        ...

    def glDrawBuffers(self, n: int, bufs: Sequence[int]) -> None:
        """
        https://doc.qt.io/qt-6/qopenglextrafunctions.html#glDrawBuffers

        **void QOpenGLExtraFunctions::glDrawBuffers(GLsizei n , const GLenum *
        bufs )**

        Convenience function that calls glDrawBuffers( **n** , **bufs** ).

        This function is only available in OpenGL ES 3.x, or OpenGL 3.x or 4.x
        contexts. When running with plain OpenGL, the function is only usable
        when the given profile and version contains the function either in core
        or as an extension.

        For more information, see the OpenGL ES 3.x documentation for
        **glDrawBuffers()** .
        """
        ...

    def glDrawElementsBaseVertex(
        self, mode: int, count: int, type: int, indices: int, basevertex: int
    ) -> None:
        """
        https://doc.qt.io/qt-6/qopenglextrafunctions.html#glDrawElementsBaseVert
        ex

        **void QOpenGLExtraFunctions::glDrawElementsBaseVertex(GLenum mode ,
        GLsizei count , GLenum type , const void * indices , GLint basevertex
        )**

        Convenience function that calls glDrawElementsBaseVertex( **mode** ,
        **count** , **type** , **indices** , **basevertex** ).

        This function is only available in OpenGL ES 3.x, or OpenGL 3.x or 4.x
        contexts. When running with plain OpenGL, the function is only usable
        when the given profile and version contains the function either in core
        or as an extension.

        For more information, see the OpenGL ES 3.X documentation for
        **glDrawElementsBaseVerte()** .
        """
        ...

    def glDrawElementsIndirect(self, mode: int, type: int, indirect: int) -> None:
        """
        https://doc.qt.io/qt-6/qopenglextrafunctions.html#glDrawElementsIndirect

        **void QOpenGLExtraFunctions::glDrawElementsIndirect(GLenum mode ,
        GLenum type , const void * indirect )**

        Convenience function that calls glDrawElementsIndirect( **mode** ,
        **type** , **indirect** ).

        This function is only available in OpenGL ES 3.x, or OpenGL 3.x or 4.x
        contexts. When running with plain OpenGL, the function is only usable
        when the given profile and version contains the function either in core
        or as an extension.

        For more information, see the OpenGL ES 3.x documentation for
        **glDrawElementsIndirect()** .
        """
        ...

    def glDrawElementsInstanced(
        self, mode: int, count: int, type: int, indices: int, instancecount: int
    ) -> None:
        """
        https://doc.qt.io/qt-6/qopenglextrafunctions.html#glDrawElementsInstance
        d

        **void QOpenGLExtraFunctions::glDrawElementsInstanced(GLenum mode ,
        GLsizei count , GLenum type , const void * indices , GLsizei
        instancecount )**

        Convenience function that calls glDrawElementsInstanced( **mode** ,
        **count** , **type** , **indices** , **instancecount** ).

        This function is only available in OpenGL ES 3.x, or OpenGL 3.x or 4.x
        contexts. When running with plain OpenGL, the function is only usable
        when the given profile and version contains the function either in core
        or as an extension.

        For more information, see the OpenGL ES 3.x documentation for
        **glDrawElementsInstanced()** .
        """
        ...

    def glDrawElementsInstancedBaseVertex(
        self,
        mode: int,
        count: int,
        type: int,
        indices: int,
        instancecount: int,
        basevertex: int,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qopenglextrafunctions.html#glDrawElementsInstance
        dBaseVertex

        **void QOpenGLExtraFunctions::glDrawElementsInstancedBaseVertex(GLenum
        mode , GLsizei count , GLenum type , const void * indices , GLsizei
        instancecount , GLint basevertex )**

        Convenience function that calls glDrawElementsInstancedBaseVertex(
        **mode** , **count** , **type** , **indices** , **instancecount** ,
        **basevertex** ).

        This function is only available in OpenGL ES 3.x, or OpenGL 3.x or 4.x
        contexts. When running with plain OpenGL, the function is only usable
        when the given profile and version contains the function either in core
        or as an extension.

        For more information, see the OpenGL ES 3.X documentation for
        **glDrawElementsInstancedBaseVerte()** .
        """
        ...

    def glDrawRangeElements(
        self, mode: int, start: int, end: int, count: int, type: int, indices: int
    ) -> None:
        """
        https://doc.qt.io/qt-6/qopenglextrafunctions.html#glDrawRangeElements

        **void QOpenGLExtraFunctions::glDrawRangeElements(GLenum mode , GLuint
        start , GLuint end , GLsizei count , GLenum type , const void * indices
        )**

        Convenience function that calls glDrawRangeElements( **mode** ,
        **start** , **end** , **count** , **type** , **indices** ).

        This function is only available in OpenGL ES 3.x, or OpenGL 3.x or 4.x
        contexts. When running with plain OpenGL, the function is only usable
        when the given profile and version contains the function either in core
        or as an extension.

        For more information, see the OpenGL ES 3.x documentation for
        **glDrawRangeElements()** .
        """
        ...

    def glDrawRangeElementsBaseVertex(
        self,
        mode: int,
        start: int,
        end: int,
        count: int,
        type: int,
        indices: int,
        basevertex: int,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qopenglextrafunctions.html#glDrawRangeElementsBas
        eVertex

        **void QOpenGLExtraFunctions::glDrawRangeElementsBaseVertex(GLenum mode
        , GLuint start , GLuint end , GLsizei count , GLenum type , const void *
        indices , GLint basevertex )**

        Convenience function that calls glDrawRangeElementsBaseVertex( **mode**
        , **start** , **end** , **count** , **type** , **indices** ,
        **basevertex** ).

        This function is only available in OpenGL ES 3.x, or OpenGL 3.x or 4.x
        contexts. When running with plain OpenGL, the function is only usable
        when the given profile and version contains the function either in core
        or as an extension.

        For more information, see the OpenGL ES 3.X documentation for
        **glDrawRangeElementsBaseVerte()** .
        """
        ...

    def glEnablei(self, target: int, index: int) -> None:
        """
        https://doc.qt.io/qt-6/qopenglextrafunctions.html#glEnablei

        **void QOpenGLExtraFunctions::glEnablei(GLenum target , GLuint index )**

        Convenience function that calls glEnablei( **target** , **index** ).

        This function is only available in OpenGL ES 3.x, or OpenGL 3.x or 4.x
        contexts. When running with plain OpenGL, the function is only usable
        when the given profile and version contains the function either in core
        or as an extension.

        For more information, see the OpenGL ES 3.X documentation for
        **glEnablei()** .
        """
        ...

    def glEndQuery(self, target: int) -> None:
        """
        https://doc.qt.io/qt-6/qopenglextrafunctions.html#glEndQuery

        **void QOpenGLExtraFunctions::glEndQuery(GLenum target )**

        Convenience function that calls glEndQuery( **target** ).

        This function is only available in OpenGL ES 3.x, or OpenGL 3.x or 4.x
        contexts. When running with plain OpenGL, the function is only usable
        when the given profile and version contains the function either in core
        or as an extension.

        For more information, see the OpenGL ES 3.x documentation for
        **glEndQuery()** .
        """
        ...

    def glFramebufferParameteri(self, target: int, pname: int, param: int) -> None:
        """
        https://doc.qt.io/qt-6/qopenglextrafunctions.html#glFramebufferParameter
        i

        **void QOpenGLExtraFunctions::glFramebufferParameteri(GLenum target ,
        GLenum pname , GLint param )**

        Convenience function that calls glFramebufferParameteri( **target** ,
        **pname** , **param** ).

        This function is only available in OpenGL ES 3.x, or OpenGL 3.x or 4.x
        contexts. When running with plain OpenGL, the function is only usable
        when the given profile and version contains the function either in core
        or as an extension.

        For more information, see the OpenGL ES 3.x documentation for
        **glFramebufferParameteri()** .
        """
        ...

    def glFramebufferTexture(
        self, target: int, attachment: int, texture: int, level: int
    ) -> None:
        """
        https://doc.qt.io/qt-6/qopenglextrafunctions.html#glFramebufferTexture

        **void QOpenGLExtraFunctions::glFramebufferTexture(GLenum target ,
        GLenum attachment , GLuint texture , GLint level )**

        Convenience function that calls glFramebufferTexture( **target** ,
        **attachment** , **texture** , **level** ).

        This function is only available in OpenGL ES 3.x, or OpenGL 3.x or 4.x
        contexts. When running with plain OpenGL, the function is only usable
        when the given profile and version contains the function either in core
        or as an extension.

        For more information, see the OpenGL ES 3.X documentation for
        **glFramebufferTexture()** .
        """
        ...

    def glFramebufferTextureLayer(
        self, target: int, attachment: int, texture: int, level: int, layer: int
    ) -> None:
        """
        https://doc.qt.io/qt-6/qopenglextrafunctions.html#glFramebufferTextureLa
        yer

        **void QOpenGLExtraFunctions::glFramebufferTextureLayer(GLenum target ,
        GLenum attachment , GLuint texture , GLint level , GLint layer )**

        Convenience function that calls glFramebufferTextureLayer( **target** ,
        **attachment** , **texture** , **level** , **layer** ).

        This function is only available in OpenGL ES 3.x, or OpenGL 3.x or 4.x
        contexts. When running with plain OpenGL, the function is only usable
        when the given profile and version contains the function either in core
        or as an extension.

        For more information, see the OpenGL ES 3.x documentation for
        **glFramebufferTextureLayer()** .
        """
        ...

    def glGenProgramPipelines(self, n: int, pipelines: Sequence[int]) -> None:
        """
        https://doc.qt.io/qt-6/qopenglextrafunctions.html#glGenProgramPipelines

        **void QOpenGLExtraFunctions::glGenProgramPipelines(GLsizei n , GLuint *
        pipelines )**

        Convenience function that calls glGenProgramPipelines( **n** ,
        **pipelines** ).

        This function is only available in OpenGL ES 3.x, or OpenGL 3.x or 4.x
        contexts. When running with plain OpenGL, the function is only usable
        when the given profile and version contains the function either in core
        or as an extension.

        For more information, see the OpenGL ES 3.x documentation for
        **glGenProgramPipelines()** .
        """
        ...

    def glGenQueries(self, n: int, ids: Sequence[int]) -> None:
        """
        https://doc.qt.io/qt-6/qopenglextrafunctions.html#glGenQueries

        **void QOpenGLExtraFunctions::glGenQueries(GLsizei n , GLuint * ids )**

        Convenience function that calls glGenQueries( **n** , **ids** ).

        This function is only available in OpenGL ES 3.x, or OpenGL 3.x or 4.x
        contexts. When running with plain OpenGL, the function is only usable
        when the given profile and version contains the function either in core
        or as an extension.

        For more information, see the OpenGL ES 3.x documentation for
        **glGenQueries()** .
        """
        ...

    def glGenSamplers(self, count: int, samplers: Sequence[int]) -> None:
        """
        https://doc.qt.io/qt-6/qopenglextrafunctions.html#glGenSamplers

        **void QOpenGLExtraFunctions::glGenSamplers(GLsizei count , GLuint *
        samplers )**

        Convenience function that calls glGenSamplers( **count** , **samplers**
        ).

        This function is only available in OpenGL ES 3.x, or OpenGL 3.x or 4.x
        contexts. When running with plain OpenGL, the function is only usable
        when the given profile and version contains the function either in core
        or as an extension.

        For more information, see the OpenGL ES 3.x documentation for
        **glGenSamplers()** .
        """
        ...

    def glGenTransformFeedbacks(self, n: int, ids: Sequence[int]) -> None:
        """
        https://doc.qt.io/qt-6/qopenglextrafunctions.html#glGenTransformFeedback
        s

        **void QOpenGLExtraFunctions::glGenTransformFeedbacks(GLsizei n , GLuint
        * ids )**

        Convenience function that calls glGenTransformFeedbacks( **n** , **ids**
        ).

        This function is only available in OpenGL ES 3.x, or OpenGL 3.x or 4.x
        contexts. When running with plain OpenGL, the function is only usable
        when the given profile and version contains the function either in core
        or as an extension.

        For more information, see the OpenGL ES 3.x documentation for
        **glGenTransformFeedbacks()** .
        """
        ...

    def glGenVertexArrays(self, n: int, arrays: Sequence[int]) -> None:
        """
        https://doc.qt.io/qt-6/qopenglextrafunctions.html#glGenVertexArrays

        **void QOpenGLExtraFunctions::glGenVertexArrays(GLsizei n , GLuint *
        arrays )**

        Convenience function that calls glGenVertexArrays( **n** , **arrays** ).

        This function is only available in OpenGL ES 3.x, or OpenGL 3.x or 4.x
        contexts. When running with plain OpenGL, the function is only usable
        when the given profile and version contains the function either in core
        or as an extension.

        For more information, see the OpenGL ES 3.x documentation for
        **glGenVertexArrays()** .
        """
        ...

    def glGetActiveUniformBlockiv(
        self, program: int, uniformBlockIndex: int, pname: int, params: Sequence[int]
    ) -> None:
        """
        https://doc.qt.io/qt-6/qopenglextrafunctions.html#glGetActiveUniformBloc
        kiv

        **void QOpenGLExtraFunctions::glGetActiveUniformBlockiv(GLuint program ,
        GLuint uniformBlockIndex , GLenum pname , GLint * params )**

        Convenience function that calls glGetActiveUniformBlockiv( **program** ,
        **uniformBlockIndex** , **pname** , **params** ).

        This function is only available in OpenGL ES 3.x, or OpenGL 3.x or 4.x
        contexts. When running with plain OpenGL, the function is only usable
        when the given profile and version contains the function either in core
        or as an extension.

        For more information, see the OpenGL ES 3.x documentation for
        **glGetActiveUniformBlockiv()** .
        """
        ...

    def glGetActiveUniformsiv(
        self,
        program: int,
        uniformCount: int,
        uniformIndices: Sequence[int],
        pname: int,
        params: Sequence[int],
    ) -> None:
        """
        https://doc.qt.io/qt-6/qopenglextrafunctions.html#glGetActiveUniformsiv

        **void QOpenGLExtraFunctions::glGetActiveUniformsiv(GLuint program ,
        GLsizei uniformCount , const GLuint * uniformIndices , GLenum pname ,
        GLint * params )**

        Convenience function that calls glGetActiveUniformsiv( **program** ,
        **uniformCount** , **uniformIndices** , **pname** , **params** ).

        This function is only available in OpenGL ES 3.x, or OpenGL 3.x or 4.x
        contexts. When running with plain OpenGL, the function is only usable
        when the given profile and version contains the function either in core
        or as an extension.

        For more information, see the OpenGL ES 3.x documentation for
        **glGetActiveUniformsiv()** .
        """
        ...

    def glGetFragDataLocation(self, program: int, name: bytes) -> int:
        """
        https://doc.qt.io/qt-6/qopenglextrafunctions.html#glGetFragDataLocation

        **GLint QOpenGLExtraFunctions::glGetFragDataLocation(GLuint program ,
        const GLchar * name )**

        Convenience function that calls glGetFragDataLocation( **program** ,
        **name** ).

        This function is only available in OpenGL ES 3.x, or OpenGL 3.x or 4.x
        contexts. When running with plain OpenGL, the function is only usable
        when the given profile and version contains the function either in core
        or as an extension.

        For more information, see the OpenGL ES 3.x documentation for
        **glGetFragDataLocation()** .
        """
        ...

    def glGetFramebufferParameteriv(
        self, target: int, pname: int, params: Sequence[int]
    ) -> None:
        """
        https://doc.qt.io/qt-6/qopenglextrafunctions.html#glGetFramebufferParame
        teriv

        **void QOpenGLExtraFunctions::glGetFramebufferParameteriv(GLenum target
        , GLenum pname , GLint * params )**

        Convenience function that calls glGetFramebufferParameteriv( **target**
        , **pname** , **params** ).

        This function is only available in OpenGL ES 3.x, or OpenGL 3.x or 4.x
        contexts. When running with plain OpenGL, the function is only usable
        when the given profile and version contains the function either in core
        or as an extension.

        For more information, see the OpenGL ES 3.x documentation for
        **glGetFramebufferParameteriv()** .
        """
        ...

    def glGetGraphicsResetStatus(self) -> int:
        """
        https://doc.qt.io/qt-6/qopenglextrafunctions.html#glGetGraphicsResetStat
        us

        **GLenum QOpenGLExtraFunctions::glGetGraphicsResetStatus()**

        Convenience function that calls glGetGraphicsResetStatus().

        This function is only available in OpenGL ES 3.x, or OpenGL 3.x or 4.x
        contexts. When running with plain OpenGL, the function is only usable
        when the given profile and version contains the function either in core
        or as an extension.

        For more information, see the OpenGL ES 3.X documentation for
        **glGetGraphicsResetStatus()** .
        """
        ...

    def glGetIntegeri_v(self, target: int, index: int, data: Sequence[int]) -> None:
        """
        https://doc.qt.io/qt-6/qopenglextrafunctions.html#glGetIntegeri_v

        **void QOpenGLExtraFunctions::glGetIntegeri_v(GLenum target , GLuint
        index , GLint * data )**

        Convenience function that calls glGetIntegeri_v( **target** , **index**
        , **data** ).

        This function is only available in OpenGL ES 3.x, or OpenGL 3.x or 4.x
        contexts. When running with plain OpenGL, the function is only usable
        when the given profile and version contains the function either in core
        or as an extension.

        For more information, see the OpenGL ES 3.x documentation for
        **glGetIntegeri_v()** .
        """
        ...

    def glGetInternalformativ(
        self,
        target: int,
        internalformat: int,
        pname: int,
        bufSize: int,
        params: Sequence[int],
    ) -> None:
        """
        https://doc.qt.io/qt-6/qopenglextrafunctions.html#glGetInternalformativ

        **void QOpenGLExtraFunctions::glGetInternalformativ(GLenum target ,
        GLenum internalformat , GLenum pname , GLsizei bufSize , GLint * params
        )**

        Convenience function that calls glGetInternalformativ( **target** ,
        **internalformat** , **pname** , **bufSize** , **params** ).

        This function is only available in OpenGL ES 3.x, or OpenGL 3.x or 4.x
        contexts. When running with plain OpenGL, the function is only usable
        when the given profile and version contains the function either in core
        or as an extension.

        For more information, see the OpenGL ES 3.x documentation for
        **glGetInternalformativ()** .
        """
        ...

    def glGetMultisamplefv(self, pname: int, index: int, val: Sequence[float]) -> None:
        """
        https://doc.qt.io/qt-6/qopenglextrafunctions.html#glGetMultisamplefv

        **void QOpenGLExtraFunctions::glGetMultisamplefv(GLenum pname , GLuint
        index , GLfloat * val )**

        Convenience function that calls glGetMultisamplefv( **pname** ,
        **index** , **val** ).

        This function is only available in OpenGL ES 3.x, or OpenGL 3.x or 4.x
        contexts. When running with plain OpenGL, the function is only usable
        when the given profile and version contains the function either in core
        or as an extension.

        For more information, see the OpenGL ES 3.x documentation for
        **glGetMultisamplefv()** .
        """
        ...

    def glGetProgramInterfaceiv(
        self, program: int, programInterface: int, pname: int, params: Sequence[int]
    ) -> None:
        """
        https://doc.qt.io/qt-6/qopenglextrafunctions.html#glGetProgramInterfacei
        v

        **void QOpenGLExtraFunctions::glGetProgramInterfaceiv(GLuint program ,
        GLenum programInterface , GLenum pname , GLint * params )**

        Convenience function that calls glGetProgramInterfaceiv( **program** ,
        **programInterface** , **pname** , **params** ).

        This function is only available in OpenGL ES 3.x, or OpenGL 3.x or 4.x
        contexts. When running with plain OpenGL, the function is only usable
        when the given profile and version contains the function either in core
        or as an extension.

        For more information, see the OpenGL ES 3.x documentation for
        **glGetProgramInterfaceiv()** .
        """
        ...

    def glGetProgramPipelineiv(
        self, pipeline: int, pname: int, params: Sequence[int]
    ) -> None:
        """
        https://doc.qt.io/qt-6/qopenglextrafunctions.html#glGetProgramPipelineiv

        **void QOpenGLExtraFunctions::glGetProgramPipelineiv(GLuint pipeline ,
        GLenum pname , GLint * params )**

        Convenience function that calls glGetProgramPipelineiv( **pipeline** ,
        **pname** , **params** ).

        This function is only available in OpenGL ES 3.x, or OpenGL 3.x or 4.x
        contexts. When running with plain OpenGL, the function is only usable
        when the given profile and version contains the function either in core
        or as an extension.

        For more information, see the OpenGL ES 3.x documentation for
        **glGetProgramPipelineiv()** .
        """
        ...

    def glGetProgramResourceIndex(
        self, program: int, programInterface: int, name: bytes
    ) -> int:
        """
        https://doc.qt.io/qt-6/qopenglextrafunctions.html#glGetProgramResourceIn
        dex

        **GLuint QOpenGLExtraFunctions::glGetProgramResourceIndex(GLuint program
        , GLenum programInterface , const GLchar * name )**

        Convenience function that calls glGetProgramResourceIndex( **program** ,
        **programInterface** , **name** ).

        This function is only available in OpenGL ES 3.x, or OpenGL 3.x or 4.x
        contexts. When running with plain OpenGL, the function is only usable
        when the given profile and version contains the function either in core
        or as an extension.

        For more information, see the OpenGL ES 3.x documentation for
        **glGetProgramResourceIndex()** .
        """
        ...

    def glGetProgramResourceLocation(
        self, program: int, programInterface: int, name: bytes
    ) -> int:
        """
        https://doc.qt.io/qt-6/qopenglextrafunctions.html#glGetProgramResourceLo
        cation

        **GLint QOpenGLExtraFunctions::glGetProgramResourceLocation(GLuint
        program , GLenum programInterface , const GLchar * name )**

        Convenience function that calls glGetProgramResourceLocation(
        **program** , **programInterface** , **name** ).

        This function is only available in OpenGL ES 3.x, or OpenGL 3.x or 4.x
        contexts. When running with plain OpenGL, the function is only usable
        when the given profile and version contains the function either in core
        or as an extension.

        For more information, see the OpenGL ES 3.x documentation for
        **glGetProgramResourceLocation()** .
        """
        ...

    def glGetProgramResourceiv(
        self,
        program: int,
        programInterface: int,
        index: int,
        propCount: int,
        props: Sequence[int],
        bufSize: int,
        length: Sequence[int],
        params: Sequence[int],
    ) -> None:
        """
        https://doc.qt.io/qt-6/qopenglextrafunctions.html#glGetProgramResourceiv

        **void QOpenGLExtraFunctions::glGetProgramResourceiv(GLuint program ,
        GLenum programInterface , GLuint index , GLsizei propCount , const
        GLenum * props , GLsizei bufSize , GLsizei * length , GLint * params )**

        Convenience function that calls glGetProgramResourceiv( **program** ,
        **programInterface** , **index** , **propCount** , **props** ,
        **bufSize** , **length** , **params** ).

        This function is only available in OpenGL ES 3.x, or OpenGL 3.x or 4.x
        contexts. When running with plain OpenGL, the function is only usable
        when the given profile and version contains the function either in core
        or as an extension.

        For more information, see the OpenGL ES 3.x documentation for
        **glGetProgramResourceiv()** .
        """
        ...

    def glGetQueryObjectuiv(self, id: int, pname: int, params: Sequence[int]) -> None:
        """
        https://doc.qt.io/qt-6/qopenglextrafunctions.html#glGetQueryObjectuiv

        **void QOpenGLExtraFunctions::glGetQueryObjectuiv(GLuint id , GLenum
        pname , GLuint * params )**

        Convenience function that calls glGetQueryObjectuiv( **id** , **pname**
        , **params** ).

        This function is only available in OpenGL ES 3.x, or OpenGL 3.x or 4.x
        contexts. When running with plain OpenGL, the function is only usable
        when the given profile and version contains the function either in core
        or as an extension.

        For more information, see the OpenGL ES 3.x documentation for
        **glGetQueryObjectuiv()** .
        """
        ...

    def glGetQueryiv(self, target: int, pname: int, params: Sequence[int]) -> None:
        """
        https://doc.qt.io/qt-6/qopenglextrafunctions.html#glGetQueryiv

        **void QOpenGLExtraFunctions::glGetQueryiv(GLenum target , GLenum pname
        , GLint * params )**

        Convenience function that calls glGetQueryiv( **target** , **pname** ,
        **params** ).

        This function is only available in OpenGL ES 3.x, or OpenGL 3.x or 4.x
        contexts. When running with plain OpenGL, the function is only usable
        when the given profile and version contains the function either in core
        or as an extension.

        For more information, see the OpenGL ES 3.x documentation for
        **glGetQueryiv()** .
        """
        ...

    def glGetSamplerParameterIiv(
        self, sampler: int, pname: int, params: Sequence[int]
    ) -> None:
        """
        https://doc.qt.io/qt-6/qopenglextrafunctions.html#glGetSamplerParameterI
        iv

        **void QOpenGLExtraFunctions::glGetSamplerParameterIiv(GLuint sampler ,
        GLenum pname , GLint * params )**

        Convenience function that calls glGetSamplerParameterIiv( **sampler** ,
        **pname** , **params** ).

        This function is only available in OpenGL ES 3.x, or OpenGL 3.x or 4.x
        contexts. When running with plain OpenGL, the function is only usable
        when the given profile and version contains the function either in core
        or as an extension.

        For more information, see the OpenGL ES 3.X documentation for
        **glGetSamplerParameterIiv()** .
        """
        ...

    def glGetSamplerParameterIuiv(
        self, sampler: int, pname: int, params: Sequence[int]
    ) -> None:
        """
        https://doc.qt.io/qt-6/qopenglextrafunctions.html#glGetSamplerParameterI
        uiv

        **void QOpenGLExtraFunctions::glGetSamplerParameterIuiv(GLuint sampler ,
        GLenum pname , GLuint * params )**

        Convenience function that calls glGetSamplerParameterIuiv( **sampler** ,
        **pname** , **params** ).

        This function is only available in OpenGL ES 3.x, or OpenGL 3.x or 4.x
        contexts. When running with plain OpenGL, the function is only usable
        when the given profile and version contains the function either in core
        or as an extension.

        For more information, see the OpenGL ES 3.X documentation for
        **glGetSamplerParameterIuiv()** .
        """
        ...

    def glGetSamplerParameterfv(
        self, sampler: int, pname: int, params: Sequence[float]
    ) -> None:
        """
        https://doc.qt.io/qt-6/qopenglextrafunctions.html#glGetSamplerParameterf
        v

        **void QOpenGLExtraFunctions::glGetSamplerParameterfv(GLuint sampler ,
        GLenum pname , GLfloat * params )**

        Convenience function that calls glGetSamplerParameterfv( **sampler** ,
        **pname** , **params** ).

        This function is only available in OpenGL ES 3.x, or OpenGL 3.x or 4.x
        contexts. When running with plain OpenGL, the function is only usable
        when the given profile and version contains the function either in core
        or as an extension.

        For more information, see the OpenGL ES 3.x documentation for
        **glGetSamplerParameterfv()** .
        """
        ...

    def glGetSamplerParameteriv(
        self, sampler: int, pname: int, params: Sequence[int]
    ) -> None:
        """
        https://doc.qt.io/qt-6/qopenglextrafunctions.html#glGetSamplerParameteri
        v

        **void QOpenGLExtraFunctions::glGetSamplerParameteriv(GLuint sampler ,
        GLenum pname , GLint * params )**

        Convenience function that calls glGetSamplerParameteriv( **sampler** ,
        **pname** , **params** ).

        This function is only available in OpenGL ES 3.x, or OpenGL 3.x or 4.x
        contexts. When running with plain OpenGL, the function is only usable
        when the given profile and version contains the function either in core
        or as an extension.

        For more information, see the OpenGL ES 3.x documentation for
        **glGetSamplerParameteriv()** .
        """
        ...

    def glGetStringi(self, name: int, index: int) -> str:
        """
        https://doc.qt.io/qt-6/qopenglextrafunctions.html#glGetStringi

        **const GLubyte *QOpenGLExtraFunctions::glGetStringi(GLenum name ,
        GLuint index )**

        Convenience function that calls glGetStringi( **name** , **index** ).

        This function is only available in OpenGL ES 3.x, or OpenGL 3.x or 4.x
        contexts. When running with plain OpenGL, the function is only usable
        when the given profile and version contains the function either in core
        or as an extension.

        For more information, see the OpenGL ES 3.x documentation for
        **glGetStringi()** .
        """
        ...

    def glGetTexLevelParameterfv(
        self, target: int, level: int, pname: int, params: Sequence[float]
    ) -> None:
        """
        https://doc.qt.io/qt-6/qopenglextrafunctions.html#glGetTexLevelParameter
        fv

        **void QOpenGLExtraFunctions::glGetTexLevelParameterfv(GLenum target ,
        GLint level , GLenum pname , GLfloat * params )**

        Convenience function that calls glGetTexLevelParameterfv( **target** ,
        **level** , **pname** , **params** ).

        This function is only available in OpenGL ES 3.x, or OpenGL 3.x or 4.x
        contexts. When running with plain OpenGL, the function is only usable
        when the given profile and version contains the function either in core
        or as an extension.

        For more information, see the OpenGL ES 3.x documentation for
        **glGetTexLevelParameterfv()** .
        """
        ...

    def glGetTexLevelParameteriv(
        self, target: int, level: int, pname: int, params: Sequence[int]
    ) -> None:
        """
        https://doc.qt.io/qt-6/qopenglextrafunctions.html#glGetTexLevelParameter
        iv

        **void QOpenGLExtraFunctions::glGetTexLevelParameteriv(GLenum target ,
        GLint level , GLenum pname , GLint * params )**

        Convenience function that calls glGetTexLevelParameteriv( **target** ,
        **level** , **pname** , **params** ).

        This function is only available in OpenGL ES 3.x, or OpenGL 3.x or 4.x
        contexts. When running with plain OpenGL, the function is only usable
        when the given profile and version contains the function either in core
        or as an extension.

        For more information, see the OpenGL ES 3.x documentation for
        **glGetTexLevelParameteriv()** .
        """
        ...

    def glGetTexParameterIiv(
        self, target: int, pname: int, params: Sequence[int]
    ) -> None:
        """
        https://doc.qt.io/qt-6/qopenglextrafunctions.html#glGetTexParameterIiv

        **void QOpenGLExtraFunctions::glGetTexParameterIiv(GLenum target ,
        GLenum pname , GLint * params )**

        Convenience function that calls glGetTexParameterIiv( **target** ,
        **pname** , **params** ).

        This function is only available in OpenGL ES 3.x, or OpenGL 3.x or 4.x
        contexts. When running with plain OpenGL, the function is only usable
        when the given profile and version contains the function either in core
        or as an extension.

        For more information, see the OpenGL ES 3.X documentation for
        **glGetTexParameterIiv()** .
        """
        ...

    def glGetTexParameterIuiv(
        self, target: int, pname: int, params: Sequence[int]
    ) -> None:
        """
        https://doc.qt.io/qt-6/qopenglextrafunctions.html#glGetTexParameterIuiv

        **void QOpenGLExtraFunctions::glGetTexParameterIuiv(GLenum target ,
        GLenum pname , GLuint * params )**

        Convenience function that calls glGetTexParameterIuiv( **target** ,
        **pname** , **params** ).

        This function is only available in OpenGL ES 3.x, or OpenGL 3.x or 4.x
        contexts. When running with plain OpenGL, the function is only usable
        when the given profile and version contains the function either in core
        or as an extension.

        For more information, see the OpenGL ES 3.X documentation for
        **glGetTexParameterIuiv()** .
        """
        ...

    def glGetUniformBlockIndex(self, program: int, uniformBlockName: bytes) -> int:
        """
        https://doc.qt.io/qt-6/qopenglextrafunctions.html#glGetUniformBlockIndex

        **GLuint QOpenGLExtraFunctions::glGetUniformBlockIndex(GLuint program ,
        const GLchar * uniformBlockName )**

        Convenience function that calls glGetUniformBlockIndex( **program** ,
        **uniformBlockName** ).

        This function is only available in OpenGL ES 3.x, or OpenGL 3.x or 4.x
        contexts. When running with plain OpenGL, the function is only usable
        when the given profile and version contains the function either in core
        or as an extension.

        For more information, see the OpenGL ES 3.x documentation for
        **glGetUniformBlockIndex()** .
        """
        ...

    def glGetUniformuiv(
        self, program: int, location: int, params: Sequence[int]
    ) -> None:
        """
        https://doc.qt.io/qt-6/qopenglextrafunctions.html#glGetUniformuiv

        **void QOpenGLExtraFunctions::glGetUniformuiv(GLuint program , GLint
        location , GLuint * params )**

        Convenience function that calls glGetUniformuiv( **program** ,
        **location** , **params** ).

        This function is only available in OpenGL ES 3.x, or OpenGL 3.x or 4.x
        contexts. When running with plain OpenGL, the function is only usable
        when the given profile and version contains the function either in core
        or as an extension.

        For more information, see the OpenGL ES 3.x documentation for
        **glGetUniformuiv()** .
        """
        ...

    def glGetVertexAttribIiv(
        self, index: int, pname: int, params: Sequence[int]
    ) -> None:
        """
        https://doc.qt.io/qt-6/qopenglextrafunctions.html#glGetVertexAttribIiv

        **void QOpenGLExtraFunctions::glGetVertexAttribIiv(GLuint index , GLenum
        pname , GLint * params )**

        Convenience function that calls glGetVertexAttribIiv( **index** ,
        **pname** , **params** ).

        This function is only available in OpenGL ES 3.x, or OpenGL 3.x or 4.x
        contexts. When running with plain OpenGL, the function is only usable
        when the given profile and version contains the function either in core
        or as an extension.

        For more information, see the OpenGL ES 3.x documentation for
        **glGetVertexAttribIiv()** .
        """
        ...

    def glGetVertexAttribIuiv(
        self, index: int, pname: int, params: Sequence[int]
    ) -> None:
        """
        https://doc.qt.io/qt-6/qopenglextrafunctions.html#glGetVertexAttribIuiv

        **void QOpenGLExtraFunctions::glGetVertexAttribIuiv(GLuint index ,
        GLenum pname , GLuint * params )**

        Convenience function that calls glGetVertexAttribIuiv( **index** ,
        **pname** , **params** ).

        This function is only available in OpenGL ES 3.x, or OpenGL 3.x or 4.x
        contexts. When running with plain OpenGL, the function is only usable
        when the given profile and version contains the function either in core
        or as an extension.

        For more information, see the OpenGL ES 3.x documentation for
        **glGetVertexAttribIuiv()** .
        """
        ...

    def glGetnUniformfv(self, program: int, location: int, bufSize: int) -> float:
        """
        https://doc.qt.io/qt-6/qopenglextrafunctions.html#glGetnUniformfv

        **void QOpenGLExtraFunctions::glGetnUniformfv(GLuint program , GLint
        location , GLsizei bufSize , GLfloat * params )**

        Convenience function that calls glGetnUniformfv( **program** ,
        **location** , **bufSize** , **params** ).

        This function is only available in OpenGL ES 3.x, or OpenGL 3.x or 4.x
        contexts. When running with plain OpenGL, the function is only usable
        when the given profile and version contains the function either in core
        or as an extension.

        For more information, see the OpenGL ES 3.X documentation for
        **glGetnUniformfv()** .
        """
        ...

    def glGetnUniformiv(
        self, program: int, location: int, bufSize: int, params: Sequence[int]
    ) -> None:
        """
        https://doc.qt.io/qt-6/qopenglextrafunctions.html#glGetnUniformiv

        **void QOpenGLExtraFunctions::glGetnUniformiv(GLuint program , GLint
        location , GLsizei bufSize , GLint * params )**

        Convenience function that calls glGetnUniformiv( **program** ,
        **location** , **bufSize** , **params** ).

        This function is only available in OpenGL ES 3.x, or OpenGL 3.x or 4.x
        contexts. When running with plain OpenGL, the function is only usable
        when the given profile and version contains the function either in core
        or as an extension.

        For more information, see the OpenGL ES 3.X documentation for
        **glGetnUniformiv()** .
        """
        ...

    def glGetnUniformuiv(
        self, program: int, location: int, bufSize: int, params: Sequence[int]
    ) -> None:
        """
        https://doc.qt.io/qt-6/qopenglextrafunctions.html#glGetnUniformuiv

        **void QOpenGLExtraFunctions::glGetnUniformuiv(GLuint program , GLint
        location , GLsizei bufSize , GLuint * params )**

        Convenience function that calls glGetnUniformuiv( **program** ,
        **location** , **bufSize** , **params** ).

        This function is only available in OpenGL ES 3.x, or OpenGL 3.x or 4.x
        contexts. When running with plain OpenGL, the function is only usable
        when the given profile and version contains the function either in core
        or as an extension.

        For more information, see the OpenGL ES 3.X documentation for
        **glGetnUniformuiv()** .
        """
        ...

    def glInvalidateFramebuffer(
        self, target: int, numAttachments: int, attachments: Sequence[int]
    ) -> None:
        """
        https://doc.qt.io/qt-6/qopenglextrafunctions.html#glInvalidateFramebuffe
        r

        **void QOpenGLExtraFunctions::glInvalidateFramebuffer(GLenum target ,
        GLsizei numAttachments , const GLenum * attachments )**

        Convenience function that calls glInvalidateFramebuffer( **target** ,
        **numAttachments** , **attachments** ).

        This function is only available in OpenGL ES 3.x, or OpenGL 3.x or 4.x
        contexts. When running with plain OpenGL, the function is only usable
        when the given profile and version contains the function either in core
        or as an extension.

        For more information, see the OpenGL ES 3.x documentation for
        **glInvalidateFramebuffer()** .
        """
        ...

    def glInvalidateSubFramebuffer(
        self,
        target: int,
        numAttachments: int,
        attachments: Sequence[int],
        x: int,
        y: int,
        width: int,
        height: int,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qopenglextrafunctions.html#glInvalidateSubFramebu
        ffer

        **void QOpenGLExtraFunctions::glInvalidateSubFramebuffer(GLenum target ,
        GLsizei numAttachments , const GLenum * attachments , GLint x , GLint y
        , GLsizei width , GLsizei height )**

        Convenience function that calls glInvalidateSubFramebuffer( **target** ,
        **numAttachments** , **attachments** , **x** , **y** , **width** ,
        **height** ).

        This function is only available in OpenGL ES 3.x, or OpenGL 3.x or 4.x
        contexts. When running with plain OpenGL, the function is only usable
        when the given profile and version contains the function either in core
        or as an extension.

        For more information, see the OpenGL ES 3.x documentation for
        **glInvalidateSubFramebuffer()** .
        """
        ...

    def glIsEnabledi(self, target: int, index: int) -> int:
        """
        https://doc.qt.io/qt-6/qopenglextrafunctions.html#glIsEnabledi

        **GLboolean QOpenGLExtraFunctions::glIsEnabledi(GLenum target , GLuint
        index )**

        Convenience function that calls glIsEnabledi( **target** , **index** ).

        This function is only available in OpenGL ES 3.x, or OpenGL 3.x or 4.x
        contexts. When running with plain OpenGL, the function is only usable
        when the given profile and version contains the function either in core
        or as an extension.

        For more information, see the OpenGL ES 3.X documentation for
        **glIsEnabledi()** .
        """
        ...

    def glIsProgramPipeline(self, pipeline: int) -> int:
        """
        https://doc.qt.io/qt-6/qopenglextrafunctions.html#glIsProgramPipeline

        **GLboolean QOpenGLExtraFunctions::glIsProgramPipeline(GLuint pipeline
        )**

        Convenience function that calls glIsProgramPipeline( **pipeline** ).

        This function is only available in OpenGL ES 3.x, or OpenGL 3.x or 4.x
        contexts. When running with plain OpenGL, the function is only usable
        when the given profile and version contains the function either in core
        or as an extension.

        For more information, see the OpenGL ES 3.x documentation for
        **glIsProgramPipeline()** .
        """
        ...

    def glIsQuery(self, id: int) -> int:
        """
        https://doc.qt.io/qt-6/qopenglextrafunctions.html#glIsQuery

        **GLboolean QOpenGLExtraFunctions::glIsQuery(GLuint id )**

        Convenience function that calls glIsQuery( **id** ).

        This function is only available in OpenGL ES 3.x, or OpenGL 3.x or 4.x
        contexts. When running with plain OpenGL, the function is only usable
        when the given profile and version contains the function either in core
        or as an extension.

        For more information, see the OpenGL ES 3.x documentation for
        **glIsQuery()** .
        """
        ...

    def glIsSampler(self, sampler: int) -> int:
        """
        https://doc.qt.io/qt-6/qopenglextrafunctions.html#glIsSampler

        **GLboolean QOpenGLExtraFunctions::glIsSampler(GLuint sampler )**

        Convenience function that calls glIsSampler( **sampler** ).

        This function is only available in OpenGL ES 3.x, or OpenGL 3.x or 4.x
        contexts. When running with plain OpenGL, the function is only usable
        when the given profile and version contains the function either in core
        or as an extension.

        For more information, see the OpenGL ES 3.x documentation for
        **glIsSampler()** .
        """
        ...

    def glIsTransformFeedback(self, id: int) -> int:
        """
        https://doc.qt.io/qt-6/qopenglextrafunctions.html#glIsTransformFeedback

        **GLboolean QOpenGLExtraFunctions::glIsTransformFeedback(GLuint id )**

        Convenience function that calls glIsTransformFeedback( **id** ).

        This function is only available in OpenGL ES 3.x, or OpenGL 3.x or 4.x
        contexts. When running with plain OpenGL, the function is only usable
        when the given profile and version contains the function either in core
        or as an extension.

        For more information, see the OpenGL ES 3.x documentation for
        **glIsTransformFeedback()** .
        """
        ...

    def glIsVertexArray(self, array: int) -> int:
        """
        https://doc.qt.io/qt-6/qopenglextrafunctions.html#glIsVertexArray

        **GLboolean QOpenGLExtraFunctions::glIsVertexArray(GLuint array )**

        Convenience function that calls glIsVertexArray( **array** ).

        This function is only available in OpenGL ES 3.x, or OpenGL 3.x or 4.x
        contexts. When running with plain OpenGL, the function is only usable
        when the given profile and version contains the function either in core
        or as an extension.

        For more information, see the OpenGL ES 3.x documentation for
        **glIsVertexArray()** .
        """
        ...

    def glMemoryBarrier(self, barriers: int) -> None:
        """
        https://doc.qt.io/qt-6/qopenglextrafunctions.html#glMemoryBarrier

        **void QOpenGLExtraFunctions::glMemoryBarrier(GLbitfield barriers )**

        Convenience function that calls glMemoryBarrier( **barriers** ).

        This function is only available in OpenGL ES 3.x, or OpenGL 3.x or 4.x
        contexts. When running with plain OpenGL, the function is only usable
        when the given profile and version contains the function either in core
        or as an extension.

        For more information, see the OpenGL ES 3.x documentation for
        **glMemoryBarrier()** .
        """
        ...

    def glMemoryBarrierByRegion(self, barriers: int) -> None:
        """
        https://doc.qt.io/qt-6/qopenglextrafunctions.html#glMemoryBarrierByRegio
        n

        **void QOpenGLExtraFunctions::glMemoryBarrierByRegion(GLbitfield
        barriers )**

        Convenience function that calls glMemoryBarrierByRegion( **barriers** ).

        This function is only available in OpenGL ES 3.x, or OpenGL 3.x or 4.x
        contexts. When running with plain OpenGL, the function is only usable
        when the given profile and version contains the function either in core
        or as an extension.

        For more information, see the OpenGL ES 3.x documentation for
        **glMemoryBarrierByRegion()** .
        """
        ...

    def glMinSampleShading(self, value: float) -> None:
        """
        https://doc.qt.io/qt-6/qopenglextrafunctions.html#glMinSampleShading

        **void QOpenGLExtraFunctions::glMinSampleShading(GLfloat value )**

        Convenience function that calls glMinSampleShading( **value** ).

        This function is only available in OpenGL ES 3.x, or OpenGL 3.x or 4.x
        contexts. When running with plain OpenGL, the function is only usable
        when the given profile and version contains the function either in core
        or as an extension.

        For more information, see the OpenGL ES 3.X documentation for
        **glMinSampleShading()** .
        """
        ...

    def glObjectLabel(
        self, identifier: int, name: int, length: int, label: bytes
    ) -> None:
        """
        https://doc.qt.io/qt-6/qopenglextrafunctions.html#glObjectLabel

        **void QOpenGLExtraFunctions::glObjectLabel(GLenum identifier , GLuint
        name , GLsizei length , const GLchar * label )**

        Convenience function that calls glObjectLabel( **identifier** , **name**
        , **length** , **label** ).

        This function is only available in OpenGL ES 3.x, or OpenGL 3.x or 4.x
        contexts. When running with plain OpenGL, the function is only usable
        when the given profile and version contains the function either in core
        or as an extension.

        For more information, see the OpenGL ES 3.X documentation for
        **glObjectLabe()** .
        """
        ...

    def glObjectPtrLabel(self, ptr: int, length: int, label: bytes) -> None:
        """
        https://doc.qt.io/qt-6/qopenglextrafunctions.html#glObjectPtrLabel

        **void QOpenGLExtraFunctions::glObjectPtrLabel(const void * ptr ,
        GLsizei length , const GLchar * label )**

        Convenience function that calls glObjectPtrLabel( **ptr** , **length** ,
        **label** ).

        This function is only available in OpenGL ES 3.x, or OpenGL 3.x or 4.x
        contexts. When running with plain OpenGL, the function is only usable
        when the given profile and version contains the function either in core
        or as an extension.

        For more information, see the OpenGL ES 3.X documentation for
        **glObjectPtrLabe()** .
        """
        ...

    def glPatchParameteri(self, pname: int, value: int) -> None:
        """
        https://doc.qt.io/qt-6/qopenglextrafunctions.html#glPatchParameteri

        **void QOpenGLExtraFunctions::glPatchParameteri(GLenum pname , GLint
        value )**

        Convenience function that calls glPatchParameteri( **pname** , **value**
        ).

        This function is only available in OpenGL ES 3.x, or OpenGL 3.x or 4.x
        contexts. When running with plain OpenGL, the function is only usable
        when the given profile and version contains the function either in core
        or as an extension.

        For more information, see the OpenGL ES 3.X documentation for
        **glPatchParameteri()** .
        """
        ...

    def glPopDebugGroup(self) -> None:
        """
        https://doc.qt.io/qt-6/qopenglextrafunctions.html#glPopDebugGroup

        **void QOpenGLExtraFunctions::glPopDebugGroup()**

        Convenience function that calls glPopDebugGroup().

        This function is only available in OpenGL ES 3.x, or OpenGL 3.x or 4.x
        contexts. When running with plain OpenGL, the function is only usable
        when the given profile and version contains the function either in core
        or as an extension.

        For more information, see the OpenGL ES 3.X documentation for
        **glPopDebugGroup()** .
        """
        ...

    def glPrimitiveBoundingBox(
        self,
        minX: float,
        minY: float,
        minZ: float,
        minW: float,
        maxX: float,
        maxY: float,
        maxZ: float,
        maxW: float,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qopenglextrafunctions.html#glPrimitiveBoundingBox

        **void QOpenGLExtraFunctions::glPrimitiveBoundingBox(GLfloat minX ,
        GLfloat minY , GLfloat minZ , GLfloat minW , GLfloat maxX , GLfloat maxY
        , GLfloat maxZ , GLfloat maxW )**

        Convenience function that calls glPrimitiveBoundingBox( **minX** ,
        **minY** , **minZ** , **minW** , **maxX** , **maxY** , **maxZ** ,
        **maxW** ).

        This function is only available in OpenGL ES 3.x, or OpenGL 3.x or 4.x
        contexts. When running with plain OpenGL, the function is only usable
        when the given profile and version contains the function either in core
        or as an extension.

        For more information, see the OpenGL ES 3.X documentation for
        **glPrimitiveBoundingBo()** .
        """
        ...

    def glProgramBinary(
        self, program: int, binaryFormat: int, binary: int, length: int
    ) -> None:
        """
        https://doc.qt.io/qt-6/qopenglextrafunctions.html#glProgramBinary

        **void QOpenGLExtraFunctions::glProgramBinary(GLuint program , GLenum
        binaryFormat , const void * binary , GLsizei length )**

        Convenience function that calls glProgramBinary( **program** ,
        **binaryFormat** , **binary** , **length** ).

        This function is only available in OpenGL ES 3.x, or OpenGL 3.x or 4.x
        contexts. When running with plain OpenGL, the function is only usable
        when the given profile and version contains the function either in core
        or as an extension.

        For more information, see the OpenGL ES 3.x documentation for
        **glProgramBinary()** .
        """
        ...

    def glProgramParameteri(self, program: int, pname: int, value: int) -> None:
        """
        https://doc.qt.io/qt-6/qopenglextrafunctions.html#glProgramParameteri

        **void QOpenGLExtraFunctions::glProgramParameteri(GLuint program ,
        GLenum pname , GLint value )**

        Convenience function that calls glProgramParameteri( **program** ,
        **pname** , **value** ).

        This function is only available in OpenGL ES 3.x, or OpenGL 3.x or 4.x
        contexts. When running with plain OpenGL, the function is only usable
        when the given profile and version contains the function either in core
        or as an extension.

        For more information, see the OpenGL ES 3.x documentation for
        **glProgramParameteri()** .
        """
        ...

    def glProgramUniform1f(self, program: int, location: int, v0: float) -> None:
        """
        https://doc.qt.io/qt-6/qopenglextrafunctions.html#glProgramUniform1f

        **void QOpenGLExtraFunctions::glProgramUniform1f(GLuint program , GLint
        location , GLfloat v0 )**

        Convenience function that calls glProgramUniform1f( **program** ,
        **location** , **v0** ).

        This function is only available in OpenGL ES 3.x, or OpenGL 3.x or 4.x
        contexts. When running with plain OpenGL, the function is only usable
        when the given profile and version contains the function either in core
        or as an extension.

        For more information, see the OpenGL ES 3.x documentation for
        **glProgramUniform1f()** .
        """
        ...

    def glProgramUniform1fv(
        self, program: int, location: int, count: int, value: Sequence[float]
    ) -> None:
        """
        https://doc.qt.io/qt-6/qopenglextrafunctions.html#glProgramUniform1fv

        **void QOpenGLExtraFunctions::glProgramUniform1fv(GLuint program , GLint
        location , GLsizei count , const GLfloat * value )**

        Convenience function that calls glProgramUniform1fv( **program** ,
        **location** , **count** , **value** ).

        This function is only available in OpenGL ES 3.x, or OpenGL 3.x or 4.x
        contexts. When running with plain OpenGL, the function is only usable
        when the given profile and version contains the function either in core
        or as an extension.

        For more information, see the OpenGL ES 3.x documentation for
        **glProgramUniform1fv()** .
        """
        ...

    def glProgramUniform1i(self, program: int, location: int, v0: int) -> None:
        """
        https://doc.qt.io/qt-6/qopenglextrafunctions.html#glProgramUniform1i

        **void QOpenGLExtraFunctions::glProgramUniform1i(GLuint program , GLint
        location , GLint v0 )**

        Convenience function that calls glProgramUniform1i( **program** ,
        **location** , **v0** ).

        This function is only available in OpenGL ES 3.x, or OpenGL 3.x or 4.x
        contexts. When running with plain OpenGL, the function is only usable
        when the given profile and version contains the function either in core
        or as an extension.

        For more information, see the OpenGL ES 3.x documentation for
        **glProgramUniform1i()** .
        """
        ...

    def glProgramUniform1iv(
        self, program: int, location: int, count: int, value: Sequence[int]
    ) -> None:
        """
        https://doc.qt.io/qt-6/qopenglextrafunctions.html#glProgramUniform1iv

        **void QOpenGLExtraFunctions::glProgramUniform1iv(GLuint program , GLint
        location , GLsizei count , const GLint * value )**

        Convenience function that calls glProgramUniform1iv( **program** ,
        **location** , **count** , **value** ).

        This function is only available in OpenGL ES 3.x, or OpenGL 3.x or 4.x
        contexts. When running with plain OpenGL, the function is only usable
        when the given profile and version contains the function either in core
        or as an extension.

        For more information, see the OpenGL ES 3.x documentation for
        **glProgramUniform1iv()** .
        """
        ...

    def glProgramUniform1ui(self, program: int, location: int, v0: int) -> None:
        """
        https://doc.qt.io/qt-6/qopenglextrafunctions.html#glProgramUniform1ui

        **void QOpenGLExtraFunctions::glProgramUniform1ui(GLuint program , GLint
        location , GLuint v0 )**

        Convenience function that calls glProgramUniform1ui( **program** ,
        **location** , **v0** ).

        This function is only available in OpenGL ES 3.x, or OpenGL 3.x or 4.x
        contexts. When running with plain OpenGL, the function is only usable
        when the given profile and version contains the function either in core
        or as an extension.

        For more information, see the OpenGL ES 3.x documentation for
        **glProgramUniform1ui()** .
        """
        ...

    def glProgramUniform1uiv(
        self, program: int, location: int, count: int, value: Sequence[int]
    ) -> None:
        """
        https://doc.qt.io/qt-6/qopenglextrafunctions.html#glProgramUniform1uiv

        **void QOpenGLExtraFunctions::glProgramUniform1uiv(GLuint program ,
        GLint location , GLsizei count , const GLuint * value )**

        Convenience function that calls glProgramUniform1uiv( **program** ,
        **location** , **count** , **value** ).

        This function is only available in OpenGL ES 3.x, or OpenGL 3.x or 4.x
        contexts. When running with plain OpenGL, the function is only usable
        when the given profile and version contains the function either in core
        or as an extension.

        For more information, see the OpenGL ES 3.x documentation for
        **glProgramUniform1uiv()** .
        """
        ...

    def glProgramUniform2f(
        self, program: int, location: int, v0: float, v1: float
    ) -> None:
        """
        https://doc.qt.io/qt-6/qopenglextrafunctions.html#glProgramUniform2f

        **void QOpenGLExtraFunctions::glProgramUniform2f(GLuint program , GLint
        location , GLfloat v0 , GLfloat v1 )**

        Convenience function that calls glProgramUniform2f( **program** ,
        **location** , **v0** , **v1** ).

        This function is only available in OpenGL ES 3.x, or OpenGL 3.x or 4.x
        contexts. When running with plain OpenGL, the function is only usable
        when the given profile and version contains the function either in core
        or as an extension.

        For more information, see the OpenGL ES 3.x documentation for
        **glProgramUniform2f()** .
        """
        ...

    def glProgramUniform2fv(
        self, program: int, location: int, count: int, value: Sequence[float]
    ) -> None:
        """
        https://doc.qt.io/qt-6/qopenglextrafunctions.html#glProgramUniform2fv

        **void QOpenGLExtraFunctions::glProgramUniform2fv(GLuint program , GLint
        location , GLsizei count , const GLfloat * value )**

        Convenience function that calls glProgramUniform2fv( **program** ,
        **location** , **count** , **value** ).

        This function is only available in OpenGL ES 3.x, or OpenGL 3.x or 4.x
        contexts. When running with plain OpenGL, the function is only usable
        when the given profile and version contains the function either in core
        or as an extension.

        For more information, see the OpenGL ES 3.x documentation for
        **glProgramUniform2fv()** .
        """
        ...

    def glProgramUniform2i(self, program: int, location: int, v0: int, v1: int) -> None:
        """
        https://doc.qt.io/qt-6/qopenglextrafunctions.html#glProgramUniform2i

        **void QOpenGLExtraFunctions::glProgramUniform2i(GLuint program , GLint
        location , GLint v0 , GLint v1 )**

        Convenience function that calls glProgramUniform2i( **program** ,
        **location** , **v0** , **v1** ).

        This function is only available in OpenGL ES 3.x, or OpenGL 3.x or 4.x
        contexts. When running with plain OpenGL, the function is only usable
        when the given profile and version contains the function either in core
        or as an extension.

        For more information, see the OpenGL ES 3.x documentation for
        **glProgramUniform2i()** .
        """
        ...

    def glProgramUniform2iv(
        self, program: int, location: int, count: int, value: Sequence[int]
    ) -> None:
        """
        https://doc.qt.io/qt-6/qopenglextrafunctions.html#glProgramUniform2iv

        **void QOpenGLExtraFunctions::glProgramUniform2iv(GLuint program , GLint
        location , GLsizei count , const GLint * value )**

        Convenience function that calls glProgramUniform2iv( **program** ,
        **location** , **count** , **value** ).

        This function is only available in OpenGL ES 3.x, or OpenGL 3.x or 4.x
        contexts. When running with plain OpenGL, the function is only usable
        when the given profile and version contains the function either in core
        or as an extension.

        For more information, see the OpenGL ES 3.x documentation for
        **glProgramUniform2iv()** .
        """
        ...

    def glProgramUniform2ui(
        self, program: int, location: int, v0: int, v1: int
    ) -> None:
        """
        https://doc.qt.io/qt-6/qopenglextrafunctions.html#glProgramUniform2ui

        **void QOpenGLExtraFunctions::glProgramUniform2ui(GLuint program , GLint
        location , GLuint v0 , GLuint v1 )**

        Convenience function that calls glProgramUniform2ui( **program** ,
        **location** , **v0** , **v1** ).

        This function is only available in OpenGL ES 3.x, or OpenGL 3.x or 4.x
        contexts. When running with plain OpenGL, the function is only usable
        when the given profile and version contains the function either in core
        or as an extension.

        For more information, see the OpenGL ES 3.x documentation for
        **glProgramUniform2ui()** .
        """
        ...

    def glProgramUniform2uiv(
        self, program: int, location: int, count: int, value: Sequence[int]
    ) -> None:
        """
        https://doc.qt.io/qt-6/qopenglextrafunctions.html#glProgramUniform2uiv

        **void QOpenGLExtraFunctions::glProgramUniform2uiv(GLuint program ,
        GLint location , GLsizei count , const GLuint * value )**

        Convenience function that calls glProgramUniform2uiv( **program** ,
        **location** , **count** , **value** ).

        This function is only available in OpenGL ES 3.x, or OpenGL 3.x or 4.x
        contexts. When running with plain OpenGL, the function is only usable
        when the given profile and version contains the function either in core
        or as an extension.

        For more information, see the OpenGL ES 3.x documentation for
        **glProgramUniform2uiv()** .
        """
        ...

    def glProgramUniform3f(
        self, program: int, location: int, v0: float, v1: float, v2: float
    ) -> None:
        """
        https://doc.qt.io/qt-6/qopenglextrafunctions.html#glProgramUniform3f

        **void QOpenGLExtraFunctions::glProgramUniform3f(GLuint program , GLint
        location , GLfloat v0 , GLfloat v1 , GLfloat v2 )**

        Convenience function that calls glProgramUniform3f( **program** ,
        **location** , **v0** , **v1** , **v2** ).

        This function is only available in OpenGL ES 3.x, or OpenGL 3.x or 4.x
        contexts. When running with plain OpenGL, the function is only usable
        when the given profile and version contains the function either in core
        or as an extension.

        For more information, see the OpenGL ES 3.x documentation for
        **glProgramUniform3f()** .
        """
        ...

    def glProgramUniform3fv(
        self, program: int, location: int, count: int, value: Sequence[float]
    ) -> None:
        """
        https://doc.qt.io/qt-6/qopenglextrafunctions.html#glProgramUniform3fv

        **void QOpenGLExtraFunctions::glProgramUniform3fv(GLuint program , GLint
        location , GLsizei count , const GLfloat * value )**

        Convenience function that calls glProgramUniform3fv( **program** ,
        **location** , **count** , **value** ).

        This function is only available in OpenGL ES 3.x, or OpenGL 3.x or 4.x
        contexts. When running with plain OpenGL, the function is only usable
        when the given profile and version contains the function either in core
        or as an extension.

        For more information, see the OpenGL ES 3.x documentation for
        **glProgramUniform3fv()** .
        """
        ...

    def glProgramUniform3i(
        self, program: int, location: int, v0: int, v1: int, v2: int
    ) -> None:
        """
        https://doc.qt.io/qt-6/qopenglextrafunctions.html#glProgramUniform3i

        **void QOpenGLExtraFunctions::glProgramUniform3i(GLuint program , GLint
        location , GLint v0 , GLint v1 , GLint v2 )**

        Convenience function that calls glProgramUniform3i( **program** ,
        **location** , **v0** , **v1** , **v2** ).

        This function is only available in OpenGL ES 3.x, or OpenGL 3.x or 4.x
        contexts. When running with plain OpenGL, the function is only usable
        when the given profile and version contains the function either in core
        or as an extension.

        For more information, see the OpenGL ES 3.x documentation for
        **glProgramUniform3i()** .
        """
        ...

    def glProgramUniform3iv(
        self, program: int, location: int, count: int, value: Sequence[int]
    ) -> None:
        """
        https://doc.qt.io/qt-6/qopenglextrafunctions.html#glProgramUniform3iv

        **void QOpenGLExtraFunctions::glProgramUniform3iv(GLuint program , GLint
        location , GLsizei count , const GLint * value )**

        Convenience function that calls glProgramUniform3iv( **program** ,
        **location** , **count** , **value** ).

        This function is only available in OpenGL ES 3.x, or OpenGL 3.x or 4.x
        contexts. When running with plain OpenGL, the function is only usable
        when the given profile and version contains the function either in core
        or as an extension.

        For more information, see the OpenGL ES 3.x documentation for
        **glProgramUniform3iv()** .
        """
        ...

    def glProgramUniform3ui(
        self, program: int, location: int, v0: int, v1: int, v2: int
    ) -> None:
        """
        https://doc.qt.io/qt-6/qopenglextrafunctions.html#glProgramUniform3ui

        **void QOpenGLExtraFunctions::glProgramUniform3ui(GLuint program , GLint
        location , GLuint v0 , GLuint v1 , GLuint v2 )**

        Convenience function that calls glProgramUniform3ui( **program** ,
        **location** , **v0** , **v1** , **v2** ).

        This function is only available in OpenGL ES 3.x, or OpenGL 3.x or 4.x
        contexts. When running with plain OpenGL, the function is only usable
        when the given profile and version contains the function either in core
        or as an extension.

        For more information, see the OpenGL ES 3.x documentation for
        **glProgramUniform3ui()** .
        """
        ...

    def glProgramUniform3uiv(
        self, program: int, location: int, count: int, value: Sequence[int]
    ) -> None:
        """
        https://doc.qt.io/qt-6/qopenglextrafunctions.html#glProgramUniform3uiv

        **void QOpenGLExtraFunctions::glProgramUniform3uiv(GLuint program ,
        GLint location , GLsizei count , const GLuint * value )**

        Convenience function that calls glProgramUniform3uiv( **program** ,
        **location** , **count** , **value** ).

        This function is only available in OpenGL ES 3.x, or OpenGL 3.x or 4.x
        contexts. When running with plain OpenGL, the function is only usable
        when the given profile and version contains the function either in core
        or as an extension.

        For more information, see the OpenGL ES 3.x documentation for
        **glProgramUniform3uiv()** .
        """
        ...

    def glProgramUniform4f(
        self, program: int, location: int, v0: float, v1: float, v2: float, v3: float
    ) -> None:
        """
        https://doc.qt.io/qt-6/qopenglextrafunctions.html#glProgramUniform4f

        **void QOpenGLExtraFunctions::glProgramUniform4f(GLuint program , GLint
        location , GLfloat v0 , GLfloat v1 , GLfloat v2 , GLfloat v3 )**

        Convenience function that calls glProgramUniform4f( **program** ,
        **location** , **v0** , **v1** , **v2** , **v3** ).

        This function is only available in OpenGL ES 3.x, or OpenGL 3.x or 4.x
        contexts. When running with plain OpenGL, the function is only usable
        when the given profile and version contains the function either in core
        or as an extension.

        For more information, see the OpenGL ES 3.x documentation for
        **glProgramUniform4f()** .
        """
        ...

    def glProgramUniform4fv(
        self, program: int, location: int, count: int, value: Sequence[float]
    ) -> None:
        """
        https://doc.qt.io/qt-6/qopenglextrafunctions.html#glProgramUniform4fv

        **void QOpenGLExtraFunctions::glProgramUniform4fv(GLuint program , GLint
        location , GLsizei count , const GLfloat * value )**

        Convenience function that calls glProgramUniform4fv( **program** ,
        **location** , **count** , **value** ).

        This function is only available in OpenGL ES 3.x, or OpenGL 3.x or 4.x
        contexts. When running with plain OpenGL, the function is only usable
        when the given profile and version contains the function either in core
        or as an extension.

        For more information, see the OpenGL ES 3.x documentation for
        **glProgramUniform4fv()** .
        """
        ...

    def glProgramUniform4i(
        self, program: int, location: int, v0: int, v1: int, v2: int, v3: int
    ) -> None:
        """
        https://doc.qt.io/qt-6/qopenglextrafunctions.html#glProgramUniform4i

        **void QOpenGLExtraFunctions::glProgramUniform4i(GLuint program , GLint
        location , GLint v0 , GLint v1 , GLint v2 , GLint v3 )**

        Convenience function that calls glProgramUniform4i( **program** ,
        **location** , **v0** , **v1** , **v2** , **v3** ).

        This function is only available in OpenGL ES 3.x, or OpenGL 3.x or 4.x
        contexts. When running with plain OpenGL, the function is only usable
        when the given profile and version contains the function either in core
        or as an extension.

        For more information, see the OpenGL ES 3.x documentation for
        **glProgramUniform4i()** .
        """
        ...

    def glProgramUniform4iv(
        self, program: int, location: int, count: int, value: Sequence[int]
    ) -> None:
        """
        https://doc.qt.io/qt-6/qopenglextrafunctions.html#glProgramUniform4iv

        **void QOpenGLExtraFunctions::glProgramUniform4iv(GLuint program , GLint
        location , GLsizei count , const GLint * value )**

        Convenience function that calls glProgramUniform4iv( **program** ,
        **location** , **count** , **value** ).

        This function is only available in OpenGL ES 3.x, or OpenGL 3.x or 4.x
        contexts. When running with plain OpenGL, the function is only usable
        when the given profile and version contains the function either in core
        or as an extension.

        For more information, see the OpenGL ES 3.x documentation for
        **glProgramUniform4iv()** .
        """
        ...

    def glProgramUniform4ui(
        self, program: int, location: int, v0: int, v1: int, v2: int, v3: int
    ) -> None:
        """
        https://doc.qt.io/qt-6/qopenglextrafunctions.html#glProgramUniform4ui

        **void QOpenGLExtraFunctions::glProgramUniform4ui(GLuint program , GLint
        location , GLuint v0 , GLuint v1 , GLuint v2 , GLuint v3 )**

        Convenience function that calls glProgramUniform4ui( **program** ,
        **location** , **v0** , **v1** , **v2** , **v3** ).

        This function is only available in OpenGL ES 3.x, or OpenGL 3.x or 4.x
        contexts. When running with plain OpenGL, the function is only usable
        when the given profile and version contains the function either in core
        or as an extension.

        For more information, see the OpenGL ES 3.x documentation for
        **glProgramUniform4ui()** .
        """
        ...

    def glProgramUniform4uiv(
        self, program: int, location: int, count: int, value: Sequence[int]
    ) -> None:
        """
        https://doc.qt.io/qt-6/qopenglextrafunctions.html#glProgramUniform4uiv

        **void QOpenGLExtraFunctions::glProgramUniform4uiv(GLuint program ,
        GLint location , GLsizei count , const GLuint * value )**

        Convenience function that calls glProgramUniform4uiv( **program** ,
        **location** , **count** , **value** ).

        This function is only available in OpenGL ES 3.x, or OpenGL 3.x or 4.x
        contexts. When running with plain OpenGL, the function is only usable
        when the given profile and version contains the function either in core
        or as an extension.

        For more information, see the OpenGL ES 3.x documentation for
        **glProgramUniform4uiv()** .
        """
        ...

    def glProgramUniformMatrix2fv(
        self,
        program: int,
        location: int,
        count: int,
        transpose: int,
        value: Sequence[float],
    ) -> None:
        """
        https://doc.qt.io/qt-6/qopenglextrafunctions.html#glProgramUniformMatrix
        2fv

        **void QOpenGLExtraFunctions::glProgramUniformMatrix2fv(GLuint program ,
        GLint location , GLsizei count , GLboolean transpose , const GLfloat *
        value )**

        Convenience function that calls glProgramUniformMatrix2fv( **program** ,
        **location** , **count** , **transpose** , **value** ).

        This function is only available in OpenGL ES 3.x, or OpenGL 3.x or 4.x
        contexts. When running with plain OpenGL, the function is only usable
        when the given profile and version contains the function either in core
        or as an extension.

        For more information, see the OpenGL ES 3.x documentation for
        **glProgramUniformMatrix2fv()** .
        """
        ...

    def glProgramUniformMatrix2x3fv(
        self,
        program: int,
        location: int,
        count: int,
        transpose: int,
        value: Sequence[float],
    ) -> None:
        """
        https://doc.qt.io/qt-6/qopenglextrafunctions.html#glProgramUniformMatrix
        2x3fv

        **void QOpenGLExtraFunctions::glProgramUniformMatrix2x3fv(GLuint program
        , GLint location , GLsizei count , GLboolean transpose , const GLfloat *
        value )**

        Convenience function that calls glProgramUniformMatrix2x3fv( **program**
        , **location** , **count** , **transpose** , **value** ).

        This function is only available in OpenGL ES 3.x, or OpenGL 3.x or 4.x
        contexts. When running with plain OpenGL, the function is only usable
        when the given profile and version contains the function either in core
        or as an extension.

        For more information, see the OpenGL ES 3.x documentation for
        **glProgramUniformMatrix2x3fv()** .
        """
        ...

    def glProgramUniformMatrix2x4fv(
        self,
        program: int,
        location: int,
        count: int,
        transpose: int,
        value: Sequence[float],
    ) -> None:
        """
        https://doc.qt.io/qt-6/qopenglextrafunctions.html#glProgramUniformMatrix
        2x4fv

        **void QOpenGLExtraFunctions::glProgramUniformMatrix2x4fv(GLuint program
        , GLint location , GLsizei count , GLboolean transpose , const GLfloat *
        value )**

        Convenience function that calls glProgramUniformMatrix2x4fv( **program**
        , **location** , **count** , **transpose** , **value** ).

        This function is only available in OpenGL ES 3.x, or OpenGL 3.x or 4.x
        contexts. When running with plain OpenGL, the function is only usable
        when the given profile and version contains the function either in core
        or as an extension.

        For more information, see the OpenGL ES 3.x documentation for
        **glProgramUniformMatrix2x4fv()** .
        """
        ...

    def glProgramUniformMatrix3fv(
        self,
        program: int,
        location: int,
        count: int,
        transpose: int,
        value: Sequence[float],
    ) -> None:
        """
        https://doc.qt.io/qt-6/qopenglextrafunctions.html#glProgramUniformMatrix
        3fv

        **void QOpenGLExtraFunctions::glProgramUniformMatrix3fv(GLuint program ,
        GLint location , GLsizei count , GLboolean transpose , const GLfloat *
        value )**

        Convenience function that calls glProgramUniformMatrix3fv( **program** ,
        **location** , **count** , **transpose** , **value** ).

        This function is only available in OpenGL ES 3.x, or OpenGL 3.x or 4.x
        contexts. When running with plain OpenGL, the function is only usable
        when the given profile and version contains the function either in core
        or as an extension.

        For more information, see the OpenGL ES 3.x documentation for
        **glProgramUniformMatrix3fv()** .
        """
        ...

    def glProgramUniformMatrix3x2fv(
        self,
        program: int,
        location: int,
        count: int,
        transpose: int,
        value: Sequence[float],
    ) -> None:
        """
        https://doc.qt.io/qt-6/qopenglextrafunctions.html#glProgramUniformMatrix
        3x2fv

        **void QOpenGLExtraFunctions::glProgramUniformMatrix3x2fv(GLuint program
        , GLint location , GLsizei count , GLboolean transpose , const GLfloat *
        value )**

        Convenience function that calls glProgramUniformMatrix3x2fv( **program**
        , **location** , **count** , **transpose** , **value** ).

        This function is only available in OpenGL ES 3.x, or OpenGL 3.x or 4.x
        contexts. When running with plain OpenGL, the function is only usable
        when the given profile and version contains the function either in core
        or as an extension.

        For more information, see the OpenGL ES 3.x documentation for
        **glProgramUniformMatrix3x2fv()** .
        """
        ...

    def glProgramUniformMatrix3x4fv(
        self,
        program: int,
        location: int,
        count: int,
        transpose: int,
        value: Sequence[float],
    ) -> None:
        """
        https://doc.qt.io/qt-6/qopenglextrafunctions.html#glProgramUniformMatrix
        3x4fv

        **void QOpenGLExtraFunctions::glProgramUniformMatrix3x4fv(GLuint program
        , GLint location , GLsizei count , GLboolean transpose , const GLfloat *
        value )**

        Convenience function that calls glProgramUniformMatrix3x4fv( **program**
        , **location** , **count** , **transpose** , **value** ).

        This function is only available in OpenGL ES 3.x, or OpenGL 3.x or 4.x
        contexts. When running with plain OpenGL, the function is only usable
        when the given profile and version contains the function either in core
        or as an extension.

        For more information, see the OpenGL ES 3.x documentation for
        **glProgramUniformMatrix3x4fv()** .
        """
        ...

    def glProgramUniformMatrix4fv(
        self,
        program: int,
        location: int,
        count: int,
        transpose: int,
        value: Sequence[float],
    ) -> None:
        """
        https://doc.qt.io/qt-6/qopenglextrafunctions.html#glProgramUniformMatrix
        4fv

        **void QOpenGLExtraFunctions::glProgramUniformMatrix4fv(GLuint program ,
        GLint location , GLsizei count , GLboolean transpose , const GLfloat *
        value )**

        Convenience function that calls glProgramUniformMatrix4fv( **program** ,
        **location** , **count** , **transpose** , **value** ).

        This function is only available in OpenGL ES 3.x, or OpenGL 3.x or 4.x
        contexts. When running with plain OpenGL, the function is only usable
        when the given profile and version contains the function either in core
        or as an extension.

        For more information, see the OpenGL ES 3.x documentation for
        **glProgramUniformMatrix4fv()** .
        """
        ...

    def glProgramUniformMatrix4x2fv(
        self,
        program: int,
        location: int,
        count: int,
        transpose: int,
        value: Sequence[float],
    ) -> None:
        """
        https://doc.qt.io/qt-6/qopenglextrafunctions.html#glProgramUniformMatrix
        4x2fv

        **void QOpenGLExtraFunctions::glProgramUniformMatrix4x2fv(GLuint program
        , GLint location , GLsizei count , GLboolean transpose , const GLfloat *
        value )**

        Convenience function that calls glProgramUniformMatrix4x2fv( **program**
        , **location** , **count** , **transpose** , **value** ).

        This function is only available in OpenGL ES 3.x, or OpenGL 3.x or 4.x
        contexts. When running with plain OpenGL, the function is only usable
        when the given profile and version contains the function either in core
        or as an extension.

        For more information, see the OpenGL ES 3.x documentation for
        **glProgramUniformMatrix4x2fv()** .
        """
        ...

    def glProgramUniformMatrix4x3fv(
        self,
        program: int,
        location: int,
        count: int,
        transpose: int,
        value: Sequence[float],
    ) -> None:
        """
        https://doc.qt.io/qt-6/qopenglextrafunctions.html#glProgramUniformMatrix
        4x3fv

        **void QOpenGLExtraFunctions::glProgramUniformMatrix4x3fv(GLuint program
        , GLint location , GLsizei count , GLboolean transpose , const GLfloat *
        value )**

        Convenience function that calls glProgramUniformMatrix4x3fv( **program**
        , **location** , **count** , **transpose** , **value** ).

        This function is only available in OpenGL ES 3.x, or OpenGL 3.x or 4.x
        contexts. When running with plain OpenGL, the function is only usable
        when the given profile and version contains the function either in core
        or as an extension.

        For more information, see the OpenGL ES 3.x documentation for
        **glProgramUniformMatrix4x3fv()** .
        """
        ...

    def glPushDebugGroup(
        self, source: int, id: int, length: int, message: bytes
    ) -> None:
        """
        https://doc.qt.io/qt-6/qopenglextrafunctions.html#glPushDebugGroup

        **void QOpenGLExtraFunctions::glPushDebugGroup(GLenum source , GLuint id
        , GLsizei length , const GLchar * message )**

        Convenience function that calls glPushDebugGroup( **source** , **id** ,
        **length** , **message** ).

        This function is only available in OpenGL ES 3.x, or OpenGL 3.x or 4.x
        contexts. When running with plain OpenGL, the function is only usable
        when the given profile and version contains the function either in core
        or as an extension.

        For more information, see the OpenGL ES 3.X documentation for
        **glPushDebugGroup()** .
        """
        ...

    def glReadBuffer(self, mode: int) -> None:
        """
        https://doc.qt.io/qt-6/qopenglextrafunctions.html#glReadBuffer

        **void QOpenGLExtraFunctions::glReadBuffer(GLenum src )**

        Convenience function that calls glReadBuffer( **src** ).

        This function is only available in OpenGL ES 3.x, or OpenGL 3.x or 4.x
        contexts. When running with plain OpenGL, the function is only usable
        when the given profile and version contains the function either in core
        or as an extension.

        For more information, see the OpenGL ES 3.x documentation for
        **glReadBuffer()** .
        """
        ...

    def glReadnPixels(
        self,
        x: int,
        y: int,
        width: int,
        height: int,
        format: int,
        type: int,
        bufSize: int,
        data: int,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qopenglextrafunctions.html#glReadnPixels

        **void QOpenGLExtraFunctions::glReadnPixels(GLint x , GLint y , GLsizei
        width , GLsizei height , GLenum format , GLenum type , GLsizei bufSize ,
        void * data )**

        Convenience function that calls glReadnPixels( **x** , **y** , **width**
        , **height** , **format** , **type** , **bufSize** , **data** ).

        This function is only available in OpenGL ES 3.x, or OpenGL 3.x or 4.x
        contexts. When running with plain OpenGL, the function is only usable
        when the given profile and version contains the function either in core
        or as an extension.

        For more information, see the OpenGL ES 3.X documentation for
        **glReadnPixels()** .
        """
        ...

    def glRenderbufferStorageMultisample(
        self, target: int, samples: int, internalformat: int, width: int, height: int
    ) -> None:
        """
        https://doc.qt.io/qt-6/qopenglextrafunctions.html#glRenderbufferStorageM
        ultisample

        **void QOpenGLExtraFunctions::glRenderbufferStorageMultisample(GLenum
        target , GLsizei samples , GLenum internalformat , GLsizei width ,
        GLsizei height )**

        Convenience function that calls glRenderbufferStorageMultisample(
        **target** , **samples** , **internalformat** , **width** , **height**
        ).

        This function is only available in OpenGL ES 3.x, or OpenGL 3.x or 4.x
        contexts. When running with plain OpenGL, the function is only usable
        when the given profile and version contains the function either in core
        or as an extension.

        For more information, see the OpenGL ES 3.x documentation for
        **glRenderbufferStorageMultisample()** .
        """
        ...

    def glSampleMaski(self, maskNumber: int, mask: int) -> None:
        """
        https://doc.qt.io/qt-6/qopenglextrafunctions.html#glSampleMaski

        **void QOpenGLExtraFunctions::glSampleMaski(GLuint maskNumber ,
        GLbitfield mask )**

        Convenience function that calls glSampleMaski( **maskNumber** , **mask**
        ).

        This function is only available in OpenGL ES 3.x, or OpenGL 3.x or 4.x
        contexts. When running with plain OpenGL, the function is only usable
        when the given profile and version contains the function either in core
        or as an extension.

        For more information, see the OpenGL ES 3.x documentation for
        **glSampleMaski()** .
        """
        ...

    def glSamplerParameterIiv(
        self, sampler: int, pname: int, param: Sequence[int]
    ) -> None:
        """
        https://doc.qt.io/qt-6/qopenglextrafunctions.html#glSamplerParameterIiv

        **void QOpenGLExtraFunctions::glSamplerParameterIiv(GLuint sampler ,
        GLenum pname , const GLint * param )**

        Convenience function that calls glSamplerParameterIiv( **sampler** ,
        **pname** , **param** ).

        This function is only available in OpenGL ES 3.x, or OpenGL 3.x or 4.x
        contexts. When running with plain OpenGL, the function is only usable
        when the given profile and version contains the function either in core
        or as an extension.

        For more information, see the OpenGL ES 3.X documentation for
        **glSamplerParameterIiv()** .
        """
        ...

    def glSamplerParameterIuiv(
        self, sampler: int, pname: int, param: Sequence[int]
    ) -> None:
        """
        https://doc.qt.io/qt-6/qopenglextrafunctions.html#glSamplerParameterIuiv

        **void QOpenGLExtraFunctions::glSamplerParameterIuiv(GLuint sampler ,
        GLenum pname , const GLuint * param )**

        Convenience function that calls glSamplerParameterIuiv( **sampler** ,
        **pname** , **param** ).

        This function is only available in OpenGL ES 3.x, or OpenGL 3.x or 4.x
        contexts. When running with plain OpenGL, the function is only usable
        when the given profile and version contains the function either in core
        or as an extension.

        For more information, see the OpenGL ES 3.X documentation for
        **glSamplerParameterIuiv()** .
        """
        ...

    def glSamplerParameterf(self, sampler: int, pname: int, param: float) -> None:
        """
        https://doc.qt.io/qt-6/qopenglextrafunctions.html#glSamplerParameterf

        **void QOpenGLExtraFunctions::glSamplerParameterf(GLuint sampler ,
        GLenum pname , GLfloat param )**

        Convenience function that calls glSamplerParameterf( **sampler** ,
        **pname** , **param** ).

        This function is only available in OpenGL ES 3.x, or OpenGL 3.x or 4.x
        contexts. When running with plain OpenGL, the function is only usable
        when the given profile and version contains the function either in core
        or as an extension.

        For more information, see the OpenGL ES 3.x documentation for
        **glSamplerParameterf()** .
        """
        ...

    def glSamplerParameterfv(
        self, sampler: int, pname: int, param: Sequence[float]
    ) -> None:
        """
        https://doc.qt.io/qt-6/qopenglextrafunctions.html#glSamplerParameterfv

        **void QOpenGLExtraFunctions::glSamplerParameterfv(GLuint sampler ,
        GLenum pname , const GLfloat * param )**

        Convenience function that calls glSamplerParameterfv( **sampler** ,
        **pname** , **param** ).

        This function is only available in OpenGL ES 3.x, or OpenGL 3.x or 4.x
        contexts. When running with plain OpenGL, the function is only usable
        when the given profile and version contains the function either in core
        or as an extension.

        For more information, see the OpenGL ES 3.x documentation for
        **glSamplerParameterfv()** .
        """
        ...

    def glSamplerParameteri(self, sampler: int, pname: int, param: int) -> None:
        """
        https://doc.qt.io/qt-6/qopenglextrafunctions.html#glSamplerParameteri

        **void QOpenGLExtraFunctions::glSamplerParameteri(GLuint sampler ,
        GLenum pname , GLint param )**

        Convenience function that calls glSamplerParameteri( **sampler** ,
        **pname** , **param** ).

        This function is only available in OpenGL ES 3.x, or OpenGL 3.x or 4.x
        contexts. When running with plain OpenGL, the function is only usable
        when the given profile and version contains the function either in core
        or as an extension.

        For more information, see the OpenGL ES 3.x documentation for
        **glSamplerParameteri()** .
        """
        ...

    def glSamplerParameteriv(
        self, sampler: int, pname: int, param: Sequence[int]
    ) -> None:
        """
        https://doc.qt.io/qt-6/qopenglextrafunctions.html#glSamplerParameteriv

        **void QOpenGLExtraFunctions::glSamplerParameteriv(GLuint sampler ,
        GLenum pname , const GLint * param )**

        Convenience function that calls glSamplerParameteriv( **sampler** ,
        **pname** , **param** ).

        This function is only available in OpenGL ES 3.x, or OpenGL 3.x or 4.x
        contexts. When running with plain OpenGL, the function is only usable
        when the given profile and version contains the function either in core
        or as an extension.

        For more information, see the OpenGL ES 3.x documentation for
        **glSamplerParameteriv()** .
        """
        ...

    def glTexBuffer(self, target: int, internalformat: int, buffer: int) -> None:
        """
        https://doc.qt.io/qt-6/qopenglextrafunctions.html#glTexBuffer

        **void QOpenGLExtraFunctions::glTexBuffer(GLenum target , GLenum
        internalformat , GLuint buffer )**

        Convenience function that calls glTexBuffer( **target** ,
        **internalformat** , **buffer** ).

        This function is only available in OpenGL ES 3.x, or OpenGL 3.x or 4.x
        contexts. When running with plain OpenGL, the function is only usable
        when the given profile and version contains the function either in core
        or as an extension.

        For more information, see the OpenGL ES 3.X documentation for
        **glTexBuffer()** .
        """
        ...

    def glTexImage3D(
        self,
        target: int,
        level: int,
        internalformat: int,
        width: int,
        height: int,
        depth: int,
        border: int,
        format: int,
        type: int,
        pixels: int,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qopenglextrafunctions.html#glTexImage3D

        **void QOpenGLExtraFunctions::glTexImage3D(GLenum target , GLint level ,
        GLint internalformat , GLsizei width , GLsizei height , GLsizei depth ,
        GLint border , GLenum format , GLenum type , const void * pixels )**

        Convenience function that calls glTexImage3D( **target** , **level** ,
        **internalformat** , **width** , **height** , **depth** , **border** ,
        **format** , **type** , **pixels** ).

        This function is only available in OpenGL ES 3.x, or OpenGL 3.x or 4.x
        contexts. When running with plain OpenGL, the function is only usable
        when the given profile and version contains the function either in core
        or as an extension.

        For more information, see the OpenGL ES 3.x documentation for
        **glTexImage3D()** .
        """
        ...

    def glTexParameterIiv(self, target: int, pname: int, params: Sequence[int]) -> None:
        """
        https://doc.qt.io/qt-6/qopenglextrafunctions.html#glTexParameterIiv

        **void QOpenGLExtraFunctions::glTexParameterIiv(GLenum target , GLenum
        pname , const GLint * params )**

        Convenience function that calls glTexParameterIiv( **target** ,
        **pname** , **params** ).

        This function is only available in OpenGL ES 3.x, or OpenGL 3.x or 4.x
        contexts. When running with plain OpenGL, the function is only usable
        when the given profile and version contains the function either in core
        or as an extension.

        For more information, see the OpenGL ES 3.X documentation for
        **glTexParameterIiv()** .
        """
        ...

    def glTexParameterIuiv(
        self, target: int, pname: int, params: Sequence[int]
    ) -> None:
        """
        https://doc.qt.io/qt-6/qopenglextrafunctions.html#glTexParameterIuiv

        **void QOpenGLExtraFunctions::glTexParameterIuiv(GLenum target , GLenum
        pname , const GLuint * params )**

        Convenience function that calls glTexParameterIuiv( **target** ,
        **pname** , **params** ).

        This function is only available in OpenGL ES 3.x, or OpenGL 3.x or 4.x
        contexts. When running with plain OpenGL, the function is only usable
        when the given profile and version contains the function either in core
        or as an extension.

        For more information, see the OpenGL ES 3.X documentation for
        **glTexParameterIuiv()** .
        """
        ...

    def glTexStorage2D(
        self, target: int, levels: int, internalformat: int, width: int, height: int
    ) -> None:
        """
        https://doc.qt.io/qt-6/qopenglextrafunctions.html#glTexStorage2D

        **void QOpenGLExtraFunctions::glTexStorage2D(GLenum target , GLsizei
        levels , GLenum internalformat , GLsizei width , GLsizei height )**

        Convenience function that calls glTexStorage2D( **target** , **levels**
        , **internalformat** , **width** , **height** ).

        This function is only available in OpenGL ES 3.x, or OpenGL 3.x or 4.x
        contexts. When running with plain OpenGL, the function is only usable
        when the given profile and version contains the function either in core
        or as an extension.

        For more information, see the OpenGL ES 3.x documentation for
        **glTexStorage2D()** .
        """
        ...

    def glTexStorage2DMultisample(
        self,
        target: int,
        samples: int,
        internalformat: int,
        width: int,
        height: int,
        fixedsamplelocations: int,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qopenglextrafunctions.html#glTexStorage2DMultisam
        ple

        **void QOpenGLExtraFunctions::glTexStorage2DMultisample(GLenum target ,
        GLsizei samples , GLenum internalformat , GLsizei width , GLsizei height
        , GLboolean fixedsamplelocations )**

        Convenience function that calls glTexStorage2DMultisample( **target** ,
        **samples** , **internalformat** , **width** , **height** ,
        **fixedsamplelocations** ).

        This function is only available in OpenGL ES 3.x, or OpenGL 3.x or 4.x
        contexts. When running with plain OpenGL, the function is only usable
        when the given profile and version contains the function either in core
        or as an extension.

        For more information, see the OpenGL ES 3.x documentation for
        **glTexStorage2DMultisample()** .
        """
        ...

    def glTexStorage3D(
        self,
        target: int,
        levels: int,
        internalformat: int,
        width: int,
        height: int,
        depth: int,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qopenglextrafunctions.html#glTexStorage3D

        **void QOpenGLExtraFunctions::glTexStorage3D(GLenum target , GLsizei
        levels , GLenum internalformat , GLsizei width , GLsizei height ,
        GLsizei depth )**

        Convenience function that calls glTexStorage3D( **target** , **levels**
        , **internalformat** , **width** , **height** , **depth** ).

        This function is only available in OpenGL ES 3.x, or OpenGL 3.x or 4.x
        contexts. When running with plain OpenGL, the function is only usable
        when the given profile and version contains the function either in core
        or as an extension.

        For more information, see the OpenGL ES 3.x documentation for
        **glTexStorage3D()** .
        """
        ...

    def glTexStorage3DMultisample(
        self,
        target: int,
        samples: int,
        internalformat: int,
        width: int,
        height: int,
        depth: int,
        fixedsamplelocations: int,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qopenglextrafunctions.html#glTexStorage3DMultisam
        ple

        **void QOpenGLExtraFunctions::glTexStorage3DMultisample(GLenum target ,
        GLsizei samples , GLenum internalformat , GLsizei width , GLsizei height
        , GLsizei depth , GLboolean fixedsamplelocations )**

        Convenience function that calls glTexStorage3DMultisample( **target** ,
        **samples** , **internalformat** , **width** , **height** , **depth** ,
        **fixedsamplelocations** ).

        This function is only available in OpenGL ES 3.x, or OpenGL 3.x or 4.x
        contexts. When running with plain OpenGL, the function is only usable
        when the given profile and version contains the function either in core
        or as an extension.

        For more information, see the OpenGL ES 3.X documentation for
        **glTexStorage3DMultisample()** .
        """
        ...

    def glTexSubImage3D(
        self,
        target: int,
        level: int,
        xoffset: int,
        yoffset: int,
        zoffset: int,
        width: int,
        height: int,
        depth: int,
        format: int,
        type: int,
        pixels: int,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qopenglextrafunctions.html#glTexSubImage3D

        **void QOpenGLExtraFunctions::glTexSubImage3D(GLenum target , GLint
        level , GLint xoffset , GLint yoffset , GLint zoffset , GLsizei width ,
        GLsizei height , GLsizei depth , GLenum format , GLenum type , const
        void * pixels )**

        Convenience function that calls glTexSubImage3D( **target** , **level**
        , **xoffset** , **yoffset** , **zoffset** , **width** , **height** ,
        **depth** , **format** , **type** , **pixels** ).

        This function is only available in OpenGL ES 3.x, or OpenGL 3.x or 4.x
        contexts. When running with plain OpenGL, the function is only usable
        when the given profile and version contains the function either in core
        or as an extension.

        For more information, see the OpenGL ES 3.x documentation for
        **glTexSubImage3D()** .
        """
        ...

    def glUniform1ui(self, location: int, v0: int) -> None:
        """
        https://doc.qt.io/qt-6/qopenglextrafunctions.html#glUniform1ui

        **void QOpenGLExtraFunctions::glUniform1ui(GLint location , GLuint v0
        )**

        Convenience function that calls glUniform1ui( **location** , **v0** ).

        This function is only available in OpenGL ES 3.x, or OpenGL 3.x or 4.x
        contexts. When running with plain OpenGL, the function is only usable
        when the given profile and version contains the function either in core
        or as an extension.

        For more information, see the OpenGL ES 3.x documentation for
        **glUniform1ui()** .
        """
        ...

    def glUniform1uiv(self, location: int, count: int, value: Sequence[int]) -> None:
        """
        https://doc.qt.io/qt-6/qopenglextrafunctions.html#glUniform1uiv

        **void QOpenGLExtraFunctions::glUniform1uiv(GLint location , GLsizei
        count , const GLuint * value )**

        Convenience function that calls glUniform1uiv( **location** , **count**
        , **value** ).

        This function is only available in OpenGL ES 3.x, or OpenGL 3.x or 4.x
        contexts. When running with plain OpenGL, the function is only usable
        when the given profile and version contains the function either in core
        or as an extension.

        For more information, see the OpenGL ES 3.x documentation for
        **glUniform1uiv()** .
        """
        ...

    def glUniform2ui(self, location: int, v0: int, v1: int) -> None:
        """
        https://doc.qt.io/qt-6/qopenglextrafunctions.html#glUniform2ui

        **void QOpenGLExtraFunctions::glUniform2ui(GLint location , GLuint v0 ,
        GLuint v1 )**

        Convenience function that calls glUniform2ui( **location** , **v0** ,
        **v1** ).

        This function is only available in OpenGL ES 3.x, or OpenGL 3.x or 4.x
        contexts. When running with plain OpenGL, the function is only usable
        when the given profile and version contains the function either in core
        or as an extension.

        For more information, see the OpenGL ES 3.x documentation for
        **glUniform2ui()** .
        """
        ...

    def glUniform2uiv(self, location: int, count: int, value: Sequence[int]) -> None:
        """
        https://doc.qt.io/qt-6/qopenglextrafunctions.html#glUniform2uiv

        **void QOpenGLExtraFunctions::glUniform2uiv(GLint location , GLsizei
        count , const GLuint * value )**

        Convenience function that calls glUniform2uiv( **location** , **count**
        , **value** ).

        This function is only available in OpenGL ES 3.x, or OpenGL 3.x or 4.x
        contexts. When running with plain OpenGL, the function is only usable
        when the given profile and version contains the function either in core
        or as an extension.

        For more information, see the OpenGL ES 3.x documentation for
        **glUniform2uiv()** .
        """
        ...

    def glUniform3ui(self, location: int, v0: int, v1: int, v2: int) -> None:
        """
        https://doc.qt.io/qt-6/qopenglextrafunctions.html#glUniform3ui

        **void QOpenGLExtraFunctions::glUniform3ui(GLint location , GLuint v0 ,
        GLuint v1 , GLuint v2 )**

        Convenience function that calls glUniform3ui( **location** , **v0** ,
        **v1** , **v2** ).

        This function is only available in OpenGL ES 3.x, or OpenGL 3.x or 4.x
        contexts. When running with plain OpenGL, the function is only usable
        when the given profile and version contains the function either in core
        or as an extension.

        For more information, see the OpenGL ES 3.x documentation for
        **glUniform3ui()** .
        """
        ...

    def glUniform3uiv(self, location: int, count: int, value: Sequence[int]) -> None:
        """
        https://doc.qt.io/qt-6/qopenglextrafunctions.html#glUniform3uiv

        **void QOpenGLExtraFunctions::glUniform3uiv(GLint location , GLsizei
        count , const GLuint * value )**

        Convenience function that calls glUniform3uiv( **location** , **count**
        , **value** ).

        This function is only available in OpenGL ES 3.x, or OpenGL 3.x or 4.x
        contexts. When running with plain OpenGL, the function is only usable
        when the given profile and version contains the function either in core
        or as an extension.

        For more information, see the OpenGL ES 3.x documentation for
        **glUniform3uiv()** .
        """
        ...

    def glUniform4ui(self, location: int, v0: int, v1: int, v2: int, v3: int) -> None:
        """
        https://doc.qt.io/qt-6/qopenglextrafunctions.html#glUniform4ui

        **void QOpenGLExtraFunctions::glUniform4ui(GLint location , GLuint v0 ,
        GLuint v1 , GLuint v2 , GLuint v3 )**

        Convenience function that calls glUniform4ui( **location** , **v0** ,
        **v1** , **v2** , **v3** ).

        This function is only available in OpenGL ES 3.x, or OpenGL 3.x or 4.x
        contexts. When running with plain OpenGL, the function is only usable
        when the given profile and version contains the function either in core
        or as an extension.

        For more information, see the OpenGL ES 3.x documentation for
        **glUniform4ui()** .
        """
        ...

    def glUniform4uiv(self, location: int, count: int, value: Sequence[int]) -> None:
        """
        https://doc.qt.io/qt-6/qopenglextrafunctions.html#glUniform4uiv

        **void QOpenGLExtraFunctions::glUniform4uiv(GLint location , GLsizei
        count , const GLuint * value )**

        Convenience function that calls glUniform4uiv( **location** , **count**
        , **value** ).

        This function is only available in OpenGL ES 3.x, or OpenGL 3.x or 4.x
        contexts. When running with plain OpenGL, the function is only usable
        when the given profile and version contains the function either in core
        or as an extension.

        For more information, see the OpenGL ES 3.x documentation for
        **glUniform4uiv()** .
        """
        ...

    def glUniformBlockBinding(
        self, program: int, uniformBlockIndex: int, uniformBlockBinding: int
    ) -> None:
        """
        https://doc.qt.io/qt-6/qopenglextrafunctions.html#glUniformBlockBinding

        **void QOpenGLExtraFunctions::glUniformBlockBinding(GLuint program ,
        GLuint uniformBlockIndex , GLuint uniformBlockBinding )**

        Convenience function that calls glUniformBlockBinding( **program** ,
        **uniformBlockIndex** , **uniformBlockBinding** ).

        This function is only available in OpenGL ES 3.x, or OpenGL 3.x or 4.x
        contexts. When running with plain OpenGL, the function is only usable
        when the given profile and version contains the function either in core
        or as an extension.

        For more information, see the OpenGL ES 3.x documentation for
        **glUniformBlockBinding()** .
        """
        ...

    def glUniformMatrix2x3fv(
        self, location: int, count: int, transpose: int, value: Sequence[float]
    ) -> None:
        """
        https://doc.qt.io/qt-6/qopenglextrafunctions.html#glUniformMatrix2x3fv

        **void QOpenGLExtraFunctions::glUniformMatrix2x3fv(GLint location ,
        GLsizei count , GLboolean transpose , const GLfloat * value )**

        Convenience function that calls glUniformMatrix2x3fv( **location** ,
        **count** , **transpose** , **value** ).

        This function is only available in OpenGL ES 3.x, or OpenGL 3.x or 4.x
        contexts. When running with plain OpenGL, the function is only usable
        when the given profile and version contains the function either in core
        or as an extension.

        For more information, see the OpenGL ES 3.x documentation for
        **glUniformMatrix2x3fv()** .
        """
        ...

    def glUniformMatrix2x4fv(
        self, location: int, count: int, transpose: int, value: Sequence[float]
    ) -> None:
        """
        https://doc.qt.io/qt-6/qopenglextrafunctions.html#glUniformMatrix2x4fv

        **void QOpenGLExtraFunctions::glUniformMatrix2x4fv(GLint location ,
        GLsizei count , GLboolean transpose , const GLfloat * value )**

        Convenience function that calls glUniformMatrix2x4fv( **location** ,
        **count** , **transpose** , **value** ).

        This function is only available in OpenGL ES 3.x, or OpenGL 3.x or 4.x
        contexts. When running with plain OpenGL, the function is only usable
        when the given profile and version contains the function either in core
        or as an extension.

        For more information, see the OpenGL ES 3.x documentation for
        **glUniformMatrix2x4fv()** .
        """
        ...

    def glUniformMatrix3x2fv(
        self, location: int, count: int, transpose: int, value: Sequence[float]
    ) -> None:
        """
        https://doc.qt.io/qt-6/qopenglextrafunctions.html#glUniformMatrix3x2fv

        **void QOpenGLExtraFunctions::glUniformMatrix3x2fv(GLint location ,
        GLsizei count , GLboolean transpose , const GLfloat * value )**

        Convenience function that calls glUniformMatrix3x2fv( **location** ,
        **count** , **transpose** , **value** ).

        This function is only available in OpenGL ES 3.x, or OpenGL 3.x or 4.x
        contexts. When running with plain OpenGL, the function is only usable
        when the given profile and version contains the function either in core
        or as an extension.

        For more information, see the OpenGL ES 3.x documentation for
        **glUniformMatrix3x2fv()** .
        """
        ...

    def glUniformMatrix3x4fv(
        self, location: int, count: int, transpose: int, value: Sequence[float]
    ) -> None:
        """
        https://doc.qt.io/qt-6/qopenglextrafunctions.html#glUniformMatrix3x4fv

        **void QOpenGLExtraFunctions::glUniformMatrix3x4fv(GLint location ,
        GLsizei count , GLboolean transpose , const GLfloat * value )**

        Convenience function that calls glUniformMatrix3x4fv( **location** ,
        **count** , **transpose** , **value** ).

        This function is only available in OpenGL ES 3.x, or OpenGL 3.x or 4.x
        contexts. When running with plain OpenGL, the function is only usable
        when the given profile and version contains the function either in core
        or as an extension.

        For more information, see the OpenGL ES 3.x documentation for
        **glUniformMatrix3x4fv()** .
        """
        ...

    def glUniformMatrix4x2fv(
        self, location: int, count: int, transpose: int, value: Sequence[float]
    ) -> None:
        """
        https://doc.qt.io/qt-6/qopenglextrafunctions.html#glUniformMatrix4x2fv

        **void QOpenGLExtraFunctions::glUniformMatrix4x2fv(GLint location ,
        GLsizei count , GLboolean transpose , const GLfloat * value )**

        Convenience function that calls glUniformMatrix4x2fv( **location** ,
        **count** , **transpose** , **value** ).

        This function is only available in OpenGL ES 3.x, or OpenGL 3.x or 4.x
        contexts. When running with plain OpenGL, the function is only usable
        when the given profile and version contains the function either in core
        or as an extension.

        For more information, see the OpenGL ES 3.x documentation for
        **glUniformMatrix4x2fv()** .
        """
        ...

    def glUniformMatrix4x3fv(
        self, location: int, count: int, transpose: int, value: Sequence[float]
    ) -> None:
        """
        https://doc.qt.io/qt-6/qopenglextrafunctions.html#glUniformMatrix4x3fv

        **void QOpenGLExtraFunctions::glUniformMatrix4x3fv(GLint location ,
        GLsizei count , GLboolean transpose , const GLfloat * value )**

        Convenience function that calls glUniformMatrix4x3fv( **location** ,
        **count** , **transpose** , **value** ).

        This function is only available in OpenGL ES 3.x, or OpenGL 3.x or 4.x
        contexts. When running with plain OpenGL, the function is only usable
        when the given profile and version contains the function either in core
        or as an extension.

        For more information, see the OpenGL ES 3.x documentation for
        **glUniformMatrix4x3fv()** .
        """
        ...

    def glUnmapBuffer(self, target: int) -> int:
        """
        https://doc.qt.io/qt-6/qopenglextrafunctions.html#glUnmapBuffer

        **GLboolean QOpenGLExtraFunctions::glUnmapBuffer(GLenum target )**

        Convenience function that calls glUnmapBuffer( **target** ).

        This function is only available in OpenGL ES 3.x, or OpenGL 3.x or 4.x
        contexts. When running with plain OpenGL, the function is only usable
        when the given profile and version contains the function either in core
        or as an extension.

        For more information, see the OpenGL ES 3.x documentation for
        **glUnmapBuffer()** .
        """
        ...

    def glUseProgramStages(self, pipeline: int, stages: int, program: int) -> None:
        """
        https://doc.qt.io/qt-6/qopenglextrafunctions.html#glUseProgramStages

        **void QOpenGLExtraFunctions::glUseProgramStages(GLuint pipeline ,
        GLbitfield stages , GLuint program )**

        Convenience function that calls glUseProgramStages( **pipeline** ,
        **stages** , **program** ).

        This function is only available in OpenGL ES 3.x, or OpenGL 3.x or 4.x
        contexts. When running with plain OpenGL, the function is only usable
        when the given profile and version contains the function either in core
        or as an extension.

        For more information, see the OpenGL ES 3.x documentation for
        **glUseProgramStages()** .
        """
        ...

    def glValidateProgramPipeline(self, pipeline: int) -> None:
        """
        https://doc.qt.io/qt-6/qopenglextrafunctions.html#glValidateProgramPipel
        ine

        **void QOpenGLExtraFunctions::glValidateProgramPipeline(GLuint pipeline
        )**

        Convenience function that calls glValidateProgramPipeline( **pipeline**
        ).

        This function is only available in OpenGL ES 3.x, or OpenGL 3.x or 4.x
        contexts. When running with plain OpenGL, the function is only usable
        when the given profile and version contains the function either in core
        or as an extension.

        For more information, see the OpenGL ES 3.x documentation for
        **glValidateProgramPipeline()** .
        """
        ...

    def glVertexAttribBinding(self, attribindex: int, bindingindex: int) -> None:
        """
        https://doc.qt.io/qt-6/qopenglextrafunctions.html#glVertexAttribBinding

        **void QOpenGLExtraFunctions::glVertexAttribBinding(GLuint attribindex ,
        GLuint bindingindex )**

        Convenience function that calls glVertexAttribBinding( **attribindex** ,
        **bindingindex** ).

        This function is only available in OpenGL ES 3.x, or OpenGL 3.x or 4.x
        contexts. When running with plain OpenGL, the function is only usable
        when the given profile and version contains the function either in core
        or as an extension.

        For more information, see the OpenGL ES 3.x documentation for
        **glVertexAttribBinding()** .
        """
        ...

    def glVertexAttribDivisor(self, index: int, divisor: int) -> None:
        """
        https://doc.qt.io/qt-6/qopenglextrafunctions.html#glVertexAttribDivisor

        **void QOpenGLExtraFunctions::glVertexAttribDivisor(GLuint index ,
        GLuint divisor )**

        Convenience function that calls glVertexAttribDivisor( **index** ,
        **divisor** ).

        This function is only available in OpenGL ES 3.x, or OpenGL 3.x or 4.x
        contexts. When running with plain OpenGL, the function is only usable
        when the given profile and version contains the function either in core
        or as an extension.

        For more information, see the OpenGL ES 3.x documentation for
        **glVertexAttribDivisor()** .
        """
        ...

    def glVertexAttribFormat(
        self,
        attribindex: int,
        size: int,
        type: int,
        normalized: int,
        relativeoffset: int,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qopenglextrafunctions.html#glVertexAttribFormat

        **void QOpenGLExtraFunctions::glVertexAttribFormat(GLuint attribindex ,
        GLint size , GLenum type , GLboolean normalized , GLuint relativeoffset
        )**

        Convenience function that calls glVertexAttribFormat( **attribindex** ,
        **size** , **type** , **normalized** , **relativeoffset** ).

        This function is only available in OpenGL ES 3.x, or OpenGL 3.x or 4.x
        contexts. When running with plain OpenGL, the function is only usable
        when the given profile and version contains the function either in core
        or as an extension.

        For more information, see the OpenGL ES 3.x documentation for
        **glVertexAttribFormat()** .
        """
        ...

    def glVertexAttribI4i(self, index: int, x: int, y: int, z: int, w: int) -> None:
        """
        https://doc.qt.io/qt-6/qopenglextrafunctions.html#glVertexAttribI4i

        **void QOpenGLExtraFunctions::glVertexAttribI4i(GLuint index , GLint x ,
        GLint y , GLint z , GLint w )**

        Convenience function that calls glVertexAttribI4i( **index** , **x** ,
        **y** , **z** , **w** ).

        This function is only available in OpenGL ES 3.x, or OpenGL 3.x or 4.x
        contexts. When running with plain OpenGL, the function is only usable
        when the given profile and version contains the function either in core
        or as an extension.

        For more information, see the OpenGL ES 3.x documentation for
        **glVertexAttribI4i()** .
        """
        ...

    def glVertexAttribI4iv(self, index: int, v: Sequence[int]) -> None:
        """
        https://doc.qt.io/qt-6/qopenglextrafunctions.html#glVertexAttribI4iv

        **void QOpenGLExtraFunctions::glVertexAttribI4iv(GLuint index , const
        GLint * v )**

        Convenience function that calls glVertexAttribI4iv( **index** , **v** ).

        This function is only available in OpenGL ES 3.x, or OpenGL 3.x or 4.x
        contexts. When running with plain OpenGL, the function is only usable
        when the given profile and version contains the function either in core
        or as an extension.

        For more information, see the OpenGL ES 3.x documentation for
        **glVertexAttribI4iv()** .
        """
        ...

    def glVertexAttribI4ui(self, index: int, x: int, y: int, z: int, w: int) -> None:
        """
        https://doc.qt.io/qt-6/qopenglextrafunctions.html#glVertexAttribI4ui

        **void QOpenGLExtraFunctions::glVertexAttribI4ui(GLuint index , GLuint x
        , GLuint y , GLuint z , GLuint w )**

        Convenience function that calls glVertexAttribI4ui( **index** , **x** ,
        **y** , **z** , **w** ).

        This function is only available in OpenGL ES 3.x, or OpenGL 3.x or 4.x
        contexts. When running with plain OpenGL, the function is only usable
        when the given profile and version contains the function either in core
        or as an extension.

        For more information, see the OpenGL ES 3.x documentation for
        **glVertexAttribI4ui()** .
        """
        ...

    def glVertexAttribI4uiv(self, index: int, v: Sequence[int]) -> None:
        """
        https://doc.qt.io/qt-6/qopenglextrafunctions.html#glVertexAttribI4uiv

        **void QOpenGLExtraFunctions::glVertexAttribI4uiv(GLuint index , const
        GLuint * v )**

        Convenience function that calls glVertexAttribI4uiv( **index** , **v**
        ).

        This function is only available in OpenGL ES 3.x, or OpenGL 3.x or 4.x
        contexts. When running with plain OpenGL, the function is only usable
        when the given profile and version contains the function either in core
        or as an extension.

        For more information, see the OpenGL ES 3.x documentation for
        **glVertexAttribI4uiv()** .
        """
        ...

    def glVertexAttribIFormat(
        self, attribindex: int, size: int, type: int, relativeoffset: int
    ) -> None:
        """
        https://doc.qt.io/qt-6/qopenglextrafunctions.html#glVertexAttribIFormat

        **void QOpenGLExtraFunctions::glVertexAttribIFormat(GLuint attribindex ,
        GLint size , GLenum type , GLuint relativeoffset )**

        Convenience function that calls glVertexAttribIFormat( **attribindex** ,
        **size** , **type** , **relativeoffset** ).

        This function is only available in OpenGL ES 3.x, or OpenGL 3.x or 4.x
        contexts. When running with plain OpenGL, the function is only usable
        when the given profile and version contains the function either in core
        or as an extension.

        For more information, see the OpenGL ES 3.x documentation for
        **glVertexAttribIFormat()** .
        """
        ...

    def glVertexAttribIPointer(
        self, index: int, size: int, type: int, stride: int, pointer: int
    ) -> None:
        """
        https://doc.qt.io/qt-6/qopenglextrafunctions.html#glVertexAttribIPointer

        **void QOpenGLExtraFunctions::glVertexAttribIPointer(GLuint index ,
        GLint size , GLenum type , GLsizei stride , const void * pointer )**

        Convenience function that calls glVertexAttribIPointer( **index** ,
        **size** , **type** , **stride** , **pointer** ).

        This function is only available in OpenGL ES 3.x, or OpenGL 3.x or 4.x
        contexts. When running with plain OpenGL, the function is only usable
        when the given profile and version contains the function either in core
        or as an extension.

        For more information, see the OpenGL ES 3.x documentation for
        **glVertexAttribIPointer()** .
        """
        ...

    def glVertexBindingDivisor(self, bindingindex: int, divisor: int) -> None:
        """
        https://doc.qt.io/qt-6/qopenglextrafunctions.html#glVertexBindingDivisor

        **void QOpenGLExtraFunctions::glVertexBindingDivisor(GLuint bindingindex
        , GLuint divisor )**

        Convenience function that calls glVertexBindingDivisor( **bindingindex**
        , **divisor** ).

        This function is only available in OpenGL ES 3.x, or OpenGL 3.x or 4.x
        contexts. When running with plain OpenGL, the function is only usable
        when the given profile and version contains the function either in core
        or as an extension.

        For more information, see the OpenGL ES 3.x documentation for
        **glVertexBindingDivisor()** .
        """
        ...
