"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtGui, except for defaults which are replaced by "...".
"""
from typing import Union, overload
import PySide6.QtCore
import PySide6.QtGui

bytes = str


class QNativeGestureEvent(PySide6.QtGui.QSinglePointEvent):
    """
    https://doc.qt.io/qt-6/qnativegestureevent.html

    **Detailed Description**

    Native gesture events are generated by the operating system, typically by
    interpreting trackpad touch events. Gesture events are high-level events
    such as zoom, rotate or pan. Several types hold incremental values: that is,
    **value** () and **delta** () provide the difference from the previous event
    to the current event.

    Event TypeDescriptionTouch sequence
    **Qt::ZoomNativeGesture**
    Magnification delta in percent.macOS and Wayland: Two-finger pinch.
    **Qt::SmartZoomNativeGesture** Boolean magnification state.macOS: Two-finger
    douple tap (trackpad) / One-finger douple tap (magic mouse).
    **Qt::RotateNativeGesture** Rotation delta in degrees.macOS and Wayland:
    Two-finger rotate.
    **Qt::SwipeNativeGesture** Swipe angle in
    degrees.macOS: Configurable in trackpad settings.
    **Qt::PanNativeGesture**
    Displacement delta in pixels.Wayland: Three or more fingers moving as a
    group, in any direction.

    In addition, BeginNativeGesture and EndNativeGesture are sent before and
    after gesture event streams:

    BeginNativeGesture ZoomNativeGesture ZoomNativeGesture ZoomNativeGesture
    EndNativeGesture

    The event stream may include interleaved gestures of different types: for
    example the two-finger pinch gesture generates a stream of Zoom and Rotate
    events, and PanNativeGesture may sometimes be interleaved with those,
    depending on the platform.

    Other types are standalone events: SmartZoomNativeGesture and
    SwipeNativeGesture occur only once each time the gesture is detected.

    **Note:** On a touchpad, moving two fingers as a group (the two-finger flick
    gesture) is usually reserved for scrolling; in that case, Qt generates
    QWheelEvents. This is the reason that three or more fingers are needed to
    generate a PanNativeGesture.

    **See also** **Qt::NativeGestureType** , **QGestureEvent** , and
    **QWheelEvent** .
    """

    @overload
    def __init__(self, arg__1: PySide6.QtGui.QNativeGestureEvent) -> None:
        """
        https://doc.qt.io/qt-6/qnativegestureevent.html#QNativeGestureEvent-3

        **[since 6.2]
        QNativeGestureEvent::QNativeGestureEvent(Qt::NativeGestureType type ,
        const QPointingDevice * device , int fingerCount , const QPointF &
        localPos , const QPointF & scenePos , const QPointF & globalPos , qreal
        value , const QPointF & delta , quint64 sequenceId = UINT64_MAX)**

        Constructs a native gesture event of type **type** originating from
        **device** describing a gesture at **scenePos** in which **fingerCount**
        fingers are involved.

        The points **localPos** , **scenePos** and **globalPos** specify the
        gesture position relative to the receiving widget or item, window, and
        screen or desktop, respectively.

        **value** has a gesture-dependent interpretation: for
        RotateNativeGesture or SwipeNativeGesture, it's an angle in degrees. For
        ZoomNativeGesture, **value** is an incremental scaling factor, usually
        much less than 1, indicating that the target item should have its scale
        adjusted like this: item.scale = item.scale * (1 + event.value)

        For PanNativeGesture, **delta** gives the distance in pixels that the
        viewport, widget or item should be moved or panned.

        **Note:** The **delta** is stored in single precision (**QVector2D** ),
        so **delta** () may return slightly different values in some cases. This
        is subject to change in future versions of Qt.

        This function was introduced in Qt 6.2.
        """
        ...

    @overload
    def __init__(
        self,
        type: PySide6.QtCore.Qt.NativeGestureType,
        dev: PySide6.QtGui.QPointingDevice,
        fingerCount: int,
        localPos: Union[
            PySide6.QtCore.QPointF,
            PySide6.QtCore.QPoint,
            PySide6.QtGui.QPainterPath.Element,
        ],
        scenePos: Union[
            PySide6.QtCore.QPointF,
            PySide6.QtCore.QPoint,
            PySide6.QtGui.QPainterPath.Element,
        ],
        globalPos: Union[
            PySide6.QtCore.QPointF,
            PySide6.QtCore.QPoint,
            PySide6.QtGui.QPainterPath.Element,
        ],
        value: float,
        delta: Union[
            PySide6.QtCore.QPointF,
            PySide6.QtCore.QPoint,
            PySide6.QtGui.QPainterPath.Element,
        ],
        sequenceId: int = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qnativegestureevent.html#QNativeGestureEvent-3

        **[since 6.2]
        QNativeGestureEvent::QNativeGestureEvent(Qt::NativeGestureType type ,
        const QPointingDevice * device , int fingerCount , const QPointF &
        localPos , const QPointF & scenePos , const QPointF & globalPos , qreal
        value , const QPointF & delta , quint64 sequenceId = UINT64_MAX)**

        Constructs a native gesture event of type **type** originating from
        **device** describing a gesture at **scenePos** in which **fingerCount**
        fingers are involved.

        The points **localPos** , **scenePos** and **globalPos** specify the
        gesture position relative to the receiving widget or item, window, and
        screen or desktop, respectively.

        **value** has a gesture-dependent interpretation: for
        RotateNativeGesture or SwipeNativeGesture, it's an angle in degrees. For
        ZoomNativeGesture, **value** is an incremental scaling factor, usually
        much less than 1, indicating that the target item should have its scale
        adjusted like this: item.scale = item.scale * (1 + event.value)

        For PanNativeGesture, **delta** gives the distance in pixels that the
        viewport, widget or item should be moved or panned.

        **Note:** The **delta** is stored in single precision (**QVector2D** ),
        so **delta** () may return slightly different values in some cases. This
        is subject to change in future versions of Qt.

        This function was introduced in Qt 6.2.
        """
        ...

    @overload
    def __init__(
        self,
        type: PySide6.QtCore.Qt.NativeGestureType,
        dev: PySide6.QtGui.QPointingDevice,
        localPos: Union[
            PySide6.QtCore.QPointF,
            PySide6.QtCore.QPoint,
            PySide6.QtGui.QPainterPath.Element,
        ],
        scenePos: Union[
            PySide6.QtCore.QPointF,
            PySide6.QtCore.QPoint,
            PySide6.QtGui.QPainterPath.Element,
        ],
        globalPos: Union[
            PySide6.QtCore.QPointF,
            PySide6.QtCore.QPoint,
            PySide6.QtGui.QPainterPath.Element,
        ],
        value: float,
        sequenceId: int,
        intArgument: int,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qnativegestureevent.html#QNativeGestureEvent-3

        **[since 6.2]
        QNativeGestureEvent::QNativeGestureEvent(Qt::NativeGestureType type ,
        const QPointingDevice * device , int fingerCount , const QPointF &
        localPos , const QPointF & scenePos , const QPointF & globalPos , qreal
        value , const QPointF & delta , quint64 sequenceId = UINT64_MAX)**

        Constructs a native gesture event of type **type** originating from
        **device** describing a gesture at **scenePos** in which **fingerCount**
        fingers are involved.

        The points **localPos** , **scenePos** and **globalPos** specify the
        gesture position relative to the receiving widget or item, window, and
        screen or desktop, respectively.

        **value** has a gesture-dependent interpretation: for
        RotateNativeGesture or SwipeNativeGesture, it's an angle in degrees. For
        ZoomNativeGesture, **value** is an incremental scaling factor, usually
        much less than 1, indicating that the target item should have its scale
        adjusted like this: item.scale = item.scale * (1 + event.value)

        For PanNativeGesture, **delta** gives the distance in pixels that the
        viewport, widget or item should be moved or panned.

        **Note:** The **delta** is stored in single precision (**QVector2D** ),
        so **delta** () may return slightly different values in some cases. This
        is subject to change in future versions of Qt.

        This function was introduced in Qt 6.2.
        """
        ...

    def clone(self) -> PySide6.QtGui.QNativeGestureEvent:
        ...

    def delta(self) -> PySide6.QtCore.QPointF:
        """
        https://doc.qt.io/qt-6/qnativegestureevent.html#delta

        **[since 6.2] QPointF QNativeGestureEvent::delta() const**

        Returns the distance moved since the previous event, in pixels. A Pan
        gesture provides the distance in pixels by which the target widget, item
        or viewport contents should be moved.

        This function was introduced in Qt 6.2.

        **See also** **QPanGesture::delta** ().
        """
        ...

    def fingerCount(self) -> int:
        """
        https://doc.qt.io/qt-6/qnativegestureevent.html#fingerCount

        **[since 6.2] int QNativeGestureEvent::fingerCount() const**

        Returns the number of fingers participating in the gesture, if known.
        When **gestureType** () is **Qt::BeginNativeGesture**  or
        **Qt::EndNativeGesture** , often this information is unknown, and
        fingerCount() returns `0`.

        This function was introduced in Qt 6.2.
        """
        ...

    def gestureType(self) -> PySide6.QtCore.Qt.NativeGestureType:
        """
        https://doc.qt.io/qt-6/qnativegestureevent.html#gestureType

        **[since 5.2] Qt::NativeGestureType QNativeGestureEvent::gestureType()
        const**

        Returns the gesture type.

        This function was introduced in Qt 5.2.
        """
        ...

    def globalPos(self) -> PySide6.QtCore.QPoint:
        ...

    def localPos(self) -> PySide6.QtCore.QPointF:
        ...

    def pos(self) -> PySide6.QtCore.QPoint:
        ...

    def screenPos(self) -> PySide6.QtCore.QPointF:
        ...

    def value(self) -> float:
        """
        https://doc.qt.io/qt-6/qnativegestureevent.html#value

        **[since 5.2] qreal QNativeGestureEvent::value() const**

        Returns the gesture value. The value should be interpreted based on the
        gesture type. For example, a Zoom gesture provides a scale factor delta
        while a Rotate gesture provides a rotation delta.

        This function was introduced in Qt 5.2.

        **See also** **QNativeGestureEvent**  and **gestureType** ().
        """
        ...

    def windowPos(self) -> PySide6.QtCore.QPointF:
        ...
