"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtGui, except for defaults which are replaced by "...".
"""
from typing import Union, overload
import PySide6.QtCore
import PySide6.QtGui

bytes = str


class QConicalGradient(PySide6.QtGui.QGradient):
    """
    https://doc.qt.io/qt-6/qconicalgradient.html

    **Detailed Description**

    Conical gradients interpolate interpolate colors counter-clockwise around a
    center point.

    ![](images/qconicalgradient.png)

    The colors in a gradient is defined using stop points of the
    **QGradientStop**  type, i.e. a position and a color. Use the
    **QGradient::setColorAt** () or the **QGradient::setStops** () function to
    define the stop points. It is the gradient's complete set of stop points
    that describes how the gradient area should be filled. If no stop points
    have been specified, a gradient of black at 0 to white at 1 is used.

    In addition to the functions inherited from **QGradient** , the
    QConicalGradient class provides the **angle** () and **center** () functions
    returning the start angle and center of the gradient.

    Note that the **setSpread** () function has no effect for conical gradients.
    The reason is that the conical gradient is closed by definition, i.e. the
    conical gradient fills the entire circle from 0 - 360 degrees, while the
    boundary of a radial or a linear gradient can be specified through its
    radius or final stop points, respectively.

    **See also** **QLinearGradient** , **QRadialGradient** , and **The Gradients
    Example** .
    """

    @overload
    def __init__(self) -> None:
        """
        https://doc.qt.io/qt-6/qconicalgradient.html#QConicalGradient

        **QConicalGradient::QConicalGradient()**

        Constructs a conical with center at (0, 0) starting the interpolation at
        angle 0.

        **See also** **QGradient::setColorAt** (), **setCenter** (), and
        **setAngle** ().
        """
        ...

    @overload
    def __init__(self, QConicalGradient: PySide6.QtGui.QConicalGradient) -> None:
        """
        https://doc.qt.io/qt-6/qconicalgradient.html#QConicalGradient-1

        **QConicalGradient::QConicalGradient(const QPointF & center , qreal
        angle )**

        Constructs a conical gradient with the given **center** , starting the
        interpolation at the given **angle**. The **angle** must be specified in
        degrees between 0 and 360.

        **See also** **QGradient::setColorAt** () and **QGradient::setStops**
        ().
        """
        ...

    @overload
    def __init__(
        self,
        center: Union[
            PySide6.QtCore.QPointF,
            PySide6.QtCore.QPoint,
            PySide6.QtGui.QPainterPath.Element,
        ],
        startAngle: float,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qconicalgradient.html#QConicalGradient-2

        **QConicalGradient::QConicalGradient(qreal cx , qreal cy , qreal angle
        )**

        Constructs a conical gradient with the given center ( **cx** , **cy** ),
        starting the interpolation at the given **angle**. The angle must be
        specified in degrees between 0 and 360.

        **See also** **QGradient::setColorAt** () and **QGradient::setStops**
        ().
        """
        ...

    @overload
    def __init__(self, cx: float, cy: float, startAngle: float) -> None:
        """
        https://doc.qt.io/qt-6/qconicalgradient.html#QConicalGradient

        **QConicalGradient::QConicalGradient()**

        Constructs a conical with center at (0, 0) starting the interpolation at
        angle 0.

        **See also** **QGradient::setColorAt** (), **setCenter** (), and
        **setAngle** ().
        """
        ...

    @staticmethod
    def __copy__() -> None:
        ...

    def angle(self) -> float:
        """
        https://doc.qt.io/qt-6/qconicalgradient.html#angle

        **qreal QConicalGradient::angle() const**

        Returns the start angle of the conical gradient in logical coordinates.

        **See also** **setAngle** () and **stops** ().
        """
        ...

    def center(self) -> PySide6.QtCore.QPointF:
        """
        https://doc.qt.io/qt-6/qconicalgradient.html#center

        **QPointF QConicalGradient::center() const**

        Returns the center of the conical gradient in logical coordinates.

        **See also** **setCenter** () and **stops** ().
        """
        ...

    def setAngle(self, angle: float) -> None:
        """
        https://doc.qt.io/qt-6/qconicalgradient.html#setAngle

        **void QConicalGradient::setAngle(qreal angle )**

        Sets **angle** to be the start angle for this conical gradient in
        logical coordinates.

        **See also** **angle** ().
        """
        ...

    @overload
    def setCenter(
        self,
        center: Union[
            PySide6.QtCore.QPointF,
            PySide6.QtCore.QPoint,
            PySide6.QtGui.QPainterPath.Element,
        ],
    ) -> None:
        """
        https://doc.qt.io/qt-6/qconicalgradient.html#setCenter

        **void QConicalGradient::setCenter(const QPointF & center )**

        Sets the center of this conical gradient in logical coordinates to
        **center**.

        **See also** **center** ().
        """
        ...

    @overload
    def setCenter(self, x: float, y: float) -> None:
        """
        https://doc.qt.io/qt-6/qconicalgradient.html#setCenter-1

        **void QConicalGradient::setCenter(qreal x , qreal y )**

        This is an overloaded function.

        Sets the center of this conical gradient in logical coordinates to (
        **x** , **y** ).

        **See also** **center** ().
        """
        ...
