"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtGui, except for defaults which are replaced by "...".
"""
from enum import Enum
from typing import List, Union, overload
import PySide6.QtCore
import PySide6.QtGui

bytes = str


class QActionGroup(PySide6.QtCore.QObject):
    """
    https://doc.qt.io/qt-6/qactiongroup.html

    **Detailed Description**

    QActionGroup is a base class for classes grouping classes inhheriting
    **QAction**  objects together.

    In some situations it is useful to group **QAction**  objects together. For
    example, if you have a **Left Align** action, a **Right Align** action, a
    **Justify** action, and a **Center** action, only one of these actions
    should be active at any one time. One simple way of achieving this is to
    group the actions together in an action group, inheriting QActionGroup.

    **See also** **QAction** .
    """

    class ExclusionPolicy(Enum):
        None_: QActionGroup.ExclusionPolicy = ...
        Exclusive: QActionGroup.ExclusionPolicy = ...
        ExclusiveOptional: QActionGroup.ExclusionPolicy = ...

    def __init__(self, parent: PySide6.QtCore.QObject) -> None:
        """
        https://doc.qt.io/qt-6/qactiongroup.html#QActionGroup

        **QActionGroup::QActionGroup(QObject * parent )**

        Constructs an action group for the **parent** object.

        The action group is exclusive by default. Call **setExclusive** (false)
        to make the action group non-exclusive. To make the group exclusive but
        allow unchecking the active action call instead **setExclusionPolicy**
        (**QActionGroup::ExclusionPolicy::ExclusiveOptional** )
        """
        ...

    def actions(self) -> List[PySide6.QtGui.QAction]:
        """
        https://doc.qt.io/qt-6/qactiongroup.html#actions

        **QList<QAction *> QActionGroup::actions() const**

        Returns the list of this groups's actions. This may be empty.
        """
        ...

    @overload
    def addAction(self, a: PySide6.QtGui.QAction) -> PySide6.QtGui.QAction:
        """
        https://doc.qt.io/qt-6/qactiongroup.html#addAction

        **QAction *QActionGroup::addAction(QAction * action )**

        Adds the **action** to this group, and returns it.

        Normally an action is added to a group by creating it with the group as
        its parent, so this function is not usually used.

        **See also** **QAction::setActionGroup** ().
        """
        ...

    @overload
    def addAction(
        self, icon: Union[PySide6.QtGui.QIcon, PySide6.QtGui.QPixmap], text: str
    ) -> PySide6.QtGui.QAction:
        """
        https://doc.qt.io/qt-6/qactiongroup.html#addAction-1

        **QAction *QActionGroup::addAction(const QString & text )**

        Creates and returns an action with **text**. The newly created action is
        a child of this action group.

        Normally an action is added to a group by creating it with the group as
        parent, so this function is not usually used.

        **See also** **QAction::setActionGroup** ().
        """
        ...

    @overload
    def addAction(self, text: str) -> PySide6.QtGui.QAction:
        """
        https://doc.qt.io/qt-6/qactiongroup.html#addAction-2

        **QAction *QActionGroup::addAction(const QIcon & icon , const QString &
        text )**

        Creates and returns an action with **text** and an **icon**. The newly
        created action is a child of this action group.

        Normally an action is added to a group by creating it with the group as
        its parent, so this function is not usually used.

        **See also** **QAction::setActionGroup** ().
        """
        ...

    def checkedAction(self) -> PySide6.QtGui.QAction:
        """
        https://doc.qt.io/qt-6/qactiongroup.html#checkedAction

        **QAction *QActionGroup::checkedAction() const**

        Returns the currently checked action in the group, or `nullptr` if none
        are checked.
        """
        ...

    def exclusionPolicy(self) -> PySide6.QtGui.QActionGroup.ExclusionPolicy:
        """
        https://doc.qt.io/qt-6/qactiongroup.html#exclusionPolicy-prop

        **exclusionPolicy : QActionGroup::ExclusionPolicy**

        This property holds the group exclusive checking policy

        If exclusionPolicy is set to Exclusive, only one checkable action in the
        action group can ever be active at any time. If the user chooses another
        checkable action in the group, the one they chose becomes active and the
        one that was active becomes inactive. If exclusionPolicy is set to
        ExclusionOptional the group is exclusive but the active checkable action
        in the group can be unchecked leaving the group with no actions checked.

        **Access functions:**

        QActionGroup::ExclusionPolicy **exclusionPolicy** () const
        void
        **setExclusionPolicy** (QActionGroup::ExclusionPolicy **policy** )

        **See also** **QAction::checkable** .
        """
        ...

    def isEnabled(self) -> bool:
        ...

    def isExclusive(self) -> bool:
        """
        https://doc.qt.io/qt-6/qactiongroup.html#isExclusive

        **bool QActionGroup::isExclusive() const**

        Returns true if the group is exclusive

        The group is exclusive if the **ExclusionPolicy**  is either Exclusive
        or ExclusionOptional.
        """
        ...

    def isVisible(self) -> bool:
        ...

    def removeAction(self, a: PySide6.QtGui.QAction) -> None:
        """
        https://doc.qt.io/qt-6/qactiongroup.html#removeAction

        **void QActionGroup::removeAction(QAction * action )**

        Removes the **action** from this group. The action will have no parent
        as a result.

        **See also** **QAction::setActionGroup** ().
        """
        ...

    def setDisabled(self, b: bool) -> None:
        """
        https://doc.qt.io/qt-6/qactiongroup.html#setDisabled

        **[slot] void QActionGroup::setDisabled(bool b )**

        This is a convenience function for the **enabled**  property, that is
        useful for signals--slots connections. If **b** is true the action group
        is disabled; otherwise it is enabled.
        """
        ...

    def setEnabled(self, arg__1: bool) -> None:
        """
        https://doc.qt.io/qt-6/qactiongroup.html#enabled-prop

        **enabled : bool**

        This property holds whether the action group is enabled

        Each action in the group will be enabled or disabled unless it has been
        explicitly disabled.

        **Access functions:**

        bool **isEnabled** () const
        void **setEnabled** (bool)

        **See also** **QAction::setEnabled** ().
        """
        ...

    def setExclusionPolicy(
        self, policy: PySide6.QtGui.QActionGroup.ExclusionPolicy
    ) -> None:
        """
        https://doc.qt.io/qt-6/qactiongroup.html#exclusionPolicy-prop

        **exclusionPolicy : QActionGroup::ExclusionPolicy**

        This property holds the group exclusive checking policy

        If exclusionPolicy is set to Exclusive, only one checkable action in the
        action group can ever be active at any time. If the user chooses another
        checkable action in the group, the one they chose becomes active and the
        one that was active becomes inactive. If exclusionPolicy is set to
        ExclusionOptional the group is exclusive but the active checkable action
        in the group can be unchecked leaving the group with no actions checked.

        **Access functions:**

        QActionGroup::ExclusionPolicy **exclusionPolicy** () const
        void
        **setExclusionPolicy** (QActionGroup::ExclusionPolicy **policy** )

        **See also** **QAction::checkable** .
        """
        ...

    def setExclusive(self, arg__1: bool) -> None:
        """
        https://doc.qt.io/qt-6/qactiongroup.html#setExclusive

        **[slot] void QActionGroup::setExclusive(bool b )**

        Enable or disable the group exclusion checking

        This is a convenience method that calls **setExclusionPolicy**
        (**ExclusionPolicy::Exclusive** ) when **b** is true, else
        **setExclusionPolicy** (**QActionGroup::ExclusionPolicy::None** ).

        **See also** **isExclusive** () and **QActionGroup::exclusionPolicy** .
        """
        ...

    def setVisible(self, arg__1: bool) -> None:
        """
        https://doc.qt.io/qt-6/qactiongroup.html#visible-prop

        **visible : bool**

        This property holds whether the action group is visible

        Each action in the action group will match the visible state of this
        group unless it has been explicitly hidden.

        **Access functions:**

        bool **isVisible** () const
        void **setVisible** (bool)

        **See also** **QAction::setEnabled** ().

        **Member Function Documentation**
        """
        ...
