"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtGui, except for defaults which are replaced by "...".
"""
from enum import Enum
from typing import Any, List, Optional, Sequence, Union, overload
import PySide6.QtCore
import PySide6.QtGui

bytes = str


class QAction(PySide6.QtCore.QObject):
    """
    https://doc.qt.io/qt-6/qaction.html

    **Detailed Description**

    In applications many common commands can be invoked via menus, toolbar
    buttons, and keyboard shortcuts. Since the user expects each command to be
    performed in the same way, regardless of the user interface used, it is
    useful to represent each command as an **action**.

    Actions can be added to menus and toolbars, and will automatically keep them
    in sync. For example, in a word processor, if the user presses a Bold
    toolbar button, the Bold menu item will automatically be checked.

    A QAction may contain an icon, menu text, a shortcut, status text, "What's
    This?" text, and a tooltip. Most of these can be set in the constructor.
    They can also be set independently with **setIcon** (), **setText** (),
    **setIconText** (), **setShortcut** (), **setStatusTip** (),
    **setWhatsThis** (), and **setToolTip** (). For menu items, it is possible
    to set an individual font with **setFont** ().

    We recommend that actions are created as children of the window they are
    used in. In most cases actions will be children of the application's main
    window.

    **QAction in widget applications**

    Once a QAction has been created, it should be added to the relevant menu and
    toolbar, then connected to the slot which will perform the action. For
    example:

    const **QIcon**  openIcon = **QIcon** ::fromTheme("document-open", **QIcon**
    (":/images/open.png"));
            **QAction**  *openAct = new **QAction**
    (openIcon, tr("&Open..."), this);
    openAct->setShortcuts(**QKeySequence** ::Open);
    openAct->setStatusTip(tr("Open an existing file"));
            connect(openAct,
    &**QAction** ::triggered, this, &MainWindow::open);
    fileMenu->addAction(openAct);
            fileToolBar->addAction(openAct);

    Actions are added to widgets using **QWidget::addAction** () or
    **QGraphicsWidget::addAction** (). Note that an action must be added to a
    widget before it can be used. This is also true when the shortcut should be
    global (i.e., **Qt::ApplicationShortcut**  as **Qt::ShortcutContext** ).

    Actions can be created as independent objects. But they may also be created
    during the construction of menus. The **QMenu**  class contains convenience
    functions for creating actions suitable for use as menu items.

    **See also** **QMenu** , **QToolBar** , and **Qt Widgets - Application
    Example** .
    """

    Trigger: QAction.ActionEvent = ...
    Hover: QAction.ActionEvent = ...
    NoRole: QAction.MenuRole = ...
    TextHeuristicRole: QAction.MenuRole = ...
    ApplicationSpecificRole: QAction.MenuRole = ...
    AboutQtRole: QAction.MenuRole = ...
    AboutRole: QAction.MenuRole = ...
    PreferencesRole: QAction.MenuRole = ...
    QuitRole: QAction.MenuRole = ...
    LowPriority: QAction.Priority = ...
    NormalPriority: QAction.Priority = ...
    HighPriority: QAction.Priority = ...

    class ActionEvent(Enum):
        Trigger: QAction.ActionEvent = ...
        Hover: QAction.ActionEvent = ...

    class MenuRole(Enum):
        NoRole: QAction.MenuRole = ...
        TextHeuristicRole: QAction.MenuRole = ...
        ApplicationSpecificRole: QAction.MenuRole = ...
        AboutQtRole: QAction.MenuRole = ...
        AboutRole: QAction.MenuRole = ...
        PreferencesRole: QAction.MenuRole = ...
        QuitRole: QAction.MenuRole = ...

    class Priority(Enum):
        LowPriority: QAction.Priority = ...
        NormalPriority: QAction.Priority = ...
        HighPriority: QAction.Priority = ...

    @overload
    def __init__(
        self,
        icon: Union[PySide6.QtGui.QIcon, PySide6.QtGui.QPixmap],
        text: str,
        parent: Optional[PySide6.QtCore.QObject] = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qaction.html#QAction

        **QAction::QAction(QObject * parent = nullptr)**

        Constructs an action with **parent**. If **parent** is an action group
        the action will be automatically inserted into the group.

        **Note:** The **parent** argument is optional since Qt 5.7.
        """
        ...

    @overload
    def __init__(self, parent: Optional[PySide6.QtCore.QObject] = ...) -> None:
        """
        https://doc.qt.io/qt-6/qaction.html#QAction-1

        **QAction::QAction(const QString & text , QObject * parent = nullptr)**

        Constructs an action with some **text** and **parent**. If **parent** is
        an action group the action will be automatically inserted into the
        group.

        The action uses a stripped version of **text** (e.g. "&Menu Option..."
        becomes "Menu Option") as descriptive text for tool buttons. You can
        override this by setting a specific description with **setText** (). The
        same text will be used for tooltips unless you specify a different text
        using **setToolTip** ().
        """
        ...

    @overload
    def __init__(
        self, text: str, parent: Optional[PySide6.QtCore.QObject] = ...
    ) -> None:
        """
        https://doc.qt.io/qt-6/qaction.html#QAction-2

        **QAction::QAction(const QIcon & icon , const QString & text , QObject *
        parent = nullptr)**

        Constructs an action with an **icon** and some **text** and **parent**.
        If **parent** is an action group the action will be automatically
        inserted into the group.

        The action uses a stripped version of **text** (e.g. "&Menu Option..."
        becomes "Menu Option") as descriptive text for tool buttons. You can
        override this by setting a specific description with **setText** (). The
        same text will be used for tooltips unless you specify a different text
        using **setToolTip** ().
        """
        ...

    def actionGroup(self) -> PySide6.QtGui.QActionGroup:
        """
        https://doc.qt.io/qt-6/qaction.html#actionGroup

        **QActionGroup *QAction::actionGroup() const**

        Returns the action group for this action. If no action group manages
        this action, then `nullptr` will be returned.

        **See also** **QActionGroup**  and **setActionGroup** ().
        """
        ...

    def activate(self, event: PySide6.QtGui.QAction.ActionEvent) -> None:
        """
        https://doc.qt.io/qt-6/qaction.html#activate

        **void QAction::activate(QAction::ActionEvent event )**

        Sends the relevant signals for **ActionEvent**  **event**.

        Action-based widgets use this API to cause the **QAction**  to emit
        signals as well as emitting their own.
        """
        ...

    def associatedObjects(self) -> List[PySide6.QtCore.QObject]:
        """
        https://doc.qt.io/qt-6/qaction.html#associatedObjects

        **[since 6.0] QList<QObject *> QAction::associatedObjects() const**

        Returns a list of objects this action has been added to.

        This function was introduced in Qt 6.0.

        **See also** **QWidget::addAction** () and
        **QGraphicsWidget::addAction** ().
        """
        ...

    def autoRepeat(self) -> bool:
        """
        https://doc.qt.io/qt-6/qaction.html#autoRepeat-prop

        **autoRepeat : bool**

        This property holds whether the action can auto repeat

        If true, the action will auto repeat when the keyboard shortcut
        combination is held down, provided that keyboard auto repeat is enabled
        on the system. The default value is true.

        **Access functions:**

        bool **autoRepeat** () const
        void **setAutoRepeat** (bool)

        **Notifier signal:**

        void ****changed** ** ()
        """
        ...

    def data(self) -> Any:
        """
        https://doc.qt.io/qt-6/qaction.html#data

        **QVariant QAction::data() const**

        Returns the user data as set in **QAction::setData** .

        **See also** **setData** ().
        """
        ...

    def event(self, arg__1: PySide6.QtCore.QEvent) -> bool:
        """
        https://doc.qt.io/qt-6/qaction.html#event

        **[override virtual protected] bool QAction::event(QEvent * e )**

        Reimplements: **QObject::event** (QEvent *e).
        """
        ...

    def font(self) -> PySide6.QtGui.QFont:
        """
        https://doc.qt.io/qt-6/qaction.html#font-prop

        **font : QFont**

        This property holds the action's font

        The font property is used to render the text set on the **QAction** .
        The font can be considered a hint as it will not be consulted in all
        cases based upon application and style.

        By default, this property contains the application's default font.

        **Access functions:**

        QFont **font** () const
        void **setFont** (const QFont & **font** )

        **Notifier signal:**

        void ****changed** ** ()

        **See also** **setText** ().
        """
        ...

    def hover(self) -> None:
        """
        https://doc.qt.io/qt-6/qaction.html#hover

        **[slot] void QAction::hover()**

        This is a convenience slot that calls activate(Hover).
        """
        ...

    def icon(self) -> PySide6.QtGui.QIcon:
        """
        https://doc.qt.io/qt-6/qaction.html#icon-prop

        **icon : QIcon**

        This property holds the action's icon

        In toolbars, the icon is used as the tool button icon; in menus, it is
        displayed to the left of the menu text. There is no default icon.

        If a null icon (**QIcon::isNull** ()) is passed into this function, the
        icon of the action is cleared.

        **Access functions:**

        QIcon **icon** () const
        void **setIcon** (const QIcon & **icon** )

        **Notifier signal:**

        void ****changed** ** ()
        """
        ...

    def iconText(self) -> str:
        """
        https://doc.qt.io/qt-6/qaction.html#iconText-prop

        **iconText : QString**

        This property holds the action's descriptive icon text

        If **QToolBar::toolButtonStyle**  is set to a value that permits text to
        be displayed, the text defined held in this property appears as a label
        in the relevant tool button.

        It also serves as the default text in menus and tooltips if the action
        has not been defined with **setText** () or **setToolTip** (), and will
        also be used in toolbar buttons if no icon has been defined using
        **setIcon** ().

        If the icon text is not explicitly set, the action's normal text will be
        used for the icon text.

        By default, this property contains an empty string.

        **Access functions:**

        QString **iconText** () const
        void **setIconText** (const QString &
        **text** )

        **Notifier signal:**

        void ****changed** ** ()

        **See also** **setToolTip** () and **setStatusTip** ().
        """
        ...

    def isCheckable(self) -> bool:
        ...

    def isChecked(self) -> bool:
        ...

    def isEnabled(self) -> bool:
        ...

    def isIconVisibleInMenu(self) -> bool:
        ...

    def isSeparator(self) -> bool:
        """
        https://doc.qt.io/qt-6/qaction.html#isSeparator

        **bool QAction::isSeparator() const**

        Returns `true` if this action is a separator action; otherwise it
        returns `false`.

        **See also** **setSeparator** ().
        """
        ...

    def isShortcutVisibleInContextMenu(self) -> bool:
        ...

    def isVisible(self) -> bool:
        ...

    def menuRole(self) -> PySide6.QtGui.QAction.MenuRole:
        """
        https://doc.qt.io/qt-6/qaction.html#menuRole-prop

        **menuRole : MenuRole**

        This property holds the action's menu role

        This indicates what role the action serves in the application menu on
        macOS. By default all actions have the **TextHeuristicRole** , which
        means that the action is added based on its text (see **QMenuBar**  for
        more information).

        The menu role can only be changed before the actions are put into the
        menu bar in macOS (usually just before the first application window is
        shown).

        **Access functions:**

        QAction::MenuRole **menuRole** () const
        void **setMenuRole**
        (QAction::MenuRole **menuRole** )

        **Notifier signal:**

        void ****changed** ** ()
        """
        ...

    def priority(self) -> PySide6.QtGui.QAction.Priority:
        """
        https://doc.qt.io/qt-6/qaction.html#priority-prop

        **priority : Priority**

        This property holds the actions's priority in the user interface.

        This property can be set to indicate how the action should be
        prioritized in the user interface.

        For instance, when toolbars have the **Qt::ToolButtonTextBesideIcon**
        mode set, then actions with **LowPriority**  will not show the text
        labels.

        **Access functions:**

        QAction::Priority **priority** () const
        void **setPriority**
        (QAction::Priority **priority** )
        """
        ...

    def resetEnabled(self) -> None:
        ...

    def setActionGroup(self, group: PySide6.QtGui.QActionGroup) -> None:
        """
        https://doc.qt.io/qt-6/qaction.html#setActionGroup

        **void QAction::setActionGroup(QActionGroup * group )**

        Sets this action group to **group**. The action will be automatically
        added to the group's list of actions.

        Actions within the group will be mutually exclusive.

        **See also** **QActionGroup**  and **actionGroup** ().
        """
        ...

    def setAutoRepeat(self, arg__1: bool) -> None:
        """
        https://doc.qt.io/qt-6/qaction.html#autoRepeat-prop

        **autoRepeat : bool**

        This property holds whether the action can auto repeat

        If true, the action will auto repeat when the keyboard shortcut
        combination is held down, provided that keyboard auto repeat is enabled
        on the system. The default value is true.

        **Access functions:**

        bool **autoRepeat** () const
        void **setAutoRepeat** (bool)

        **Notifier signal:**

        void ****changed** ** ()
        """
        ...

    def setCheckable(self, arg__1: bool) -> None:
        """
        https://doc.qt.io/qt-6/qaction.html#checkable-prop

        **checkable : bool**

        This property holds whether the action is a checkable action

        A checkable action is one which has an on/off state. For example, in a
        word processor, a Bold toolbar button may be either on or off. An action
        which is not a toggle action is a command action; a command action is
        simply executed, e.g. file save. By default, this property is `false`.

        In some situations, the state of one toggle action should depend on the
        state of others. For example, "Left Align", "Center" and "Right Align"
        toggle actions are mutually exclusive. To achieve exclusive toggling,
        add the relevant toggle actions to a **QActionGroup**  with the
        QActionGroup::exclusive property set to true.

        **Access functions:**

        bool **isCheckable** () const
        void **setCheckable** (bool)

        **Notifier signal:**

        void **checkableChanged** (bool **checkable** )

        **See also** **setChecked** ().
        """
        ...

    def setChecked(self, arg__1: bool) -> None:
        """
        https://doc.qt.io/qt-6/qaction.html#checked-prop

        **checked : bool**

        This property holds whether the action is checked.

        Only checkable actions can be checked. By default, this is false (the
        action is unchecked).

        **Note:** The notifier signal for this property is **toggled** (). As
        toggling a **QAction**  changes its state, it will also emit a
        **changed** () signal.

        **Access functions:**

        bool **isChecked** () const
        void **setChecked** (bool)

        **Notifier signal:**

        void ****toggled** ** (bool **checked** )

        **See also** **checkable**  and **toggled** ().
        """
        ...

    def setData(self, var: Any) -> None:
        """
        https://doc.qt.io/qt-6/qaction.html#setData

        **void QAction::setData(const QVariant & data )**

        Sets the action's internal data to the given **data**.

        **See also** **data** ().
        """
        ...

    def setDisabled(self, b: bool) -> None:
        """
        https://doc.qt.io/qt-6/qaction.html#setDisabled

        **[slot] void QAction::setDisabled(bool b )**

        This is a convenience function for the **enabled**  property, that is
        useful for signals--slots connections. If **b** is true the action is
        disabled; otherwise it is enabled.
        """
        ...

    def setEnabled(self, arg__1: bool) -> None:
        """
        https://doc.qt.io/qt-6/qaction.html#enabled-prop

        **enabled : bool**

        This property holds whether the action is enabled

        Disabled actions cannot be chosen by the user. They do not disappear
        from menus or toolbars, but they are displayed in a way which indicates
        that they are unavailable. For example, they might be displayed using
        only shades of gray.

        **What's This?** help on disabled actions is still available, provided
        that the **QAction::whatsThis**  property is set.

        An action will be disabled when all widgets to which it is added (with
        **QWidget::addAction** ()) are disabled or not visible. When an action
        is disabled, it is not possible to trigger it through its shortcut.

        By default, this property is `true` (actions are enabled).

        **Access functions:**

        bool **isEnabled** () const
        void **setEnabled** (bool)
        void
        **resetEnabled** ()

        **Notifier signal:**

        void **enabledChanged** (bool **enabled** )

        **See also** **text** .
        """
        ...

    def setFont(self, font: Union[PySide6.QtGui.QFont, str, Sequence[str]]) -> None:
        """
        https://doc.qt.io/qt-6/qaction.html#font-prop

        **font : QFont**

        This property holds the action's font

        The font property is used to render the text set on the **QAction** .
        The font can be considered a hint as it will not be consulted in all
        cases based upon application and style.

        By default, this property contains the application's default font.

        **Access functions:**

        QFont **font** () const
        void **setFont** (const QFont & **font** )

        **Notifier signal:**

        void ****changed** ** ()

        **See also** **setText** ().
        """
        ...

    def setIcon(self, icon: Union[PySide6.QtGui.QIcon, PySide6.QtGui.QPixmap]) -> None:
        """
        https://doc.qt.io/qt-6/qaction.html#icon-prop

        **icon : QIcon**

        This property holds the action's icon

        In toolbars, the icon is used as the tool button icon; in menus, it is
        displayed to the left of the menu text. There is no default icon.

        If a null icon (**QIcon::isNull** ()) is passed into this function, the
        icon of the action is cleared.

        **Access functions:**

        QIcon **icon** () const
        void **setIcon** (const QIcon & **icon** )

        **Notifier signal:**

        void ****changed** ** ()
        """
        ...

    def setIconText(self, text: str) -> None:
        """
        https://doc.qt.io/qt-6/qaction.html#iconText-prop

        **iconText : QString**

        This property holds the action's descriptive icon text

        If **QToolBar::toolButtonStyle**  is set to a value that permits text to
        be displayed, the text defined held in this property appears as a label
        in the relevant tool button.

        It also serves as the default text in menus and tooltips if the action
        has not been defined with **setText** () or **setToolTip** (), and will
        also be used in toolbar buttons if no icon has been defined using
        **setIcon** ().

        If the icon text is not explicitly set, the action's normal text will be
        used for the icon text.

        By default, this property contains an empty string.

        **Access functions:**

        QString **iconText** () const
        void **setIconText** (const QString &
        **text** )

        **Notifier signal:**

        void ****changed** ** ()

        **See also** **setToolTip** () and **setStatusTip** ().
        """
        ...

    def setIconVisibleInMenu(self, visible: bool) -> None:
        """
        https://doc.qt.io/qt-6/qaction.html#iconVisibleInMenu-prop

        **iconVisibleInMenu : bool**

        This property holds whether or not an action should show an icon in a
        menu

        In some applications, it may make sense to have actions with icons in
        the toolbar, but not in menus. If true, the icon (if valid) is shown in
        the menu, when it is false, it is not shown.

        The default is to follow whether the **Qt::AA_DontShowIconsInMenus**
        attribute is set for the application. Explicitly settings this property
        overrides the presence (or absence) of the attribute.

        For example:

        **QApplication**  app(argc, argv);
        app.setAttribute(Qt::AA_DontShowIconsInMenus);  // Icons are *no longer
        shown* in menus
            // ...
            **QAction**  *myAction = new **QAction**
        ();
            // ...
            myAction->setIcon(SomeIcon);
        myAction->setIconVisibleInMenu(true);   // Icon *will* be shown in menus
        for *this* action.

        **Access functions:**

        bool **isIconVisibleInMenu** () const
        void **setIconVisibleInMenu**
        (bool **visible** )

        **Notifier signal:**

        void ****changed** ** ()

        **See also** **icon**  and **QCoreApplication::setAttribute** ().
        """
        ...

    def setMenuRole(self, menuRole: PySide6.QtGui.QAction.MenuRole) -> None:
        """
        https://doc.qt.io/qt-6/qaction.html#menuRole-prop

        **menuRole : MenuRole**

        This property holds the action's menu role

        This indicates what role the action serves in the application menu on
        macOS. By default all actions have the **TextHeuristicRole** , which
        means that the action is added based on its text (see **QMenuBar**  for
        more information).

        The menu role can only be changed before the actions are put into the
        menu bar in macOS (usually just before the first application window is
        shown).

        **Access functions:**

        QAction::MenuRole **menuRole** () const
        void **setMenuRole**
        (QAction::MenuRole **menuRole** )

        **Notifier signal:**

        void ****changed** ** ()
        """
        ...

    def setPriority(self, priority: PySide6.QtGui.QAction.Priority) -> None:
        """
        https://doc.qt.io/qt-6/qaction.html#priority-prop

        **priority : Priority**

        This property holds the actions's priority in the user interface.

        This property can be set to indicate how the action should be
        prioritized in the user interface.

        For instance, when toolbars have the **Qt::ToolButtonTextBesideIcon**
        mode set, then actions with **LowPriority**  will not show the text
        labels.

        **Access functions:**

        QAction::Priority **priority** () const
        void **setPriority**
        (QAction::Priority **priority** )
        """
        ...

    def setSeparator(self, b: bool) -> None:
        """
        https://doc.qt.io/qt-6/qaction.html#setSeparator

        **void QAction::setSeparator(bool b )**

        If **b** is true then this action will be considered a separator.

        How a separator is represented depends on the widget it is inserted
        into. Under most circumstances the text, submenu, and icon will be
        ignored for separator actions.

        **See also** **isSeparator** ().
        """
        ...

    @overload
    def setShortcut(self, arg__1: PySide6.QtCore.Qt.Key) -> None:
        """
        https://doc.qt.io/qt-6/qaction.html#setShortcut

        **void QAction::setShortcut(const QKeySequence & shortcut )**

        Sets **shortcut** as the sole shortcut that triggers the action.

        **Note:** Setter function for property **shortcut** .

        **See also** **shortcut**  and **setShortcuts** ().
        """
        ...

    @overload
    def setShortcut(
        self,
        shortcut: Union[
            PySide6.QtGui.QKeySequence,
            PySide6.QtCore.QKeyCombination,
            PySide6.QtGui.QKeySequence.StandardKey,
            str,
            int,
        ],
    ) -> None:
        """
        https://doc.qt.io/qt-6/qaction.html#shortcut

        **QKeySequence QAction::shortcut() const**

        Returns the primary shortcut.

        **Note:** Getter function for property shortcut.

        **See also** **setShortcuts** ().
        """
        ...

    def setShortcutContext(self, context: PySide6.QtCore.Qt.ShortcutContext) -> None:
        """
        https://doc.qt.io/qt-6/qaction.html#shortcutContext-prop

        **shortcutContext : Qt::ShortcutContext**

        This property holds the context for the action's shortcut

        Valid values for this property can be found in **Qt::ShortcutContext** .
        The default value is **Qt::WindowShortcut** .

        **Access functions:**

        Qt::ShortcutContext **shortcutContext** () const
        void
        **setShortcutContext** (Qt::ShortcutContext **context** )

        **Notifier signal:**

        void ****changed** ** ()
        """
        ...

    def setShortcutVisibleInContextMenu(self, show: bool) -> None:
        """
        https://doc.qt.io/qt-6/qaction.html#shortcutVisibleInContextMenu-prop

        **shortcutVisibleInContextMenu : bool**

        This property holds whether or not an action should show a shortcut in a
        context menu

        In some applications, it may make sense to have actions with shortcuts
        in context menus. If true, the shortcut (if valid) is shown when the
        action is shown via a context menu, when it is false, it is not shown.

        The default is to follow whether the
        **Qt::AA_DontShowShortcutsInContextMenus**  attribute is set for the
        application. Explicitly setting this property overrides the attribute.

        **Access functions:**

        bool **isShortcutVisibleInContextMenu** () const
        void
        **setShortcutVisibleInContextMenu** (bool **show** )

        **Notifier signal:**

        void ****changed** ** ()

        **See also** **shortcut**  and **QCoreApplication::setAttribute** ().
        """
        ...

    @overload
    def setShortcuts(self, arg__1: PySide6.QtGui.QKeySequence.StandardKey) -> None:
        """
        https://doc.qt.io/qt-6/qaction.html#setShortcuts

        **void QAction::setShortcuts(const QList<QKeySequence> & shortcuts )**

        Sets **shortcuts** as the list of shortcuts that trigger the action. The
        first element of the list is the primary shortcut.

        **See also** **shortcuts** (), **shortcut** , and **setShortcut** ().
        """
        ...

    @overload
    def setShortcuts(self, shortcuts: Sequence[PySide6.QtGui.QKeySequence]) -> None:
        """
        https://doc.qt.io/qt-6/qaction.html#setShortcuts-1

        **void QAction::setShortcuts(QKeySequence::StandardKey key )**

        Sets a platform dependent list of shortcuts based on the **key**. The
        result of calling this function will depend on the currently running
        platform. Note that more than one shortcut can assigned by this action.
        If only the primary shortcut is required, use **setShortcut**  instead.

        **See also** **QKeySequence::keyBindings** ().
        """
        ...

    def setStatusTip(self, statusTip: str) -> None:
        """
        https://doc.qt.io/qt-6/qaction.html#statusTip-prop

        **statusTip : QString**

        This property holds the action's status tip

        The status tip is displayed on all status bars provided by the action's
        top-level parent widget.

        By default, this property contains an empty string.

        **Access functions:**

        QString **statusTip** () const
        void **setStatusTip** (const QString &
        **statusTip** )

        **Notifier signal:**

        void ****changed** ** ()

        **See also** **setToolTip** () and **showStatusText** ().
        """
        ...

    def setText(self, text: str) -> None:
        """
        https://doc.qt.io/qt-6/qaction.html#text-prop

        **text : QString**

        This property holds the action's descriptive text

        If the action is added to a menu, the menu option will consist of the
        icon (if there is one), the text, and the shortcut (if there is one). If
        the text is not explicitly set in the constructor, or by using
        setText(), the action's description icon text will be used as text.
        There is no default text.

        **Access functions:**

        QString **text** () const
        void **setText** (const QString & **text** )

        **Notifier signal:**

        void ****changed** ** ()

        **See also** **iconText** .
        """
        ...

    def setToolTip(self, tip: str) -> None:
        """
        https://doc.qt.io/qt-6/qaction.html#toolTip-prop

        **toolTip : QString**

        This property holds the action's tooltip

        This text is used for the tooltip. If no tooltip is specified, the
        action's text is used.

        By default, this property contains the action's text.

        **Access functions:**

        QString **toolTip** () const
        void **setToolTip** (const QString &
        **tip** )

        **Notifier signal:**

        void ****changed** ** ()

        **See also** **setStatusTip** () and **setShortcut** ().
        """
        ...

    def setVisible(self, arg__1: bool) -> None:
        """
        https://doc.qt.io/qt-6/qaction.html#visible-prop

        **visible : bool**

        This property holds whether the action can be seen (e.g. in menus and
        toolbars)

        If **visible** is true the action can be seen (e.g. in menus and
        toolbars) and chosen by the user; if **visible** is false the action
        cannot be seen or chosen by the user.

        Actions which are not visible are **not** grayed out; they do not appear
        at all.

        By default, this property is `true` (actions are visible).

        **Access functions:**

        bool **isVisible** () const
        void **setVisible** (bool)

        **Notifier signal:**

        void **visibleChanged** ()
        """
        ...

    def setWhatsThis(self, what: str) -> None:
        """
        https://doc.qt.io/qt-6/qaction.html#whatsThis-prop

        **whatsThis : QString**

        This property holds the action's "What's This?" help text

        The "What's This?" text is used to provide a brief description of the
        action. The text may contain rich text. There is no default "What's
        This?" text.

        **Access functions:**

        QString **whatsThis** () const
        void **setWhatsThis** (const QString &
        **what** )

        **Notifier signal:**

        void ****changed** ** ()

        **See also** **QWhatsThis** .

        **Member Function Documentation**
        """
        ...

    def shortcut(self) -> PySide6.QtGui.QKeySequence:
        """
        https://doc.qt.io/qt-6/qaction.html#shortcut-prop

        **shortcut : QKeySequence**

        This property holds the action's primary shortcut key

        Valid keycodes for this property can be found in **Qt::Key**  and
        **Qt::Modifier** . There is no default shortcut key.

        **Access functions:**

        QKeySequence ****shortcut** ** () const
        void ****setShortcut** **
        (const QKeySequence & **shortcut** )

        **Notifier signal:**

        void ****changed** ** ()
        """
        ...

    def shortcutContext(self) -> PySide6.QtCore.Qt.ShortcutContext:
        """
        https://doc.qt.io/qt-6/qaction.html#shortcutContext-prop

        **shortcutContext : Qt::ShortcutContext**

        This property holds the context for the action's shortcut

        Valid values for this property can be found in **Qt::ShortcutContext** .
        The default value is **Qt::WindowShortcut** .

        **Access functions:**

        Qt::ShortcutContext **shortcutContext** () const
        void
        **setShortcutContext** (Qt::ShortcutContext **context** )

        **Notifier signal:**

        void ****changed** ** ()
        """
        ...

    def shortcuts(self) -> List[PySide6.QtGui.QKeySequence]:
        """
        https://doc.qt.io/qt-6/qaction.html#shortcuts

        **QList<QKeySequence> QAction::shortcuts() const**

        Returns the list of shortcuts, with the primary shortcut as the first
        element of the list.

        **See also** **setShortcuts** ().
        """
        ...

    def showStatusText(self, object: Optional[PySide6.QtCore.QObject] = ...) -> bool:
        """
        https://doc.qt.io/qt-6/qaction.html#showStatusText

        **bool QAction::showStatusText(QObject * object = nullptr)**

        Updates the relevant status bar for the UI represented by **object** by
        sending a **QStatusTipEvent** . Returns `true` if an event was sent,
        otherwise returns `false`.

        If a null widget is specified, the event is sent to the action's parent.

        **See also** **statusTip** .
        """
        ...

    def statusTip(self) -> str:
        """
        https://doc.qt.io/qt-6/qaction.html#statusTip-prop

        **statusTip : QString**

        This property holds the action's status tip

        The status tip is displayed on all status bars provided by the action's
        top-level parent widget.

        By default, this property contains an empty string.

        **Access functions:**

        QString **statusTip** () const
        void **setStatusTip** (const QString &
        **statusTip** )

        **Notifier signal:**

        void ****changed** ** ()

        **See also** **setToolTip** () and **showStatusText** ().
        """
        ...

    def text(self) -> str:
        """
        https://doc.qt.io/qt-6/qaction.html#text-prop

        **text : QString**

        This property holds the action's descriptive text

        If the action is added to a menu, the menu option will consist of the
        icon (if there is one), the text, and the shortcut (if there is one). If
        the text is not explicitly set in the constructor, or by using
        setText(), the action's description icon text will be used as text.
        There is no default text.

        **Access functions:**

        QString **text** () const
        void **setText** (const QString & **text** )

        **Notifier signal:**

        void ****changed** ** ()

        **See also** **iconText** .
        """
        ...

    def toggle(self) -> None:
        """
        https://doc.qt.io/qt-6/qaction.html#toggle

        **[slot] void QAction::toggle()**

        This is a convenience function for the **checked**  property. Connect to
        it to change the checked state to its opposite state.
        """
        ...

    def toolTip(self) -> str:
        """
        https://doc.qt.io/qt-6/qaction.html#toolTip-prop

        **toolTip : QString**

        This property holds the action's tooltip

        This text is used for the tooltip. If no tooltip is specified, the
        action's text is used.

        By default, this property contains the action's text.

        **Access functions:**

        QString **toolTip** () const
        void **setToolTip** (const QString &
        **tip** )

        **Notifier signal:**

        void ****changed** ** ()

        **See also** **setStatusTip** () and **setShortcut** ().
        """
        ...

    def trigger(self) -> None:
        """
        https://doc.qt.io/qt-6/qaction.html#trigger

        **[slot] void QAction::trigger()**

        This is a convenience slot that calls activate(Trigger).
        """
        ...

    def whatsThis(self) -> str:
        """
        https://doc.qt.io/qt-6/qaction.html#whatsThis-prop

        **whatsThis : QString**

        This property holds the action's "What's This?" help text

        The "What's This?" text is used to provide a brief description of the
        action. The text may contain rich text. There is no default "What's
        This?" text.

        **Access functions:**

        QString **whatsThis** () const
        void **setWhatsThis** (const QString &
        **what** )

        **Notifier signal:**

        void ****changed** ** ()

        **See also** **QWhatsThis** .

        **Member Function Documentation**
        """
        ...

    @property
    def changed(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qaction.html#changed

        **[signal] void QAction::changed()**

        This signal is emitted when an action has changed. If you are only
        interested in actions in a given widget, you can watch for
        **QWidget::actionEvent** () sent with an **QEvent::ActionChanged** .

        **Note:** Notifier signal for property **autoRepeat** . Notifier signal
        for property **font** . Notifier signal for property **icon** . Notifier
        signal for property **iconText** . Notifier signal for property
        **iconVisibleInMenu** . Notifier signal for property **menuRole** .
        Notifier signal for property **shortcut** . Notifier signal for property
        **shortcutContext** . Notifier signal for property
        **shortcutVisibleInContextMenu** . Notifier signal for property
        **statusTip** . Notifier signal for property **text** . Notifier signal
        for property **toolTip** . Notifier signal for property **whatsThis** .

        **See also** **QWidget::actionEvent** ().
        """
        ...

    @property
    def checkableChanged(self) -> PySide6.QtCore.SignalInstance:
        ...

    @property
    def enabledChanged(self) -> PySide6.QtCore.SignalInstance:
        ...

    @property
    def hovered(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qaction.html#hovered

        **[signal] void QAction::hovered()**

        This signal is emitted when an action is highlighted by the user; for
        example, when the user pauses with the cursor over a menu option,
        toolbar button, or presses an action's shortcut key combination.

        **See also** **activate** ().
        """
        ...

    @property
    def toggled(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qaction.html#toggled

        **[signal] void QAction::toggled(bool checked )**

        This signal is emitted whenever a checkable action changes its
        **isChecked** () status. This can be the result of a user interaction,
        or because **setChecked** () was called. As **setChecked** () changes
        the **QAction** , it emits **changed** () in addition to toggled().

        **checked** is true if the action is checked, or false if the action is
        unchecked.

        **Note:** Notifier signal for property **checked** .

        **See also** **activate** (), **triggered** (), and **checked** .
        """
        ...

    @property
    def triggered(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qaction.html#triggered

        **[signal] void QAction::triggered(bool checked = false)**

        This signal is emitted when an action is activated by the user; for
        example, when the user clicks a menu option, toolbar button, or presses
        an action's shortcut key combination, or when **trigger** () was called.
        Notably, it is **not** emitted when **setChecked** () or **toggle** ()
        is called.

        If the action is checkable, **checked** is true if the action is
        checked, or false if the action is unchecked.

        **See also** **activate** (), **toggled** (), and **checked** .
        """
        ...

    @property
    def visibleChanged(self) -> PySide6.QtCore.SignalInstance:
        ...
