"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtGui, except for defaults which are replaced by "...".
"""
bytes = str


class QAccessibleEditableTextInterface(object):
    """
    https://doc.qt.io/qt-6/qaccessibleeditabletextinterface.html

    **Detailed Description**

    When implementing this interface you will almost certainly also want to
    implement **QAccessibleTextInterface** .

    **IAccessible2 Specification**

    **See also** **QAccessibleInterface** .
    """

    def __init__(self) -> None:
        ...

    def deleteText(self, startOffset: int, endOffset: int) -> None:
        """
        https://doc.qt.io/qt-6/qaccessibleeditabletextinterface.html#deleteText

        **[pure virtual] void QAccessibleEditableTextInterface::deleteText(int
        startOffset , int endOffset )**

        Deletes the text from **startOffset** to **endOffset**.
        """
        ...

    def insertText(self, offset: int, text: str) -> None:
        """
        https://doc.qt.io/qt-6/qaccessibleeditabletextinterface.html#insertText

        **[pure virtual] void QAccessibleEditableTextInterface::insertText(int
        offset , const QString & text )**

        Inserts **text** at position **offset**.
        """
        ...

    def replaceText(self, startOffset: int, endOffset: int, text: str) -> None:
        """
        https://doc.qt.io/qt-6/qaccessibleeditabletextinterface.html#replaceText

        **[pure virtual] void QAccessibleEditableTextInterface::replaceText(int
        startOffset , int endOffset , const QString & text )**

        Removes the text from **startOffset** to **endOffset** and instead
        inserts **text**.
        """
        ...
