"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtDesigner, except for defaults which are replaced by "...".
"""
from typing import Any

bytes = str


class QDesignerDynamicPropertySheetExtension(object):
    """
    https://doc.qt.io/qt-6/qdesignerdynamicpropertysheetextension.html

    **Detailed Description**

    **See also** **QDesignerPropertySheetExtension**  and **Dynamic Properties**
    .
    """

    def __init__(self) -> None:
        ...

    def addDynamicProperty(self, propertyName: str, value: Any) -> int:
        """
        https://doc.qt.io/qt-6/qdesignerdynamicpropertysheetextension.html#addDy
        namicProperty

        **[pure virtual] int
        QDesignerDynamicPropertySheetExtension::addDynamicProperty(const QString
        & propertyName , const QVariant & value )**

        Adds a dynamic property named **propertyName** and sets its value to
        **value**. Returns the index of the property if it was added
        successfully; otherwise returns -1 to indicate failure.
        """
        ...

    def canAddDynamicProperty(self, propertyName: str) -> bool:
        """
        https://doc.qt.io/qt-6/qdesignerdynamicpropertysheetextension.html#canAd
        dDynamicProperty

        **[pure virtual] bool
        QDesignerDynamicPropertySheetExtension::canAddDynamicProperty(const
        QString & propertyName ) const**

        Returns true if **propertyName** is a valid, unique name for a dynamic
        property; otherwise returns false.
        """
        ...

    def dynamicPropertiesAllowed(self) -> bool:
        """
        https://doc.qt.io/qt-6/qdesignerdynamicpropertysheetextension.html#dynam
        icPropertiesAllowed

        **[pure virtual] bool
        QDesignerDynamicPropertySheetExtension::dynamicPropertiesAllowed()
        const**

        Returns true if the widget supports dynamic properties; otherwise
        returns false.
        """
        ...

    def isDynamicProperty(self, index: int) -> bool:
        """
        https://doc.qt.io/qt-6/qdesignerdynamicpropertysheetextension.html#isDyn
        amicProperty

        **[pure virtual] bool
        QDesignerDynamicPropertySheetExtension::isDynamicProperty(int index )
        const**

        Returns true if the property at the given **index** is a dynamic
        property; otherwise returns false.
        """
        ...

    def removeDynamicProperty(self, index: int) -> bool:
        """
        https://doc.qt.io/qt-6/qdesignerdynamicpropertysheetextension.html#remov
        eDynamicProperty

        **[pure virtual] bool
        QDesignerDynamicPropertySheetExtension::removeDynamicProperty(int index
        )**

        Removes the dynamic property at the given **index**. Returns true if the
        operation succeeds; otherwise returns false.
        """
        ...
