"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtDesigner, except for defaults which are replaced by "...".
"""
from typing import Any, Optional, Union
import PySide6.QtCore
import PySide6.QtGui
import PySide6.QtWidgets
import PySide6.QtDesigner

bytes = str


class QAbstractFormBuilder(object):
    """
    https://doc.qt.io/qt-6/qabstractformbuilder.html

    **Detailed Description**

    QAbstractFormBuilder provides a standard interface and a default
    implementation for constructing forms from user interface files. It is not
    intended to be instantiated directly. Use the **QFormBuilder**  class to
    create user interfaces from UI files at run-time. For example:

    MyForm::MyForm(**QWidget**  *parent)
                    : **QWidget** (parent)
    {
                    **QFormBuilder**  builder;
                    **QFile**
    file(":/forms/myWidget.ui");
                    file.open(**QFile**
    ::ReadOnly);
                    **QWidget**  *myWidget = builder.load(&file,
    this);
                    file.close();

                    **QVBoxLayout**
    *layout = new **QVBoxLayout** ;
                    layout->addWidget(myWidget);
    setLayout(layout);
                }

    To override certain aspects of the form builder's behavior, subclass
    QAbstractFormBuilder and reimplement the relevant virtual functions:

    * **load** () handles reading of UI format files from arbitrary QIODevices,
    and construction of widgets from the XML data that they contain.
      *
    **save** () handles saving of widget details in UI format to arbitrary
    QIODevices.
      * **workingDirectory** () and **setWorkingDirectory** ()
    control the directory in which forms are held. The form builder looks for
    other resources on paths relative to this directory.

    The **QFormBuilder**  class is typically used by custom components and
    applications that embed **Qt Designer**. Standalone applications that need
    to dynamically generate user interfaces at run-time use the **QUiLoader** ,
    found in the **Qt UI Tools**  module.

    **See also** **Qt UI Tools** .
    """

    def __init__(self) -> None:
        """
        https://doc.qt.io/qt-6/qabstractformbuilder.html#QAbstractFormBuilder-2

        **QAbstractFormBuilder::QAbstractFormBuilder()**

        Constructs a new form builder.
        """
        ...

    def addMenuAction(self, action: PySide6.QtGui.QAction) -> None:
        ...

    def applyPropertyInternally(
        self, o: PySide6.QtCore.QObject, propertyName: str, value: Any
    ) -> bool:
        ...

    def checkProperty(self, obj: PySide6.QtCore.QObject, prop: str) -> bool:
        ...

    def createAction(
        self, parent: PySide6.QtCore.QObject, name: str
    ) -> PySide6.QtGui.QAction:
        ...

    def createActionGroup(
        self, parent: PySide6.QtCore.QObject, name: str
    ) -> PySide6.QtGui.QActionGroup:
        ...

    def createLayout(
        self, layoutName: str, parent: PySide6.QtCore.QObject, name: str
    ) -> PySide6.QtWidgets.QLayout:
        ...

    def createWidget(
        self, widgetName: str, parentWidget: PySide6.QtWidgets.QWidget, name: str
    ) -> PySide6.QtWidgets.QWidget:
        ...

    def errorString(self) -> str:
        """
        https://doc.qt.io/qt-6/qabstractformbuilder.html#errorString

        **[since 5.0] QString QAbstractFormBuilder::errorString() const**

        Returns a human-readable description of the last error occurred in
        **load** ().

        This function was introduced in Qt 5.0.

        **See also** **load** ().
        """
        ...

    def load(
        self,
        dev: PySide6.QtCore.QIODevice,
        parentWidget: Optional[PySide6.QtWidgets.QWidget] = ...,
    ) -> PySide6.QtWidgets.QWidget:
        """
        https://doc.qt.io/qt-6/qabstractformbuilder.html#load

        **[virtual] QWidget *QAbstractFormBuilder::load(QIODevice * device ,
        QWidget * parent = nullptr)**

        Loads an XML representation of a widget from the given **device** , and
        constructs a new widget with the specified **parent**.

        **See also** **save** () and **errorString** ().
        """
        ...

    def reset(self) -> None:
        ...

    def save(
        self, dev: PySide6.QtCore.QIODevice, widget: PySide6.QtWidgets.QWidget
    ) -> None:
        """
        https://doc.qt.io/qt-6/qabstractformbuilder.html#save

        **[virtual] void QAbstractFormBuilder::save(QIODevice * device , QWidget
        * widget )**

        Saves an XML representation of the given **widget** to the specified
        **device** in the standard UI file format.

        **Note:** Unlike when saving a form in Qt Designer, all property values
        are written. This is because, the state of whether a property value was
        modified or not isn't stored in the Qt property system. The widget that
        is being saved, could have been created dynamically, not loaded via
        **load** (), so in this case the form builder isn't aware of the list of
        changed properties. Also, there's no generic way to do this for widgets
        that were created dynamically.

        Therefore, you should remove properties that are not required from your
        resulting XML files, before loading them. Alternatively, if you already
        know which properties you want to save when you call this method, you
        can overload `computeProperties()` and return a filtered list of
        required properties. Otherwise, unexpected behavior may occur as some of
        these properties may depend on each other.

        **See also** **load** ().
        """
        ...

    def setWorkingDirectory(self, directory: Union[PySide6.QtCore.QDir, str]) -> None:
        """
        https://doc.qt.io/qt-6/qabstractformbuilder.html#setWorkingDirectory

        **void QAbstractFormBuilder::setWorkingDirectory(const QDir & directory
        )**

        Sets the current working directory of the form builder to the specified
        **directory**.

        **See also** **workingDirectory** ().
        """
        ...

    @staticmethod
    def toolBarAreaMetaEnum() -> PySide6.QtCore.QMetaEnum:
        ...

    def workingDirectory(self) -> PySide6.QtCore.QDir:
        """
        https://doc.qt.io/qt-6/qabstractformbuilder.html#workingDirectory

        **QDir QAbstractFormBuilder::workingDirectory() const**

        Returns the current working directory of the form builder.

        **See also** **setWorkingDirectory** ().
        """
        ...
