"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtDataVisualization, except for defaults which are replaced by "...".
"""
from typing import Optional, overload
import PySide6.QtCore
import PySide6.QtGui
import PySide6.QtDataVisualization

bytes = str


class QScatter3DSeries(PySide6.QtDataVisualization.QAbstract3DSeries):
    """
    https://doc.qt.io/qt-6/qscatter3dseries.html

    **Detailed Description**

    This class manages the series specific visual elements, as well as the
    series data (via a data proxy).

    If no data proxy is set explicitly for the series, the series creates a
    default proxy. Setting another proxy will destroy the existing proxy and all
    data added to it.

    QScatter3DSeries supports the following format tags for
    **QAbstract3DSeries::setItemLabelFormat** ():

    @xTitleTitle from x-axis
    @yTitleTitle from y-axis
    @zTitleTitle from
    z-axis
    @xLabelItem value formatted using the format of the x-axis. For
    more information, see **QValue3DAxis::setLabelFormat** ().
    @yLabelItem
    value formatted using the format of the y-axis. For more information, see
    **QValue3DAxis::setLabelFormat** ().
    @zLabelItem value formatted using the
    format of the z-axis. For more information, see
    **QValue3DAxis::setLabelFormat** ().
    @seriesNameName of the series

    For example:

    proxy->setItemLabelFormat(**QStringLiteral** ("@valueTitle for (@rowLabel,
    @colLabel): %.1f"));

    **See also** **Qt Data Visualization Data Handling** .
    """

    @overload
    def __init__(
        self,
        dataProxy: PySide6.QtDataVisualization.QScatterDataProxy,
        parent: Optional[PySide6.QtCore.QObject] = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qscatter3dseries.html#QScatter3DSeries

        **QScatter3DSeries::QScatter3DSeries(QObject * parent = nullptr)**

        Constructs a scatter 3D series with the parent **parent**.
        """
        ...

    @overload
    def __init__(self, parent: Optional[PySide6.QtCore.QObject] = ...) -> None:
        """
        https://doc.qt.io/qt-6/qscatter3dseries.html#QScatter3DSeries-1

        **QScatter3DSeries::QScatter3DSeries(QScatterDataProxy * dataProxy ,
        QObject * parent = nullptr)**

        Constructs a scatter 3D series with the data proxy **dataProxy** and the
        parent **parent**.
        """
        ...

    def dataProxy(self) -> PySide6.QtDataVisualization.QScatterDataProxy:
        """
        https://doc.qt.io/qt-6/qscatter3dseries.html#dataProxy-prop

        **dataProxy : QScatterDataProxy***

        This property holds the active data proxy.

        **Access functions:**

        QScatterDataProxy * **dataProxy** () const
        void ****setDataProxy** **
        (QScatterDataProxy * **proxy** )

        **Notifier signal:**

        void **dataProxyChanged** (QScatterDataProxy * **proxy** )
        """
        ...

    @staticmethod
    def invalidSelectionIndex() -> int:
        """
        https://doc.qt.io/qt-6/qscatter3dseries.html#invalidSelectionIndex

        **[static] int QScatter3DSeries::invalidSelectionIndex()**

        Returns an invalid index for selection. This index is set to the
        **selectedItem**  property to clear the selection from this series.

        **See also** **QAbstract3DGraph::clearSelection** ().
        """
        ...

    def itemSize(self) -> float:
        """
        https://doc.qt.io/qt-6/qscatter3dseries.html#itemSize-prop

        **itemSize : float**

        Item size for the series.

        The size must be between `0.0f` and `1.0f`. Setting the size to `0.0f`
        causes the item size to be automatically scaled based on the total
        number of items in all the series for the graph.

        The preset default is `0.0f`.

        **Access functions:**

        float **itemSize** () const
        void **setItemSize** (float **size** )

        **Notifier signal:**

        void **itemSizeChanged** (float **size** )
        """
        ...

    def selectedItem(self) -> int:
        """
        https://doc.qt.io/qt-6/qscatter3dseries.html#selectedItem-prop

        **selectedItem : int**

        This property holds the item that is selected in the series.

        **Access functions:**

        int **selectedItem** () const
        void ****setSelectedItem** ** (int
        **index** )

        **Notifier signal:**

        void **selectedItemChanged** (int **index** )

        **Member Function Documentation**
        """
        ...

    def setDataProxy(
        self, proxy: PySide6.QtDataVisualization.QScatterDataProxy
    ) -> None:
        """
        https://doc.qt.io/qt-6/qscatter3dseries.html#setDataProxy

        **void QScatter3DSeries::setDataProxy(QScatterDataProxy * proxy )**

        Sets the active data proxy for the series to **proxy**. The series
        assumes ownership of any proxy set to it and deletes any previously set
        proxy when a new one is added. The **proxy** argument cannot be null or
        set to another series.

        **Note:** Setter function for property **dataProxy** .

        **See also** **dataProxy** ().
        """
        ...

    def setItemSize(self, size: float) -> None:
        """
        https://doc.qt.io/qt-6/qscatter3dseries.html#itemSize-prop

        **itemSize : float**

        Item size for the series.

        The size must be between `0.0f` and `1.0f`. Setting the size to `0.0f`
        causes the item size to be automatically scaled based on the total
        number of items in all the series for the graph.

        The preset default is `0.0f`.

        **Access functions:**

        float **itemSize** () const
        void **setItemSize** (float **size** )

        **Notifier signal:**

        void **itemSizeChanged** (float **size** )
        """
        ...

    def setSelectedItem(self, index: int) -> None:
        """
        https://doc.qt.io/qt-6/qscatter3dseries.html#setSelectedItem

        **void QScatter3DSeries::setSelectedItem(int index )**

        Selects the item at the index **index** in the data array of the series.
        Only one item can be selected at a time.

        To clear selection from this series, **invalidSelectionIndex** () is set
        as **index**. If this series is added to a graph, the graph can adjust
        the selection according to user interaction or if it becomes invalid.
        Selecting an item on another added series will also clear the selection.

        Removing items from or inserting items to the series before the selected
        item will adjust the selection so that the same item will stay selected.

        **Note:** Setter function for property **selectedItem** .

        **See also** **selectedItem** () and
        **QAbstract3DGraph::clearSelection** ().
        """
        ...

    @property
    def dataProxyChanged(self) -> PySide6.QtCore.SignalInstance:
        ...

    @property
    def itemSizeChanged(self) -> PySide6.QtCore.SignalInstance:
        ...

    @property
    def selectedItemChanged(self) -> PySide6.QtCore.SignalInstance:
        ...
