"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtDataVisualization, except for defaults which are replaced by "...".
"""
from typing import Optional, overload
import PySide6.QtCore
import PySide6.QtGui
import PySide6.QtDataVisualization

bytes = str


class QBar3DSeries(PySide6.QtDataVisualization.QAbstract3DSeries):
    """
    https://doc.qt.io/qt-6/qbar3dseries.html

    **Detailed Description**

    This class manages the series specific visual elements, as well as the
    series data (via a data proxy).

    If no data proxy is set explicitly for the series, the series creates a
    default proxy. Setting another proxy will destroy the existing proxy and all
    data added to it.

    QBar3DSeries supports the following format tags for
    **QAbstract3DSeries::setItemLabelFormat** ():

    @rowTitleTitle from row axis
    @colTitleTitle from column axis
    @valueTitleTitle from value axis
    @rowIdxVisible row index. Localized using
    the graph locale.
    @colIdxVisible column index. Localized using the graph
    locale.
    @rowLabelLabel from row axis
    @colLabelLabel from column axis
    @valueLabelItem value formatted using the format of the value axis attached
    to the graph. For more information, see **QValue3DAxis::labelFormat** .
    @seriesNameName of the series
    %<format spec>Item value in the specified
    format. Formatted using the same rules as **QValue3DAxis::labelFormat** .

    For example:

    proxy->setItemLabelFormat(**QStringLiteral** ("@valueTitle for (@rowLabel,
    @colLabel): %.1f"));

    **See also** **Qt Data Visualization Data Handling**  and
    **QAbstract3DGraph::locale** .
    """

    @overload
    def __init__(
        self,
        dataProxy: PySide6.QtDataVisualization.QBarDataProxy,
        parent: Optional[PySide6.QtCore.QObject] = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qbar3dseries.html#QBar3DSeries

        **QBar3DSeries::QBar3DSeries(QObject * parent = nullptr)**

        Constructsa bar 3D series with the parent **parent**.
        """
        ...

    @overload
    def __init__(self, parent: Optional[PySide6.QtCore.QObject] = ...) -> None:
        """
        https://doc.qt.io/qt-6/qbar3dseries.html#QBar3DSeries-1

        **QBar3DSeries::QBar3DSeries(QBarDataProxy * dataProxy , QObject *
        parent = nullptr)**

        Constructs a bar 3D series with the data proxy **dataProxy** and the
        parent **parent**.
        """
        ...

    def dataProxy(self) -> PySide6.QtDataVisualization.QBarDataProxy:
        """
        https://doc.qt.io/qt-6/qbar3dseries.html#dataProxy-prop

        **dataProxy : QBarDataProxy***

        This property holds the active data proxy.

        The series assumes ownership of any proxy set to it and deletes any
        previously set proxy when a new one is added. The proxy cannot be null
        or set to another series.

        **Access functions:**

        QBarDataProxy * **dataProxy** () const
        void **setDataProxy**
        (QBarDataProxy * **proxy** )

        **Notifier signal:**

        void **dataProxyChanged** (QBarDataProxy * **proxy** )
        """
        ...

    @staticmethod
    def invalidSelectionPosition() -> PySide6.QtCore.QPoint:
        """
        https://doc.qt.io/qt-6/qbar3dseries.html#invalidSelectionPosition

        **[static] QPoint QBar3DSeries::invalidSelectionPosition()**

        Returns an invalid position for selection. This position is set to the
        **selectedBar**  property to clear the selection from this series.

        **See also** **QAbstract3DGraph::clearSelection** ().
        """
        ...

    def meshAngle(self) -> float:
        """
        https://doc.qt.io/qt-6/qbar3dseries.html#meshAngle-prop

        **meshAngle : float**

        This property holds the series rotation angle in degrees.

        Setting this property is equivalent to the following call:

        setMeshRotation(**QQuaternion** ::fromAxisAndAngle(0.0f, 1.0f, 0.0f,
        angle))

        **Note:** When reading this property, it is calculated from the
        **QAbstract3DSeries::meshRotation**  value using floating point
        precision and always returns a value from zero to 360 degrees.

        **Access functions:**

        float **meshAngle** () const
        void **setMeshAngle** (float **angle** )

        **Notifier signal:**

        void **meshAngleChanged** (float **angle** )

        **See also** **QAbstract3DSeries::meshRotation** .
        """
        ...

    def selectedBar(self) -> PySide6.QtCore.QPoint:
        """
        https://doc.qt.io/qt-6/qbar3dseries.html#selectedBar-prop

        **selectedBar : QPoint**

        This property holds the bar in the series that is selected.

        **Access functions:**

        QPoint **selectedBar** () const
        void ****setSelectedBar** ** (const
        QPoint & **position** )

        **Notifier signal:**

        void **selectedBarChanged** (const QPoint & **position** )

        **Member Function Documentation**
        """
        ...

    def setDataProxy(self, proxy: PySide6.QtDataVisualization.QBarDataProxy) -> None:
        """
        https://doc.qt.io/qt-6/qbar3dseries.html#dataProxy-prop

        **dataProxy : QBarDataProxy***

        This property holds the active data proxy.

        The series assumes ownership of any proxy set to it and deletes any
        previously set proxy when a new one is added. The proxy cannot be null
        or set to another series.

        **Access functions:**

        QBarDataProxy * **dataProxy** () const
        void **setDataProxy**
        (QBarDataProxy * **proxy** )

        **Notifier signal:**

        void **dataProxyChanged** (QBarDataProxy * **proxy** )
        """
        ...

    def setMeshAngle(self, angle: float) -> None:
        """
        https://doc.qt.io/qt-6/qbar3dseries.html#meshAngle-prop

        **meshAngle : float**

        This property holds the series rotation angle in degrees.

        Setting this property is equivalent to the following call:

        setMeshRotation(**QQuaternion** ::fromAxisAndAngle(0.0f, 1.0f, 0.0f,
        angle))

        **Note:** When reading this property, it is calculated from the
        **QAbstract3DSeries::meshRotation**  value using floating point
        precision and always returns a value from zero to 360 degrees.

        **Access functions:**

        float **meshAngle** () const
        void **setMeshAngle** (float **angle** )

        **Notifier signal:**

        void **meshAngleChanged** (float **angle** )

        **See also** **QAbstract3DSeries::meshRotation** .
        """
        ...

    def setSelectedBar(self, position: PySide6.QtCore.QPoint) -> None:
        """
        https://doc.qt.io/qt-6/qbar3dseries.html#setSelectedBar

        **void QBar3DSeries::setSelectedBar(const QPoint & position )**

        Selects the bar at the **position** position, specified as a row and
        column in the data array of the series.

        Only one bar can be selected at a time.

        To clear selection from this series, **invalidSelectionPosition** () is
        set as **position**.

        If this series is added to a graph, the graph can adjust the selection
        according to user interaction or if it becomes invalid. Selecting a bar
        on another added series will also clear the selection.

        Removing rows from or inserting rows to the series before the row of the
        selected bar will adjust the selection so that the same bar will stay
        selected.

        **Note:** Setter function for property **selectedBar** .

        **See also** **selectedBar** () and **QAbstract3DGraph::clearSelection**
        ().
        """
        ...

    @property
    def dataProxyChanged(self) -> PySide6.QtCore.SignalInstance:
        ...

    @property
    def meshAngleChanged(self) -> PySide6.QtCore.SignalInstance:
        ...

    @property
    def selectedBarChanged(self) -> PySide6.QtCore.SignalInstance:
        ...
