"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtDataVisualization, except for defaults which are replaced by "...".
"""
from enum import Enum
from typing import Any, Union
import PySide6.QtCore
import PySide6.QtGui
import PySide6.QtDataVisualization

bytes = str


class QAbstract3DSeries(PySide6.QtCore.QObject):
    """
    https://doc.qt.io/qt-6/qabstract3dseries.html

    **Detailed Description**

    There are inherited classes for each supported series type: **QBar3DSeries**
    , **QScatter3DSeries** , and **QSurface3DSeries** .

    For more information, see **Qt Data Visualization Data Handling** .
    """

    MeshUserDefined: QAbstract3DSeries.Mesh = ...
    MeshBar: QAbstract3DSeries.Mesh = ...
    MeshCube: QAbstract3DSeries.Mesh = ...
    MeshPyramid: QAbstract3DSeries.Mesh = ...
    MeshCone: QAbstract3DSeries.Mesh = ...
    MeshCylinder: QAbstract3DSeries.Mesh = ...
    MeshBevelBar: QAbstract3DSeries.Mesh = ...
    MeshBevelCube: QAbstract3DSeries.Mesh = ...
    MeshSphere: QAbstract3DSeries.Mesh = ...
    MeshMinimal: QAbstract3DSeries.Mesh = ...
    MeshArrow: QAbstract3DSeries.Mesh = ...
    MeshPoint: QAbstract3DSeries.Mesh = ...
    SeriesTypeNone: QAbstract3DSeries.SeriesType = ...
    SeriesTypeBar: QAbstract3DSeries.SeriesType = ...
    SeriesTypeScatter: QAbstract3DSeries.SeriesType = ...
    SeriesTypeSurface: QAbstract3DSeries.SeriesType = ...

    class Mesh(Enum):
        MeshUserDefined: QAbstract3DSeries.Mesh = ...
        MeshBar: QAbstract3DSeries.Mesh = ...
        MeshCube: QAbstract3DSeries.Mesh = ...
        MeshPyramid: QAbstract3DSeries.Mesh = ...
        MeshCone: QAbstract3DSeries.Mesh = ...
        MeshCylinder: QAbstract3DSeries.Mesh = ...
        MeshBevelBar: QAbstract3DSeries.Mesh = ...
        MeshBevelCube: QAbstract3DSeries.Mesh = ...
        MeshSphere: QAbstract3DSeries.Mesh = ...
        MeshMinimal: QAbstract3DSeries.Mesh = ...
        MeshArrow: QAbstract3DSeries.Mesh = ...
        MeshPoint: QAbstract3DSeries.Mesh = ...

    class SeriesType(Enum):
        SeriesTypeNone: QAbstract3DSeries.SeriesType = ...
        SeriesTypeBar: QAbstract3DSeries.SeriesType = ...
        SeriesTypeScatter: QAbstract3DSeries.SeriesType = ...
        SeriesTypeSurface: QAbstract3DSeries.SeriesType = ...

    def baseColor(self) -> PySide6.QtGui.QColor:
        """
        https://doc.qt.io/qt-6/qabstract3dseries.html#baseColor-prop

        **baseColor : QColor**

        This property holds the base color of the series.

        **Access functions:**

        QColor **baseColor** () const
        void **setBaseColor** (const QColor &
        **color** )

        **Notifier signal:**

        void **baseColorChanged** (const QColor & **color** )

        **See also** **colorStyle**  and **Q3DTheme::baseColors** .
        """
        ...

    def baseGradient(self) -> PySide6.QtGui.QLinearGradient:
        """
        https://doc.qt.io/qt-6/qabstract3dseries.html#baseGradient-prop

        **baseGradient : QLinearGradient**

        This property holds the base gradient of the series.

        **Access functions:**

        QLinearGradient **baseGradient** () const
        void **setBaseGradient**
        (const QLinearGradient & **gradient** )

        **Notifier signal:**

        void **baseGradientChanged** (const QLinearGradient & **gradient** )

        **See also** **colorStyle**  and **Q3DTheme::baseGradients** .
        """
        ...

    def colorStyle(self) -> PySide6.QtDataVisualization.Q3DTheme.ColorStyle:
        """
        https://doc.qt.io/qt-6/qabstract3dseries.html#colorStyle-prop

        **colorStyle : Q3DTheme::ColorStyle**

        This property holds the color style for the series.

        **Access functions:**

        Q3DTheme::ColorStyle **colorStyle** () const
        void **setColorStyle**
        (Q3DTheme::ColorStyle **style** )

        **Notifier signal:**

        void **colorStyleChanged** (Q3DTheme::ColorStyle **style** )

        **See also** **Q3DTheme::ColorStyle** .
        """
        ...

    def isItemLabelVisible(self) -> bool:
        ...

    def isMeshSmooth(self) -> bool:
        ...

    def isVisible(self) -> bool:
        ...

    def itemLabel(self) -> str:
        """
        https://doc.qt.io/qt-6/qabstract3dseries.html#itemLabel-prop

        **[read-only, since QtDataVisualization 1.1] itemLabel : const QString**

        This property holds the formatted item label.

        If there is no selected item or the selected item is not visible,
        returns an empty string.

        This property was introduced in QtDataVisualization 1.1.

        **Access functions:**

        QString **itemLabel** () const

        **Notifier signal:**

        void **itemLabelChanged** (const QString & **label** )

        **See also** **itemLabelFormat** .
        """
        ...

    def itemLabelFormat(self) -> str:
        """
        https://doc.qt.io/qt-6/qabstract3dseries.html#itemLabelFormat-prop

        **itemLabelFormat : QString**

        This property holds the label format for data items in this series.

        This format is used for single item labels, for example, when an item is
        selected. How the format is interpreted depends on series type:
        **QBar3DSeries** , **QScatter3DSeries** , **QSurface3DSeries** .

        **Access functions:**

        QString **itemLabelFormat** () const
        void **setItemLabelFormat**
        (const QString & **format** )

        **Notifier signal:**

        void **itemLabelFormatChanged** (const QString & **format** )
        """
        ...

    def mesh(self) -> PySide6.QtDataVisualization.QAbstract3DSeries.Mesh:
        """
        https://doc.qt.io/qt-6/qabstract3dseries.html#mesh-prop

        **mesh : Mesh**

        This property holds the mesh of the items in the series.

        For **QSurface3DSeries** , this property holds the selection pointer.

        If the mesh is **MeshUserDefined** , then the **userDefinedMesh**
        property must also be set for items to render properly. The default
        value depends on the graph type.

        **Access functions:**

        QAbstract3DSeries::Mesh **mesh** () const
        void **setMesh**
        (QAbstract3DSeries::Mesh **mesh** )

        **Notifier signal:**

        void **meshChanged** (QAbstract3DSeries::Mesh **mesh** )
        """
        ...

    def meshRotation(self) -> PySide6.QtGui.QQuaternion:
        """
        https://doc.qt.io/qt-6/qabstract3dseries.html#meshRotation-prop

        **meshRotation : QQuaternion**

        This property holds the mesh rotation that is applied to all items of
        the series.

        The rotation should be a normalized **QQuaternion** . For those series
        types that support item specific rotation, the rotations are multiplied
        together. **QBar3DSeries**  ignores any rotation that is not around the
        y-axis. **QSurface3DSeries**  applies the rotation only to the selection
        pointer. Defaults to no rotation.

        **Access functions:**

        QQuaternion **meshRotation** () const
        void **setMeshRotation** (const
        QQuaternion & **rotation** )

        **Notifier signal:**

        void **meshRotationChanged** (const QQuaternion & **rotation** )
        """
        ...

    def multiHighlightColor(self) -> PySide6.QtGui.QColor:
        """
        https://doc.qt.io/qt-6/qabstract3dseries.html#multiHighlightColor-prop

        **multiHighlightColor : QColor**

        This property holds the multiple item highlight color of the series.

        **Access functions:**

        QColor **multiHighlightColor** () const
        void
        **setMultiHighlightColor** (const QColor & **color** )

        **Notifier signal:**

        void **multiHighlightColorChanged** (const QColor & **color** )

        **See also** **colorStyle**  and **Q3DTheme::multiHighlightColor** .
        """
        ...

    def multiHighlightGradient(self) -> PySide6.QtGui.QLinearGradient:
        """
        https://doc.qt.io/qt-6/qabstract3dseries.html#multiHighlightGradient-
        prop

        **multiHighlightGradient : QLinearGradient**

        This property holds the multiple item highlight gradient of the series.

        **Access functions:**

        QLinearGradient **multiHighlightGradient** () const
        void
        **setMultiHighlightGradient** (const QLinearGradient & **gradient** )

        **Notifier signal:**

        void **multiHighlightGradientChanged** (const QLinearGradient &
        **gradient** )

        **See also** **colorStyle**  and **Q3DTheme::multiHighlightGradient** .
        """
        ...

    def name(self) -> str:
        """
        https://doc.qt.io/qt-6/qabstract3dseries.html#name-prop

        **name : QString**

        This property holds the series name.

        The series name can be used in item label format with the tag
        `@seriesName`.

        **Access functions:**

        QString **name** () const
        void **setName** (const QString & **name** )

        **Notifier signal:**

        void **nameChanged** (const QString & **name** )

        **See also** **itemLabelFormat** .
        """
        ...

    def setBaseColor(
        self,
        color: Union[
            PySide6.QtGui.QColor,
            PySide6.QtGui.QRgba64,
            Any,
            PySide6.QtCore.Qt.GlobalColor,
            str,
            int,
        ],
    ) -> None:
        """
        https://doc.qt.io/qt-6/qabstract3dseries.html#baseColor-prop

        **baseColor : QColor**

        This property holds the base color of the series.

        **Access functions:**

        QColor **baseColor** () const
        void **setBaseColor** (const QColor &
        **color** )

        **Notifier signal:**

        void **baseColorChanged** (const QColor & **color** )

        **See also** **colorStyle**  and **Q3DTheme::baseColors** .
        """
        ...

    def setBaseGradient(self, gradient: PySide6.QtGui.QLinearGradient) -> None:
        """
        https://doc.qt.io/qt-6/qabstract3dseries.html#baseGradient-prop

        **baseGradient : QLinearGradient**

        This property holds the base gradient of the series.

        **Access functions:**

        QLinearGradient **baseGradient** () const
        void **setBaseGradient**
        (const QLinearGradient & **gradient** )

        **Notifier signal:**

        void **baseGradientChanged** (const QLinearGradient & **gradient** )

        **See also** **colorStyle**  and **Q3DTheme::baseGradients** .
        """
        ...

    def setColorStyle(
        self, style: PySide6.QtDataVisualization.Q3DTheme.ColorStyle
    ) -> None:
        """
        https://doc.qt.io/qt-6/qabstract3dseries.html#colorStyle-prop

        **colorStyle : Q3DTheme::ColorStyle**

        This property holds the color style for the series.

        **Access functions:**

        Q3DTheme::ColorStyle **colorStyle** () const
        void **setColorStyle**
        (Q3DTheme::ColorStyle **style** )

        **Notifier signal:**

        void **colorStyleChanged** (Q3DTheme::ColorStyle **style** )

        **See also** **Q3DTheme::ColorStyle** .
        """
        ...

    def setItemLabelFormat(self, format: str) -> None:
        """
        https://doc.qt.io/qt-6/qabstract3dseries.html#itemLabelFormat-prop

        **itemLabelFormat : QString**

        This property holds the label format for data items in this series.

        This format is used for single item labels, for example, when an item is
        selected. How the format is interpreted depends on series type:
        **QBar3DSeries** , **QScatter3DSeries** , **QSurface3DSeries** .

        **Access functions:**

        QString **itemLabelFormat** () const
        void **setItemLabelFormat**
        (const QString & **format** )

        **Notifier signal:**

        void **itemLabelFormatChanged** (const QString & **format** )
        """
        ...

    def setItemLabelVisible(self, visible: bool) -> None:
        """
        https://doc.qt.io/qt-6/qabstract3dseries.html#itemLabelVisible-prop

        **[since QtDataVisualization 1.1] itemLabelVisible : bool**

        This property holds the visibility of item labels in the graph.

        If `true`, item labels are drawn as floating labels in the graph.
        Otherwise, item labels are not drawn. To show the item label in an
        external control, this property is set to `false`. Defaults to `true`.

        This property was introduced in QtDataVisualization 1.1.

        **Access functions:**

        bool **isItemLabelVisible** () const
        void **setItemLabelVisible**
        (bool **visible** )

        **Notifier signal:**

        void **itemLabelVisibilityChanged** (bool **visible** )

        **See also** **itemLabelFormat**  and **itemLabel** .
        """
        ...

    def setMesh(self, mesh: PySide6.QtDataVisualization.QAbstract3DSeries.Mesh) -> None:
        """
        https://doc.qt.io/qt-6/qabstract3dseries.html#mesh-prop

        **mesh : Mesh**

        This property holds the mesh of the items in the series.

        For **QSurface3DSeries** , this property holds the selection pointer.

        If the mesh is **MeshUserDefined** , then the **userDefinedMesh**
        property must also be set for items to render properly. The default
        value depends on the graph type.

        **Access functions:**

        QAbstract3DSeries::Mesh **mesh** () const
        void **setMesh**
        (QAbstract3DSeries::Mesh **mesh** )

        **Notifier signal:**

        void **meshChanged** (QAbstract3DSeries::Mesh **mesh** )
        """
        ...

    def setMeshAxisAndAngle(self, axis: PySide6.QtGui.QVector3D, angle: float) -> None:
        """
        https://doc.qt.io/qt-6/qabstract3dseries.html#setMeshAxisAndAngle

        **[invokable] void QAbstract3DSeries::setMeshAxisAndAngle(const
        QVector3D & axis , float angle )**

        A convenience function to construct a mesh rotation quaternion from
        **axis** and **angle**.

        **Note:** This function can be invoked via the meta-object system and
        from QML. See **Q_INVOKABLE** .

        **See also** **meshRotation** .
        """
        ...

    def setMeshRotation(self, rotation: PySide6.QtGui.QQuaternion) -> None:
        """
        https://doc.qt.io/qt-6/qabstract3dseries.html#meshRotation-prop

        **meshRotation : QQuaternion**

        This property holds the mesh rotation that is applied to all items of
        the series.

        The rotation should be a normalized **QQuaternion** . For those series
        types that support item specific rotation, the rotations are multiplied
        together. **QBar3DSeries**  ignores any rotation that is not around the
        y-axis. **QSurface3DSeries**  applies the rotation only to the selection
        pointer. Defaults to no rotation.

        **Access functions:**

        QQuaternion **meshRotation** () const
        void **setMeshRotation** (const
        QQuaternion & **rotation** )

        **Notifier signal:**

        void **meshRotationChanged** (const QQuaternion & **rotation** )
        """
        ...

    def setMeshSmooth(self, enable: bool) -> None:
        """
        https://doc.qt.io/qt-6/qabstract3dseries.html#meshSmooth-prop

        **meshSmooth : bool**

        This property holds whether smooth versions of predefined meshes are
        used.

        If `true`, smooth versions set via the **mesh**  property are used. This
        property does not affect custom meshes used when the mesh is set to
        **MeshUserDefined** . Defaults to `false`.

        **Access functions:**

        bool **isMeshSmooth** () const
        void **setMeshSmooth** (bool **enable**
        )

        **Notifier signal:**

        void **meshSmoothChanged** (bool **enabled** )
        """
        ...

    def setMultiHighlightColor(
        self,
        color: Union[
            PySide6.QtGui.QColor,
            PySide6.QtGui.QRgba64,
            Any,
            PySide6.QtCore.Qt.GlobalColor,
            str,
            int,
        ],
    ) -> None:
        """
        https://doc.qt.io/qt-6/qabstract3dseries.html#multiHighlightColor-prop

        **multiHighlightColor : QColor**

        This property holds the multiple item highlight color of the series.

        **Access functions:**

        QColor **multiHighlightColor** () const
        void
        **setMultiHighlightColor** (const QColor & **color** )

        **Notifier signal:**

        void **multiHighlightColorChanged** (const QColor & **color** )

        **See also** **colorStyle**  and **Q3DTheme::multiHighlightColor** .
        """
        ...

    def setMultiHighlightGradient(
        self, gradient: PySide6.QtGui.QLinearGradient
    ) -> None:
        """
        https://doc.qt.io/qt-6/qabstract3dseries.html#multiHighlightGradient-
        prop

        **multiHighlightGradient : QLinearGradient**

        This property holds the multiple item highlight gradient of the series.

        **Access functions:**

        QLinearGradient **multiHighlightGradient** () const
        void
        **setMultiHighlightGradient** (const QLinearGradient & **gradient** )

        **Notifier signal:**

        void **multiHighlightGradientChanged** (const QLinearGradient &
        **gradient** )

        **See also** **colorStyle**  and **Q3DTheme::multiHighlightGradient** .
        """
        ...

    def setName(self, name: str) -> None:
        """
        https://doc.qt.io/qt-6/qabstract3dseries.html#name-prop

        **name : QString**

        This property holds the series name.

        The series name can be used in item label format with the tag
        `@seriesName`.

        **Access functions:**

        QString **name** () const
        void **setName** (const QString & **name** )

        **Notifier signal:**

        void **nameChanged** (const QString & **name** )

        **See also** **itemLabelFormat** .
        """
        ...

    def setSingleHighlightColor(
        self,
        color: Union[
            PySide6.QtGui.QColor,
            PySide6.QtGui.QRgba64,
            Any,
            PySide6.QtCore.Qt.GlobalColor,
            str,
            int,
        ],
    ) -> None:
        """
        https://doc.qt.io/qt-6/qabstract3dseries.html#singleHighlightColor-prop

        **singleHighlightColor : QColor**

        This property holds the single item highlight color of the series.

        **Access functions:**

        QColor **singleHighlightColor** () const
        void
        **setSingleHighlightColor** (const QColor & **color** )

        **Notifier signal:**

        void **singleHighlightColorChanged** (const QColor & **color** )

        **See also** **colorStyle**  and **Q3DTheme::singleHighlightColor** .
        """
        ...

    def setSingleHighlightGradient(
        self, gradient: PySide6.QtGui.QLinearGradient
    ) -> None:
        """
        https://doc.qt.io/qt-6/qabstract3dseries.html#singleHighlightGradient-
        prop

        **singleHighlightGradient : QLinearGradient**

        This property holds the single item highlight gradient of the series.

        **Access functions:**

        QLinearGradient **singleHighlightGradient** () const
        void
        **setSingleHighlightGradient** (const QLinearGradient & **gradient** )

        **Notifier signal:**

        void **singleHighlightGradientChanged** (const QLinearGradient &
        **gradient** )

        **See also** **colorStyle**  and **Q3DTheme::singleHighlightGradient** .
        """
        ...

    def setUserDefinedMesh(self, fileName: str) -> None:
        """
        https://doc.qt.io/qt-6/qabstract3dseries.html#userDefinedMesh-prop

        **userDefinedMesh : QString**

        This property holds the filename for a user defined custom mesh for
        objects.

        The custom mesh is used when **mesh**  is **MeshUserDefined** .

        **Note:** The file needs to be in the Wavefront OBJ format and include
        vertices, normals, and UVs. It also needs to be in triangles.

        **Access functions:**

        QString **userDefinedMesh** () const
        void **setUserDefinedMesh**
        (const QString & **fileName** )

        **Notifier signal:**

        void **userDefinedMeshChanged** (const QString & **fileName** )
        """
        ...

    def setVisible(self, visible: bool) -> None:
        """
        https://doc.qt.io/qt-6/qabstract3dseries.html#visible-prop

        **visible : bool**

        This property holds the visibility of the series.

        If this property is `false`, the series is not rendered. Defaults to
        `true`.

        **Access functions:**

        bool **isVisible** () const
        void **setVisible** (bool **visible** )

        **Notifier signal:**

        void **visibilityChanged** (bool **visible** )

        **Member Function Documentation**
        """
        ...

    def singleHighlightColor(self) -> PySide6.QtGui.QColor:
        """
        https://doc.qt.io/qt-6/qabstract3dseries.html#singleHighlightColor-prop

        **singleHighlightColor : QColor**

        This property holds the single item highlight color of the series.

        **Access functions:**

        QColor **singleHighlightColor** () const
        void
        **setSingleHighlightColor** (const QColor & **color** )

        **Notifier signal:**

        void **singleHighlightColorChanged** (const QColor & **color** )

        **See also** **colorStyle**  and **Q3DTheme::singleHighlightColor** .
        """
        ...

    def singleHighlightGradient(self) -> PySide6.QtGui.QLinearGradient:
        """
        https://doc.qt.io/qt-6/qabstract3dseries.html#singleHighlightGradient-
        prop

        **singleHighlightGradient : QLinearGradient**

        This property holds the single item highlight gradient of the series.

        **Access functions:**

        QLinearGradient **singleHighlightGradient** () const
        void
        **setSingleHighlightGradient** (const QLinearGradient & **gradient** )

        **Notifier signal:**

        void **singleHighlightGradientChanged** (const QLinearGradient &
        **gradient** )

        **See also** **colorStyle**  and **Q3DTheme::singleHighlightGradient** .
        """
        ...

    def type(self) -> PySide6.QtDataVisualization.QAbstract3DSeries.SeriesType:
        """
        https://doc.qt.io/qt-6/qabstract3dseries.html#type-prop

        **[read-only] type : const SeriesType**

        This property holds the type of the series.

        **Access functions:**

        QAbstract3DSeries::SeriesType **type** () const
        """
        ...

    def userDefinedMesh(self) -> str:
        """
        https://doc.qt.io/qt-6/qabstract3dseries.html#userDefinedMesh-prop

        **userDefinedMesh : QString**

        This property holds the filename for a user defined custom mesh for
        objects.

        The custom mesh is used when **mesh**  is **MeshUserDefined** .

        **Note:** The file needs to be in the Wavefront OBJ format and include
        vertices, normals, and UVs. It also needs to be in triangles.

        **Access functions:**

        QString **userDefinedMesh** () const
        void **setUserDefinedMesh**
        (const QString & **fileName** )

        **Notifier signal:**

        void **userDefinedMeshChanged** (const QString & **fileName** )
        """
        ...

    @property
    def baseColorChanged(self) -> PySide6.QtCore.SignalInstance:
        ...

    @property
    def baseGradientChanged(self) -> PySide6.QtCore.SignalInstance:
        ...

    @property
    def colorStyleChanged(self) -> PySide6.QtCore.SignalInstance:
        ...

    @property
    def itemLabelChanged(self) -> PySide6.QtCore.SignalInstance:
        ...

    @property
    def itemLabelFormatChanged(self) -> PySide6.QtCore.SignalInstance:
        ...

    @property
    def itemLabelVisibilityChanged(self) -> PySide6.QtCore.SignalInstance:
        ...

    @property
    def meshChanged(self) -> PySide6.QtCore.SignalInstance:
        ...

    @property
    def meshRotationChanged(self) -> PySide6.QtCore.SignalInstance:
        ...

    @property
    def meshSmoothChanged(self) -> PySide6.QtCore.SignalInstance:
        ...

    @property
    def multiHighlightColorChanged(self) -> PySide6.QtCore.SignalInstance:
        ...

    @property
    def multiHighlightGradientChanged(self) -> PySide6.QtCore.SignalInstance:
        ...

    @property
    def nameChanged(self) -> PySide6.QtCore.SignalInstance:
        ...

    @property
    def singleHighlightColorChanged(self) -> PySide6.QtCore.SignalInstance:
        ...

    @property
    def singleHighlightGradientChanged(self) -> PySide6.QtCore.SignalInstance:
        ...

    @property
    def userDefinedMeshChanged(self) -> PySide6.QtCore.SignalInstance:
        ...

    @property
    def visibilityChanged(self) -> PySide6.QtCore.SignalInstance:
        ...
