"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtDataVisualization, except for defaults which are replaced by "...".
"""
from typing import List, Optional, Union
import PySide6.QtCore
import PySide6.QtGui
import PySide6.QtDataVisualization

bytes = str


class Q3DScatter(PySide6.QtDataVisualization.QAbstract3DGraph):
    """
    https://doc.qt.io/qt-6/q3dscatter.html

    **Detailed Description**

    This class enables developers to render scatter graphs in 3D and to view
    them by rotating the scene freely. Rotation is done by holding down the
    right mouse button and moving the mouse. Zooming is done by mouse wheel.
    Selection, if enabled, is done by left mouse button. The scene can be reset
    to default camera view by clicking mouse wheel. In touch devices rotation is
    done by tap-and-move, selection by tap-and-hold and zoom by pinch.

    If no axes are set explicitly to Q3DScatter, temporary default axes with no
    labels are created. These default axes can be modified via axis accessors,
    but as soon any axis is set explicitly for the orientation, the default axis
    for that orientation is destroyed.

    Q3DScatter supports more than one series visible at the same time.

    **How to construct a minimal Q3DScatter graph**

    First, construct Q3DScatter. Since we are running the graph as top level
    window in this example, we need to clear the `Qt::FramelessWindowHint` flag,
    which gets set by default:

    **Q3DScatter**  scatter;
        scatter.setFlags(scatter.flags() ^
    Qt::FramelessWindowHint);

    Now Q3DScatter is ready to receive data to be rendered. Add one series of 3
    **QVector3D**  items:

    QScatter3DSeries *series = new QScatter3DSeries;
        **QScatterDataArray**
    data;
        data << QVector3D(0.5f, 0.5f, 0.5f) << QVector3D(-0.3f, -0.5f,
    -0.4f) << QVector3D(0.0f, -0.3f, 0.2f);
    series->dataProxy()->addItems(data);
        scatter.addSeries(series);

    Finally you will need to set it visible:

    scatter.show();

    The complete code needed to create and display this graph is:

    #include <QtDataVisualization>

        int main(int argc, char **argv)
    {
            qputenv("QSG_RHI_BACKEND", "opengl");
            **QGuiApplication**
    app(argc, argv);

            **Q3DScatter**  scatter;
    scatter.setFlags(scatter.flags() ^ Qt::FramelessWindowHint);
    QScatter3DSeries *series = new QScatter3DSeries;
    **QScatterDataArray**  data;
            data << QVector3D(0.5f, 0.5f, 0.5f) <<
    QVector3D(-0.3f, -0.5f, -0.4f) << QVector3D(0.0f, -0.3f, 0.2f);
    series->dataProxy()->addItems(data);
            scatter.addSeries(series);
    scatter.show();

            return app.exec();
        }

    And this is what those few lines of code produce:

    ![](images/q3dscatter-minimal.png)

    The scene can be rotated, zoomed into, and an item can be selected to view
    its position, but no other interaction is included in this minimal code
    example. You can learn more by familiarizing yourself with the examples
    provided, like the **Scatter Example** .

    **See also** **Q3DBars** , **Q3DSurface** , and **Qt Data Visualization C++
    Classes** .
    """

    def __init__(
        self,
        format: Union[
            PySide6.QtGui.QSurfaceFormat,
            PySide6.QtGui.QSurfaceFormat.FormatOptions,
            NoneType,
        ] = ...,
        parent: Optional[PySide6.QtGui.QWindow] = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-6/q3dscatter.html#Q3DScatter

        **Q3DScatter::Q3DScatter(const QSurfaceFormat * format = nullptr,
        QWindow * parent = nullptr)**

        Constructs a new 3D scatter graph with optional **parent** window and
        surface **format**.
        """
        ...

    def addAxis(self, axis: PySide6.QtDataVisualization.QValue3DAxis) -> None:
        """
        https://doc.qt.io/qt-6/q3dscatter.html#addAxis

        **void Q3DScatter::addAxis(QValue3DAxis * axis )**

        Adds **axis** to the graph. The axes added via addAxis are not yet taken
        to use, addAxis is simply used to give the ownership of the **axis** to
        the graph. The **axis** must not be null or added to another graph.

        **See also** **releaseAxis** (), **setAxisX** (), **setAxisY** (), and
        **setAxisZ** ().
        """
        ...

    def addSeries(self, series: PySide6.QtDataVisualization.QScatter3DSeries) -> None:
        """
        https://doc.qt.io/qt-6/q3dscatter.html#addSeries

        **void Q3DScatter::addSeries(QScatter3DSeries * series )**

        Adds the **series** to the graph. A graph can contain multiple series,
        but has only one set of axes. If the newly added series has specified a
        selected item, it will be highlighted and any existing selection will be
        cleared. Only one added series can have an active selection.
        """
        ...

    def axes(self) -> List[PySide6.QtDataVisualization.QValue3DAxis]:
        """
        https://doc.qt.io/qt-6/q3dscatter.html#axes

        **QList<QValue3DAxis *> Q3DScatter::axes() const**

        Returns the list of all added axes.

        **See also** **addAxis** ().
        """
        ...

    def axisX(self) -> PySide6.QtDataVisualization.QValue3DAxis:
        """
        https://doc.qt.io/qt-6/q3dscatter.html#axisX-prop

        **axisX : QValue3DAxis***

        This property holds the active x-axis.

        **Access functions:**

        QValue3DAxis * **axisX** () const
        void ****setAxisX** ** (QValue3DAxis
        * **axis** )

        **Notifier signal:**

        void **axisXChanged** (QValue3DAxis * **axis** )
        """
        ...

    def axisY(self) -> PySide6.QtDataVisualization.QValue3DAxis:
        """
        https://doc.qt.io/qt-6/q3dscatter.html#axisY-prop

        **axisY : QValue3DAxis***

        This property holds the active y-axis.

        **Access functions:**

        QValue3DAxis * **axisY** () const
        void ****setAxisY** ** (QValue3DAxis
        * **axis** )

        **Notifier signal:**

        void **axisYChanged** (QValue3DAxis * **axis** )
        """
        ...

    def axisZ(self) -> PySide6.QtDataVisualization.QValue3DAxis:
        """
        https://doc.qt.io/qt-6/q3dscatter.html#axisZ

        **QValue3DAxis *Q3DScatter::axisZ() const**

        Returns the used z-axis.

        **Note:** Getter function for property axisZ.

        **See also** **setAxisZ** ().
        """
        ...

    def releaseAxis(self, axis: PySide6.QtDataVisualization.QValue3DAxis) -> None:
        """
        https://doc.qt.io/qt-6/q3dscatter.html#releaseAxis

        **void Q3DScatter::releaseAxis(QValue3DAxis * axis )**

        Releases the ownership of the **axis** back to the caller, if it is
        added to this graph. If the released **axis** is in use, a new default
        axis will be created and set active.

        If the default axis is released and added back later, it behaves as any
        other axis would.

        **See also** **addAxis** (), **setAxisX** (), **setAxisY** (), and
        **setAxisZ** ().
        """
        ...

    def removeSeries(
        self, series: PySide6.QtDataVisualization.QScatter3DSeries
    ) -> None:
        """
        https://doc.qt.io/qt-6/q3dscatter.html#removeSeries

        **void Q3DScatter::removeSeries(QScatter3DSeries * series )**

        Removes the **series** from the graph.
        """
        ...

    def selectedSeries(self) -> PySide6.QtDataVisualization.QScatter3DSeries:
        """
        https://doc.qt.io/qt-6/q3dscatter.html#selectedSeries-prop

        **[read-only] selectedSeries : QScatter3DSeries* const**

        This property holds the selected series or null.

        **Access functions:**

        QScatter3DSeries * **selectedSeries** () const

        **Notifier signal:**

        void **selectedSeriesChanged** (QScatter3DSeries * **series** )

        **Member Function Documentation**
        """
        ...

    def seriesList(self) -> List[PySide6.QtDataVisualization.QScatter3DSeries]:
        """
        https://doc.qt.io/qt-6/q3dscatter.html#seriesList

        **QList<QScatter3DSeries *> Q3DScatter::seriesList() const**

        Returns the list of series added to this graph.
        """
        ...

    def setAxisX(self, axis: PySide6.QtDataVisualization.QValue3DAxis) -> None:
        """
        https://doc.qt.io/qt-6/q3dscatter.html#setAxisX

        **void Q3DScatter::setAxisX(QValue3DAxis * axis )**

        Sets **axis** as the active x-axis. Implicitly calls **addAxis** () to
        transfer the ownership of the axis to this graph.

        If **axis** is null, a temporary default axis with no labels and an
        automatically adjusting range is created. This temporary axis is
        destroyed if another axis is set explicitly to the same orientation.

        **Note:** Setter function for property **axisX** .

        **See also** **axisX** (), **addAxis** (), and **releaseAxis** ().
        """
        ...

    def setAxisY(self, axis: PySide6.QtDataVisualization.QValue3DAxis) -> None:
        """
        https://doc.qt.io/qt-6/q3dscatter.html#setAxisY

        **void Q3DScatter::setAxisY(QValue3DAxis * axis )**

        Sets **axis** as the active y-axis. Implicitly calls **addAxis** () to
        transfer the ownership of the axis to this graph.

        If **axis** is null, a temporary default axis with no labels and an
        automatically adjusting range is created. This temporary axis is
        destroyed if another axis is set explicitly to the same orientation.

        **Note:** Setter function for property **axisY** .

        **See also** **axisY** (), **addAxis** (), and **releaseAxis** ().
        """
        ...

    def setAxisZ(self, axis: PySide6.QtDataVisualization.QValue3DAxis) -> None:
        """
        https://doc.qt.io/qt-6/q3dscatter.html#setAxisZ

        **void Q3DScatter::setAxisZ(QValue3DAxis * axis )**

        Sets **axis** as the active z-axis. Implicitly calls **addAxis** () to
        transfer the ownership of the axis to this graph.

        If **axis** is null, a temporary default axis with no labels and an
        automatically adjusting range is created. This temporary axis is
        destroyed if another axis is set explicitly to the same orientation.

        **Note:** Setter function for property **axisZ** .

        **See also** **axisZ** (), **addAxis** (), and **releaseAxis** ().
        """
        ...

    @property
    def axisXChanged(self) -> PySide6.QtCore.SignalInstance:
        ...

    @property
    def axisYChanged(self) -> PySide6.QtCore.SignalInstance:
        ...

    @property
    def axisZChanged(self) -> PySide6.QtCore.SignalInstance:
        ...

    @property
    def selectedSeriesChanged(self) -> PySide6.QtCore.SignalInstance:
        ...
