"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtDataVisualization, except for defaults which are replaced by "...".
"""
from typing import Optional
import PySide6.QtCore
import PySide6.QtGui
import PySide6.QtDataVisualization

bytes = str


class Q3DInputHandler(PySide6.QtDataVisualization.QAbstract3DInputHandler):
    """
    https://doc.qt.io/qt-6/q3dinputhandler.html

    **Detailed Description**

    Q3DInputHandler is the basic input handler for wheel mouse type of input
    devices.

    Default input handler has the following functionalty:

    Mouse actionAction
    Drag with right button pressedRotate graph within
    limits set for **Q3DCamera** .
    Left clickSelect item under cursor or
    remove selection if none. May open the secondary view depending on the
    **selection mode** .
    Mouse wheelZoom in/out within the allowable zoom
    range set for **Q3DCamera** .
    Left click on the primary view when the
    secondary view is visibleCloses the secondary view.

    **Note:** Secondary
    view is available only for **Q3DBars**  and **Q3DSurface**  graphs.

    Rotation, zoom, and selection can each be individually disabled using
    corresponding properties of this class.
    """

    def __init__(self, parent: Optional[PySide6.QtCore.QObject] = ...) -> None:
        """
        https://doc.qt.io/qt-6/q3dinputhandler.html#Q3DInputHandler

        **Q3DInputHandler::Q3DInputHandler(QObject * parent = nullptr)**

        Constructs the basic mouse input handler. An optional **parent**
        parameter can be given and is then passed to **QObject**  constructor.
        """
        ...

    def isRotationEnabled(self) -> bool:
        ...

    def isSelectionEnabled(self) -> bool:
        ...

    def isZoomAtTargetEnabled(self) -> bool:
        ...

    def isZoomEnabled(self) -> bool:
        ...

    def mouseMoveEvent(
        self, event: PySide6.QtGui.QMouseEvent, mousePos: PySide6.QtCore.QPoint
    ) -> None:
        """
        https://doc.qt.io/qt-6/q3dinputhandler.html#mouseMoveEvent

        **[override virtual] void Q3DInputHandler::mouseMoveEvent(QMouseEvent *
        event , const QPoint & mousePos )**

        Reimplements: **QAbstract3DInputHandler::mouseMoveEvent** (QMouseEvent
        *event, const QPoint &mousePos).

        Override this to change handling of mouse move events. Mouse move event
        is given in the **event** and the mouse position in **mousePos**.
        """
        ...

    def mousePressEvent(
        self, event: PySide6.QtGui.QMouseEvent, mousePos: PySide6.QtCore.QPoint
    ) -> None:
        """
        https://doc.qt.io/qt-6/q3dinputhandler.html#mousePressEvent

        **[override virtual] void Q3DInputHandler::mousePressEvent(QMouseEvent *
        event , const QPoint & mousePos )**

        Reimplements: **QAbstract3DInputHandler::mousePressEvent** (QMouseEvent
        *event, const QPoint &mousePos).

        Override this to change handling of mouse press events. Mouse press
        event is given in the **event** and the mouse position in **mousePos**.
        """
        ...

    def mouseReleaseEvent(
        self, event: PySide6.QtGui.QMouseEvent, mousePos: PySide6.QtCore.QPoint
    ) -> None:
        """
        https://doc.qt.io/qt-6/q3dinputhandler.html#mouseReleaseEvent

        **[override virtual] void Q3DInputHandler::mouseReleaseEvent(QMouseEvent
        * event , const QPoint & mousePos )**

        Reimplements: **QAbstract3DInputHandler::mouseReleaseEvent**
        (QMouseEvent *event, const QPoint &mousePos).

        Override this to change handling of mouse release events. Mouse release
        event is given in the **event** and the mouse position in **mousePos**.
        """
        ...

    def setRotationEnabled(self, enable: bool) -> None:
        """
        https://doc.qt.io/qt-6/q3dinputhandler.html#rotationEnabled-prop

        **[since QtDataVisualization 1.2] rotationEnabled : bool**

        This property holds whether this input handler allows graph rotation.

        Defaults to `true`.

        This property was introduced in QtDataVisualization 1.2.

        **Access functions:**

        bool **isRotationEnabled** () const
        void **setRotationEnabled** (bool
        **enable** )

        **Notifier signal:**

        void **rotationEnabledChanged** (bool **enable** )
        """
        ...

    def setSelectionEnabled(self, enable: bool) -> None:
        """
        https://doc.qt.io/qt-6/q3dinputhandler.html#selectionEnabled-prop

        **[since QtDataVisualization 1.2] selectionEnabled : bool**

        This property holds whether this input handler allows selection from the
        graph.

        Defaults to `true`.

        This property was introduced in QtDataVisualization 1.2.

        **Access functions:**

        bool **isSelectionEnabled** () const
        void **setSelectionEnabled**
        (bool **enable** )

        **Notifier signal:**

        void **selectionEnabledChanged** (bool **enable** )
        """
        ...

    def setZoomAtTargetEnabled(self, enable: bool) -> None:
        """
        https://doc.qt.io/qt-6/q3dinputhandler.html#zoomAtTargetEnabled-prop

        **[since QtDataVisualization 1.2] zoomAtTargetEnabled : bool**

        This property holds whether zooming should change the camera target so
        that the zoomed point of the graph stays at the same location after the
        zoom.

        Defaults to `true`.

        This property was introduced in QtDataVisualization 1.2.

        **Access functions:**

        bool **isZoomAtTargetEnabled** () const
        void
        **setZoomAtTargetEnabled** (bool **enable** )

        **Notifier signal:**

        void **zoomAtTargetEnabledChanged** (bool **enable** )
        """
        ...

    def setZoomEnabled(self, enable: bool) -> None:
        """
        https://doc.qt.io/qt-6/q3dinputhandler.html#zoomEnabled-prop

        **[since QtDataVisualization 1.2] zoomEnabled : bool**

        This property holds whether this input handler allows graph zooming.

        Defaults to `true`.

        This property was introduced in QtDataVisualization 1.2.

        **Access functions:**

        bool **isZoomEnabled** () const
        void **setZoomEnabled** (bool
        **enable** )

        **Notifier signal:**

        void **zoomEnabledChanged** (bool **enable** )

        **Member Function Documentation**
        """
        ...

    def wheelEvent(self, event: PySide6.QtGui.QWheelEvent) -> None:
        """
        https://doc.qt.io/qt-6/q3dinputhandler.html#wheelEvent

        **[override virtual] void Q3DInputHandler::wheelEvent(QWheelEvent *
        event )**

        Reimplements: **QAbstract3DInputHandler::wheelEvent** (QWheelEvent
        *event).

        Override this to change handling of wheel events. The wheel event is
        given in the **event**.
        """
        ...

    @property
    def rotationEnabledChanged(self) -> PySide6.QtCore.SignalInstance:
        ...

    @property
    def selectionEnabledChanged(self) -> PySide6.QtCore.SignalInstance:
        ...

    @property
    def zoomAtTargetEnabledChanged(self) -> PySide6.QtCore.SignalInstance:
        ...

    @property
    def zoomEnabledChanged(self) -> PySide6.QtCore.SignalInstance:
        ...
