"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtCore, except for defaults which are replaced by "...".
"""
from typing import Union, overload
import PySide6.QtCore

bytes = str


class QXmlStreamWriter(object):
    """
    https://doc.qt.io/qt-6/qxmlstreamwriter.html

    **Detailed Description**

    QXmlStreamWriter is the counterpart to **QXmlStreamReader**  for writing
    XML. Like its related class, it operates on a **QIODevice**  specified with
    **setDevice** (). The API is simple and straightforward: for every XML token
    or event you want to write, the writer provides a specialized function.

    You start a document with **writeStartDocument** () and end it with
    **writeEndDocument** (). This will implicitly close all remaining open tags.

    Element tags are opened with **writeStartElement** () followed by
    **writeAttribute** () or **writeAttributes** (), element content, and then
    **writeEndElement** (). A shorter form **writeEmptyElement** () can be used
    to write empty elements, followed by **writeAttributes** ().

    Element content consists of either characters, entity references or nested
    elements. It is written with **writeCharacters** (), which also takes care
    of escaping all forbidden characters and character sequences,
    **writeEntityReference** (), or subsequent calls to **writeStartElement**
    (). A convenience method **writeTextElement** () can be used for writing
    terminal elements that contain nothing but text.

    The following abridged code snippet shows the basic use of the class to
    write formatted XML with indentation:

    **QXmlStreamWriter**  stream(&output);
    stream.setAutoFormatting(true);
            stream.writeStartDocument();
    ...
            stream.writeStartElement("bookmark");
    stream.writeAttribute("href", "http://qt-project.org/");
    stream.writeTextElement("title", "Qt Project");
    stream.writeEndElement(); // bookmark
            ...
    stream.writeEndDocument();

    QXmlStreamWriter takes care of prefixing namespaces, all you have to do is
    specify the `namespaceUri` when writing elements or attributes. If you must
    conform to certain prefixes, you can force the writer to use them by
    declaring the namespaces manually with either **writeNamespace** () or
    **writeDefaultNamespace** (). Alternatively, you can bypass the stream
    writer's namespace support and use overloaded methods that take a qualified
    name instead. The namespace **http://www.w3.org/XML/1998/namespace** is
    implicit and mapped to the prefix **xml**.

    The stream writer can automatically format the generated XML data by adding
    line-breaks and indentation to empty sections between elements, making the
    XML data more readable for humans and easier to work with for most source
    code management systems. The feature can be turned on with the
    **autoFormatting**  property, and customized with the
    **autoFormattingIndent**  property.

    Other functions are **writeCDATA** (), **writeComment** (),
    **writeProcessingInstruction** (), and **writeDTD** (). Chaining of XML
    streams is supported with **writeCurrentToken** ().

    QXmlStreamWriter always encodes XML in UTF-8.

    If an error occurs while writing to the underlying device, **hasError** ()
    starts returning true and subsequent writes are ignored.

    The **QXmlStream Bookmarks Example**  illustrates how to use a stream writer
    to write an XML bookmark file (XBEL) that was previously read in by a
    **QXmlStreamReader** .
    """

    @overload
    def __init__(self) -> None:
        """
        https://doc.qt.io/qt-6/qxmlstreamwriter.html#QXmlStreamWriter

        **QXmlStreamWriter::QXmlStreamWriter()**

        Constructs a stream writer.

        **See also** **setDevice** ().
        """
        ...

    @overload
    def __init__(self, array: Union[PySide6.QtCore.QByteArray, bytes]) -> None:
        """
        https://doc.qt.io/qt-6/qxmlstreamwriter.html#QXmlStreamWriter-1

        **QXmlStreamWriter::QXmlStreamWriter(QIODevice * device )**

        Constructs a stream writer that writes into **device** ;
        """
        ...

    @overload
    def __init__(self, device: PySide6.QtCore.QIODevice) -> None:
        """
        https://doc.qt.io/qt-6/qxmlstreamwriter.html#QXmlStreamWriter-2

        **QXmlStreamWriter::QXmlStreamWriter(QByteArray * array )**

        Constructs a stream writer that writes into **array**. This is the same
        as creating an xml writer that operates on a **QBuffer**  device which
        in turn operates on **array**.
        """
        ...

    def autoFormatting(self) -> bool:
        """
        https://doc.qt.io/qt-6/qxmlstreamwriter.html#autoFormatting

        **bool QXmlStreamWriter::autoFormatting() const**

        Returns `true` if auto formatting is enabled, otherwise `false`.

        **Note:** Getter function for property autoFormatting.

        **See also** **setAutoFormatting** ().
        """
        ...

    def autoFormattingIndent(self) -> int:
        """
        https://doc.qt.io/qt-6/qxmlstreamwriter.html#autoFormattingIndent-prop

        **autoFormattingIndent : int**

        This property holds the number of spaces or tabs used for indentation
        when auto-formatting is enabled. Positive numbers indicate spaces,
        negative numbers tabs.

        The default indentation is 4.

        **Access functions:**

        int **autoFormattingIndent** () const
        void **setAutoFormattingIndent**
        (int **spacesOrTabs** )

        **See also** **autoFormatting** .

        **Member Function Documentation**
        """
        ...

    def device(self) -> PySide6.QtCore.QIODevice:
        """
        https://doc.qt.io/qt-6/qxmlstreamwriter.html#device

        **QIODevice *QXmlStreamWriter::device() const**

        Returns the current device associated with the **QXmlStreamWriter** , or
        `nullptr` if no device has been assigned.

        **See also** **setDevice** ().
        """
        ...

    def hasError(self) -> bool:
        """
        https://doc.qt.io/qt-6/qxmlstreamwriter.html#hasError

        **bool QXmlStreamWriter::hasError() const**

        Returns `true` if writing failed.

        This can happen if the stream failed to write to the underlying device
        or if the data to be written contained invalid characters.

        The error status is never reset. Writes happening after the error
        occurred may be ignored, even if the error condition is cleared.
        """
        ...

    def setAutoFormatting(self, arg__1: bool) -> None:
        """
        https://doc.qt.io/qt-6/qxmlstreamwriter.html#setAutoFormatting

        **void QXmlStreamWriter::setAutoFormatting(bool enable )**

        Enables auto formatting if **enable** is `true`, otherwise disables it.

        The default value is `false`.

        **Note:** Setter function for property **autoFormatting** .

        **See also** **autoFormatting** ().
        """
        ...

    def setAutoFormattingIndent(self, spacesOrTabs: int) -> None:
        """
        https://doc.qt.io/qt-6/qxmlstreamwriter.html#autoFormattingIndent-prop

        **autoFormattingIndent : int**

        This property holds the number of spaces or tabs used for indentation
        when auto-formatting is enabled. Positive numbers indicate spaces,
        negative numbers tabs.

        The default indentation is 4.

        **Access functions:**

        int **autoFormattingIndent** () const
        void **setAutoFormattingIndent**
        (int **spacesOrTabs** )

        **See also** **autoFormatting** .

        **Member Function Documentation**
        """
        ...

    def setDevice(self, device: PySide6.QtCore.QIODevice) -> None:
        """
        https://doc.qt.io/qt-6/qxmlstreamwriter.html#setDevice

        **void QXmlStreamWriter::setDevice(QIODevice * device )**

        Sets the current device to **device**. If you want the stream to write
        into a **QByteArray** , you can create a **QBuffer**  device.

        **See also** **device** ().
        """
        ...

    @overload
    def writeAttribute(self, attribute: PySide6.QtCore.QXmlStreamAttribute) -> None:
        """
        https://doc.qt.io/qt-6/qxmlstreamwriter.html#writeAttribute

        **void QXmlStreamWriter::writeAttribute(const QString & namespaceUri ,
        const QString & name , const QString & value )**

        Writes an attribute with **name** and **value** , prefixed for the
        specified **namespaceUri**. If the namespace has not been declared yet,
        **QXmlStreamWriter**  will generate a namespace declaration for it.

        This function can only be called after **writeStartElement** () before
        any content is written, or after **writeEmptyElement** ().
        """
        ...

    @overload
    def writeAttribute(self, namespaceUri: str, name: str, value: str) -> None:
        """
        https://doc.qt.io/qt-6/qxmlstreamwriter.html#writeAttribute-1

        **void QXmlStreamWriter::writeAttribute(const QString & qualifiedName ,
        const QString & value )**

        This is an overloaded function.

        Writes an attribute with **qualifiedName** and **value**.

        This function can only be called after **writeStartElement** () before
        any content is written, or after **writeEmptyElement** ().
        """
        ...

    @overload
    def writeAttribute(self, qualifiedName: str, value: str) -> None:
        """
        https://doc.qt.io/qt-6/qxmlstreamwriter.html#writeAttribute-2

        **void QXmlStreamWriter::writeAttribute(const QXmlStreamAttribute &
        attribute )**

        This is an overloaded function.

        Writes the **attribute**.

        This function can only be called after **writeStartElement** () before
        any content is written, or after **writeEmptyElement** ().
        """
        ...

    def writeAttributes(self, attributes: PySide6.QtCore.QXmlStreamAttributes) -> None:
        """
        https://doc.qt.io/qt-6/qxmlstreamwriter.html#writeAttributes

        **void QXmlStreamWriter::writeAttributes(const QXmlStreamAttributes &
        attributes )**

        Writes the attribute vector **attributes**. If a namespace referenced in
        an attribute not been declared yet, **QXmlStreamWriter**  will generate
        a namespace declaration for it.

        This function can only be called after **writeStartElement** () before
        any content is written, or after **writeEmptyElement** ().

        **See also** **writeAttribute** () and **writeNamespace** ().
        """
        ...

    def writeCDATA(self, text: str) -> None:
        """
        https://doc.qt.io/qt-6/qxmlstreamwriter.html#writeCDATA

        **void QXmlStreamWriter::writeCDATA(const QString & text )**

        Writes **text** as CDATA section. If **text** contains the forbidden
        character sequence "]]>", it is split into different CDATA sections.

        This function mainly exists for completeness. Normally you should not
        need use it, because **writeCharacters** () automatically escapes all
        non-content characters.
        """
        ...

    def writeCharacters(self, text: str) -> None:
        """
        https://doc.qt.io/qt-6/qxmlstreamwriter.html#writeCharacters

        **void QXmlStreamWriter::writeCharacters(const QString & text )**

        Writes **text**. The characters "<", "&", and ""\" are escaped as entity
        references "&lt;", "&amp;, and "&quot;". To avoid the forbidden sequence
        "]]>", ">" is also escaped as "&gt;".

        **See also** **writeEntityReference** ().
        """
        ...

    def writeComment(self, text: str) -> None:
        """
        https://doc.qt.io/qt-6/qxmlstreamwriter.html#writeComment

        **void QXmlStreamWriter::writeComment(const QString & text )**

        Writes **text** as XML comment, where **text** must not contain the
        forbidden sequence "--" or end with "-". Note that XML does not provide
        any way to escape "-" in a comment.
        """
        ...

    def writeCurrentToken(self, reader: PySide6.QtCore.QXmlStreamReader) -> None:
        """
        https://doc.qt.io/qt-6/qxmlstreamwriter.html#writeCurrentToken

        **void QXmlStreamWriter::writeCurrentToken(const QXmlStreamReader &
        reader )**

        Writes the current state of the **reader**. All possible valid states
        are supported.

        The purpose of this function is to support chained processing of XML
        data.

        **See also** **QXmlStreamReader::tokenType** ().
        """
        ...

    def writeDTD(self, dtd: str) -> None:
        """
        https://doc.qt.io/qt-6/qxmlstreamwriter.html#writeDTD

        **void QXmlStreamWriter::writeDTD(const QString & dtd )**

        Writes a DTD section. The **dtd** represents the entire doctypedecl
        production from the XML 1.0 specification.
        """
        ...

    def writeDefaultNamespace(self, namespaceUri: str) -> None:
        """
        https://doc.qt.io/qt-6/qxmlstreamwriter.html#writeDefaultNamespace

        **void QXmlStreamWriter::writeDefaultNamespace(const QString &
        namespaceUri )**

        Writes a default namespace declaration for **namespaceUri**.

        If **writeStartElement** () or **writeEmptyElement** () was called, the
        declaration applies to the current element; otherwise it applies to the
        next child element.

        Note that the namespaces **http://www.w3.org/XML/1998/namespace** (bound
        to **xmlns** ) and **http://www.w3.org/2000/xmlns/** (bound to **xml** )
        by definition cannot be declared as default.
        """
        ...

    @overload
    def writeEmptyElement(self, namespaceUri: str, name: str) -> None:
        """
        https://doc.qt.io/qt-6/qxmlstreamwriter.html#writeEmptyElement

        **void QXmlStreamWriter::writeEmptyElement(const QString & namespaceUri
        , const QString & name )**

        Writes an empty element with **name** , prefixed for the specified
        **namespaceUri**. If the namespace has not been declared,
        **QXmlStreamWriter**  will generate a namespace declaration for it.
        Subsequent calls to **writeAttribute** () will add attributes to this
        element.

        **See also** **writeNamespace** ().
        """
        ...

    @overload
    def writeEmptyElement(self, qualifiedName: str) -> None:
        """
        https://doc.qt.io/qt-6/qxmlstreamwriter.html#writeEmptyElement-1

        **void QXmlStreamWriter::writeEmptyElement(const QString & qualifiedName
        )**

        This is an overloaded function.

        Writes an empty element with qualified name **qualifiedName**.
        Subsequent calls to **writeAttribute** () will add attributes to this
        element.
        """
        ...

    def writeEndDocument(self) -> None:
        """
        https://doc.qt.io/qt-6/qxmlstreamwriter.html#writeEndDocument

        **void QXmlStreamWriter::writeEndDocument()**

        Closes all remaining open start elements and writes a newline.

        **See also** **writeStartDocument** ().
        """
        ...

    def writeEndElement(self) -> None:
        """
        https://doc.qt.io/qt-6/qxmlstreamwriter.html#writeEndElement

        **void QXmlStreamWriter::writeEndElement()**

        Closes the previous start element.

        **See also** **writeStartElement** ().
        """
        ...

    def writeEntityReference(self, name: str) -> None:
        """
        https://doc.qt.io/qt-6/qxmlstreamwriter.html#writeEntityReference

        **void QXmlStreamWriter::writeEntityReference(const QString & name )**

        Writes the entity reference **name** to the stream, as "& **name** ;".
        """
        ...

    def writeNamespace(self, namespaceUri: str, prefix: str = ...) -> None:
        """
        https://doc.qt.io/qt-6/qxmlstreamwriter.html#writeNamespace

        **void QXmlStreamWriter::writeNamespace(const QString & namespaceUri ,
        const QString & prefix = QString())**

        Writes a namespace declaration for **namespaceUri** with **prefix**. If
        **prefix** is empty, **QXmlStreamWriter**  assigns a unique prefix
        consisting of the letter 'n' followed by a number.

        If **writeStartElement** () or **writeEmptyElement** () was called, the
        declaration applies to the current element; otherwise it applies to the
        next child element.

        Note that the prefix **xml** is both predefined and reserved for
        **http://www.w3.org/XML/1998/namespace** , which in turn cannot be bound
        to any other prefix. The prefix **xmlns** and its URI
        **http://www.w3.org/2000/xmlns/** are used for the namespace mechanism
        itself and thus completely forbidden in declarations.
        """
        ...

    def writeProcessingInstruction(self, target: str, data: str = ...) -> None:
        """
        https://doc.qt.io/qt-6/qxmlstreamwriter.html#writeProcessingInstruction

        **void QXmlStreamWriter::writeProcessingInstruction(const QString &
        target , const QString & data = QString())**

        Writes an XML processing instruction with **target** and **data** ,
        where **data** must not contain the sequence "?>".
        """
        ...

    @overload
    def writeStartDocument(self) -> None:
        """
        https://doc.qt.io/qt-6/qxmlstreamwriter.html#writeStartDocument

        **void QXmlStreamWriter::writeStartDocument(const QString & version )**

        Writes a document start with the XML version number **version**.

        **See also** **writeEndDocument** ().
        """
        ...

    @overload
    def writeStartDocument(self, version: str) -> None:
        """
        https://doc.qt.io/qt-6/qxmlstreamwriter.html#writeStartDocument-1

        **void QXmlStreamWriter::writeStartDocument()**

        This is an overloaded function.

        Writes a document start with XML version number "1.0".

        **See also** **writeEndDocument** ().
        """
        ...

    @overload
    def writeStartDocument(self, version: str, standalone: bool) -> None:
        """
        https://doc.qt.io/qt-6/qxmlstreamwriter.html#writeStartDocument-2

        **void QXmlStreamWriter::writeStartDocument(const QString & version ,
        bool standalone )**

        Writes a document start with the XML version number **version** and a
        standalone attribute **standalone**.

        **See also** **writeEndDocument** ().
        """
        ...

    @overload
    def writeStartElement(self, namespaceUri: str, name: str) -> None:
        """
        https://doc.qt.io/qt-6/qxmlstreamwriter.html#writeStartElement

        **void QXmlStreamWriter::writeStartElement(const QString & namespaceUri
        , const QString & name )**

        Writes a start element with **name** , prefixed for the specified
        **namespaceUri**. If the namespace has not been declared yet,
        **QXmlStreamWriter**  will generate a namespace declaration for it.
        Subsequent calls to **writeAttribute** () will add attributes to this
        element.

        **See also** **writeNamespace** (), **writeEndElement** (), and
        **writeEmptyElement** ().
        """
        ...

    @overload
    def writeStartElement(self, qualifiedName: str) -> None:
        """
        https://doc.qt.io/qt-6/qxmlstreamwriter.html#writeStartElement-1

        **void QXmlStreamWriter::writeStartElement(const QString & qualifiedName
        )**

        This is an overloaded function.

        Writes a start element with **qualifiedName**. Subsequent calls to
        **writeAttribute** () will add attributes to this element.

        **See also** **writeEndElement** () and **writeEmptyElement** ().
        """
        ...

    @overload
    def writeTextElement(self, namespaceUri: str, name: str, text: str) -> None:
        """
        https://doc.qt.io/qt-6/qxmlstreamwriter.html#writeTextElement

        **void QXmlStreamWriter::writeTextElement(const QString & namespaceUri ,
        const QString & name , const QString & text )**

        Writes a text element with **name** , prefixed for the specified
        **namespaceUri** , and **text**. If the namespace has not been declared,
        **QXmlStreamWriter**  will generate a namespace declaration for it.

        This is a convenience function equivalent to:

        writeStartElement(namespaceUri, name);
        writeCharacters(text);
                    writeEndElement();
        """
        ...

    @overload
    def writeTextElement(self, qualifiedName: str, text: str) -> None:
        """
        https://doc.qt.io/qt-6/qxmlstreamwriter.html#writeTextElement-1

        **void QXmlStreamWriter::writeTextElement(const QString & qualifiedName
        , const QString & text )**

        This is an overloaded function.

        Writes a text element with **qualifiedName** and **text**.

        This is a convenience function equivalent to:

        writeStartElement(qualifiedName);
                    writeCharacters(text);
        writeEndElement();
        """
        ...
