"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtCore, except for defaults which are replaced by "...".
"""
from enum import Enum
from typing import Union, overload
import PySide6.QtCore

bytes = str


class QUuid(object):
    """
    https://doc.qt.io/qt-6/quuid.html

    **Detailed Description**

    Using **U** niversally **U** nique **ID** entifiers (UUID) is a standard way
    to uniquely identify entities in a distributed computing environment. A UUID
    is a 16-byte (128-bit) number generated by some algorithm that is meant to
    guarantee that the UUID will be unique in the distributed computing
    environment where it is used. The acronym GUID is often used instead, **G**
    lobally **U** nique **ID** entifiers, but it refers to the same thing.

    Actually, the GUID is one **variant** of UUID. Multiple variants are in use.
    Each UUID contains a bit field that specifies which type (variant) of UUID
    it is. Call **variant** () to discover which type of UUID an instance of
    QUuid contains. It extracts the three most significant bits of byte 8 of the
    16 bytes. In QUuid, byte 8 is `QUuid::data4[0]`. If you create instances of
    QUuid using the constructor that accepts all the numeric values as
    parameters, use the following table to set the three most significant bits
    of parameter `b1`, which becomes `QUuid::data4[0]` and contains the variant
    field in its three most significant bits. In the table, 'x' means **don't
    care**.

    msb0msb1msb2Variant
    0xxNCS (Network Computing System)
    10xDCE
    (Distributed Computing Environment)
    110Microsoft (GUID)
    111Reserved for
    future expansion

    If **variant** () returns **QUuid::DCE** , the UUID also contains a
    **version** field in the four most significant bits of `QUuid::data3`, and
    you can call **version** () to discover which version your QUuid contains.
    If you create instances of QUuid using the constructor that accepts all the
    numeric values as parameters, use the following table to set the four most
    significant bits of parameter `w2`, which becomes `QUuid::data3` and
    contains the version field in its four most significant bits.

    msb0msb1msb2msb3Version
    0001Time
    0010Embedded POSIX
    0011Md5(Name)
    0100Random
    0101Sha1

    The field layouts for the DCE versions listed in the table above are
    specified in the **Network Working Group UUID Specification** .

    Most platforms provide a tool for generating new UUIDs, e.g. `uuidgen` and
    `guidgen`. You can also use **createUuid** (). UUIDs generated by
    **createUuid** () are of the random type. Their **QUuid::Version**  bits are
    set to **QUuid::Random** , and their **QUuid::Variant**  bits are set to
    **QUuid::DCE** . The rest of the UUID is composed of random numbers.
    Theoretically, this means there is a small chance that a UUID generated by
    **createUuid** () will not be unique. But it is **a **very** small chance**
    .

    UUIDs can be constructed from numeric values or from strings, or using the
    static **createUuid** () function. They can be converted to a string with
    **toString** (). UUIDs have a **variant** () and a **version** (), and null
    UUIDs return true from **isNull** ().
    """

    WithBraces: QUuid.StringFormat = ...
    WithoutBraces: QUuid.StringFormat = ...
    Id128: QUuid.StringFormat = ...
    VarUnknown: QUuid.Variant = ...
    NCS: QUuid.Variant = ...
    DCE: QUuid.Variant = ...
    Microsoft: QUuid.Variant = ...
    Reserved: QUuid.Variant = ...
    VerUnknown: QUuid.Version = ...
    Time: QUuid.Version = ...
    EmbeddedPOSIX: QUuid.Version = ...
    Md5: QUuid.Version = ...
    Name: QUuid.Version = ...
    Random: QUuid.Version = ...
    Sha1: QUuid.Version = ...

    class StringFormat(Enum):
        WithBraces: QUuid.StringFormat = ...
        WithoutBraces: QUuid.StringFormat = ...
        Id128: QUuid.StringFormat = ...

    class Variant(Enum):
        VarUnknown: QUuid.Variant = ...
        NCS: QUuid.Variant = ...
        DCE: QUuid.Variant = ...
        Microsoft: QUuid.Variant = ...
        Reserved: QUuid.Variant = ...

    class Version(Enum):
        VerUnknown: QUuid.Version = ...
        Time: QUuid.Version = ...
        EmbeddedPOSIX: QUuid.Version = ...
        Md5: QUuid.Version = ...
        Name: QUuid.Version = ...
        Random: QUuid.Version = ...
        Sha1: QUuid.Version = ...

    @overload
    def __init__(self) -> None:
        """
        https://doc.qt.io/qt-6/quuid.html#QUuid

        **QUuid::QUuid(const QByteArray & text )**

        Creates a QUuid object from the **QByteArray**  **text** , which must be
        formatted as five hex fields separated by '-', e.g., "{xxxxxxxx-xxxx-
        xxxx-xxxx-xxxxxxxxxxxx}" where each 'x' is a hex digit. The curly braces
        shown here are optional, but it is normal to include them. If the
        conversion fails, a null UUID is created. See **toByteArray** () for an
        explanation of how the five hex fields map to the public data members in
        QUuid.

        **See also** **toByteArray** () and **QUuid** ().
        """
        ...

    @overload
    def __init__(self, arg__1: str) -> None:
        """
        https://doc.qt.io/qt-6/quuid.html#QUuid-1

        **QUuid::QUuid()**

        Creates the null UUID. **toString** () will output the null UUID as
        "{00000000-0000-0000-0000-000000000000}".
        """
        ...

    @overload
    def __init__(self, arg__1: bytes) -> None:
        """
        https://doc.qt.io/qt-6/quuid.html#QUuid-2

        **QUuid::QUuid(uint l , ushort w1 , ushort w2 , uchar b1 , uchar b2 ,
        uchar b3 , uchar b4 , uchar b5 , uchar b6 , uchar b7 , uchar b8 )**

        Creates a UUID with the value specified by the parameters, **l** ,
        **w1** , **w2** , **b1** , **b2** , **b3** , **b4** , **b5** , **b6** ,
        **b7** , **b8**.

        Example:

        // {67C8770B-44F1-410A-AB9A-F9B5446F13EE}
            QUuid
        IID_MyInterface(0x67c8770b, 0x44f1, 0x410a, 0xab, 0x9a, 0xf9, 0xb5,
        0x44, 0x6f, 0x13, 0xee);
        """
        ...

    @overload
    def __init__(self, arg__1: Union[PySide6.QtCore.QByteArray, bytes]) -> None:
        """
        https://doc.qt.io/qt-6/quuid.html#QUuid-3

        **QUuid::QUuid(const QString & text )**

        Creates a QUuid object from the string **text** , which must be
        formatted as five hex fields separated by '-', e.g., "{xxxxxxxx-xxxx-
        xxxx-xxxx-xxxxxxxxxxxx}" where each 'x' is a hex digit. The curly braces
        shown here are optional, but it is normal to include them. If the
        conversion fails, a null UUID is created. See **toString** () for an
        explanation of how the five hex fields map to the public data members in
        QUuid.

        **See also** **toString** () and **QUuid** ().
        """
        ...

    @overload
    def __init__(
        self,
        l: int,
        w1: int,
        w2: int,
        b1: int,
        b2: int,
        b3: int,
        b4: int,
        b5: int,
        b6: int,
        b7: int,
        b8: int,
    ) -> None:
        """
        https://doc.qt.io/qt-6/quuid.html#QUuid-4

        **QUuid::QUuid(const GUID & guid )**

        Casts a Windows **guid** to a Qt QUuid.

        **Warning:** This function is only for Windows platforms.
        """
        ...

    @staticmethod
    def __copy__() -> None:
        ...

    def __reduce__(self) -> object:
        ...

    def __repr__(self) -> object:
        ...

    @staticmethod
    def createUuid() -> PySide6.QtCore.QUuid:
        """
        https://doc.qt.io/qt-6/quuid.html#createUuid

        **[static] QUuid QUuid::createUuid()**

        On any platform other than Windows, this function returns a new UUID
        with variant **QUuid::DCE**  and version **QUuid::Random** . On Windows,
        a GUID is generated using the Windows API and will be of the type that
        the API decides to create.

        **See also** **variant** () and **version** ().
        """
        ...

    @overload
    @staticmethod
    def createUuidV3(ns: PySide6.QtCore.QUuid, baseData: str) -> PySide6.QtCore.QUuid:
        """
        https://doc.qt.io/qt-6/quuid.html#createUuidV3

        **[static, since 5.0] QUuid QUuid::createUuidV3(const QUuid & ns , const
        QByteArray & baseData )**

        This function returns a new UUID with variant **QUuid::DCE**  and
        version **QUuid::Md5** . **ns** is the namespace and **baseData** is the
        basic data as described by RFC 4122.

        This function was introduced in Qt 5.0.

        **See also** **variant** (), **version** (), and **createUuidV5** ().
        """
        ...

    @overload
    @staticmethod
    def createUuidV3(
        ns: PySide6.QtCore.QUuid, baseData: Union[PySide6.QtCore.QByteArray, bytes]
    ) -> PySide6.QtCore.QUuid:
        """
        https://doc.qt.io/qt-6/quuid.html#createUuidV3-1

        **[static, since 5.0] QUuid QUuid::createUuidV3(const QUuid & ns , const
        QString & baseData )**

        This function returns a new UUID with variant **QUuid::DCE**  and
        version **QUuid::Md5** . **ns** is the namespace and **baseData** is the
        basic data as described by RFC 4122.

        This function was introduced in Qt 5.0.

        **See also** **variant** (), **version** (), and **createUuidV5** ().
        """
        ...

    @overload
    @staticmethod
    def createUuidV5(ns: PySide6.QtCore.QUuid, baseData: str) -> PySide6.QtCore.QUuid:
        """
        https://doc.qt.io/qt-6/quuid.html#createUuidV5

        **[static, since 5.0] QUuid QUuid::createUuidV5(const QUuid & ns , const
        QByteArray & baseData )**

        This function returns a new UUID with variant **QUuid::DCE**  and
        version **QUuid::Sha1** . **ns** is the namespace and **baseData** is
        the basic data as described by RFC 4122.

        This function was introduced in Qt 5.0.

        **See also** **variant** (), **version** (), and **createUuidV3** ().
        """
        ...

    @overload
    @staticmethod
    def createUuidV5(
        ns: PySide6.QtCore.QUuid, baseData: Union[PySide6.QtCore.QByteArray, bytes]
    ) -> PySide6.QtCore.QUuid:
        """
        https://doc.qt.io/qt-6/quuid.html#createUuidV5-1

        **[static, since 5.0] QUuid QUuid::createUuidV5(const QUuid & ns , const
        QString & baseData )**

        This function returns a new UUID with variant **QUuid::DCE**  and
        version **QUuid::Sha1** . **ns** is the namespace and **baseData** is
        the basic data as described by RFC 4122.

        This function was introduced in Qt 5.0.

        **See also** **variant** (), **version** (), and **createUuidV3** ().
        """
        ...

    @staticmethod
    def fromRfc4122(
        arg__1: Union[PySide6.QtCore.QByteArray, bytes]
    ) -> PySide6.QtCore.QUuid:
        """
        https://doc.qt.io/qt-6/quuid.html#fromRfc4122

        **[static] QUuid QUuid::fromRfc4122(const QByteArray & bytes )**

        Creates a **QUuid**  object from the binary representation of the UUID,
        as specified by RFC 4122 section 4.1.2. See **toRfc4122** () for a
        further explanation of the order of **bytes** required.

        The byte array accepted is NOT a human readable format.

        If the conversion fails, a null UUID is created.

        **See also** **toRfc4122** () and **QUuid** ().
        """
        ...

    @staticmethod
    def fromString(string: str) -> PySide6.QtCore.QUuid:
        """
        https://doc.qt.io/qt-6/quuid.html#fromString

        **[static, since 5.10] QUuid QUuid::fromString(QStringView text )**

        Creates a **QUuid**  object from the string **text** , which must be
        formatted as five hex fields separated by '-', e.g., "{xxxxxxxx-xxxx-
        xxxx-xxxx-xxxxxxxxxxxx}" where each 'x' is a hex digit. The curly braces
        shown here are optional, but it is normal to include them. If the
        conversion fails, a null UUID is returned. See **toString** () for an
        explanation of how the five hex fields map to the public data members in
        **QUuid** .

        This function was introduced in Qt 5.10.

        **See also** **toString** () and **QUuid** ().
        """
        ...

    def isNull(self) -> bool:
        """
        https://doc.qt.io/qt-6/quuid.html#isNull

        **bool QUuid::isNull() const**

        Returns `true` if this is the null UUID
        {00000000-0000-0000-0000-000000000000}; otherwise returns `false`.
        """
        ...

    def toByteArray(
        self, mode: PySide6.QtCore.QUuid.StringFormat = ...
    ) -> PySide6.QtCore.QByteArray:
        """
        https://doc.qt.io/qt-6/quuid.html#toByteArray

        **[since 5.11] QByteArray QUuid::toByteArray(QUuid::StringFormat mode =
        WithBraces) const**

        Returns the string representation of this **QUuid** , with the
        formattiong controlled by the **mode** parameter. From left to right,
        the five hex fields are obtained from the four public data members in
        **QUuid**  as follows:

        Field #Source
        1data1
        2data2
        3data3
        4data4[0] .. data4[1]
        5data4[2] .. data4[7]

        This function was introduced in Qt 5.11.
        """
        ...

    def toRfc4122(self) -> PySide6.QtCore.QByteArray:
        """
        https://doc.qt.io/qt-6/quuid.html#toRfc4122

        **QByteArray QUuid::toRfc4122() const**

        Returns the binary representation of this **QUuid** . The byte array is
        in big endian format, and formatted according to RFC 4122, section 4.1.2
        - "Layout and byte order".

        The order is as follows:

        Field #Source
        1data1
        2data2
        3data3
        4data4[0] .. data4[7]
        """
        ...

    def toString(self, mode: PySide6.QtCore.QUuid.StringFormat = ...) -> str:
        """
        https://doc.qt.io/qt-6/quuid.html#toString

        **[since 5.11] QString QUuid::toString(QUuid::StringFormat mode =
        WithBraces) const**

        Returns the string representation of this **QUuid** , with the
        formattiong controlled by the **mode** parameter. From left to right,
        the five hex fields are obtained from the four public data members in
        **QUuid**  as follows:

        Field #Source
        1data1
        2data2
        3data3
        4data4[0] .. data4[1]
        5data4[2] .. data4[7]

        This function was introduced in Qt 5.11.
        """
        ...

    def variant(self) -> PySide6.QtCore.QUuid.Variant:
        """
        https://doc.qt.io/qt-6/quuid.html#variant

        **QUuid::Variant QUuid::variant() const**

        Returns the value in the **variant field**  of the UUID. If the return
        value is **QUuid::DCE** , call **version** () to see which layout it
        uses. The null UUID is considered to be of an unknown variant.

        **See also** **version** ().
        """
        ...

    def version(self) -> PySide6.QtCore.QUuid.Version:
        """
        https://doc.qt.io/qt-6/quuid.html#version

        **QUuid::Version QUuid::version() const**

        Returns the **version field**  of the UUID, if the UUID's **variant
        field**  is **QUuid::DCE** . Otherwise it returns **QUuid::VerUnknown**
        .

        **See also** **variant** ().
        """
        ...
