"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtCore, except for defaults which are replaced by "...".
"""
from typing import Union, overload
import PySide6.QtCore

bytes = str


class QStringDecoder(PySide6.QtCore.QStringConverter):
    """
    https://doc.qt.io/qt-6/qstringdecoder.html

    **Detailed Description**

    A text decoder converts text an encoded text format that uses a specific
    encoding into Qt's internal representation.

    Converting encoded data into a **QString**  can be achieved using the
    following code:

    **QByteArray**  encodedString = "...";
        auto toUtf16 =
    QStringDecoder(QStringDecoder::Utf8);
        **QString**  string =
    toUtf16(encodedString);

    The decoder remembers any state that is required between calls, so
    converting data received in chunks, for example, when receiving it over a
    network, is just as easy, by calling the decoder whenever new data is
    available:

    auto toUtf16 = QStringDecoder(QStringDecoder::Utf8);

        **QString**
    string;
        while (new_data_available()) {
            **QByteArray**  chunk =
    get_new_data();
            string += toUtf16(chunk);
        }

    The QStringDecoder object maintains state between chunks and therefore works
    correctly even if chunks are split in the middle of a multi-byte character
    sequence.

    QStringDecoder objects can't be copied because of their internal state, but
    can be moved.

    **See also** **QStringConverter**  and **QStringEncoder** .
    """

    @overload
    def __init__(self) -> None:
        """
        https://doc.qt.io/qt-6/qstringdecoder.html#QStringDecoder-1

        **QStringDecoder::QStringDecoder(QStringConverter::Encoding encoding ,
        QStringConverter::Flags flags = Flag::Default)**

        Creates an decoder object using **encoding** and **flags**.
        """
        ...

    @overload
    def __init__(
        self,
        encoding: PySide6.QtCore.QStringConverter.Encoding,
        flags: PySide6.QtCore.QStringConverterBase.Flags = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qstringdecoder.html#QStringDecoder-2

        **QStringDecoder::QStringDecoder()**

        Default constructs an decoder. The default decoder is not valid, and
        can't be used for converting text.
        """
        ...

    @overload
    def __init__(
        self, name: bytes, f: PySide6.QtCore.QStringConverterBase.Flags = ...
    ) -> None:
        """
        https://doc.qt.io/qt-6/qstringdecoder.html#QStringDecoder-3

        **QStringDecoder::QStringDecoder(const char * name ,
        QStringConverter::Flags flags = Flag::Default)**

        Creates an decoder object using **name** and **flags**. If **name** is
        not the name of a known encoding an invalid converter will get created.

        **See also** **isValid** ().
        """
        ...

    def appendToBuffer(
        self, out: bytes, ba: Union[PySide6.QtCore.QByteArray, bytes]
    ) -> bytes:
        """
        https://doc.qt.io/qt-6/qstringdecoder.html#appendToBuffer

        **QChar *QStringDecoder::appendToBuffer(QChar * out , QByteArrayView in
        )**

        Decodes the sequence of bytes viewed by **in** and writes the decoded
        result into the buffer starting at **out**. Returns a pointer to the end
        of data written.

        **out** needs to be large enough to be able to hold all the decoded
        data. Use **requiredSpace**  to determine the maximum size requirements
        to decode an encoded data buffer of `in.size()` bytes.

        **See also** **requiredSpace** .
        """
        ...

    def requiredSpace(self, inputLength: int) -> int:
        """
        https://doc.qt.io/qt-6/qstringdecoder.html#requiredSpace

        **qsizetype QStringDecoder::requiredSpace(qsizetype inputLength )
        const**

        Returns the maximum amount of UTF-16 code units required to be able to
        process **inputLength** encoded data.

        **See also** **appendToBuffer** .
        """
        ...
