"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtCore, except for defaults which are replaced by "...".
"""
from typing import Union, overload
import PySide6.QtCore

bytes = str


class QSizeF(object):
    """
    https://doc.qt.io/qt-6/qsizef.html

    **Detailed Description**

    A size is specified by a **width** () and a **height** (). It can be set in
    the constructor and changed using the **setWidth** (), **setHeight** (), or
    **scale** () functions, or using arithmetic operators. A size can also be
    manipulated directly by retrieving references to the width and height using
    the **rwidth** () and **rheight** () functions. Finally, the width and
    height can be swapped using the **transpose** () function.

    The **isValid** () function determines if a size is valid. A valid size has
    both width and height greater than or equal to zero. The **isEmpty** ()
    function returns `true` if either of the width and height is **less** than
    (or equal to) zero, while the **isNull** () function returns `true` only if
    both the width and the height is zero.

    Use the **expandedTo** () function to retrieve a size which holds the
    maximum height and width of this size and a given size. Similarly, the
    **boundedTo** () function returns a size which holds the minimum height and
    width of this size and a given size.

    The QSizeF class also provides the **toSize** () function returning a
    **QSize**  copy of this size, constructed by rounding the width and height
    to the nearest integers.

    QSizeF objects can be streamed as well as compared.

    **See also** **QSize** , **QPointF** , and **QRectF** .
    """

    @overload
    def __init__(self) -> None:
        """
        https://doc.qt.io/qt-6/qsizef.html#QSizeF

        **QSizeF::QSizeF()**

        Constructs an invalid size.

        **See also** **isValid** ().
        """
        ...

    @overload
    def __init__(
        self, QSizeF: Union[PySide6.QtCore.QSizeF, PySide6.QtCore.QSize]
    ) -> None:
        """
        https://doc.qt.io/qt-6/qsizef.html#QSizeF-1

        **QSizeF::QSizeF(const QSize & size )**

        Constructs a size with floating point accuracy from the given **size**.

        **See also** **toSize** ().
        """
        ...

    @overload
    def __init__(self, sz: PySide6.QtCore.QSize) -> None:
        """
        https://doc.qt.io/qt-6/qsizef.html#QSizeF-2

        **QSizeF::QSizeF(qreal width , qreal height )**

        Constructs a size with the given finite **width** and **height**.
        """
        ...

    @overload
    def __init__(self, w: float, h: float) -> None:
        """
        https://doc.qt.io/qt-6/qsizef.html#QSizeF

        **QSizeF::QSizeF()**

        Constructs an invalid size.

        **See also** **isValid** ().
        """
        ...

    def __add__(
        self, s2: Union[PySide6.QtCore.QSizeF, PySide6.QtCore.QSize]
    ) -> PySide6.QtCore.QSizeF:
        ...

    @staticmethod
    def __copy__() -> None:
        ...

    def __iadd__(
        self, arg__1: Union[PySide6.QtCore.QSizeF, PySide6.QtCore.QSize]
    ) -> PySide6.QtCore.QSizeF:
        ...

    def __imul__(self, c: float) -> PySide6.QtCore.QSizeF:
        ...

    def __isub__(
        self, arg__1: Union[PySide6.QtCore.QSizeF, PySide6.QtCore.QSize]
    ) -> PySide6.QtCore.QSizeF:
        ...

    def __mul__(self, c: float) -> PySide6.QtCore.QSizeF:
        ...

    def __reduce__(self) -> object:
        ...

    def __repr__(self) -> object:
        ...

    def __sub__(
        self, s2: Union[PySide6.QtCore.QSizeF, PySide6.QtCore.QSize]
    ) -> PySide6.QtCore.QSizeF:
        ...

    def boundedTo(
        self, arg__1: Union[PySide6.QtCore.QSizeF, PySide6.QtCore.QSize]
    ) -> PySide6.QtCore.QSizeF:
        """
        https://doc.qt.io/qt-6/qsizef.html#boundedTo

        **QSizeF QSizeF::boundedTo(const QSizeF & otherSize ) const**

        Returns a size holding the minimum width and height of this size and the
        given **otherSize**.

        **See also** **expandedTo** () and **scale** ().
        """
        ...

    def expandedTo(
        self, arg__1: Union[PySide6.QtCore.QSizeF, PySide6.QtCore.QSize]
    ) -> PySide6.QtCore.QSizeF:
        """
        https://doc.qt.io/qt-6/qsizef.html#expandedTo

        **QSizeF QSizeF::expandedTo(const QSizeF & otherSize ) const**

        Returns a size holding the maximum width and height of this size and the
        given **otherSize**.

        **See also** **boundedTo** () and **scale** ().
        """
        ...

    def grownBy(
        self, m: Union[PySide6.QtCore.QMarginsF, PySide6.QtCore.QMargins]
    ) -> PySide6.QtCore.QSizeF:
        """
        https://doc.qt.io/qt-6/qsizef.html#grownBy

        **[since 5.14] QSizeF QSizeF::grownBy(QMarginsF margins ) const**

        Returns the size that results from growing this size by **margins**.

        This function was introduced in Qt 5.14.

        **See also** **shrunkBy** ().
        """
        ...

    def height(self) -> float:
        """
        https://doc.qt.io/qt-6/qsizef.html#height

        **qreal QSizeF::height() const**

        Returns the height.

        **See also** **width** () and **setHeight** ().
        """
        ...

    def isEmpty(self) -> bool:
        """
        https://doc.qt.io/qt-6/qsizef.html#isEmpty

        **bool QSizeF::isEmpty() const**

        Returns `true` if either of the width and height is less than or equal
        to 0; otherwise returns `false`.

        **See also** **isNull** () and **isValid** ().
        """
        ...

    def isNull(self) -> bool:
        """
        https://doc.qt.io/qt-6/qsizef.html#isNull

        **bool QSizeF::isNull() const**

        Returns `true` if both the width and height are 0.0 (ignoring the sign);
        otherwise returns `false`.

        **See also** **isValid** () and **isEmpty** ().
        """
        ...

    def isValid(self) -> bool:
        """
        https://doc.qt.io/qt-6/qsizef.html#isValid

        **bool QSizeF::isValid() const**

        Returns `true` if both the width and height are equal to or greater than
        0; otherwise returns `false`.

        **See also** **isNull** () and **isEmpty** ().
        """
        ...

    @overload
    def scale(
        self,
        s: Union[PySide6.QtCore.QSizeF, PySide6.QtCore.QSize],
        mode: PySide6.QtCore.Qt.AspectRatioMode,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qsizef.html#scale

        **void QSizeF::scale(qreal width , qreal height , Qt::AspectRatioMode
        mode )**

        Scales the size to a rectangle with the given **width** and **height** ,
        according to the specified **mode**.

        * If **mode** is **Qt::IgnoreAspectRatio** , the size is set to (
        **width** , **height** ).
          * If **mode** is **Qt::KeepAspectRatio** ,
        the current size is scaled to a rectangle as large as possible inside (
        **width** , **height** ), preserving the aspect ratio.
          * If **mode**
        is **Qt::KeepAspectRatioByExpanding** , the current size is scaled to a
        rectangle as small as possible outside ( **width** , **height** ),
        preserving the aspect ratio.

        Example:

        **QSizeF**  t1(10, 12);
            t1.scale(60, 60, Qt::IgnoreAspectRatio);
        // t1 is (60, 60)

            **QSizeF**  t2(10, 12);
            t2.scale(60, 60,
        Qt::KeepAspectRatio);
            // t2 is (50, 60)

            **QSizeF**  t3(10,
        12);
            t3.scale(60, 60, Qt::KeepAspectRatioByExpanding);
            // t3 is
        (60, 72)

        **See also** **setWidth** (), **setHeight** (), and **scaled** ().
        """
        ...

    @overload
    def scale(
        self, w: float, h: float, mode: PySide6.QtCore.Qt.AspectRatioMode
    ) -> None:
        """
        https://doc.qt.io/qt-6/qsizef.html#scale-1

        **void QSizeF::scale(const QSizeF & size , Qt::AspectRatioMode mode )**

        This is an overloaded function.

        Scales the size to a rectangle with the given **size** , according to
        the specified **mode**.
        """
        ...

    @overload
    def scaled(
        self,
        s: Union[PySide6.QtCore.QSizeF, PySide6.QtCore.QSize],
        mode: PySide6.QtCore.Qt.AspectRatioMode,
    ) -> PySide6.QtCore.QSizeF:
        """
        https://doc.qt.io/qt-6/qsizef.html#scaled

        **[since 5.0] QSizeF QSizeF::scaled(qreal width , qreal height ,
        Qt::AspectRatioMode mode ) const**

        Returns a size scaled to a rectangle with the given **width** and
        **height** , according to the specified **mode**.

        This function was introduced in Qt 5.0.

        **See also** **scale** ().
        """
        ...

    @overload
    def scaled(
        self, w: float, h: float, mode: PySide6.QtCore.Qt.AspectRatioMode
    ) -> PySide6.QtCore.QSizeF:
        """
        https://doc.qt.io/qt-6/qsizef.html#scaled-1

        **[since 5.0] QSizeF QSizeF::scaled(const QSizeF & s ,
        Qt::AspectRatioMode mode ) const**

        This is an overloaded function.

        Returns a size scaled to a rectangle with the given size **s** ,
        according to the specified **mode**.

        This function was introduced in Qt 5.0.
        """
        ...

    def setHeight(self, h: float) -> None:
        """
        https://doc.qt.io/qt-6/qsizef.html#setHeight

        **void QSizeF::setHeight(qreal height )**

        Sets the height to the given finite **height**.

        **See also** **height** (), **rheight** (), and **setWidth** ().
        """
        ...

    def setWidth(self, w: float) -> None:
        """
        https://doc.qt.io/qt-6/qsizef.html#setWidth

        **void QSizeF::setWidth(qreal width )**

        Sets the width to the given finite **width**.

        **See also** **width** (), **rwidth** (), and **setHeight** ().
        """
        ...

    def shrunkBy(
        self, m: Union[PySide6.QtCore.QMarginsF, PySide6.QtCore.QMargins]
    ) -> PySide6.QtCore.QSizeF:
        """
        https://doc.qt.io/qt-6/qsizef.html#shrunkBy

        **[since 5.14] QSizeF QSizeF::shrunkBy(QMarginsF margins ) const**

        Returns the size that results from shrinking this size by **margins**.

        This function was introduced in Qt 5.14.

        **See also** **grownBy** ().
        """
        ...

    def toSize(self) -> PySide6.QtCore.QSize:
        """
        https://doc.qt.io/qt-6/qsizef.html#toSize

        **QSize QSizeF::toSize() const**

        Returns an integer based copy of this size.

        Note that the coordinates in the returned size will be rounded to the
        nearest integer.

        **See also** **QSizeF** ().
        """
        ...

    def toTuple(self) -> object:
        ...

    def transpose(self) -> None:
        """
        https://doc.qt.io/qt-6/qsizef.html#transpose

        **void QSizeF::transpose()**

        Swaps the width and height values.

        **See also** **setWidth** (), **setHeight** (), and **transposed** ().
        """
        ...

    def transposed(self) -> PySide6.QtCore.QSizeF:
        """
        https://doc.qt.io/qt-6/qsizef.html#transposed

        **[since 5.0] QSizeF QSizeF::transposed() const**

        Returns the size with width and height values swapped.

        This function was introduced in Qt 5.0.

        **See also** **transpose** ().
        """
        ...

    def width(self) -> float:
        """
        https://doc.qt.io/qt-6/qsizef.html#width

        **qreal QSizeF::width() const**

        Returns the width.

        **See also** **height** () and **setWidth** ().
        """
        ...
