"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtCore, except for defaults which are replaced by "...".
"""
from enum import Enum
from typing import Any, List, Optional, overload
import PySide6.QtCore

bytes = str


class QSettings(PySide6.QtCore.QObject):
    """
    https://doc.qt.io/qt-6/qsettings.html

    **Detailed Description**

    Users normally expect an application to remember its settings (window sizes
    and positions, options, etc.) across sessions. This information is often
    stored in the system registry on Windows, and in property list files on
    macOS and iOS. On Unix systems, in the absence of a standard, many
    applications (including the KDE applications) use INI text files.

    QSettings is an abstraction around these technologies, enabling you to save
    and restore application settings in a portable manner. It also supports
    **custom storage formats** .

    QSettings's API is based on **QVariant** , allowing you to save most value-
    based types, such as **QString** , **QRect** , and **QImage** , with the
    minimum of effort.

    If all you need is a non-persistent memory-based structure, consider using
    **QMap** <**QString** , **QVariant** > instead.

    **Basic Usage**

    When creating a QSettings object, you must pass the name of your company or
    organization as well as the name of your application. For example, if your
    product is called Star Runner and your company is called MySoft, you would
    construct the QSettings object as follows:

    **QSettings**  settings("MySoft", "Star Runner");

    QSettings objects can be created either on the stack or on the heap (i.e.
    using `new`). Constructing and destroying a QSettings object is very fast.

    If you use QSettings from many places in your application, you might want to
    specify the organization name and the application name using
    **QCoreApplication::setOrganizationName** () and
    **QCoreApplication::setApplicationName** (), and then use the default
    QSettings constructor:

    **QCoreApplication** ::setOrganizationName("MySoft");
    **QCoreApplication** ::setOrganizationDomain("mysoft.com");
    **QCoreApplication** ::setApplicationName("Star Runner");
            ...
    **QSettings**  settings;

    (Here, we also specify the organization's Internet domain. When the Internet
    domain is set, it is used on macOS and iOS instead of the organization name,
    since macOS and iOS applications conventionally use Internet domains to
    identify themselves. If no domain is set, a fake domain is derived from the
    organization name. See the **Platform-Specific Notes**  below for details.)

    QSettings stores settings. Each setting consists of a **QString**  that
    specifies the setting's name (the **key** ) and a **QVariant**  that stores
    the data associated with the key. To write a setting, use **setValue** ().
    For example:

    settings.setValue("editor/wrapMargin", 68);

    If there already exists a setting with the same key, the existing value is
    overwritten by the new value. For efficiency, the changes may not be saved
    to permanent storage immediately. (You can always call **sync** () to commit
    your changes.)

    You can get a setting's value back using **value** ():

    int margin = settings.value("editor/wrapMargin").toInt();

    If there is no setting with the specified name, QSettings returns a null
    **QVariant**  (which can be converted to the integer 0). You can specify
    another default value by passing a second argument to **value** ():

    int margin = settings.value("editor/wrapMargin", 80).toInt();

    To test whether a given key exists, call **contains** (). To remove the
    setting associated with a key, call **remove** (). To obtain the list of all
    keys, call **allKeys** (). To remove all keys, call **clear** ().

    **QVariant and GUI Types**

    Because **QVariant**  is part of the Qt Core module, it cannot provide
    conversion functions to data types such as **QColor** , **QImage** , and
    **QPixmap** , which are part of Qt GUI. In other words, there is no
    `toColor()`, `toImage()`, or `toPixmap()` functions in **QVariant** .

    Instead, you can use the **QVariant::value** () template function. For
    example:

    **QSettings**  settings("MySoft", "Star Runner");
        **QColor**  color =
    settings.value("DataPump/bgcolor").value<**QColor** >();

    The inverse conversion (e.g., from **QColor**  to **QVariant** ) is
    automatic for all data types supported by **QVariant** , including GUI-
    related types:

    **QSettings**  settings("MySoft", "Star Runner");
        **QColor**  color =
    palette().background().color();
        settings.setValue("DataPump/bgcolor",
    color);

    Custom types registered using **qRegisterMetaType** () that have operators
    for streaming to and from a **QDataStream**  can be stored using QSettings.

    **Section and Key Syntax**

    Setting keys can contain any Unicode characters. The Windows registry and
    INI files use case-insensitive keys, whereas the CFPreferences API on macOS
    and iOS uses case-sensitive keys. To avoid portability problems, follow
    these simple rules:

    1. Always refer to the same key using the same case. For example, if you
    refer to a key as "text fonts" in one place in your code, don't refer to it
    as "Text Fonts" somewhere else.
      2. Avoid key names that are identical
    except for the case. For example, if you have a key called "MainWindow",
    don't try to save another key as "mainwindow".
      3. Do not use slashes ('/'
    and '\\') in section or key names; the backslash character is used to
    separate sub keys (see below). On windows '\\' are converted by QSettings to
    '/', which makes them identical.

    You can form hierarchical keys using the '/' character as a separator,
    similar to Unix file paths. For example:

    settings.setValue("mainwindow/size", win->size());
    settings.setValue("mainwindow/fullScreen", win->isFullScreen());
    settings.setValue("outputpanel/visible", panel->isVisible());

    If you want to save or restore many settings with the same prefix, you can
    specify the prefix using **beginGroup** () and call **endGroup** () at the
    end. Here's the same example again, but this time using the group mechanism:

    settings.beginGroup("mainwindow");
            settings.setValue("size",
    win->size());
            settings.setValue("fullScreen", win->isFullScreen());
    settings.endGroup();

            settings.beginGroup("outputpanel");
    settings.setValue("visible", panel->isVisible());
    settings.endGroup();

    If a group is set using **beginGroup** (), the behavior of most functions
    changes consequently. Groups can be set recursively.

    In addition to groups, QSettings also supports an "array" concept. See
    **beginReadArray** () and **beginWriteArray** () for details.

    **Fallback Mechanism**

    Let's assume that you have created a QSettings object with the organization
    name MySoft and the application name Star Runner. When you look up a value,
    up to four locations are searched in that order:

    1. a user-specific location for the Star Runner application
      2. a user-
    specific location for all applications by MySoft
      3. a system-wide location
    for the Star Runner application
      4. a system-wide location for all
    applications by MySoft

    (See **Platform-Specific Notes**  below for information on what these
    locations are on the different platforms supported by Qt.)

    If a key cannot be found in the first location, the search goes on in the
    second location, and so on. This enables you to store system-wide or
    organization-wide settings and to override them on a per-user or per-
    application basis. To turn off this mechanism, call **setFallbacksEnabled**
    (false).

    Although keys from all four locations are available for reading, only the
    first file (the user-specific location for the application at hand) is
    accessible for writing. To write to any of the other files, omit the
    application name and/or specify **QSettings::SystemScope**  (as opposed to
    **QSettings::UserScope** , the default).

    Let's see with an example:

    **QSettings**  obj1("MySoft", "Star Runner");
            **QSettings**
    obj2("MySoft");
            **QSettings**  obj3(**QSettings** ::SystemScope,
    "MySoft", "Star Runner");
            **QSettings**  obj4(**QSettings**
    ::SystemScope, "MySoft");

    The table below summarizes which QSettings objects access which location. "
    **X** " means that the location is the main location associated to the
    QSettings object and is used both for reading and for writing; "o" means
    that the location is used as a fallback when reading.

    Locations`obj1``obj2``obj3``obj4`
    1\\. User, Application **X**
    2\\. User,
    Organizationo **X**
    3\\. System, Applicationo **X**
    4\\. System,
    Organizationooo **X**

    The beauty of this mechanism is that it works on all platforms supported by
    Qt and that it still gives you a lot of flexibility, without requiring you
    to specify any file names or registry paths.

    If you want to use INI files on all platforms instead of the native API, you
    can pass **QSettings::IniFormat**  as the first argument to the QSettings
    constructor, followed by the scope, the organization name, and the
    application name:

    **QSettings**  settings(**QSettings** ::IniFormat, **QSettings**
    ::UserScope,
                               "MySoft", "Star Runner");

    Note that type information is not preserved when reading settings from INI
    files; all values will be returned as **QString** .

    The **Settings Editor**  example lets you experiment with different settings
    location and with fallbacks turned on or off.

    **Restoring the State of a GUI Application**

    QSettings is often used to store the state of a GUI application. The
    following example illustrates how to use QSettings to save and restore the
    geometry of an application's main window.

    void MainWindow::writeSettings()
        {
            **QSettings**
    settings("Moose Soft", "Clipper");
    settings.beginGroup("MainWindow");
            settings.setValue("geometry",
    saveGeometry());
            settings.endGroup();
        }

        void
    MainWindow::readSettings()
        {
            **QSettings**  settings("Moose
    Soft", "Clipper");

            settings.beginGroup("MainWindow");
    const auto geometry = settings.value("geometry", **QByteArray**
    ()).toByteArray();
            if (geometry.isEmpty())
    setGeometry(200, 200, 400, 400);
            else
    restoreGeometry(geometry)
            settings.endGroup();
        }

    See **Window Geometry**  for a discussion on why it is better to call
    **QWidget::resize** () and **QWidget::move** () rather than
    **QWidget::setGeometry** () to restore a window's geometry.

    The `readSettings()` and `writeSettings()` functions must be called from the
    main window's constructor and close event handler as follows:

    MainWindow::MainWindow()
        {
            ...
            readSettings();
        }
    void MainWindow::closeEvent(**QCloseEvent**  *event)
        {
            if
    (userReallyWantsToQuit()) {
                writeSettings();
    event->accept();
            } else {
                event->ignore();
            }
    }

    See the **Application**  example for a self-contained example that uses
    QSettings.

    **Accessing Settings from Multiple Threads or Processes Simultaneously**

    QSettings is **reentrant** . This means that you can use distinct QSettings
    object in different threads simultaneously. This guarantee stands even when
    the QSettings objects refer to the same files on disk (or to the same
    entries in the system registry). If a setting is modified through one
    QSettings object, the change will immediately be visible in any other
    QSettings objects that operate on the same location and that live in the
    same process.

    QSettings can safely be used from different processes (which can be
    different instances of your application running at the same time or
    different applications altogether) to read and write to the same system
    locations, provided certain conditions are met. For **QSettings::IniFormat**
    , it uses advisory file locking and a smart merging algorithm to ensure data
    integrity. The condition for that to work is that the writeable
    configuration file must be a regular file and must reside in a directory
    that the current user can create new, temporary files in. If that is not the
    case, then one must use **setAtomicSyncRequired** () to turn the safety off.

    Note that **sync** () imports changes made by other processes (in addition
    to writing the changes from this QSettings).

    **Platform-Specific Notes**

    **Locations Where Application Settings Are Stored**

    As mentioned in the **Fallback Mechanism**  section, QSettings stores
    settings for an application in up to four locations, depending on whether
    the settings are user-specific or system-wide and whether the settings are
    application-specific or organization-wide. For simplicity, we're assuming
    the organization is called MySoft and the application is called Star Runner.

    On Unix systems, if the file format is **NativeFormat** , the following
    files are used by default:

    1. `$HOME/.config/MySoft/Star Runner.conf` (Qt for Embedded Linux:
    `$HOME/Settings/MySoft/Star Runner.conf`)
      2. `$HOME/.config/MySoft.conf`
    (Qt for Embedded Linux: `$HOME/Settings/MySoft.conf`)
      3. for each
    directory <dir> in $XDG_CONFIG_DIRS: `<dir>/MySoft/Star Runner.conf`
      4.
    for each directory <dir> in $XDG_CONFIG_DIRS: `<dir>/MySoft.conf`

    **Note:** If XDG_CONFIG_DIRS is unset, the default value of `/etc/xdg` is
    used.

    On macOS and iOS, if the file format is **NativeFormat** , these files are
    used by default:

    1. `$HOME/Library/Preferences/com.MySoft.Star Runner.plist`
      2.
    `$HOME/Library/Preferences/com.MySoft.plist`
      3.
    `/Library/Preferences/com.MySoft.Star Runner.plist`
      4.
    `/Library/Preferences/com.MySoft.plist`

    On Windows, **NativeFormat**  settings are stored in the following registry
    paths:

    1. `HKEY_CURRENT_USER\\Software\\MySoft\\Star Runner`
      2.
    `HKEY_CURRENT_USER\\Software\\MySoft\\OrganizationDefaults`
      3.
    `HKEY_LOCAL_MACHINE\\Software\\MySoft\\Star Runner`
      4.
    `HKEY_LOCAL_MACHINE\\Software\\MySoft\\OrganizationDefaults`

    **Note:** On Windows, for 32-bit programs running in WOW64 mode, settings
    are stored in the following registry path:
    `HKEY_LOCAL_MACHINE\\Software\\WOW6432node`.

    If the file format is **NativeFormat** , this is "Settings/MySoft/Star
    Runner.conf" in the application's home directory.

    If the file format is **IniFormat** , the following files are used on Unix,
    macOS, and iOS:

    1. `$HOME/.config/MySoft/Star Runner.ini` (Qt for Embedded Linux:
    `$HOME/Settings/MySoft/Star Runner.ini`)
      2. `$HOME/.config/MySoft.ini` (Qt
    for Embedded Linux: `$HOME/Settings/MySoft.ini`)
      3. for each directory
    <dir> in $XDG_CONFIG_DIRS: `<dir>/MySoft/Star Runner.ini`
      4. for each
    directory <dir> in $XDG_CONFIG_DIRS: `<dir>/MySoft.ini`

    **Note:** If XDG_CONFIG_DIRS is unset, the default value of `/etc/xdg` is
    used.

    On Windows, the following files are used:

    1. `FOLDERID_RoamingAppData\\MySoft\\Star Runner.ini`
      2.
    `FOLDERID_RoamingAppData\\MySoft.ini`
      3. `FOLDERID_ProgramData\\MySoft\\Star
    Runner.ini`
      4. `FOLDERID_ProgramData\\MySoft.ini`

    The identifiers prefixed by `FOLDERID_` are special item ID lists to be
    passed to the Win32 API function `SHGetKnownFolderPath()` to obtain the
    corresponding path.

    `FOLDERID_RoamingAppData` usually points to `C:\\Users\\ **User Name**
    \\AppData\\Roaming`, also shown by the environment variable `%APPDATA%`.

    `FOLDERID_ProgramData` usually points to `C:\\ProgramData`.

    If the file format is **IniFormat** , this is "Settings/MySoft/Star
    Runner.ini" in the application's home directory.

    The paths for the `.ini` and `.conf` files can be changed using **setPath**
    (). On Unix, macOS, and iOS the user can override them by setting the
    `XDG_CONFIG_HOME` environment variable; see **setPath** () for details.

    **Accessing INI and .plist Files Directly**

    Sometimes you do want to access settings stored in a specific file or
    registry path. On all platforms, if you want to read an INI file directly,
    you can use the QSettings constructor that takes a file name as first
    argument and pass **QSettings::IniFormat**  as second argument. For example:

    **QSettings**  settings("/home/petra/misc/myapp.ini",
    **QSettings** ::IniFormat);

    You can then use the QSettings object to read and write settings in the
    file.

    On macOS and iOS, you can access property list `.plist` files by passing
    **QSettings::NativeFormat**  as second argument. For example:

    **QSettings**  settings("/Users/petra/misc/myapp.plist",
    **QSettings** ::NativeFormat);

    **Accessing the Windows Registry Directly**

    On Windows, QSettings lets you access settings that have been written with
    QSettings (or settings in a supported format, e.g., string data) in the
    system registry. This is done by constructing a QSettings object with a path
    in the registry and **QSettings::NativeFormat** .

    For example:

    **QSettings**  settings("HKEY_CURRENT_USER\\\\Software\\\\Microsoft\\\\Office",
    **QSettings** ::NativeFormat);

    All the registry entries that appear under the specified path can be read or
    written through the QSettings object as usual (using forward slashes instead
    of backslashes). For example:

    settings.setValue("11.0/Outlook/Security/DontTrustInstalledFiles", 0);

    Note that the backslash character is, as mentioned, used by QSettings to
    separate subkeys. As a result, you cannot read or write windows registry
    entries that contain slashes or backslashes; you should use a native windows
    API if you need to do so.

    **Accessing Common Registry Settings on Windows**

    On Windows, it is possible for a key to have both a value and subkeys. Its
    default value is accessed by using "Default" or "." in place of a subkey:

    settings.setValue("HKEY_CURRENT_USER\\\\MySoft\\\\Star Runner\\\\Galaxy",
    "Milkyway");
        settings.setValue("HKEY_CURRENT_USER\\\\MySoft\\\\Star
    Runner\\\\Galaxy\\\\Sun", "OurStar");
    settings.value("HKEY_CURRENT_USER\\\\MySoft\\\\Star Runner\\\\Galaxy\\\\Default");
    // returns "Milkyway"

    On other platforms than Windows, "Default" and "." would be treated as
    regular subkeys.

    **Platform Limitations**

    While QSettings attempts to smooth over the differences between the
    different supported platforms, there are still a few differences that you
    should be aware of when porting your application:

    * The Windows system registry has the following limitations: A subkey may
    not exceed 255 characters, an entry's value may not exceed 16,383
    characters, and all the values of a key may not exceed 65,535 characters.
    One way to work around these limitations is to store the settings using the
    **IniFormat**  instead of the **NativeFormat** .
      * On Windows, when the
    Windows system registry is used, QSettings does not preserve the original
    type of the value. Therefore, the type of the value might change when a new
    value is set. For example, a value with type `REG_EXPAND_SZ` will change to
    `REG_SZ`.
      * On macOS and iOS, **allKeys** () will return some extra keys
    for global settings that apply to all applications. These keys can be read
    using **value** () but cannot be changed, only shadowed. Calling
    **setFallbacksEnabled** (false) will hide these global settings.
      * On
    macOS and iOS, the CFPreferences API used by QSettings expects Internet
    domain names rather than organization names. To provide a uniform API,
    QSettings derives a fake domain name from the organization name (unless the
    organization name already is a domain name, e.g. OpenOffice.org). The
    algorithm appends ".com" to the company name and replaces spaces and other
    illegal characters with hyphens. If you want to specify a different domain
    name, call **QCoreApplication::setOrganizationDomain** (),
    **QCoreApplication::setOrganizationName** (), and
    **QCoreApplication::setApplicationName** () in your `main()` function and
    then use the default QSettings constructor. Another solution is to use
    preprocessor directives, for example:

            #ifdef Q_OS_MAC
    **QSettings**  settings("grenoullelogique.fr", "Squash");
        #else
    **QSettings**  settings("Grenoulle Logique", "Squash");
        #endif

      * On
    macOS, permissions to access settings not belonging to the current user
    (i.e. **SystemScope** ) have changed with 10.7 (Lion). Prior to that
    version, users having admin rights could access these. For 10.7 and 10.8
    (Mountain Lion), only root can. However, 10.9 (Mavericks) changes that rule
    again but only for the native format (plist files).

    **See also** **QVariant** , **QSessionManager** , **Settings Editor
    Example** , and **Qt Widgets - Application Example** .
    """

    NativeFormat: QSettings.Format = ...
    IniFormat: QSettings.Format = ...
    Registry32Format: QSettings.Format = ...
    Registry64Format: QSettings.Format = ...
    InvalidFormat: QSettings.Format = ...
    CustomFormat1: QSettings.Format = ...
    CustomFormat2: QSettings.Format = ...
    CustomFormat3: QSettings.Format = ...
    CustomFormat4: QSettings.Format = ...
    CustomFormat5: QSettings.Format = ...
    CustomFormat6: QSettings.Format = ...
    CustomFormat7: QSettings.Format = ...
    CustomFormat8: QSettings.Format = ...
    CustomFormat9: QSettings.Format = ...
    CustomFormat10: QSettings.Format = ...
    CustomFormat11: QSettings.Format = ...
    CustomFormat12: QSettings.Format = ...
    CustomFormat13: QSettings.Format = ...
    CustomFormat14: QSettings.Format = ...
    CustomFormat15: QSettings.Format = ...
    CustomFormat16: QSettings.Format = ...
    UserScope: QSettings.Scope = ...
    SystemScope: QSettings.Scope = ...
    NoError: QSettings.Status = ...
    AccessError: QSettings.Status = ...
    FormatError: QSettings.Status = ...

    class Format(Enum):
        NativeFormat: QSettings.Format = ...
        IniFormat: QSettings.Format = ...
        Registry32Format: QSettings.Format = ...
        Registry64Format: QSettings.Format = ...
        InvalidFormat: QSettings.Format = ...
        CustomFormat1: QSettings.Format = ...
        CustomFormat2: QSettings.Format = ...
        CustomFormat3: QSettings.Format = ...
        CustomFormat4: QSettings.Format = ...
        CustomFormat5: QSettings.Format = ...
        CustomFormat6: QSettings.Format = ...
        CustomFormat7: QSettings.Format = ...
        CustomFormat8: QSettings.Format = ...
        CustomFormat9: QSettings.Format = ...
        CustomFormat10: QSettings.Format = ...
        CustomFormat11: QSettings.Format = ...
        CustomFormat12: QSettings.Format = ...
        CustomFormat13: QSettings.Format = ...
        CustomFormat14: QSettings.Format = ...
        CustomFormat15: QSettings.Format = ...
        CustomFormat16: QSettings.Format = ...

    class Scope(Enum):
        UserScope: QSettings.Scope = ...
        SystemScope: QSettings.Scope = ...

    class Status(Enum):
        NoError: QSettings.Status = ...
        AccessError: QSettings.Status = ...
        FormatError: QSettings.Status = ...

    @overload
    def __init__(
        self,
        fileName: str,
        format: PySide6.QtCore.QSettings.Format,
        parent: Optional[PySide6.QtCore.QObject] = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qsettings.html#QSettings

        **QSettings::QSettings(const QString & organization , const QString &
        application = QString(), QObject * parent = nullptr)**

        Constructs a QSettings object for accessing settings of the application
        called **application** from the organization called **organization** ,
        and with parent **parent**.

        Example:

        QSettings settings("Moose Tech", "Facturo-Pro");

        The scope is set to **QSettings::UserScope** , and the format is set to
        **QSettings::NativeFormat**  (i.e. calling **setDefaultFormat** ()
        before calling this constructor has no effect).

        **See also** **setDefaultFormat** () and **Fallback Mechanism** .
        """
        ...

    @overload
    def __init__(
        self,
        format: PySide6.QtCore.QSettings.Format,
        scope: PySide6.QtCore.QSettings.Scope,
        organization: str,
        application: str = ...,
        parent: Optional[PySide6.QtCore.QObject] = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qsettings.html#QSettings-1

        **QSettings::QSettings(QSettings::Scope scope , const QString &
        organization , const QString & application = QString(), QObject * parent
        = nullptr)**

        Constructs a QSettings object for accessing settings of the application
        called **application** from the organization called **organization** ,
        and with parent **parent**.

        If **scope** is **QSettings::UserScope** , the QSettings object searches
        user-specific settings first, before it searches system-wide settings as
        a fallback. If **scope** is **QSettings::SystemScope** , the QSettings
        object ignores user-specific settings and provides access to system-wide
        settings.

        The storage format is set to **QSettings::NativeFormat**  (i.e. calling
        **setDefaultFormat** () before calling this constructor has no effect).

        If no application name is given, the QSettings object will only access
        the organization-wide **locations** .

        **See also** **setDefaultFormat** ().
        """
        ...

    @overload
    def __init__(
        self,
        organization: str,
        application: str = ...,
        parent: Optional[PySide6.QtCore.QObject] = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qsettings.html#QSettings-2

        **QSettings::QSettings(QSettings::Format format , QSettings::Scope scope
        , const QString & organization , const QString & application =
        QString(), QObject * parent = nullptr)**

        Constructs a QSettings object for accessing settings of the application
        called **application** from the organization called **organization** ,
        and with parent **parent**.

        If **scope** is **QSettings::UserScope** , the QSettings object searches
        user-specific settings first, before it searches system-wide settings as
        a fallback. If **scope** is **QSettings::SystemScope** , the QSettings
        object ignores user-specific settings and provides access to system-wide
        settings.

        If **format** is **QSettings::NativeFormat** , the native API is used
        for storing settings. If **format** is **QSettings::IniFormat** , the
        INI format is used.

        If no application name is given, the QSettings object will only access
        the organization-wide **locations** .
        """
        ...

    @overload
    def __init__(self, parent: Optional[PySide6.QtCore.QObject] = ...) -> None:
        """
        https://doc.qt.io/qt-6/qsettings.html#QSettings-3

        **QSettings::QSettings(const QString & fileName , QSettings::Format
        format , QObject * parent = nullptr)**

        Constructs a QSettings object for accessing the settings stored in the
        file called **fileName** , with parent **parent**. If the file doesn't
        already exist, it is created.

        If **format** is **QSettings::NativeFormat** , the meaning of
        **fileName** depends on the platform. On Unix, **fileName** is the name
        of an INI file. On macOS and iOS, **fileName** is the name of a `.plist`
        file. On Windows, **fileName** is a path in the system registry.

        If **format** is **QSettings::IniFormat** , **fileName** is the name of
        an INI file.

        **Warning:** This function is provided for convenience. It works well
        for accessing INI or `.plist` files generated by Qt, but might fail on
        some syntaxes found in such files originated by other programs. In
        particular, be aware of the following limitations:

        * QSettings provides no way of reading INI "path" entries, i.e., entries
        with unescaped slash characters. (This is because these entries are
        ambiguous and cannot be resolved automatically.)
          * In INI files,
        QSettings uses the `@` character as a metacharacter in some contexts, to
        encode Qt-specific data types (e.g., `@Rect`), and might therefore
        misinterpret it when it occurs in pure INI files.

        **See also** **fileName** ().
        """
        ...

    @overload
    def __init__(
        self,
        scope: PySide6.QtCore.QSettings.Scope,
        organization: str,
        application: str = ...,
        parent: Optional[PySide6.QtCore.QObject] = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qsettings.html#QSettings-4

        **QSettings::QSettings(QObject * parent = nullptr)**

        Constructs a QSettings object for accessing settings of the application
        and organization set previously with a call to
        **QCoreApplication::setOrganizationName** (),
        **QCoreApplication::setOrganizationDomain** (), and
        **QCoreApplication::setApplicationName** ().

        The scope is **QSettings::UserScope**  and the format is
        **defaultFormat** () (**QSettings::NativeFormat**  by default). Use
        **setDefaultFormat** () before calling this constructor to change the
        default format used by this constructor.

        The code

        **QSettings**  settings("Moose Soft", "Facturo-Pro");

        is equivalent to

        **QCoreApplication** ::setOrganizationName("Moose Soft");
        **QCoreApplication** ::setApplicationName("Facturo-Pro");
        **QSettings**  settings;

        If **QCoreApplication::setOrganizationName** () and
        **QCoreApplication::setApplicationName** () has not been previously
        called, the QSettings object will not be able to read or write any
        settings, and **status** () will return **AccessError** .

        You should supply both the domain (used by default on macOS and iOS) and
        the name (used by default elsewhere), although the code will cope if you
        supply only one, which will then be used (on all platforms), at odds
        with the usual naming of the file on platforms for which it isn't the
        default.

        **See also** **QCoreApplication::setOrganizationName** (),
        **QCoreApplication::setOrganizationDomain** (),
        **QCoreApplication::setApplicationName** (), and **setDefaultFormat**
        ().
        """
        ...

    @overload
    def __init__(
        self,
        scope: PySide6.QtCore.QSettings.Scope,
        parent: Optional[PySide6.QtCore.QObject] = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qsettings.html#QSettings-5

        **[since 5.13] QSettings::QSettings(QSettings::Scope scope , QObject *
        parent = nullptr)**

        Constructs a QSettings object in the same way as QSettings(**QObject**
        *parent) but with the given **scope**.

        This function was introduced in Qt 5.13.

        **See also** **QSettings** (QObject *parent).
        """
        ...

    def allKeys(self) -> List[str]:
        """
        https://doc.qt.io/qt-6/qsettings.html#allKeys

        **QStringList QSettings::allKeys() const**

        Returns a list of all keys, including subkeys, that can be read using
        the **QSettings**  object.

        Example:

        **QSettings**  settings;
            settings.setValue("fridge/color",
        **QColor** (Qt::white));
            settings.setValue("fridge/size", **QSize**
        (32, 96));
            settings.setValue("sofa", true);
        settings.setValue("tv", false);

            **QStringList**  keys =
        settings.allKeys();
            // keys: ["fridge/color", "fridge/size", "sofa",
        "tv"]

        If a group is set using **beginGroup** (), only the keys in the group
        are returned, without the group prefix:

        settings.beginGroup("fridge");
            keys = settings.allKeys();
            //
        keys: ["color", "size"]

        **See also** **childGroups** () and **childKeys** ().
        """
        ...

    def applicationName(self) -> str:
        """
        https://doc.qt.io/qt-6/qsettings.html#applicationName

        **QString QSettings::applicationName() const**

        Returns the application name used for storing the settings.

        **See also** **QCoreApplication::applicationName** (), **format** (),
        **scope** (), and **organizationName** ().
        """
        ...

    def beginGroup(self, prefix: str) -> None:
        """
        https://doc.qt.io/qt-6/qsettings.html#beginGroup

        **void QSettings::beginGroup(const QString & prefix )**

        Appends **prefix** to the current group.

        The current group is automatically prepended to all keys specified to
        **QSettings** . In addition, query functions such as **childGroups** (),
        **childKeys** (), and **allKeys** () are based on the group. By default,
        no group is set.

        Groups are useful to avoid typing in the same setting paths over and
        over. For example:

        settings.beginGroup("mainwindow");
            settings.setValue("size",
        win->size());
            settings.setValue("fullScreen", win->isFullScreen());
        settings.endGroup();

            settings.beginGroup("outputpanel");
        settings.setValue("visible", panel->isVisible());
        settings.endGroup();

        This will set the value of three settings:

        * `mainwindow/size`
          * `mainwindow/fullScreen`
          *
        `outputpanel/visible`

        Call **endGroup** () to reset the current group to what it was before
        the corresponding beginGroup() call. Groups can be nested.

        **See also** **endGroup** () and **group** ().
        """
        ...

    def beginReadArray(self, prefix: str) -> int:
        """
        https://doc.qt.io/qt-6/qsettings.html#beginReadArray

        **int QSettings::beginReadArray(const QString & prefix )**

        Adds **prefix** to the current group and starts reading from an array.
        Returns the size of the array.

        Example:

        struct Login {
                **QString**  userName;
                **QString**
        password;
            };
            **QList** <Login> logins;
            ...
        **QSettings**  settings;
            int size =
        settings.beginReadArray("logins");
            for (int i = 0; i < size; ++i) {
        settings.setArrayIndex(i);
                Login login;
                login.userName =
        settings.value("userName").toString();
                login.password =
        settings.value("password").toString();
                logins.append(login);
        }
            settings.endArray();

        Use **beginWriteArray** () to write the array in the first place.

        **See also** **beginWriteArray** (), **endArray** (), and
        **setArrayIndex** ().
        """
        ...

    def beginWriteArray(self, prefix: str, size: int = ...) -> None:
        """
        https://doc.qt.io/qt-6/qsettings.html#beginWriteArray

        **void QSettings::beginWriteArray(const QString & prefix , int size =
        -1)**

        Adds **prefix** to the current group and starts writing an array of size
        **size**. If **size** is -1 (the default), it is automatically
        determined based on the indexes of the entries written.

        If you have many occurrences of a certain set of keys, you can use
        arrays to make your life easier. For example, let's suppose that you
        want to save a variable-length list of user names and passwords. You
        could then write:

        struct Login {
                **QString**  userName;
                **QString**
        password;
            };
            **QList** <Login> logins;
            ...
        **QSettings**  settings;
            settings.beginWriteArray("logins");
            for
        (int i = 0; i < logins.size(); ++i) {
                settings.setArrayIndex(i);
        settings.setValue("userName", list.at(i).userName);
        settings.setValue("password", list.at(i).password);
            }
        settings.endArray();

        The generated keys will have the form

        * `logins/size`
          * `logins/1/userName`
          * `logins/1/password`
          *
        `logins/2/userName`
          * `logins/2/password`
          * `logins/3/userName`
          *
        `logins/3/password`
          * ...

        To read back an array, use **beginReadArray** ().

        **See also** **beginReadArray** (), **endArray** (), and
        **setArrayIndex** ().
        """
        ...

    def childGroups(self) -> List[str]:
        """
        https://doc.qt.io/qt-6/qsettings.html#childGroups

        **QStringList QSettings::childGroups() const**

        Returns a list of all key top-level groups that contain keys that can be
        read using the **QSettings**  object.

        Example:

        **QSettings**  settings;
            settings.setValue("fridge/color",
        **QColor** (Qt::white));
            settings.setValue("fridge/size", **QSize**
        (32, 96));
            settings.setValue("sofa", true);
        settings.setValue("tv", false);

            **QStringList**  groups =
        settings.childGroups();
            // groups: ["fridge"]

        If a group is set using **beginGroup** (), the first-level keys in that
        group are returned, without the group prefix.

        settings.beginGroup("fridge");
            groups = settings.childGroups();
        // groups: []

        You can navigate through the entire setting hierarchy using
        **childKeys** () and childGroups() recursively.

        **See also** **childKeys** () and **allKeys** ().
        """
        ...

    def childKeys(self) -> List[str]:
        """
        https://doc.qt.io/qt-6/qsettings.html#childKeys

        **QStringList QSettings::childKeys() const**

        Returns a list of all top-level keys that can be read using the
        **QSettings**  object.

        Example:

        **QSettings**  settings;
            settings.setValue("fridge/color",
        **QColor** (Qt::white));
            settings.setValue("fridge/size", **QSize**
        (32, 96));
            settings.setValue("sofa", true);
        settings.setValue("tv", false);

            **QStringList**  keys =
        settings.childKeys();
            // keys: ["sofa", "tv"]

        If a group is set using **beginGroup** (), the top-level keys in that
        group are returned, without the group prefix:

        settings.beginGroup("fridge");
            keys = settings.childKeys();
            //
        keys: ["color", "size"]

        You can navigate through the entire setting hierarchy using childKeys()
        and **childGroups** () recursively.

        **See also** **childGroups** () and **allKeys** ().
        """
        ...

    def clear(self) -> None:
        """
        https://doc.qt.io/qt-6/qsettings.html#clear

        **void QSettings::clear()**

        Removes all entries in the primary location associated to this
        **QSettings**  object.

        Entries in fallback locations are not removed.

        If you only want to remove the entries in the current **group** (), use
        remove("") instead.

        **See also** **remove** () and **setFallbacksEnabled** ().
        """
        ...

    def contains(self, key: str) -> bool:
        """
        https://doc.qt.io/qt-6/qsettings.html#contains

        **bool QSettings::contains(const QString & key ) const**

        Returns `true` if there exists a setting called **key** ; returns false
        otherwise.

        If a group is set using **beginGroup** (), **key** is taken to be
        relative to that group.

        Note that the Windows registry and INI files use case-insensitive keys,
        whereas the CFPreferences API on macOS and iOS uses case-sensitive keys.
        To avoid portability problems, see the **Section and Key Syntax**
        rules.

        **See also** **value** () and **setValue** ().
        """
        ...

    @staticmethod
    def defaultFormat() -> PySide6.QtCore.QSettings.Format:
        """
        https://doc.qt.io/qt-6/qsettings.html#defaultFormat

        **[static] QSettings::Format QSettings::defaultFormat()**

        Returns default file format used for storing settings for the
        **QSettings** (**QObject**  *) constructor. If no default format is set,
        **QSettings::NativeFormat**  is used.

        **See also** **setDefaultFormat** () and **format** ().
        """
        ...

    def endArray(self) -> None:
        """
        https://doc.qt.io/qt-6/qsettings.html#endArray

        **void QSettings::endArray()**

        Closes the array that was started using **beginReadArray** () or
        **beginWriteArray** ().

        **See also** **beginReadArray** () and **beginWriteArray** ().
        """
        ...

    def endGroup(self) -> None:
        """
        https://doc.qt.io/qt-6/qsettings.html#endGroup

        **void QSettings::endGroup()**

        Resets the group to what it was before the corresponding **beginGroup**
        () call.

        Example:

        settings.beginGroup("alpha");
            // settings.group() == "alpha"
        settings.beginGroup("beta");
            // settings.group() == "alpha/beta"
        settings.endGroup();
            // settings.group() == "alpha"
        settings.endGroup();
            // settings.group() == ""

        **See also** **beginGroup** () and **group** ().
        """
        ...

    def event(self, event: PySide6.QtCore.QEvent) -> bool:
        """
        https://doc.qt.io/qt-6/qsettings.html#event

        **[override virtual protected] bool QSettings::event(QEvent * event )**

        Reimplements: **QObject::event** (QEvent *e).
        """
        ...

    def fallbacksEnabled(self) -> bool:
        """
        https://doc.qt.io/qt-6/qsettings.html#fallbacksEnabled

        **bool QSettings::fallbacksEnabled() const**

        Returns `true` if fallbacks are enabled; returns `false` otherwise.

        By default, fallbacks are enabled.

        **See also** **setFallbacksEnabled** ().
        """
        ...

    def fileName(self) -> str:
        """
        https://doc.qt.io/qt-6/qsettings.html#fileName

        **QString QSettings::fileName() const**

        Returns the path where settings written using this **QSettings**  object
        are stored.

        On Windows, if the format is **QSettings::NativeFormat** , the return
        value is a system registry path, not a file path.

        **See also** **isWritable** () and **format** ().
        """
        ...

    def format(self) -> PySide6.QtCore.QSettings.Format:
        """
        https://doc.qt.io/qt-6/qsettings.html#format

        **QSettings::Format QSettings::format() const**

        Returns the format used for storing the settings.

        **See also** **defaultFormat** (), **fileName** (), **scope** (),
        **organizationName** (), and **applicationName** ().
        """
        ...

    def group(self) -> str:
        """
        https://doc.qt.io/qt-6/qsettings.html#group

        **QString QSettings::group() const**

        Returns the current group.

        **See also** **beginGroup** () and **endGroup** ().
        """
        ...

    def isAtomicSyncRequired(self) -> bool:
        """
        https://doc.qt.io/qt-6/qsettings.html#isAtomicSyncRequired

        **[since 5.10] bool QSettings::isAtomicSyncRequired() const**

        Returns `true` if **QSettings**  is only allowed to perform atomic
        saving and reloading (synchronization) of the settings. Returns `false`
        if it is allowed to save the settings contents directly to the
        configuration file.

        The default is `true`.

        This function was introduced in Qt 5.10.

        **See also** **setAtomicSyncRequired** () and **QSaveFile** .
        """
        ...

    def isWritable(self) -> bool:
        """
        https://doc.qt.io/qt-6/qsettings.html#isWritable

        **bool QSettings::isWritable() const**

        Returns `true` if settings can be written using this **QSettings**
        object; returns `false` otherwise.

        One reason why isWritable() might return false is if **QSettings**
        operates on a read-only file.

        **Warning:** This function is not perfectly reliable, because the file
        permissions can change at any time.

        **See also** **fileName** (), **status** (), and **sync** ().
        """
        ...

    def organizationName(self) -> str:
        """
        https://doc.qt.io/qt-6/qsettings.html#organizationName

        **QString QSettings::organizationName() const**

        Returns the organization name used for storing the settings.

        **See also** **QCoreApplication::organizationName** (), **format** (),
        **scope** (), and **applicationName** ().
        """
        ...

    def remove(self, key: str) -> None:
        """
        https://doc.qt.io/qt-6/qsettings.html#remove

        **void QSettings::remove(const QString & key )**

        Removes the setting **key** and any sub-settings of **key**.

        Example:

        **QSettings**  settings;
            settings.setValue("ape");
        settings.setValue("monkey", 1);
            settings.setValue("monkey/sea", 2);
        settings.setValue("monkey/doe", 4);

            settings.remove("monkey");
        **QStringList**  keys = settings.allKeys();
            // keys: ["ape"]

        Be aware that if one of the fallback locations contains a setting with
        the same key, that setting will be visible after calling remove().

        If **key** is an empty string, all keys in the current **group** () are
        removed. For example:

        **QSettings**  settings;
            settings.setValue("ape");
        settings.setValue("monkey", 1);
            settings.setValue("monkey/sea", 2);
        settings.setValue("monkey/doe", 4);
        settings.beginGroup("monkey");
            settings.remove("");
        settings.endGroup();

            **QStringList**  keys =
        settings.allKeys();
            // keys: ["ape"]

        Note that the Windows registry and INI files use case-insensitive keys,
        whereas the CFPreferences API on macOS and iOS uses case-sensitive keys.
        To avoid portability problems, see the **Section and Key Syntax**
        rules.

        **See also** **setValue** (), **value** (), and **contains** ().
        """
        ...

    def scope(self) -> PySide6.QtCore.QSettings.Scope:
        """
        https://doc.qt.io/qt-6/qsettings.html#scope

        **QSettings::Scope QSettings::scope() const**

        Returns the scope used for storing the settings.

        **See also** **format** (), **organizationName** (), and
        **applicationName** ().
        """
        ...

    def setArrayIndex(self, i: int) -> None:
        """
        https://doc.qt.io/qt-6/qsettings.html#setArrayIndex

        **void QSettings::setArrayIndex(int i )**

        Sets the current array index to **i**. Calls to functions such as
        **setValue** (), **value** (), **remove** (), and **contains** () will
        operate on the array entry at that index.

        You must call **beginReadArray** () or **beginWriteArray** () before you
        can call this function.
        """
        ...

    def setAtomicSyncRequired(self, enable: bool) -> None:
        """
        https://doc.qt.io/qt-6/qsettings.html#setAtomicSyncRequired

        **[since 5.10] void QSettings::setAtomicSyncRequired(bool enable )**

        Configures whether **QSettings**  is required to perform atomic saving
        and reloading (synchronization) of the settings. If the **enable**
        argument is `true` (the default), **sync** () will only perform
        synchronization operations that are atomic. If this is not possible,
        **sync** () will fail and **status** () will be an error condition.

        Setting this property to `false` will allow **QSettings**  to write
        directly to the configuration file and ignore any errors trying to lock
        it against other processes trying to write at the same time. Because of
        the potential for corruption, this option should be used with care, but
        is required in certain conditions, like a **QSettings::IniFormat**
        configuration file that exists in an otherwise non-writeable directory
        or NTFS Alternate Data Streams.

        See **QSaveFile**  for more information on the feature.

        This function was introduced in Qt 5.10.

        **See also** **isAtomicSyncRequired** () and **QSaveFile** .
        """
        ...

    @staticmethod
    def setDefaultFormat(format: PySide6.QtCore.QSettings.Format) -> None:
        """
        https://doc.qt.io/qt-6/qsettings.html#setDefaultFormat

        **[static] void QSettings::setDefaultFormat(QSettings::Format format )**

        Sets the default file format to the given **format** , which is used for
        storing settings for the **QSettings** (**QObject**  *) constructor.

        If no default format is set, **QSettings::NativeFormat**  is used. See
        the documentation for the **QSettings**  constructor you are using to
        see if that constructor will ignore this function.

        **See also** **defaultFormat** () and **format** ().
        """
        ...

    def setFallbacksEnabled(self, b: bool) -> None:
        """
        https://doc.qt.io/qt-6/qsettings.html#setFallbacksEnabled

        **void QSettings::setFallbacksEnabled(bool b )**

        Sets whether fallbacks are enabled to **b**.

        By default, fallbacks are enabled.

        **See also** **fallbacksEnabled** ().
        """
        ...

    @staticmethod
    def setPath(
        format: PySide6.QtCore.QSettings.Format,
        scope: PySide6.QtCore.QSettings.Scope,
        path: str,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qsettings.html#setPath

        **[static] void QSettings::setPath(QSettings::Format format ,
        QSettings::Scope scope , const QString & path )**

        Sets the path used for storing settings for the given **format** and
        **scope** , to **path**. The **format** can be a custom format.

        The table below summarizes the default values:

        PlatformFormatScopePath
        Windows**IniFormat** **UserScope**
        `FOLDERID_RoamingAppData`
        **SystemScope** `FOLDERID_ProgramData`
        Unix**NativeFormat** , **IniFormat** **UserScope** `$HOME/.config`
        **SystemScope** `/etc/xdg`
        Qt for Embedded Linux**NativeFormat** ,
        **IniFormat** **UserScope** `$HOME/Settings`
        **SystemScope**
        `/etc/xdg`
        macOS and iOS**IniFormat** **UserScope** `$HOME/.config`
        **SystemScope** `/etc/xdg`

        The default **UserScope**  paths on Unix, macOS, and iOS
        (`$HOME/.config` or $HOME/Settings) can be overridden by the user by
        setting the `XDG_CONFIG_HOME` environment variable. The default
        **SystemScope**  paths on Unix, macOS, and iOS (`/etc/xdg`) can be
        overridden when building the Qt library using the `configure` script's
        `-sysconfdir` flag (see **QLibraryInfo**  for details).

        Setting the **NativeFormat**  paths on Windows, macOS, and iOS has no
        effect.

        **Warning:** This function doesn't affect existing **QSettings**
        objects.

        **See also** **registerFormat** ().
        """
        ...

    def setValue(self, key: str, value: Any) -> None:
        """
        https://doc.qt.io/qt-6/qsettings.html#setValue

        **void QSettings::setValue(const QString & key , const QVariant & value
        )**

        Sets the value of setting **key** to **value**. If the **key** already
        exists, the previous value is overwritten.

        Note that the Windows registry and INI files use case-insensitive keys,
        whereas the CFPreferences API on macOS and iOS uses case-sensitive keys.
        To avoid portability problems, see the **Section and Key Syntax**
        rules.

        Example:

        **QSettings**  settings;
            settings.setValue("interval", 30);
        settings.value("interval").toInt();     // returns 30
        settings.setValue("interval", 6.55);
        settings.value("interval").toDouble();  // returns 6.55

        **See also** **value** (), **remove** (), and **contains** ().
        """
        ...

    def status(self) -> PySide6.QtCore.QSettings.Status:
        """
        https://doc.qt.io/qt-6/qsettings.html#status

        **QSettings::Status QSettings::status() const**

        Returns a status code indicating the first error that was met by
        **QSettings** , or **QSettings::NoError**  if no error occurred.

        Be aware that **QSettings**  delays performing some operations. For this
        reason, you might want to call **sync** () to ensure that the data
        stored in **QSettings**  is written to disk before calling status().

        **See also** **sync** ().
        """
        ...

    def sync(self) -> None:
        """
        https://doc.qt.io/qt-6/qsettings.html#sync

        **void QSettings::sync()**

        Writes any unsaved changes to permanent storage, and reloads any
        settings that have been changed in the meantime by another application.

        This function is called automatically from **QSettings** 's destructor
        and by the event loop at regular intervals, so you normally don't need
        to call it yourself.

        **See also** **status** ().
        """
        ...

    def value(
        self, arg__1: str, defaultValue: Optional[Any] = ..., type: object = ...
    ) -> object:
        """
        https://doc.qt.io/qt-6/qsettings.html#value

        **QVariant QSettings::value(const QString & key , const QVariant &
        defaultValue = QVariant()) const**

        Returns the value for setting **key**. If the setting doesn't exist,
        returns **defaultValue**.

        If no default value is specified, a default **QVariant**  is returned.

        Note that the Windows registry and INI files use case-insensitive keys,
        whereas the CFPreferences API on macOS and iOS uses case-sensitive keys.
        To avoid portability problems, see the **Section and Key Syntax**
        rules.

        Example:

        **QSettings**  settings;
            settings.setValue("animal/snake", 58);
        settings.value("animal/snake", 1024).toInt();   // returns 58
        settings.value("animal/zebra", 1024).toInt();   // returns 1024
        settings.value("animal/zebra").toInt();         // returns 0

        **See also** **setValue** (), **contains** (), and **remove** ().
        """
        ...
