"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtCore, except for defaults which are replaced by "...".
"""
from typing import Optional
import PySide6.QtCore

bytes = str


class QSequentialAnimationGroup(PySide6.QtCore.QAnimationGroup):
    """
    https://doc.qt.io/qt-6/qsequentialanimationgroup.html

    **Detailed Description**

    QSequentialAnimationGroup is a **QAnimationGroup**  that runs its animations
    in sequence, i.e., it starts one animation after another has finished
    playing. The animations are played in the order they are added to the group
    (using **addAnimation** () or **insertAnimation** ()). The animation group
    finishes when its last animation has finished.

    At each moment there is at most one animation that is active in the group;
    it is returned by **currentAnimation** (). An empty group has no current
    animation.

    A sequential animation group can be treated as any other animation, i.e., it
    can be started, stopped, and added to other groups. You can also call
    **addPause** () or **insertPause** () to add a pause to a sequential
    animation group.

    **QSequentialAnimationGroup**  *group = new **QSequentialAnimationGroup** ;
    group->addAnimation(anim1);
            group->addAnimation(anim2);
    group->start();

    In this example, `anim1` and `anim2` are two already set up
    **QPropertyAnimation** s.

    **See also** **QAnimationGroup** , **QAbstractAnimation** , and **The
    Animation Framework** .
    """

    def __init__(self, parent: Optional[PySide6.QtCore.QObject] = ...) -> None:
        """
        https://doc.qt.io/qt-6/qsequentialanimationgroup.html#QSequentialAnimati
        onGroup

        **QSequentialAnimationGroup::QSequentialAnimationGroup(QObject * parent
        = nullptr)**

        Constructs a QSequentialAnimationGroup. **parent** is passed to
        **QObject** 's constructor.
        """
        ...

    def addPause(self, msecs: int) -> PySide6.QtCore.QPauseAnimation:
        """
        https://doc.qt.io/qt-6/qsequentialanimationgroup.html#addPause

        **QPauseAnimation *QSequentialAnimationGroup::addPause(int msecs )**

        Adds a pause of **msecs** to this animation group. The pause is
        considered as a special type of animation, thus **animationCount**  will
        be increased by one.

        **See also** **insertPause** () and **QAnimationGroup::addAnimation**
        ().
        """
        ...

    def currentAnimation(self) -> PySide6.QtCore.QAbstractAnimation:
        """
        https://doc.qt.io/qt-6/qsequentialanimationgroup.html#currentAnimation-
        prop

        **[bindable read-only] currentAnimation : QAbstractAnimation***

        **Note:** This property supports **QProperty**  bindings.

        This property holds the animation in the current time.

        **Member Function Documentation**
        """
        ...

    def duration(self) -> int:
        """
        https://doc.qt.io/qt-6/qsequentialanimationgroup.html#duration

        **[override virtual] int QSequentialAnimationGroup::duration() const**

        Reimplements: **QAbstractAnimation::duration() const** .
        """
        ...

    def event(self, event: PySide6.QtCore.QEvent) -> bool:
        """
        https://doc.qt.io/qt-6/qsequentialanimationgroup.html#event

        **[override virtual protected] bool
        QSequentialAnimationGroup::event(QEvent * event )**

        Reimplements: **QAnimationGroup::event** (QEvent *event).
        """
        ...

    def insertPause(self, index: int, msecs: int) -> PySide6.QtCore.QPauseAnimation:
        """
        https://doc.qt.io/qt-6/qsequentialanimationgroup.html#insertPause

        **QPauseAnimation *QSequentialAnimationGroup::insertPause(int index ,
        int msecs )**

        Inserts a pause of **msecs** milliseconds at **index** in this animation
        group.

        **See also** **addPause** () and **QAnimationGroup::insertAnimation**
        ().
        """
        ...

    def updateCurrentTime(self, arg__1: int) -> None:
        """
        https://doc.qt.io/qt-6/qsequentialanimationgroup.html#updateCurrentTime

        **[override virtual protected] void
        QSequentialAnimationGroup::updateCurrentTime(int currentTime )**

        Reimplements: **QAbstractAnimation::updateCurrentTime** (int
        currentTime).
        """
        ...

    def updateDirection(
        self, direction: PySide6.QtCore.QAbstractAnimation.Direction
    ) -> None:
        """
        https://doc.qt.io/qt-6/qsequentialanimationgroup.html#updateDirection

        **[override virtual protected] void
        QSequentialAnimationGroup::updateDirection(QAbstractAnimation::Direction
        direction )**

        Reimplements: **QAbstractAnimation::updateDirection**
        (QAbstractAnimation::Direction direction).
        """
        ...

    def updateState(
        self,
        newState: PySide6.QtCore.QAbstractAnimation.State,
        oldState: PySide6.QtCore.QAbstractAnimation.State,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qsequentialanimationgroup.html#updateState

        **[override virtual protected] void
        QSequentialAnimationGroup::updateState(QAbstractAnimation::State
        newState , QAbstractAnimation::State oldState )**

        Reimplements: **QAbstractAnimation::updateState**
        (QAbstractAnimation::State newState, QAbstractAnimation::State
        oldState).
        """
        ...

    @property
    def currentAnimationChanged(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qsequentialanimationgroup.html#currentAnimationCh
        anged

        **[signal] void
        QSequentialAnimationGroup::currentAnimationChanged(QAbstractAnimation *
        current )**

        **QSequentialAnimationGroup**  emits this signal when
        **currentAnimation**  has been changed. **current** is the current
        animation.

        **Note:** Notifier signal for property **currentAnimation** .

        **See also** **currentAnimation** ().
        """
        ...
