"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtCore, except for defaults which are replaced by "...".
"""
from typing import Tuple, overload
import PySide6.QtCore

bytes = str


class QRect(object):
    """
    https://doc.qt.io/qt-6/qrect.html

    **Detailed Description**

    A rectangle is normally expressed as a top-left corner and a size. The size
    (width and height) of a QRect is always equivalent to the mathematical
    rectangle that forms the basis for its rendering.

    A QRect can be constructed with a set of left, top, width and height
    integers, or from a **QPoint**  and a **QSize** . The following code creates
    two identical rectangles.

    **QRect**  r1(100, 200, 11, 16);
        **QRect**  r2(**QPoint** (100, 200),
    **QSize** (11, 16));

    There is a third constructor that creates a QRect using the top-left and
    bottom-right coordinates, but we recommend that you avoid using it. The
    rationale is that for historical reasons the values returned by the
    **bottom** () and **right** () functions deviate from the true bottom-right
    corner of the rectangle.

    The QRect class provides a collection of functions that return the various
    rectangle coordinates, and enable manipulation of these. QRect also provides
    functions to move the rectangle relative to the various coordinates. In
    addition there is a **moveTo** () function that moves the rectangle, leaving
    its top left corner at the given coordinates. Alternatively, the
    **translate** () function moves the rectangle the given offset relative to
    the current position, and the **translated** () function returns a
    translated copy of this rectangle.

    The **size** () function returns the rectangle's dimensions as a **QSize** .
    The dimensions can also be retrieved separately using the **width** () and
    **height** () functions. To manipulate the dimensions use the **setSize**
    (), **setWidth** () or **setHeight** () functions. Alternatively, the size
    can be changed by applying either of the functions setting the rectangle
    coordinates, for example, **setBottom** () or **setRight** ().

    The **contains** () function tells whether a given point is inside the
    rectangle or not, and the **intersects** () function returns `true` if this
    rectangle intersects with a given rectangle. The QRect class also provides
    the **intersected** () function which returns the intersection rectangle,
    and the **united** () function which returns the rectangle that encloses the
    given rectangle and this:

    ![](images/qrect-intersect.png)![](images/qrect-unite.png)
    **intersected**
    ()**united** ()

    The **isEmpty** () function returns `true` if **left** () > **right** () or
    **top** () > **bottom** (). Note that an empty rectangle is not valid: The
    **isValid** () function returns `true` if **left** () <= **right** ()
    **and** **top** () <= **bottom** (). A null rectangle (**isNull** () ==
    true) on the other hand, has both width and height set to 0.

    Note that due to the way QRect and **QRectF**  are defined, an empty QRect
    is defined in essentially the same way as **QRectF** .

    Finally, QRect objects can be streamed as well as compared.

    **Rendering**

    When using an **anti-aliased**  painter, the boundary line of a QRect will
    be rendered symmetrically on both sides of the mathematical rectangle's
    boundary line. But when using an aliased painter (the default) other rules
    apply.

    Then, when rendering with a one pixel wide pen the QRect's boundary line
    will be rendered to the right and below the mathematical rectangle's
    boundary line.

    When rendering with a two pixels wide pen the boundary line will be split in
    the middle by the mathematical rectangle. This will be the case whenever the
    pen is set to an even number of pixels, while rendering with a pen with an
    odd number of pixels, the spare pixel will be rendered to the right and
    below the mathematical rectangle as in the one pixel case.

    ![](images/qrect-diagram-zero.png)![](images/qrect-diagram-one.png)
    Logical representationOne pixel wide pen
    ![](images/qrect-diagram-
    two.png)![](images/qrect-diagram-three.png)
    Two pixel wide penThree pixel
    wide pen

    **Coordinates**

    The QRect class provides a collection of functions that return the various
    rectangle coordinates, and enable manipulation of these. QRect also provides
    functions to move the rectangle relative to the various coordinates.

    For example the **left** (), **setLeft** () and **moveLeft** () functions as
    an example: **left** () returns the x-coordinate of the rectangle's left
    edge, **setLeft** () sets the left edge of the rectangle to the given x
    coordinate (it may change the width, but will never change the rectangle's
    right edge) and **moveLeft** () moves the entire rectangle horizontally,
    leaving the rectangle's left edge at the given x coordinate and its size
    unchanged.

    ![](images/qrect-coordinates.png)

    Note that for historical reasons the values returned by the **bottom** ()
    and **right** () functions deviate from the true bottom-right corner of the
    rectangle: The **right** () function returns ****left** () + **width** () -
    1** and the **bottom** () function returns ****top** () + **height** () -
    1**. The same is the case for the point returned by the **bottomRight** ()
    convenience function. In addition, the x and y coordinate of the
    **topRight** () and **bottomLeft** () functions, respectively, contain the
    same deviation from the true right and bottom edges.

    We recommend that you use **x** () + **width** () and **y** () + **height**
    () to find the true bottom-right corner, and avoid **right** () and
    **bottom** (). Another solution is to use **QRectF** : The **QRectF**  class
    defines a rectangle in the plane using floating point accuracy for
    coordinates, and the **QRectF::right** () and **QRectF::bottom** ()
    functions **do** return the right and bottom coordinates.

    It is also possible to add offsets to this rectangle's coordinates using the
    **adjust** () function, as well as retrieve a new rectangle based on
    adjustments of the original one using the **adjusted** () function. If
    either of the width and height is negative, use the **normalized** ()
    function to retrieve a rectangle where the corners are swapped.

    In addition, QRect provides the **getCoords** () function which extracts the
    position of the rectangle's top-left and bottom-right corner, and the
    **getRect** () function which extracts the rectangle's top-left corner,
    width and height. Use the **setCoords** () and **setRect** () function to
    manipulate the rectangle's coordinates and dimensions in one go.

    **Constraints**

    QRect is limited to the minimum and maximum values for the `int` type.
    Operations on a QRect that could potentially result in values outside this
    range will result in undefined behavior.

    **See also** **QRectF**  and **QRegion** .
    """

    @overload
    def __init__(self) -> None:
        """
        https://doc.qt.io/qt-6/qrect.html#QRect

        **QRect::QRect()**

        Constructs a null rectangle.

        **See also** **isNull** ().
        """
        ...

    @overload
    def __init__(self, QRect: PySide6.QtCore.QRect) -> None:
        """
        https://doc.qt.io/qt-6/qrect.html#QRect-1

        **QRect::QRect(const QPoint & topLeft , const QPoint & bottomRight )**

        Constructs a rectangle with the given **topLeft** and **bottomRight**
        corners, both included.

        If **bottomRight** is to higher and to the left of **topLeft** , the
        rectangle defined is instead non-inclusive of the corners.

        **Note:** To ensure both points are included regardless of relative
        order, use **span** ().

        **See also** **setTopLeft** (), **setBottomRight** (), and **span** ().
        """
        ...

    @overload
    def __init__(self, left: int, top: int, width: int, height: int) -> None:
        """
        https://doc.qt.io/qt-6/qrect.html#QRect-2

        **QRect::QRect(const QPoint & topLeft , const QSize & size )**

        Constructs a rectangle with the given **topLeft** corner and the given
        **size**.

        **See also** **setTopLeft** () and **setSize** ().
        """
        ...

    @overload
    def __init__(
        self, topleft: PySide6.QtCore.QPoint, bottomright: PySide6.QtCore.QPoint
    ) -> None:
        """
        https://doc.qt.io/qt-6/qrect.html#QRect-3

        **QRect::QRect(int x , int y , int width , int height )**

        Constructs a rectangle with ( **x** , **y** ) as its top-left corner and
        the given **width** and **height**.

        **See also** **setRect** ().
        """
        ...

    @overload
    def __init__(
        self, topleft: PySide6.QtCore.QPoint, size: PySide6.QtCore.QSize
    ) -> None:
        """
        https://doc.qt.io/qt-6/qrect.html#QRect

        **QRect::QRect()**

        Constructs a null rectangle.

        **See also** **isNull** ().
        """
        ...

    def __add__(self, margins: PySide6.QtCore.QMargins) -> PySide6.QtCore.QRect:
        ...

    def __and__(self, r: PySide6.QtCore.QRect) -> PySide6.QtCore.QRect:
        ...

    @staticmethod
    def __copy__() -> None:
        ...

    def __iadd__(self, margins: PySide6.QtCore.QMargins) -> PySide6.QtCore.QRect:
        ...

    def __iand__(self, r: PySide6.QtCore.QRect) -> PySide6.QtCore.QRect:
        ...

    def __ior__(self, r: PySide6.QtCore.QRect) -> PySide6.QtCore.QRect:
        ...

    def __isub__(self, margins: PySide6.QtCore.QMargins) -> PySide6.QtCore.QRect:
        ...

    def __or__(self, r: PySide6.QtCore.QRect) -> PySide6.QtCore.QRect:
        ...

    def __reduce__(self) -> object:
        ...

    def __repr__(self) -> object:
        ...

    def __sub__(self, rhs: PySide6.QtCore.QMargins) -> PySide6.QtCore.QRect:
        ...

    def adjust(self, x1: int, y1: int, x2: int, y2: int) -> None:
        """
        https://doc.qt.io/qt-6/qrect.html#adjust

        **void QRect::adjust(int dx1 , int dy1 , int dx2 , int dy2 )**

        Adds **dx1** , **dy1** , **dx2** and **dy2** respectively to the
        existing coordinates of the rectangle.

        **See also** **adjusted** () and **setRect** ().
        """
        ...

    def adjusted(self, x1: int, y1: int, x2: int, y2: int) -> PySide6.QtCore.QRect:
        """
        https://doc.qt.io/qt-6/qrect.html#adjusted

        **QRect QRect::adjusted(int dx1 , int dy1 , int dx2 , int dy2 ) const**

        Returns a new rectangle with **dx1** , **dy1** , **dx2** and **dy2**
        added respectively to the existing coordinates of this rectangle.

        **See also** **adjust** ().
        """
        ...

    def bottom(self) -> int:
        """
        https://doc.qt.io/qt-6/qrect.html#bottom

        **int QRect::bottom() const**

        Returns the y-coordinate of the rectangle's bottom edge.

        Note that for historical reasons this function returns **top** () +
        **height** () - 1; use **y** () + **height** () to retrieve the true
        y-coordinate.

        **See also** **setBottom** (), **bottomLeft** (), and **bottomRight**
        ().
        """
        ...

    def bottomLeft(self) -> PySide6.QtCore.QPoint:
        """
        https://doc.qt.io/qt-6/qrect.html#bottomLeft

        **QPoint QRect::bottomLeft() const**

        Returns the position of the rectangle's bottom-left corner. Note that
        for historical reasons this function returns **QPoint** (**left** (),
        **top** () + **height** () - 1).

        **See also** **setBottomLeft** (), **bottom** (), and **left** ().
        """
        ...

    def bottomRight(self) -> PySide6.QtCore.QPoint:
        """
        https://doc.qt.io/qt-6/qrect.html#bottomRight

        **QPoint QRect::bottomRight() const**

        Returns the position of the rectangle's bottom-right corner.

        Note that for historical reasons this function returns **QPoint**
        (**left** () + **width** () -1, **top** () + **height** () - 1).

        **See also** **setBottomRight** (), **bottom** (), and **right** ().
        """
        ...

    def center(self) -> PySide6.QtCore.QPoint:
        """
        https://doc.qt.io/qt-6/qrect.html#center

        **QPoint QRect::center() const**

        Returns the center point of the rectangle.

        **See also** **moveCenter** ().
        """
        ...

    @overload
    def contains(self, p: PySide6.QtCore.QPoint, proper: bool = ...) -> bool:
        """
        https://doc.qt.io/qt-6/qrect.html#contains

        **bool QRect::contains(const QPoint & point , bool proper = false)
        const**

        Returns `true` if the given **point** is inside or on the edge of the
        rectangle, otherwise returns `false`. If **proper** is true, this
        function only returns `true` if the given **point** is **inside** the
        rectangle (i.e., not on the edge).

        **See also** **intersects** ().
        """
        ...

    @overload
    def contains(self, r: PySide6.QtCore.QRect, proper: bool = ...) -> bool:
        """
        https://doc.qt.io/qt-6/qrect.html#contains-1

        **bool QRect::contains(const QRect & rectangle , bool proper = false)
        const**

        This is an overloaded function.

        Returns `true` if the given **rectangle** is inside this rectangle.
        otherwise returns `false`. If **proper** is true, this function only
        returns `true` if the **rectangle** is entirely inside this rectangle
        (not on the edge).
        """
        ...

    @overload
    def contains(self, x: int, y: int) -> bool:
        """
        https://doc.qt.io/qt-6/qrect.html#contains-2

        **bool QRect::contains(int x , int y ) const**

        This is an overloaded function.

        Returns `true` if the point ( **x** , **y** ) is inside this rectangle,
        otherwise returns `false`.
        """
        ...

    @overload
    def contains(self, x: int, y: int, proper: bool) -> bool:
        """
        https://doc.qt.io/qt-6/qrect.html#contains-3

        **bool QRect::contains(int x , int y , bool proper ) const**

        This is an overloaded function.

        Returns `true` if the point ( **x** , **y** ) is inside or on the edge
        of the rectangle, otherwise returns `false`. If **proper** is true, this
        function only returns `true` if the point is entirely inside the
        rectangle(not on the edge).
        """
        ...

    def getCoords(self) -> Tuple[int, int, int, int]:
        """
        https://doc.qt.io/qt-6/qrect.html#getCoords

        **void QRect::getCoords(int * x1 , int * y1 , int * x2 , int * y2 )
        const**

        Extracts the position of the rectangle's top-left corner to * **x1** and
        * **y1** , and the position of the bottom-right corner to * **x2** and *
        **y2**.

        **See also** **setCoords** () and **getRect** ().
        """
        ...

    def getRect(self) -> Tuple[int, int, int, int]:
        """
        https://doc.qt.io/qt-6/qrect.html#getRect

        **void QRect::getRect(int * x , int * y , int * width , int * height )
        const**

        Extracts the position of the rectangle's top-left corner to * **x** and
        * **y** , and its dimensions to * **width** and * **height**.

        **See also** **setRect** () and **getCoords** ().
        """
        ...

    def height(self) -> int:
        """
        https://doc.qt.io/qt-6/qrect.html#height

        **int QRect::height() const**

        Returns the height of the rectangle.

        **See also** **setHeight** (), **width** (), and **size** ().
        """
        ...

    def intersected(self, other: PySide6.QtCore.QRect) -> PySide6.QtCore.QRect:
        """
        https://doc.qt.io/qt-6/qrect.html#intersected

        **QRect QRect::intersected(const QRect & rectangle ) const**

        Returns the intersection of this rectangle and the given **rectangle**.
        Note that `r.intersected(s)` is equivalent to `r & s`.

        ![](images/qrect-intersect.png)

        **See also** **intersects** (), **united** (), and **operator&=** ().
        """
        ...

    def intersects(self, r: PySide6.QtCore.QRect) -> bool:
        """
        https://doc.qt.io/qt-6/qrect.html#intersects

        **bool QRect::intersects(const QRect & rectangle ) const**

        Returns `true` if this rectangle intersects with the given **rectangle**
        (i.e., there is at least one pixel that is within both rectangles),
        otherwise returns `false`.

        The intersection rectangle can be retrieved using the **intersected** ()
        function.

        **See also** **contains** ().
        """
        ...

    def isEmpty(self) -> bool:
        """
        https://doc.qt.io/qt-6/qrect.html#isEmpty

        **bool QRect::isEmpty() const**

        Returns `true` if the rectangle is empty, otherwise returns `false`.

        An empty rectangle has a **left** () > **right** () or **top** () >
        **bottom** (). An empty rectangle is not valid (i.e., isEmpty() ==
        !**isValid** ()).

        Use the **normalized** () function to retrieve a rectangle where the
        corners are swapped.

        **See also** **isNull** (), **isValid** (), and **normalized** ().
        """
        ...

    def isNull(self) -> bool:
        """
        https://doc.qt.io/qt-6/qrect.html#isNull

        **bool QRect::isNull() const**

        Returns `true` if the rectangle is a null rectangle, otherwise returns
        `false`.

        A null rectangle has both the width and the height set to 0 (i.e.,
        **right** () == **left** () - 1 and **bottom** () == **top** () - 1). A
        null rectangle is also empty, and hence is not valid.

        **See also** **isEmpty** () and **isValid** ().
        """
        ...

    def isValid(self) -> bool:
        """
        https://doc.qt.io/qt-6/qrect.html#isValid

        **bool QRect::isValid() const**

        Returns `true` if the rectangle is valid, otherwise returns `false`.

        A valid rectangle has a **left** () <= **right** () and **top** () <=
        **bottom** (). Note that non-trivial operations like intersections are
        not defined for invalid rectangles. A valid rectangle is not empty
        (i.e., isValid() == !**isEmpty** ()).

        **See also** **isNull** (), **isEmpty** (), and **normalized** ().
        """
        ...

    def left(self) -> int:
        """
        https://doc.qt.io/qt-6/qrect.html#left

        **int QRect::left() const**

        Returns the x-coordinate of the rectangle's left edge. Equivalent to
        **x** ().

        **See also** **setLeft** (), **topLeft** (), and **bottomLeft** ().
        """
        ...

    def marginsAdded(self, margins: PySide6.QtCore.QMargins) -> PySide6.QtCore.QRect:
        """
        https://doc.qt.io/qt-6/qrect.html#marginsAdded

        **[since 5.1] QRect QRect::marginsAdded(const QMargins & margins )
        const**

        Returns a rectangle grown by the **margins**.

        This function was introduced in Qt 5.1.

        **See also** **operator+=** (), **marginsRemoved** (), and
        **operator-=** ().
        """
        ...

    def marginsRemoved(self, margins: PySide6.QtCore.QMargins) -> PySide6.QtCore.QRect:
        """
        https://doc.qt.io/qt-6/qrect.html#marginsRemoved

        **[since 5.1] QRect QRect::marginsRemoved(const QMargins & margins )
        const**

        Removes the **margins** from the rectangle, shrinking it.

        This function was introduced in Qt 5.1.

        **See also** **marginsAdded** (), **operator+=** (), and **operator-=**
        ().
        """
        ...

    def moveBottom(self, pos: int) -> None:
        """
        https://doc.qt.io/qt-6/qrect.html#moveBottom

        **void QRect::moveBottom(int y )**

        Moves the rectangle vertically, leaving the rectangle's bottom edge at
        the given **y** coordinate. The rectangle's size is unchanged.

        **See also** **bottom** (), **setBottom** (), and **moveTop** ().
        """
        ...

    def moveBottomLeft(self, p: PySide6.QtCore.QPoint) -> None:
        """
        https://doc.qt.io/qt-6/qrect.html#moveBottomLeft

        **void QRect::moveBottomLeft(const QPoint & position )**

        Moves the rectangle, leaving the bottom-left corner at the given
        **position**. The rectangle's size is unchanged.

        **See also** **setBottomLeft** (), **moveBottom** (), and **moveLeft**
        ().
        """
        ...

    def moveBottomRight(self, p: PySide6.QtCore.QPoint) -> None:
        """
        https://doc.qt.io/qt-6/qrect.html#moveBottomRight

        **void QRect::moveBottomRight(const QPoint & position )**

        Moves the rectangle, leaving the bottom-right corner at the given
        **position**. The rectangle's size is unchanged.

        **See also** **setBottomRight** (), **moveRight** (), and **moveBottom**
        ().
        """
        ...

    def moveCenter(self, p: PySide6.QtCore.QPoint) -> None:
        """
        https://doc.qt.io/qt-6/qrect.html#moveCenter

        **void QRect::moveCenter(const QPoint & position )**

        Moves the rectangle, leaving the center point at the given **position**.
        The rectangle's size is unchanged.

        **See also** **center** ().
        """
        ...

    def moveLeft(self, pos: int) -> None:
        """
        https://doc.qt.io/qt-6/qrect.html#moveLeft

        **void QRect::moveLeft(int x )**

        Moves the rectangle horizontally, leaving the rectangle's left edge at
        the given **x** coordinate. The rectangle's size is unchanged.

        **See also** **left** (), **setLeft** (), and **moveRight** ().
        """
        ...

    def moveRight(self, pos: int) -> None:
        """
        https://doc.qt.io/qt-6/qrect.html#moveRight

        **void QRect::moveRight(int x )**

        Moves the rectangle horizontally, leaving the rectangle's right edge at
        the given **x** coordinate. The rectangle's size is unchanged.

        **See also** **right** (), **setRight** (), and **moveLeft** ().
        """
        ...

    @overload
    def moveTo(self, p: PySide6.QtCore.QPoint) -> None:
        """
        https://doc.qt.io/qt-6/qrect.html#moveTo

        **void QRect::moveTo(int x , int y )**

        Moves the rectangle, leaving the top-left corner at the given position (
        **x** , **y** ). The rectangle's size is unchanged.

        **See also** **translate** () and **moveTopLeft** ().
        """
        ...

    @overload
    def moveTo(self, x: int, t: int) -> None:
        """
        https://doc.qt.io/qt-6/qrect.html#moveTo-1

        **void QRect::moveTo(const QPoint & position )**

        Moves the rectangle, leaving the top-left corner at the given
        **position**.
        """
        ...

    def moveTop(self, pos: int) -> None:
        """
        https://doc.qt.io/qt-6/qrect.html#moveTop

        **void QRect::moveTop(int y )**

        Moves the rectangle vertically, leaving the rectangle's top edge at the
        given **y** coordinate. The rectangle's size is unchanged.

        **See also** **top** (), **setTop** (), and **moveBottom** ().
        """
        ...

    def moveTopLeft(self, p: PySide6.QtCore.QPoint) -> None:
        """
        https://doc.qt.io/qt-6/qrect.html#moveTopLeft

        **void QRect::moveTopLeft(const QPoint & position )**

        Moves the rectangle, leaving the top-left corner at the given
        **position**. The rectangle's size is unchanged.

        **See also** **setTopLeft** (), **moveTop** (), and **moveLeft** ().
        """
        ...

    def moveTopRight(self, p: PySide6.QtCore.QPoint) -> None:
        """
        https://doc.qt.io/qt-6/qrect.html#moveTopRight

        **void QRect::moveTopRight(const QPoint & position )**

        Moves the rectangle, leaving the top-right corner at the given
        **position**. The rectangle's size is unchanged.

        **See also** **setTopRight** (), **moveTop** (), and **moveRight** ().
        """
        ...

    def normalized(self) -> PySide6.QtCore.QRect:
        """
        https://doc.qt.io/qt-6/qrect.html#normalized

        **QRect QRect::normalized() const**

        Returns a normalized rectangle; i.e., a rectangle that has a non-
        negative width and height.

        If **width** () < 0 the function swaps the left and right corners, and
        it swaps the top and bottom corners if **height** () < 0\\. The corners
        are at the same time changed from being non-inclusive to inclusive.

        **See also** **isValid** () and **isEmpty** ().
        """
        ...

    def right(self) -> int:
        """
        https://doc.qt.io/qt-6/qrect.html#right

        **int QRect::right() const**

        Returns the x-coordinate of the rectangle's right edge.

        Note that for historical reasons this function returns **left** () +
        **width** () - 1; use **x** () + **width** () to retrieve the true
        x-coordinate.

        **See also** **setRight** (), **topRight** (), and **bottomRight** ().
        """
        ...

    def setBottom(self, pos: int) -> None:
        """
        https://doc.qt.io/qt-6/qrect.html#setBottom

        **void QRect::setBottom(int y )**

        Sets the bottom edge of the rectangle to the given **y** coordinate. May
        change the height, but will never change the top edge of the rectangle.

        **See also** **bottom** () and **moveBottom** ().
        """
        ...

    def setBottomLeft(self, p: PySide6.QtCore.QPoint) -> None:
        """
        https://doc.qt.io/qt-6/qrect.html#setBottomLeft

        **void QRect::setBottomLeft(const QPoint & position )**

        Set the bottom-left corner of the rectangle to the given **position**.
        May change the size, but will never change the top-right corner of the
        rectangle.

        **See also** **bottomLeft** () and **moveBottomLeft** ().
        """
        ...

    def setBottomRight(self, p: PySide6.QtCore.QPoint) -> None:
        """
        https://doc.qt.io/qt-6/qrect.html#setBottomRight

        **void QRect::setBottomRight(const QPoint & position )**

        Set the bottom-right corner of the rectangle to the given **position**.
        May change the size, but will never change the top-left corner of the
        rectangle.

        **See also** **bottomRight** () and **moveBottomRight** ().
        """
        ...

    def setCoords(self, x1: int, y1: int, x2: int, y2: int) -> None:
        """
        https://doc.qt.io/qt-6/qrect.html#setCoords

        **void QRect::setCoords(int x1 , int y1 , int x2 , int y2 )**

        Sets the coordinates of the rectangle's top-left corner to ( **x1** ,
        **y1** ), and the coordinates of its bottom-right corner to ( **x2** ,
        **y2** ).

        **See also** **getCoords** () and **setRect** ().
        """
        ...

    def setHeight(self, h: int) -> None:
        """
        https://doc.qt.io/qt-6/qrect.html#setHeight

        **void QRect::setHeight(int height )**

        Sets the height of the rectangle to the given **height**. The bottom
        edge is changed, but not the top one.

        **See also** **height** () and **setSize** ().
        """
        ...

    def setLeft(self, pos: int) -> None:
        """
        https://doc.qt.io/qt-6/qrect.html#setLeft

        **void QRect::setLeft(int x )**

        Sets the left edge of the rectangle to the given **x** coordinate. May
        change the width, but will never change the right edge of the rectangle.

        Equivalent to **setX** ().

        **See also** **left** () and **moveLeft** ().
        """
        ...

    def setRect(self, x: int, y: int, w: int, h: int) -> None:
        """
        https://doc.qt.io/qt-6/qrect.html#setRect

        **void QRect::setRect(int x , int y , int width , int height )**

        Sets the coordinates of the rectangle's top-left corner to ( **x** ,
        **y** ), and its size to the given **width** and **height**.

        **See also** **getRect** () and **setCoords** ().
        """
        ...

    def setRight(self, pos: int) -> None:
        """
        https://doc.qt.io/qt-6/qrect.html#setRight

        **void QRect::setRight(int x )**

        Sets the right edge of the rectangle to the given **x** coordinate. May
        change the width, but will never change the left edge of the rectangle.

        **See also** **right** () and **moveRight** ().
        """
        ...

    def setSize(self, s: PySide6.QtCore.QSize) -> None:
        """
        https://doc.qt.io/qt-6/qrect.html#setSize

        **void QRect::setSize(const QSize & size )**

        Sets the size of the rectangle to the given **size**. The top-left
        corner is not moved.

        **See also** **size** (), **setWidth** (), and **setHeight** ().
        """
        ...

    def setTop(self, pos: int) -> None:
        """
        https://doc.qt.io/qt-6/qrect.html#setTop

        **void QRect::setTop(int y )**

        Sets the top edge of the rectangle to the given **y** coordinate. May
        change the height, but will never change the bottom edge of the
        rectangle.

        Equivalent to **setY** ().

        **See also** **top** () and **moveTop** ().
        """
        ...

    def setTopLeft(self, p: PySide6.QtCore.QPoint) -> None:
        """
        https://doc.qt.io/qt-6/qrect.html#setTopLeft

        **void QRect::setTopLeft(const QPoint & position )**

        Set the top-left corner of the rectangle to the given **position**. May
        change the size, but will never change the bottom-right corner of the
        rectangle.

        **See also** **topLeft** () and **moveTopLeft** ().
        """
        ...

    def setTopRight(self, p: PySide6.QtCore.QPoint) -> None:
        """
        https://doc.qt.io/qt-6/qrect.html#setTopRight

        **void QRect::setTopRight(const QPoint & position )**

        Set the top-right corner of the rectangle to the given **position**. May
        change the size, but will never change the bottom-left corner of the
        rectangle.

        **See also** **topRight** () and **moveTopRight** ().
        """
        ...

    def setWidth(self, w: int) -> None:
        """
        https://doc.qt.io/qt-6/qrect.html#setWidth

        **void QRect::setWidth(int width )**

        Sets the width of the rectangle to the given **width**. The right edge
        is changed, but not the left one.

        **See also** **width** () and **setSize** ().
        """
        ...

    def setX(self, x: int) -> None:
        """
        https://doc.qt.io/qt-6/qrect.html#setX

        **void QRect::setX(int x )**

        Sets the left edge of the rectangle to the given **x** coordinate. May
        change the width, but will never change the right edge of the rectangle.

        Equivalent to **setLeft** ().

        **See also** **x** (), **setY** (), and **setTopLeft** ().
        """
        ...

    def setY(self, y: int) -> None:
        """
        https://doc.qt.io/qt-6/qrect.html#setY

        **void QRect::setY(int y )**

        Sets the top edge of the rectangle to the given **y** coordinate. May
        change the height, but will never change the bottom edge of the
        rectangle.

        Equivalent to **setTop** ().

        **See also** **y** (), **setX** (), and **setTopLeft** ().
        """
        ...

    def size(self) -> PySide6.QtCore.QSize:
        """
        https://doc.qt.io/qt-6/qrect.html#size

        **QSize QRect::size() const**

        Returns the size of the rectangle.

        **See also** **setSize** (), **width** (), and **height** ().
        """
        ...

    @staticmethod
    def span(
        p1: PySide6.QtCore.QPoint, p2: PySide6.QtCore.QPoint
    ) -> PySide6.QtCore.QRect:
        """
        https://doc.qt.io/qt-6/qrect.html#span

        **[static, since 6.0] QRect QRect::span(const QPoint & p1 , const QPoint
        & p2 )**

        Returns a rectangle spanning the two points **p1** and **p2** ,
        including both and everything in between.

        This function was introduced in Qt 6.0.
        """
        ...

    def top(self) -> int:
        """
        https://doc.qt.io/qt-6/qrect.html#top

        **int QRect::top() const**

        Returns the y-coordinate of the rectangle's top edge. Equivalent to
        **y** ().

        **See also** **setTop** (), **topLeft** (), and **topRight** ().
        """
        ...

    def topLeft(self) -> PySide6.QtCore.QPoint:
        """
        https://doc.qt.io/qt-6/qrect.html#topLeft

        **QPoint QRect::topLeft() const**

        Returns the position of the rectangle's top-left corner.

        **See also** **setTopLeft** (), **top** (), and **left** ().
        """
        ...

    def topRight(self) -> PySide6.QtCore.QPoint:
        """
        https://doc.qt.io/qt-6/qrect.html#topRight

        **QPoint QRect::topRight() const**

        Returns the position of the rectangle's top-right corner.

        Note that for historical reasons this function returns **QPoint**
        (**left** () + **width** () -1, **top** ()).

        **See also** **setTopRight** (), **top** (), and **right** ().
        """
        ...

    @overload
    def translate(self, dx: int, dy: int) -> None:
        """
        https://doc.qt.io/qt-6/qrect.html#translate

        **void QRect::translate(int dx , int dy )**

        Moves the rectangle **dx** along the x axis and **dy** along the y axis,
        relative to the current position. Positive values move the rectangle to
        the right and down.

        **See also** **moveTopLeft** (), **moveTo** (), and **translated** ().
        """
        ...

    @overload
    def translate(self, p: PySide6.QtCore.QPoint) -> None:
        """
        https://doc.qt.io/qt-6/qrect.html#translate-1

        **void QRect::translate(const QPoint & offset )**

        This is an overloaded function.

        Moves the rectangle **offset**.**x** () along the x axis and
        **offset**.**y** () along the y axis, relative to the current position.
        """
        ...

    @overload
    def translated(self, dx: int, dy: int) -> PySide6.QtCore.QRect:
        """
        https://doc.qt.io/qt-6/qrect.html#translated

        **QRect QRect::translated(int dx , int dy ) const**

        Returns a copy of the rectangle that is translated **dx** along the x
        axis and **dy** along the y axis, relative to the current position.
        Positive values move the rectangle to the right and down.

        **See also** **translate** ().
        """
        ...

    @overload
    def translated(self, p: PySide6.QtCore.QPoint) -> PySide6.QtCore.QRect:
        """
        https://doc.qt.io/qt-6/qrect.html#translated-1

        **QRect QRect::translated(const QPoint & offset ) const**

        This is an overloaded function.

        Returns a copy of the rectangle that is translated **offset**.**x** ()
        along the x axis and **offset**.**y** () along the y axis, relative to
        the current position.
        """
        ...

    def transposed(self) -> PySide6.QtCore.QRect:
        """
        https://doc.qt.io/qt-6/qrect.html#transposed

        **[since 5.7] QRect QRect::transposed() const**

        Returns a copy of the rectangle that has its width and height exchanged:

        **QRect**  r = {15, 51, 42, 24};
            r = r.transposed(); // r == {15,
        51, 24, 42}

        This function was introduced in Qt 5.7.

        **See also** **QSize::transposed** ().
        """
        ...

    def united(self, other: PySide6.QtCore.QRect) -> PySide6.QtCore.QRect:
        """
        https://doc.qt.io/qt-6/qrect.html#united

        **QRect QRect::united(const QRect & rectangle ) const**

        Returns the bounding rectangle of this rectangle and the given
        **rectangle**.

        ![](images/qrect-unite.png)

        **See also** **intersected** ().
        """
        ...

    def width(self) -> int:
        """
        https://doc.qt.io/qt-6/qrect.html#width

        **int QRect::width() const**

        Returns the width of the rectangle.

        **See also** **setWidth** (), **height** (), and **size** ().
        """
        ...

    def x(self) -> int:
        """
        https://doc.qt.io/qt-6/qrect.html#x

        **int QRect::x() const**

        Returns the x-coordinate of the rectangle's left edge. Equivalent to
        **left** ().

        **See also** **setX** (), **y** (), and **topLeft** ().
        """
        ...

    def y(self) -> int:
        """
        https://doc.qt.io/qt-6/qrect.html#y

        **int QRect::y() const**

        Returns the y-coordinate of the rectangle's top edge. Equivalent to
        **top** ().

        **See also** **setY** (), **x** (), and **topLeft** ().
        """
        ...
