"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtCore, except for defaults which are replaced by "...".
"""
from typing import overload
import PySide6.QtCore

bytes = str


class QPoint(object):
    """
    https://doc.qt.io/qt-6/qpoint.html

    **Detailed Description**

    A point is specified by a x coordinate and an y coordinate which can be
    accessed using the **x** () and **y** () functions. The **isNull** ()
    function returns `true` if both x and y are set to 0. The coordinates can be
    set (or altered) using the **setX** () and **setY** () functions, or
    alternatively the **rx** () and **ry** () functions which return references
    to the coordinates (allowing direct manipulation).

    Given a point **p** , the following statements are all equivalent:

    **QPoint**  p;

        p.setX(p.x() + 1);
        p += **QPoint** (1, 0);
    p.rx()++;

    A QPoint object can also be used as a vector: Addition and subtraction are
    defined as for vectors (each component is added separately). A QPoint object
    can also be divided or multiplied by an `int` or a `qreal`.

    In addition, the QPoint class provides the **manhattanLength** () function
    which gives an inexpensive approximation of the length of the QPoint object
    interpreted as a vector. Finally, QPoint objects can be streamed as well as
    compared.

    **See also** **QPointF**  and **QPolygon** .
    """

    @overload
    def __init__(self) -> None:
        """
        https://doc.qt.io/qt-6/qpoint.html#QPoint

        **QPoint::QPoint()**

        Constructs a null point, i.e. with coordinates (0, 0)

        **See also** **isNull** ().
        """
        ...

    @overload
    def __init__(self, QPoint: PySide6.QtCore.QPoint) -> None:
        """
        https://doc.qt.io/qt-6/qpoint.html#QPoint-1

        **QPoint::QPoint(int xpos , int ypos )**

        Constructs a point with the given coordinates ( **xpos** , **ypos** ).

        **See also** **setX** () and **setY** ().
        """
        ...

    @overload
    def __init__(self, xpos: int, ypos: int) -> None:
        """
        https://doc.qt.io/qt-6/qpoint.html#QPoint

        **QPoint::QPoint()**

        Constructs a null point, i.e. with coordinates (0, 0)

        **See also** **isNull** ().
        """
        ...

    def __add__(self, p2: PySide6.QtCore.QPoint) -> PySide6.QtCore.QPoint:
        ...

    @staticmethod
    def __copy__() -> None:
        ...

    def __iadd__(self, p: PySide6.QtCore.QPoint) -> PySide6.QtCore.QPoint:
        ...

    @overload
    def __imul__(self, factor: float) -> PySide6.QtCore.QPoint:
        ...

    @overload
    def __imul__(self, factor: float) -> PySide6.QtCore.QPoint:
        ...

    @overload
    def __imul__(self, factor: int) -> PySide6.QtCore.QPoint:
        ...

    def __isub__(self, p: PySide6.QtCore.QPoint) -> PySide6.QtCore.QPoint:
        ...

    @overload
    def __mul__(self, factor: float) -> PySide6.QtCore.QPoint:
        ...

    @overload
    def __mul__(self, factor: float) -> PySide6.QtCore.QPoint:
        ...

    @overload
    def __mul__(self, factor: int) -> PySide6.QtCore.QPoint:
        ...

    def __neg__(self) -> PySide6.QtCore.QPoint:
        ...

    def __pos__(self) -> PySide6.QtCore.QPoint:
        ...

    def __reduce__(self) -> object:
        ...

    def __repr__(self) -> object:
        ...

    def __sub__(self, p2: PySide6.QtCore.QPoint) -> PySide6.QtCore.QPoint:
        ...

    @staticmethod
    def dotProduct(p1: PySide6.QtCore.QPoint, p2: PySide6.QtCore.QPoint) -> int:
        """
        https://doc.qt.io/qt-6/qpoint.html#dotProduct

        **[static, since 5.1] int QPoint::dotProduct(const QPoint & p1 , const
        QPoint & p2 )**

        **QPoint**  p( 3, 7);
            **QPoint**  q(-1, 4);
            int lengthSquared =
        **QPoint** ::dotProduct(p, q);   // lengthSquared becomes 25

        Returns the dot product of **p1** and **p2**.

        This function was introduced in Qt 5.1.
        """
        ...

    def isNull(self) -> bool:
        """
        https://doc.qt.io/qt-6/qpoint.html#isNull

        **bool QPoint::isNull() const**

        Returns `true` if both the x and y coordinates are set to 0, otherwise
        returns `false`.
        """
        ...

    def manhattanLength(self) -> int:
        """
        https://doc.qt.io/qt-6/qpoint.html#manhattanLength

        **int QPoint::manhattanLength() const**

        Returns the sum of the absolute values of **x** () and **y** (),
        traditionally known as the "Manhattan length" of the vector from the
        origin to the point. For example:

        **QPoint**  oldPosition;
        MyWidget::mouseMoveEvent(**QMouseEvent**  *event)
            {
        **QPoint**  point = event->pos() - oldPosition;
                if
        (point.manhattanLength() > 3)
                    // the mouse has moved more
        than 3 pixels since the oldPosition
            }

        This is a useful, and quick to calculate, approximation to the true
        length:

        double trueLength = std::sqrt(std::pow(x(), 2) + std::pow(y(), 2));

        The tradition of "Manhattan length" arises because such distances apply
        to travelers who can only travel on a rectangular grid, like the streets
        of Manhattan.
        """
        ...

    def setX(self, x: int) -> None:
        """
        https://doc.qt.io/qt-6/qpoint.html#setX

        **void QPoint::setX(int x )**

        Sets the x coordinate of this point to the given **x** coordinate.

        **See also** **x** () and **setY** ().
        """
        ...

    def setY(self, y: int) -> None:
        """
        https://doc.qt.io/qt-6/qpoint.html#setY

        **void QPoint::setY(int y )**

        Sets the y coordinate of this point to the given **y** coordinate.

        **See also** **y** () and **setX** ().
        """
        ...

    def toTuple(self) -> object:
        ...

    def transposed(self) -> PySide6.QtCore.QPoint:
        """
        https://doc.qt.io/qt-6/qpoint.html#transposed

        **[since 5.14] QPoint QPoint::transposed() const**

        Returns a point with x and y coordinates exchanged:

        **QPoint** {1, 2}.transposed() // {2, 1}

        This function was introduced in Qt 5.14.

        **See also** **x** (), **y** (), **setX** (), and **setY** ().
        """
        ...

    def x(self) -> int:
        """
        https://doc.qt.io/qt-6/qpoint.html#x

        **int QPoint::x() const**

        Returns the x coordinate of this point.

        **See also** **setX** () and **rx** ().
        """
        ...

    def y(self) -> int:
        """
        https://doc.qt.io/qt-6/qpoint.html#y

        **int QPoint::y() const**

        Returns the y coordinate of this point.

        **See also** **setY** () and **ry** ().
        """
        ...
