"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtCore, except for defaults which are replaced by "...".
"""
from typing import Optional, overload
import PySide6.QtCore

bytes = str


class QPauseAnimation(PySide6.QtCore.QAbstractAnimation):
    """
    https://doc.qt.io/qt-6/qpauseanimation.html

    **Detailed Description**

    If you wish to introduce a delay between animations in a
    **QSequentialAnimationGroup** , you can insert a QPauseAnimation. This class
    does not animate anything, but does not **finish**  before a specified
    number of milliseconds have elapsed from when it was started. You specify
    the duration of the pause in the constructor. It can also be set directly
    with **setDuration** ().

    It is not necessary to construct a QPauseAnimation yourself.
    **QSequentialAnimationGroup**  provides the convenience functions
    **addPause** () and **insertPause** (). These functions simply take the
    number of milliseconds the pause should last.

    **See also** **QSequentialAnimationGroup** .
    """

    @overload
    def __init__(
        self, msecs: int, parent: Optional[PySide6.QtCore.QObject] = ...
    ) -> None:
        """
        https://doc.qt.io/qt-6/qpauseanimation.html#QPauseAnimation

        **QPauseAnimation::QPauseAnimation(QObject * parent = nullptr)**

        Constructs a QPauseAnimation. **parent** is passed to **QObject** 's
        constructor. The default duration is 0.
        """
        ...

    @overload
    def __init__(self, parent: Optional[PySide6.QtCore.QObject] = ...) -> None:
        """
        https://doc.qt.io/qt-6/qpauseanimation.html#QPauseAnimation-1

        **QPauseAnimation::QPauseAnimation(int msecs , QObject * parent =
        nullptr)**

        Constructs a QPauseAnimation. **msecs** is the duration of the pause.
        **parent** is passed to **QObject** 's constructor.
        """
        ...

    def duration(self) -> int:
        """
        https://doc.qt.io/qt-6/qpauseanimation.html#duration-prop

        **[bindable] duration : int**

        **Note:** This property supports **QProperty**  bindings.

        This property holds the duration of the pause.

        The duration of the pause. The duration should not be negative. The
        default duration is 250 milliseconds.

        **Member Function Documentation**
        """
        ...

    def event(self, e: PySide6.QtCore.QEvent) -> bool:
        """
        https://doc.qt.io/qt-6/qpauseanimation.html#event

        **[override virtual protected] bool QPauseAnimation::event(QEvent * e
        )**

        Reimplements: **QAbstractAnimation::event** (QEvent *event).
        """
        ...

    def setDuration(self, msecs: int) -> None:
        """
        https://doc.qt.io/qt-6/qpauseanimation.html#duration-prop

        **[bindable] duration : int**

        **Note:** This property supports **QProperty**  bindings.

        This property holds the duration of the pause.

        The duration of the pause. The duration should not be negative. The
        default duration is 250 milliseconds.

        **Member Function Documentation**
        """
        ...

    def updateCurrentTime(self, arg__1: int) -> None:
        """
        https://doc.qt.io/qt-6/qpauseanimation.html#updateCurrentTime

        **[override virtual protected] void
        QPauseAnimation::updateCurrentTime(int)**

        Reimplements: **QAbstractAnimation::updateCurrentTime** (int
        currentTime).
        """
        ...
