"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtCore, except for defaults which are replaced by "...".
"""
from typing import Union, overload
import PySide6.QtCore

bytes = str


class QMessageAuthenticationCode(object):
    """
    https://doc.qt.io/qt-6/qmessageauthenticationcode.html

    **Detailed Description**

    QMessageAuthenticationCode supports all cryptographic hashes which are
    supported by **QCryptographicHash** .

    To generate message authentication code, pass hash algorithm
    **QCryptographicHash::Algorithm**  to constructor, then set key and message
    by **setKey** () and **addData** () functions. Result can be acquired by
    **result** () function.

    **QByteArray**  key = "key";
            **QByteArray**  message = "The quick
    brown fox jumps over the lazy dog";
            ...
    **QMessageAuthenticationCode**  code(**QCryptographicHash** ::Sha1);
    code.setKey(key);
            code.addData(message);
    code.result().toHex();      // returns
    "de7c9b85b8b78aa6bc8a7a36f70a90701c9db4d9"

    Alternatively, this effect can be achieved by providing message, key and
    method to **hash** () method.

    **QMessageAuthenticationCode** ::hash(message, key, **QCryptographicHash**
    ::Sha1).toHex();

    **See also** **QCryptographicHash** .
    """

    def __init__(
        self,
        method: PySide6.QtCore.QCryptographicHash.Algorithm,
        key: Union[PySide6.QtCore.QByteArray, bytes] = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qmessageauthenticationcode.html#QMessageAuthentic
        ationCode

        **QMessageAuthenticationCode::QMessageAuthenticationCode(QCryptographicH
        ash::Algorithm method , const QByteArray & key = QByteArray())**

        Constructs an object that can be used to create a cryptographic hash
        from data using method **method** and key **key**.
        """
        ...

    @overload
    def addData(self, data: bytes, length: int) -> None:
        """
        https://doc.qt.io/qt-6/qmessageauthenticationcode.html#addData

        **void QMessageAuthenticationCode::addData(const char * data , qsizetype
        length )**

        Adds the first **length** chars of **data** to the message.
        """
        ...

    @overload
    def addData(self, data: Union[PySide6.QtCore.QByteArray, bytes]) -> None:
        """
        https://doc.qt.io/qt-6/qmessageauthenticationcode.html#addData-1

        **void QMessageAuthenticationCode::addData(const QByteArray & data )**

        This function overloads addData().
        """
        ...

    @overload
    def addData(self, device: PySide6.QtCore.QIODevice) -> bool:
        """
        https://doc.qt.io/qt-6/qmessageauthenticationcode.html#addData-2

        **bool QMessageAuthenticationCode::addData(QIODevice * device )**

        Reads the data from the open **QIODevice**  **device** until it ends and
        adds it to message. Returns `true` if reading was successful.

        **Note:** **device** must be already opened.
        """
        ...

    @staticmethod
    def hash(
        message: Union[PySide6.QtCore.QByteArray, bytes],
        key: Union[PySide6.QtCore.QByteArray, bytes],
        method: PySide6.QtCore.QCryptographicHash.Algorithm,
    ) -> PySide6.QtCore.QByteArray:
        """
        https://doc.qt.io/qt-6/qmessageauthenticationcode.html#hash

        **[static] QByteArray QMessageAuthenticationCode::hash(const QByteArray
        & message , const QByteArray & key , QCryptographicHash::Algorithm
        method )**

        Returns the authentication code for the message **message** using the
        key **key** and the method **method**.
        """
        ...

    def reset(self) -> None:
        """
        https://doc.qt.io/qt-6/qmessageauthenticationcode.html#reset

        **void QMessageAuthenticationCode::reset()**

        Resets message data. Calling this method doesn't affect the key.
        """
        ...

    def result(self) -> PySide6.QtCore.QByteArray:
        """
        https://doc.qt.io/qt-6/qmessageauthenticationcode.html#result

        **QByteArray QMessageAuthenticationCode::result() const**

        Returns the final authentication code.

        **See also** **QByteArray::toHex** ().
        """
        ...

    def setKey(self, key: Union[PySide6.QtCore.QByteArray, bytes]) -> None:
        """
        https://doc.qt.io/qt-6/qmessageauthenticationcode.html#setKey

        **void QMessageAuthenticationCode::setKey(const QByteArray & key )**

        Sets secret **key**. Calling this method automatically resets the object
        state.
        """
        ...
