"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtCore, except for defaults which are replaced by "...".
"""
from enum import Enum
from typing import Sequence, Union, overload
import PySide6.QtCore

bytes = str


class QDirIterator(object):
    """
    https://doc.qt.io/qt-6/qdiriterator.html

    **Detailed Description**

    You can use QDirIterator to navigate entries of a directory one at a time.
    It is similar to **QDir::entryList** () and **QDir::entryInfoList** (), but
    because it lists entries one at a time instead of all at once, it scales
    better and is more suitable for large directories. It also supports listing
    directory contents recursively, and following symbolic links. Unlike
    **QDir::entryList** (), QDirIterator does not support sorting.

    The QDirIterator constructor takes a **QDir**  or a directory as argument.
    After construction, the iterator is located before the first directory
    entry. Here's how to iterate over all the entries sequentially:

    **QDirIterator**  it("/etc", **QDirIterator** ::Subdirectories);
        while
    (it.hasNext()) {
            **qDebug** () << it.next();

            // /etc/.
    // /etc/..
            // /etc/X11
            // /etc/X11/fs
            // ...
        }

    Here's how to find and read all files filtered by name, recursively:

    **QDirIterator**  it("/sys", **QStringList** () << "scaling_cur_freq",
    **QDir** ::NoFilter, **QDirIterator** ::Subdirectories);
        while
    (it.hasNext()) {
            **QFile**  f(it.next());
    f.open(**QIODevice** ::ReadOnly);
            **qDebug** () << f.fileName() <<
    f.readAll().trimmed().toDouble() / 1000 << "MHz";
        }

    The **next** () function returns the path to the next directory entry and
    advances the iterator. You can also call **filePath** () to get the current
    file path without advancing the iterator. The **fileName** () function
    returns only the name of the file, similar to how **QDir::entryList** ()
    works. You can also call **fileInfo** () to get a **QFileInfo**  for the
    current entry.

    Unlike Qt's container iterators, QDirIterator is uni-directional (i.e., you
    cannot iterate directories in reverse order) and does not allow random
    access.

    **See also** **QDir**  and **QDir::entryList** ().
    """

    NoIteratorFlags: QDirIterator.IteratorFlag = ...
    FollowSymlinks: QDirIterator.IteratorFlag = ...
    Subdirectories: QDirIterator.IteratorFlag = ...

    class IteratorFlag(Enum):
        NoIteratorFlags: QDirIterator.IteratorFlag = ...
        FollowSymlinks: QDirIterator.IteratorFlag = ...
        Subdirectories: QDirIterator.IteratorFlag = ...

    class IteratorFlags(object):
        ...

    @overload
    def __init__(
        self,
        dir: Union[PySide6.QtCore.QDir, str],
        flags: PySide6.QtCore.QDirIterator.IteratorFlags = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qdiriterator.html#QDirIterator

        **QDirIterator::QDirIterator(const QDir & dir ,
        QDirIterator::IteratorFlags flags = NoIteratorFlags)**

        Constructs a QDirIterator that can iterate over **dir** 's entrylist,
        using **dir** 's name filters and regular filters. You can pass options
        via **flags** to decide how the directory should be iterated.

        By default, **flags** is **NoIteratorFlags** , which provides the same
        behavior as in **QDir::entryList** ().

        The sorting in **dir** is ignored.

        **Note:** To list symlinks that point to non existing files,
        **QDir::System**  must be passed to the flags.

        **See also** **hasNext** (), **next** (), and **IteratorFlags** .
        """
        ...

    @overload
    def __init__(
        self,
        path: str,
        filter: PySide6.QtCore.QDir.Filters,
        flags: PySide6.QtCore.QDirIterator.IteratorFlags = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qdiriterator.html#QDirIterator-1

        **QDirIterator::QDirIterator(const QString & path ,
        QDirIterator::IteratorFlags flags = NoIteratorFlags)**

        Constructs a QDirIterator that can iterate over **path**. You can pass
        options via **flags** to decide how the directory should be iterated.

        By default, **flags** is **NoIteratorFlags** , which provides the same
        behavior as in **QDir::entryList** ().

        **Note:** To list symlinks that point to non existing files,
        **QDir::System**  must be passed to the flags.

        **See also** **hasNext** (), **next** (), and **IteratorFlags** .
        """
        ...

    @overload
    def __init__(
        self, path: str, flags: PySide6.QtCore.QDirIterator.IteratorFlags = ...
    ) -> None:
        """
        https://doc.qt.io/qt-6/qdiriterator.html#QDirIterator-2

        **QDirIterator::QDirIterator(const QString & path , QDir::Filters
        filters , QDirIterator::IteratorFlags flags = NoIteratorFlags)**

        Constructs a QDirIterator that can iterate over **path** , with no name
        filtering and **filters** for entry filtering. You can pass options via
        **flags** to decide how the directory should be iterated.

        By default, **filters** is **QDir::NoFilter** , and **flags** is
        **NoIteratorFlags** , which provides the same behavior as in
        **QDir::entryList** ().

        **Note:** To list symlinks that point to non existing files,
        **QDir::System**  must be passed to the flags.

        **See also** **hasNext** (), **next** (), and **IteratorFlags** .
        """
        ...

    @overload
    def __init__(
        self,
        path: str,
        nameFilters: Sequence[str],
        filters: PySide6.QtCore.QDir.Filters = ...,
        flags: PySide6.QtCore.QDirIterator.IteratorFlags = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qdiriterator.html#QDirIterator-3

        **QDirIterator::QDirIterator(const QString & path , const QStringList &
        nameFilters , QDir::Filters filters = QDir::NoFilter,
        QDirIterator::IteratorFlags flags = NoIteratorFlags)**

        Constructs a QDirIterator that can iterate over **path** , using
        **nameFilters** and **filters**. You can pass options via **flags** to
        decide how the directory should be iterated.

        By default, **flags** is **NoIteratorFlags** , which provides the same
        behavior as **QDir::entryList** ().

        For example, the following iterator could be used to iterate over audio
        files:

        **QDirIterator**  audioFileIt(audioPath, {"*.mp3", "*.wav"}, **QDir**
        ::Files);

        **Note:** To list symlinks that point to non existing files,
        **QDir::System**  must be passed to the flags.

        **See also** **hasNext** (), **next** (), **IteratorFlags** , and
        **QDir::setNameFilters** ().
        """
        ...

    def fileInfo(self) -> PySide6.QtCore.QFileInfo:
        """
        https://doc.qt.io/qt-6/qdiriterator.html#fileInfo

        **QFileInfo QDirIterator::fileInfo() const**

        Returns a **QFileInfo**  for the current directory entry.

        **See also** **filePath** () and **fileName** ().
        """
        ...

    def fileName(self) -> str:
        """
        https://doc.qt.io/qt-6/qdiriterator.html#fileName

        **QString QDirIterator::fileName() const**

        Returns the file name for the current directory entry, without the path
        prepended.

        This function is convenient when iterating a single directory. When
        using the **QDirIterator::Subdirectories**  flag, you can use
        **filePath** () to get the full path.

        **See also** **filePath** () and **fileInfo** ().
        """
        ...

    def filePath(self) -> str:
        """
        https://doc.qt.io/qt-6/qdiriterator.html#filePath

        **QString QDirIterator::filePath() const**

        Returns the full file path for the current directory entry.

        **See also** **fileInfo** () and **fileName** ().
        """
        ...

    def hasNext(self) -> bool:
        """
        https://doc.qt.io/qt-6/qdiriterator.html#hasNext

        **bool QDirIterator::hasNext() const**

        Returns `true` if there is at least one more entry in the directory;
        otherwise, false is returned.

        **See also** **next** (), **fileName** (), **filePath** (), and
        **fileInfo** ().
        """
        ...

    def next(self) -> str:
        """
        https://doc.qt.io/qt-6/qdiriterator.html#next

        **QString QDirIterator::next()**

        Advances the iterator to the next entry, and returns the file path of
        this new entry. If **hasNext** () returns `false`, this function does
        nothing, and returns an empty **QString** .

        You can call **fileName** () or **filePath** () to get the current entry
        file name or path, or **fileInfo** () to get a **QFileInfo**  for the
        current entry.

        **See also** **hasNext** (), **fileName** (), **filePath** (), and
        **fileInfo** ().
        """
        ...

    def path(self) -> str:
        """
        https://doc.qt.io/qt-6/qdiriterator.html#path

        **QString QDirIterator::path() const**

        Returns the base directory of the iterator.
        """
        ...
