"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtCore, except for defaults which are replaced by "...".
"""
from typing import overload
import PySide6.QtCore

bytes = str


class QChildEvent(PySide6.QtCore.QEvent):
    """
    https://doc.qt.io/qt-6/qchildevent.html

    **Detailed Description**

    Child events are sent immediately to objects when children are added or
    removed.

    In both cases you can only rely on the child being a **QObject**  (or, if
    **QObject::isWidgetType** () returns `true`, a **QWidget** ). This is
    because in the **QEvent::ChildAdded**  case the child is not yet fully
    constructed; in the **QEvent::ChildRemoved**  case it might have already
    been destructed.

    The handler for these events is **QObject::childEvent** ().
    """

    @overload
    def __init__(self, arg__1: PySide6.QtCore.QChildEvent) -> None:
        """
        https://doc.qt.io/qt-6/qchildevent.html#QChildEvent-2

        **QChildEvent::QChildEvent(QEvent::Type type , QObject * child )**

        Constructs a child event object of a particular **type** for the
        **child**.

        **type** can be **QEvent::ChildAdded** , **QEvent::ChildRemoved** , or
        **QEvent::ChildPolished** .

        **See also** **child** ().
        """
        ...

    @overload
    def __init__(
        self, type: PySide6.QtCore.QEvent.Type, child: PySide6.QtCore.QObject
    ) -> None:
        """
        https://doc.qt.io/qt-6/qchildevent.html#QChildEvent-2

        **QChildEvent::QChildEvent(QEvent::Type type , QObject * child )**

        Constructs a child event object of a particular **type** for the
        **child**.

        **type** can be **QEvent::ChildAdded** , **QEvent::ChildRemoved** , or
        **QEvent::ChildPolished** .

        **See also** **child** ().
        """
        ...

    def added(self) -> bool:
        """
        https://doc.qt.io/qt-6/qchildevent.html#added

        **bool QChildEvent::added() const**

        Returns `true` if **type** () is **QEvent::ChildAdded** ; otherwise
        returns false.
        """
        ...

    def child(self) -> PySide6.QtCore.QObject:
        """
        https://doc.qt.io/qt-6/qchildevent.html#child

        **QObject *QChildEvent::child() const**

        Returns the child object that was added or removed.
        """
        ...

    def clone(self) -> PySide6.QtCore.QChildEvent:
        ...

    def polished(self) -> bool:
        """
        https://doc.qt.io/qt-6/qchildevent.html#polished

        **bool QChildEvent::polished() const**

        Returns `true` if **type** () is **QEvent::ChildPolished** ; otherwise
        returns false.
        """
        ...

    def removed(self) -> bool:
        """
        https://doc.qt.io/qt-6/qchildevent.html#removed

        **bool QChildEvent::removed() const**

        Returns `true` if **type** () is **QEvent::ChildRemoved** ; otherwise
        returns false.
        """
        ...
