"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtCore, except for defaults which are replaced by "...".
"""
from enum import Enum
from typing import List, Union, overload
import PySide6.QtCore

bytes = str


class QCalendar(object):
    """
    https://doc.qt.io/qt-6/qcalendar.html

    **Detailed Description**

    A QCalendar object maps a year, month, and day-number to a specific day
    (ultimately identified by its Julian day number), using the rules of a
    particular system.

    The default QCalendar() is a proleptic Gregorian calendar, which has no year
    zero. Other calendars may be supported by enabling suitable features or
    loading plugins. Calendars supported as features can be constructed by
    passing the **QCalendar::System**  enumeration to the constructor. All
    supported calendars may be constructed by name, once they have been
    constructed. (Thus plugins instantiate their calendar backend to register
    it.) Built-in backends, accessible via **QCalendar::System** , are also
    always available by name. Calendars using custom backends may also be
    constructed using a unique ID allocated to the backend on construction.

    A QCalendar value is immutable.

    **See also** **QDate**  and **QDateTime** .
    """

    class System(Enum):
        User: QCalendar.System = ...
        Gregorian: QCalendar.System = ...
        Julian: QCalendar.System = ...
        Milankovic: QCalendar.System = ...
        Jalali: QCalendar.System = ...
        IslamicCivil: QCalendar.System = ...
        Last: QCalendar.System = ...

    class SystemId(object):
        def __init__(self) -> None:
            ...

        def index(self) -> int:
            ...

        def isValid(self) -> bool:
            ...

    class YearMonthDay(object):
        @overload
        def __init__(self) -> None:
            ...

        @overload
        def __init__(
            self, YearMonthDay: Union[PySide6.QtCore.QCalendar.YearMonthDay, int]
        ) -> None:
            ...

        @overload
        def __init__(self, y: int, m: int = ..., d: int = ...) -> None:
            ...

        @staticmethod
        def __copy__() -> None:
            ...

        def isValid(self) -> bool:
            ...

    @overload
    def __init__(self) -> None:
        """
        https://doc.qt.io/qt-6/qcalendar.html#QCalendar-4

        **[since 6.2] QCalendar::QCalendar(QCalendar::SystemId id )**

        This is an overloaded function.

        Constructs a calendar object.

        When using a custom calendar implementation, its backend is allocated a
        unique ID when created; passing that as **id** to this constructor will
        get a QCalendar using that backend. This can be useful when the backend
        is not registered by name.

        This function was introduced in Qt 6.2.
        """
        ...

    @overload
    def __init__(self, id: PySide6.QtCore.QCalendar.SystemId) -> None:
        """
        https://doc.qt.io/qt-6/qcalendar.html#QCalendar-4

        **[since 6.2] QCalendar::QCalendar(QCalendar::SystemId id )**

        This is an overloaded function.

        Constructs a calendar object.

        When using a custom calendar implementation, its backend is allocated a
        unique ID when created; passing that as **id** to this constructor will
        get a QCalendar using that backend. This can be useful when the backend
        is not registered by name.

        This function was introduced in Qt 6.2.
        """
        ...

    @overload
    def __init__(self, name: str) -> None:
        """
        https://doc.qt.io/qt-6/qcalendar.html#QCalendar-4

        **[since 6.2] QCalendar::QCalendar(QCalendar::SystemId id )**

        This is an overloaded function.

        Constructs a calendar object.

        When using a custom calendar implementation, its backend is allocated a
        unique ID when created; passing that as **id** to this constructor will
        get a QCalendar using that backend. This can be useful when the backend
        is not registered by name.

        This function was introduced in Qt 6.2.
        """
        ...

    @overload
    def __init__(self, system: PySide6.QtCore.QCalendar.System) -> None:
        """
        https://doc.qt.io/qt-6/qcalendar.html#QCalendar-4

        **[since 6.2] QCalendar::QCalendar(QCalendar::SystemId id )**

        This is an overloaded function.

        Constructs a calendar object.

        When using a custom calendar implementation, its backend is allocated a
        unique ID when created; passing that as **id** to this constructor will
        get a QCalendar using that backend. This can be useful when the backend
        is not registered by name.

        This function was introduced in Qt 6.2.
        """
        ...

    @staticmethod
    def __copy__() -> None:
        ...

    @staticmethod
    def availableCalendars() -> List[str]:
        """
        https://doc.qt.io/qt-6/qcalendar.html#availableCalendars

        **[static] QStringList QCalendar::availableCalendars()**

        Returns a list of names of the available calendar systems.

        These may be supplied by plugins or other code linked into an
        application, in addition to the ones provided by Qt, some of which are
        controlled by features.
        """
        ...

    @overload
    def dateFromParts(
        self, parts: Union[PySide6.QtCore.QCalendar.YearMonthDay, int]
    ) -> PySide6.QtCore.QDate:
        ...

    @overload
    def dateFromParts(self, year: int, month: int, day: int) -> PySide6.QtCore.QDate:
        ...

    def dateTimeToString(
        self,
        format: str,
        datetime: PySide6.QtCore.QDateTime,
        dateOnly: PySide6.QtCore.QDate,
        timeOnly: PySide6.QtCore.QTime,
        locale: Union[PySide6.QtCore.QLocale, PySide6.QtCore.QLocale.Language],
    ) -> str:
        """
        https://doc.qt.io/qt-6/qcalendar.html#dateTimeToString

        **QString QCalendar::dateTimeToString(QStringView format , const
        QDateTime & datetime , QDate dateOnly , QTime timeOnly , const QLocale &
        locale ) const**

        Returns a string representing a given date, time or date-time.

        If **datetime** is valid, it is represented and format specifiers for
        both date and time fields are recognized; otherwise, if **dateOnly** is
        valid, it is represented and only format specifiers for date fields are
        recognized; finally, if **timeOnly** is valid, it is represented and
        only format specifiers for time fields are recognized. If none of these
        is valid, an empty string is returned.

        See **QDate::toString**  and **QTime::toString** () for the supported
        field specifiers. Characters in **format** that are recognized as field
        specifiers are replaced by text representing appropriate data from the
        date and/or time being represented. The texts to represent them may
        depend on the **locale** specified. Other charagers in **format** are
        copied verbatim into the returned string.

        **See also** **monthName** (), **weekDayName** (), **QDate::toString**
        (), and **QTime::toString** ().
        """
        ...

    def dayOfWeek(self, date: PySide6.QtCore.QDate) -> int:
        """
        https://doc.qt.io/qt-6/qcalendar.html#dayOfWeek

        **int QCalendar::dayOfWeek(QDate date ) const**

        Returns the day of the week number for the given **date**.

        Returns zero if the calendar is unable to represent the indicated date.
        Returns 1 for Monday through 7 for Sunday. Calendars with intercallary
        days may use other numbers to represent these.

        **See also** **partsFromDate** () and **Qt::DayOfWeek** .
        """
        ...

    def daysInMonth(self, month: int, year: int = ...) -> int:
        """
        https://doc.qt.io/qt-6/qcalendar.html#daysInMonth

        **int QCalendar::daysInMonth(int month , int year = Unspecified) const**

        Returns the number of days in the given **month** of the given **year**.

        Months are numbered consecutively, starting with 1 for the first month
        of each year. If **year** is `Unspecified` (its default, if not passed),
        the month's length in a normal year is returned.

        **See also** **maximumDaysInMonth** () and **minimumDaysInMonth** ().
        """
        ...

    def daysInYear(self, year: int) -> int:
        """
        https://doc.qt.io/qt-6/qcalendar.html#daysInYear

        **int QCalendar::daysInYear(int year ) const**

        Returns the number of days in the given **year**.

        Handling of `Unspecified` as **year** is undefined.
        """
        ...

    def hasYearZero(self) -> bool:
        """
        https://doc.qt.io/qt-6/qcalendar.html#hasYearZero

        **bool QCalendar::hasYearZero() const**

        Returns `true` if this calendar has a year zero.

        A calendar may represent years from its first year onwards but provide
        no way to describe years before its first; such a calendar has no year
        zero and is not proleptic.

        A calendar which represents years before its first may number these
        years simply by following the usual integer counting, so that the year
        before the first is year zero, with negative-numbered years preceding
        this; such a calendar is proleptic and has a year zero. A calendar might
        also have a year zero (for example, the year of some great event, with
        subsequent years being the first year after that event, the second year
        after, and so on) without describing years before its year zero. Such a
        calendar would have a year zero without being proleptic.

        Some calendars, however, represent years before their first by an
        alternate numbering; for example, the proleptic Gregorian calendar's
        first year is 1 CE and the year before it is 1 BCE, preceded by 2 BCE
        and so on. In this case, we use negative year numbers for this alternate
        numbering, with year -1 as the year before year 1, year -2 as the year
        before year -1 and so on. Such a calendar is proleptic but has no year
        zero.

        **See also** **isProleptic** ().
        """
        ...

    def isDateValid(self, year: int, month: int, day: int) -> bool:
        """
        https://doc.qt.io/qt-6/qcalendar.html#isDateValid

        **bool QCalendar::isDateValid(int year , int month , int day ) const**

        Returns `true` precisely if the given **year** , **month** , and **day**
        specify a valid date in this calendar.

        Usually this means 1 <= month <= **monthsInYear** (year) and 1 <= day <=
        **daysInMonth** (month, year). However, calendars with intercallary days
        or months may complicate that.
        """
        ...

    def isGregorian(self) -> bool:
        """
        https://doc.qt.io/qt-6/qcalendar.html#isGregorian

        **bool QCalendar::isGregorian() const**

        Returns `true` if this calendar object is the Gregorian calendar object
        used as default calendar by other Qt APIs, e.g. in **QDate** .
        """
        ...

    def isLeapYear(self, year: int) -> bool:
        """
        https://doc.qt.io/qt-6/qcalendar.html#isLeapYear

        **bool QCalendar::isLeapYear(int year ) const**

        Returns `true` if the given **year** is a leap year.

        Since the year is not a whole number of days long, some years are longer
        than others. The difference may be a whole month or just a single day;
        the details vary between calendars.

        **See also** **isDateValid** ().
        """
        ...

    def isLunar(self) -> bool:
        """
        https://doc.qt.io/qt-6/qcalendar.html#isLunar

        **bool QCalendar::isLunar() const**

        Returns `true` if this calendar is a lunar calendar.

        A lunar calendar is one based primarily on the phases of the moon.
        """
        ...

    def isLuniSolar(self) -> bool:
        """
        https://doc.qt.io/qt-6/qcalendar.html#isLuniSolar

        **bool QCalendar::isLuniSolar() const**

        Returns `true` if this calendar is luni-solar.

        A luni-solar calendar expresses the phases of the moon but adapts itself
        to also keep track of the Sun's varying position in the sky, relative to
        the fixed stars.
        """
        ...

    def isProleptic(self) -> bool:
        """
        https://doc.qt.io/qt-6/qcalendar.html#isProleptic

        **bool QCalendar::isProleptic() const**

        Returns `true` if this calendar is proleptic.

        A proleptic calendar is able to describe years arbitrarily long before
        its first. These are represented by negative year numbers and possibly
        by a year zero.

        **See also** **hasYearZero** ().
        """
        ...

    def isSolar(self) -> bool:
        """
        https://doc.qt.io/qt-6/qcalendar.html#isSolar

        **bool QCalendar::isSolar() const**

        Returns `true` if this calendar is solar.

        A solar calendar is based primarily on the Sun's varying position in the
        sky, relative to the fixed stars.
        """
        ...

    def isValid(self) -> bool:
        """
        https://doc.qt.io/qt-6/qcalendar.html#isValid

        **bool QCalendar::isValid() const**

        Returns true if this is a valid calendar object.

        Constructing a calendar with an unrecognised calendar name may result in
        an invalid object. Use this method to check after creating a calendar by
        name.
        """
        ...

    def maximumDaysInMonth(self) -> int:
        """
        https://doc.qt.io/qt-6/qcalendar.html#maximumDaysInMonth

        **int QCalendar::maximumDaysInMonth() const**

        Returns the number of days in the longest month in the calendar, in any
        year.

        **See also** **daysInMonth** () and **minimumDaysInMonth** ().
        """
        ...

    def maximumMonthsInYear(self) -> int:
        """
        https://doc.qt.io/qt-6/qcalendar.html#maximumMonthsInYear

        **int QCalendar::maximumMonthsInYear() const**

        Returns the largest number of months that any year may contain.

        **See also** **monthName** (), **standaloneMonthName** (), and
        **monthsInYear** ().
        """
        ...

    def minimumDaysInMonth(self) -> int:
        """
        https://doc.qt.io/qt-6/qcalendar.html#minimumDaysInMonth

        **int QCalendar::minimumDaysInMonth() const**

        Returns the number of days in the shortest month in the calendar, in any
        year.

        **See also** **daysInMonth** () and **maximumDaysInMonth** ().
        """
        ...

    def monthName(
        self,
        locale: Union[PySide6.QtCore.QLocale, PySide6.QtCore.QLocale.Language],
        month: int,
        year: int = ...,
        format: PySide6.QtCore.QLocale.FormatType = ...,
    ) -> str:
        """
        https://doc.qt.io/qt-6/qcalendar.html#monthName

        **QString QCalendar::monthName(const QLocale & locale , int month , int
        year = Unspecified, QLocale::FormatType format = QLocale::LongFormat)
        const**

        Returns a suitably localised name for a month.

        The month is indicated by a number, with **month** = 1 meaning the first
        month of the year and subsequent months numbered accordingly. Returns an
        empty string if the **month** number is unrecognized.

        The **year** may be Unspecified, in which case the mapping from numbers
        to names for a typical year's months should be used. Some calendars have
        leap months that aren't always at the end of the year; their mapping of
        month numbers to names may then depend on the placement of a leap month.
        Thus the year should normally be specified, if known.

        The name is returned in the form that would normally be used in a full
        date, in the specified **locale** ; the **format** determines how fully
        it shall be expressed (i.e. to what extent it is abbreviated).

        **See also** **standaloneMonthName** (), **maximumMonthsInYear** (), and
        **dateTimeToString** ().
        """
        ...

    def monthsInYear(self, year: int) -> int:
        """
        https://doc.qt.io/qt-6/qcalendar.html#monthsInYear

        **int QCalendar::monthsInYear(int year ) const**

        Returns the number of months in the given **year**.

        If **year** is `Unspecified`, returns the maximum number of months in a
        year.

        **See also** **maximumMonthsInYear** ().
        """
        ...

    def name(self) -> str:
        """
        https://doc.qt.io/qt-6/qcalendar.html#name

        **QString QCalendar::name() const**

        The primary name of this calendar.

        The calendar may also be known by some aliases. A calendar instantiated
        by name may use such an alias, in which case its name() need not match
        the alias by which it was instantiated.
        """
        ...

    def partsFromDate(
        self, date: PySide6.QtCore.QDate
    ) -> PySide6.QtCore.QCalendar.YearMonthDay:
        """
        https://doc.qt.io/qt-6/qcalendar.html#partsFromDate

        **QCalendar::YearMonthDay QCalendar::partsFromDate(QDate date ) const**

        Converts a **QDate**  to a year, month, and day of the month.

        The returned structure's **isValid** () shall be false if the calendar
        is unable to represent the given **date**. Otherwise its year, month,
        and day members record the so-named parts of its representation.

        **See also** **dateFromParts** (), **isProleptic** (), and
        **hasYearZero** ().
        """
        ...

    def standaloneMonthName(
        self,
        locale: Union[PySide6.QtCore.QLocale, PySide6.QtCore.QLocale.Language],
        month: int,
        year: int = ...,
        format: PySide6.QtCore.QLocale.FormatType = ...,
    ) -> str:
        """
        https://doc.qt.io/qt-6/qcalendar.html#standaloneMonthName

        **QString QCalendar::standaloneMonthName(const QLocale & locale , int
        month , int year = Unspecified, QLocale::FormatType format =
        QLocale::LongFormat) const**

        Returns a suitably localised standalone name for a month.

        The month is indicated by a number, with **month** = 1 meaning the first
        month of the year and subsequent months numbered accordingly. Returns an
        empty string if the **month** number is unrecognized.

        The **year** may be Unspecified, in which case the mapping from numbers
        to names for a typical year's months should be used. Some calendars have
        leap months that aren't always at the end of the year; their mapping of
        month numbers to names may then depend on the placement of a leap month.
        Thus the year should normally be specified, if known.

        The name is returned in the form that would be used in isolation in the
        specified **locale** ; the **format** determines how fully it shall be
        expressed (i.e. to what extent it is abbreviated).

        **See also** **monthName** (), **maximumMonthsInYear** (), and
        **dateTimeToString** ().
        """
        ...

    def standaloneWeekDayName(
        self,
        locale: Union[PySide6.QtCore.QLocale, PySide6.QtCore.QLocale.Language],
        day: int,
        format: PySide6.QtCore.QLocale.FormatType = ...,
    ) -> str:
        """
        https://doc.qt.io/qt-6/qcalendar.html#standaloneWeekDayName

        **QString QCalendar::standaloneWeekDayName(const QLocale & locale , int
        day , QLocale::FormatType format = QLocale::LongFormat) const**

        Returns a suitably localised standalone name for a day of the week.

        The days of the week are numbered from 1 for Monday through 7 for
        Sunday. Some calendars may support higher numbers for other days (e.g.
        intercallary days, that are not part of any week). Returns an empty
        string if the **day** number is unrecognized.

        The name is returned in the form that would be used in isolation (for
        example as a column heading in a calendar's tabular display of a month
        with successive weeks as rows) in the specified **locale** ; the
        **format** determines how fully it shall be expressed (i.e. to what
        extent it is abbreviated).

        **See also** **weekDayName** () and **dayOfWeek** ().
        """
        ...

    def weekDayName(
        self,
        locale: Union[PySide6.QtCore.QLocale, PySide6.QtCore.QLocale.Language],
        day: int,
        format: PySide6.QtCore.QLocale.FormatType = ...,
    ) -> str:
        """
        https://doc.qt.io/qt-6/qcalendar.html#weekDayName

        **QString QCalendar::weekDayName(const QLocale & locale , int day ,
        QLocale::FormatType format = QLocale::LongFormat) const**

        Returns a suitably localised name for a day of the week.

        The days of the week are numbered from 1 for Monday through 7 for
        Sunday. Some calendars may support higher numbers for other days (e.g.
        intercallary days, that are not part of any week). Returns an empty
        string if the **day** number is unrecognized.

        The name is returned in the form that would normally be used in a full
        date, in the specified **locale** ; the **format** determines how fully
        it shall be expressed (i.e. to what extent it is abbreviated).

        **See also** **standaloneWeekDayName** () and **dayOfWeek** ().
        """
        ...
