"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtCore, except for defaults which are replaced by "...".
"""
from typing import overload
import PySide6.QtCore

bytes = str


class QBasicTimer(object):
    """
    https://doc.qt.io/qt-6/qbasictimer.html

    **Detailed Description**

    This is a fast, lightweight, and low-level class used by Qt internally. We
    recommend using the higher-level **QTimer**  class rather than this class if
    you want to use timers in your applications. Note that this timer is a
    repeating timer that will send subsequent timer events unless the **stop**
    () function is called.

    To use this class, create a QBasicTimer, and call its **start** () function
    with a timeout interval and with a pointer to a **QObject**  subclass. When
    the timer times out it will send a timer event to the **QObject**  subclass.
    The timer can be stopped at any time using **stop** (). **isActive** ()
    returns `true` for a timer that is running; i.e. it has been started, has
    not reached the timeout time, and has not been stopped. The timer's ID can
    be retrieved using **timerId** ().

    Objects of this class cannot be copied, but can be moved, so you can
    maintain a list of basic timers by holding them in container that supports
    move-only types, e.g. std::vector.

    The **Wiggly**  example uses QBasicTimer to repaint a widget at regular
    intervals.

    **See also** **QTimer** , **QTimerEvent** , **QObject::timerEvent** (),
    **Timers** , and **Wiggly Example** .
    """

    def __init__(self) -> None:
        """
        https://doc.qt.io/qt-6/qbasictimer.html#QBasicTimer-1

        **QBasicTimer::QBasicTimer()**

        Constructs a basic timer.

        **See also** **start** ().
        """
        ...

    def isActive(self) -> bool:
        """
        https://doc.qt.io/qt-6/qbasictimer.html#isActive

        **bool QBasicTimer::isActive() const**

        Returns `true` if the timer is running and has not been stopped;
        otherwise returns `false`.

        **See also** **start** () and **stop** ().
        """
        ...

    @overload
    def start(self, msec: int, obj: PySide6.QtCore.QObject) -> None:
        """
        https://doc.qt.io/qt-6/qbasictimer.html#start

        **void QBasicTimer::start(int msec , QObject * object )**

        Starts (or restarts) the timer with a **msec** milliseconds timeout. The
        timer will be a **Qt::CoarseTimer** . See **Qt::TimerType**  for
        information on the different timer types.

        The given **object** will receive timer events.

        **See also** **stop** (), **isActive** (), **QObject::timerEvent** (),
        and **Qt::CoarseTimer** .
        """
        ...

    @overload
    def start(
        self,
        msec: int,
        timerType: PySide6.QtCore.Qt.TimerType,
        obj: PySide6.QtCore.QObject,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qbasictimer.html#start-1

        **void QBasicTimer::start(int msec , Qt::TimerType timerType , QObject *
        obj )**

        This is an overloaded function.

        Starts (or restarts) the timer with a **msec** milliseconds timeout and
        the given **timerType**. See **Qt::TimerType**  for information on the
        different timer types.

        **obj** will receive timer events.

        **See also** **stop** (), **isActive** (), **QObject::timerEvent** (),
        and **Qt::TimerType** .
        """
        ...

    def stop(self) -> None:
        """
        https://doc.qt.io/qt-6/qbasictimer.html#stop

        **void QBasicTimer::stop()**

        Stops the timer.

        **See also** **start** () and **isActive** ().
        """
        ...

    def swap(self, other: PySide6.QtCore.QBasicTimer) -> None:
        """
        https://doc.qt.io/qt-6/qbasictimer.html#swap

        **[since 5.14] void QBasicTimer::swap(QBasicTimer & other )**

        Swaps string **other** with this string, or **lhs** with **rhs**. This
        operation is very fast and never fails.

        This function was introduced in Qt 5.14.
        """
        ...

    def timerId(self) -> int:
        """
        https://doc.qt.io/qt-6/qbasictimer.html#timerId

        **int QBasicTimer::timerId() const**

        Returns the timer's ID.

        **See also** **QTimerEvent::timerId** ().
        """
        ...
