"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtCharts, except for defaults which are replaced by "...".
"""
from typing import List, Optional, Sequence, overload
import PySide6.QtCore
import PySide6.QtGui
import PySide6.QtWidgets
import PySide6.QtCharts

bytes = str


class QPieSeries(PySide6.QtCharts.QAbstractSeries):
    """
    https://doc.qt.io/qt-6/qpieseries.html

    **Detailed Description**

    A pie series consists of slices that are defined as **QPieSlice**  objects.
    The slices can have any values as the QPieSeries object calculates the
    percentage of a slice compared with the sum of all slices in the series to
    determine the actual size of the slice in the chart.

    Pie size and position on the chart are controlled by using relative values
    that range from 0.0 to 1.0. These relate to the actual chart rectangle.

    By default, the pie is defined as a full pie. A partial pie can be created
    by setting a starting angle and angle span for the series. A full pie is 360
    degrees, where 0 is at 12 a'clock.

    See the **pie chart example**  or **donut chart example**  to learn how to
    use QPieSeries.

    ![](images/examples_piechart.png)

    ![](images/examples_donutchart.png)

    **See also** **QPieSlice**  and **QChart** .
    """

    def __init__(self, parent: Optional[PySide6.QtCore.QObject] = ...) -> None:
        """
        https://doc.qt.io/qt-6/qpieseries.html#QPieSeries

        **QPieSeries::QPieSeries(QObject * parent = nullptr)**

        Constructs a series object that is a child of **parent**.
        """
        ...

    def __lshift__(
        self, slice: PySide6.QtCharts.QPieSlice
    ) -> PySide6.QtCharts.QPieSeries:
        ...

    @overload
    def append(self, label: str, value: float) -> PySide6.QtCharts.QPieSlice:
        """
        https://doc.qt.io/qt-6/qpieseries.html#append

        **bool QPieSeries::append(QPieSlice * slice )**

        Appends the slice specified by **slice** to the series. Slice ownership
        is passed to the series.

        Returns `true` if appending succeeds.
        """
        ...

    @overload
    def append(self, slice: PySide6.QtCharts.QPieSlice) -> bool:
        """
        https://doc.qt.io/qt-6/qpieseries.html#append-1

        **bool QPieSeries::append(const QList<QPieSlice *> & slices )**

        Appends the array of slices specified by **slices** to the series. Slice
        ownership is passed to the series.

        Returns `true` if appending succeeds.
        """
        ...

    @overload
    def append(self, slices: Sequence[PySide6.QtCharts.QPieSlice]) -> bool:
        """
        https://doc.qt.io/qt-6/qpieseries.html#append-2

        **QPieSlice *QPieSeries::append(const QString & label , qreal value )**

        Appends a single slice with the specified **value** and **label** to the
        series. Slice ownership is passed to the series. Returns null if
        **value** is `NaN`, `Inf`, or `-Inf` and adds nothing to the series.
        """
        ...

    def clear(self) -> None:
        """
        https://doc.qt.io/qt-6/qpieseries.html#clear

        **void QPieSeries::clear()**

        Clears all slices from the series.
        """
        ...

    def count(self) -> int:
        """
        https://doc.qt.io/qt-6/qpieseries.html#count

        **int QPieSeries::count() const**

        Returns the number of the slices in this series.

        **Note:** Getter function for property count.
        """
        ...

    def holeSize(self) -> float:
        """
        https://doc.qt.io/qt-6/qpieseries.html#holeSize-prop

        **holeSize : qreal**

        This property holds the donut hole size.

        The value is relative to the chart rectangle, so that:

        * 0.0 is the minimum size (full pie drawn without a hole).
          * 1.0 is
        the maximum size that can fit the chart (the donut has no width).

        When setting this property, the **size**  property is adjusted if
        necessary, to ensure that the hole size is not greater than the pie
        size.

        The default value is 0.0.

        **Access functions:**

        qreal **holeSize** () const
        void **setHoleSize** (qreal **holeSize** )
        """
        ...

    def horizontalPosition(self) -> float:
        """
        https://doc.qt.io/qt-6/qpieseries.html#horizontalPosition-prop

        **horizontalPosition : qreal**

        This property holds the horizontal position of the pie.

        The value is relative to the chart rectangle, so that:

        * 0.0 is the absolute left.
          * 1.0 is the absolute right.

        The default value is 0.5 (center).

        **Access functions:**

        qreal **horizontalPosition** () const
        void **setHorizontalPosition**
        (qreal **relativePosition** )

        **See also** **verticalPosition** .
        """
        ...

    def insert(self, index: int, slice: PySide6.QtCharts.QPieSlice) -> bool:
        """
        https://doc.qt.io/qt-6/qpieseries.html#insert

        **bool QPieSeries::insert(int index , QPieSlice * slice )**

        Inserts the slice specified by **slice** to the series before the slice
        at the position specified by **index**. Slice ownership is passed to the
        series.

        Returns `true` if inserting succeeds.
        """
        ...

    def isEmpty(self) -> bool:
        """
        https://doc.qt.io/qt-6/qpieseries.html#isEmpty

        **bool QPieSeries::isEmpty() const**

        Returns `true` if the series is empty.
        """
        ...

    def pieEndAngle(self) -> float:
        """
        https://doc.qt.io/qt-6/qpieseries.html#pieEndAngle

        **qreal QPieSeries::pieEndAngle() const**

        Returns the end angle of the pie.

        A full pie is 360 degrees, where 0 degrees is at 12 a'clock.

        **Note:** Getter function for property **endAngle** .

        **See also** **setPieEndAngle** (), **pieStartAngle** (), and
        **setPieStartAngle** ().
        """
        ...

    def pieSize(self) -> float:
        ...

    def pieStartAngle(self) -> float:
        ...

    def remove(self, slice: PySide6.QtCharts.QPieSlice) -> bool:
        """
        https://doc.qt.io/qt-6/qpieseries.html#remove

        **bool QPieSeries::remove(QPieSlice * slice )**

        Removes a single slice, specified by **slice** , from the series and
        deletes it permanently.

        The pointer cannot be referenced after this call.

        Returns `true` if the removal succeeds.
        """
        ...

    def setHoleSize(self, holeSize: float) -> None:
        """
        https://doc.qt.io/qt-6/qpieseries.html#holeSize-prop

        **holeSize : qreal**

        This property holds the donut hole size.

        The value is relative to the chart rectangle, so that:

        * 0.0 is the minimum size (full pie drawn without a hole).
          * 1.0 is
        the maximum size that can fit the chart (the donut has no width).

        When setting this property, the **size**  property is adjusted if
        necessary, to ensure that the hole size is not greater than the pie
        size.

        The default value is 0.0.

        **Access functions:**

        qreal **holeSize** () const
        void **setHoleSize** (qreal **holeSize** )
        """
        ...

    def setHorizontalPosition(self, relativePosition: float) -> None:
        """
        https://doc.qt.io/qt-6/qpieseries.html#horizontalPosition-prop

        **horizontalPosition : qreal**

        This property holds the horizontal position of the pie.

        The value is relative to the chart rectangle, so that:

        * 0.0 is the absolute left.
          * 1.0 is the absolute right.

        The default value is 0.5 (center).

        **Access functions:**

        qreal **horizontalPosition** () const
        void **setHorizontalPosition**
        (qreal **relativePosition** )

        **See also** **verticalPosition** .
        """
        ...

    def setLabelsPosition(
        self, position: PySide6.QtCharts.QPieSlice.LabelPosition
    ) -> None:
        """
        https://doc.qt.io/qt-6/qpieseries.html#setLabelsPosition

        **void QPieSeries::setLabelsPosition(QPieSlice::LabelPosition position
        )**

        Sets the position of all the slice labels to **position**.

        **Note:** This function affects only the current slices in the series.
        If a new slice is added, the default label position is
        **QPieSlice::LabelOutside** .

        **See also** **QPieSlice::labelPosition** () and
        **QPieSlice::setLabelPosition** ().
        """
        ...

    def setLabelsVisible(self, visible: bool = ...) -> None:
        """
        https://doc.qt.io/qt-6/qpieseries.html#setLabelsVisible

        **void QPieSeries::setLabelsVisible(bool visible = true)**

        Sets the visibility of all slice labels to **visible**.

        **Note:** This function affects only the current slices in the series.
        If a new slice is added, the default label visibility is `false`.

        **See also** **QPieSlice::isLabelVisible** () and
        **QPieSlice::setLabelVisible** ().
        """
        ...

    def setPieEndAngle(self, endAngle: float) -> None:
        """
        https://doc.qt.io/qt-6/qpieseries.html#setPieEndAngle

        **void QPieSeries::setPieEndAngle(qreal angle )**

        Sets the end angle of the pie.

        A full pie is 360 degrees, where 0 degrees is at 12 a'clock.

        **angle** must be greater than the start angle.

        **Note:** Setter function for property **endAngle** .

        **See also** **pieEndAngle** (), **pieStartAngle** (), and
        **setPieStartAngle** ().
        """
        ...

    def setPieSize(self, relativeSize: float) -> None:
        ...

    def setPieStartAngle(self, startAngle: float) -> None:
        ...

    def setVerticalPosition(self, relativePosition: float) -> None:
        """
        https://doc.qt.io/qt-6/qpieseries.html#verticalPosition-prop

        **verticalPosition : qreal**

        This property holds the vertical position of the pie.

        The value is relative to the chart rectangle, so that:

        * 0.0 is the absolute top.
          * 1.0 is the absolute bottom.

        The default value is 0.5 (center).

        **Access functions:**

        qreal **verticalPosition** () const
        void **setVerticalPosition**
        (qreal **relativePosition** )

        **See also** **horizontalPosition** .

        **Member Function Documentation**
        """
        ...

    def slices(self) -> List[PySide6.QtCharts.QPieSlice]:
        """
        https://doc.qt.io/qt-6/qpieseries.html#slices

        **QList<QPieSlice *> QPieSeries::slices() const**

        Returns a list of slices that belong to this series.
        """
        ...

    def sum(self) -> float:
        """
        https://doc.qt.io/qt-6/qpieseries.html#sum

        **qreal QPieSeries::sum() const**

        Returns the sum of all slice values in this series.

        **Note:** Getter function for property sum.

        **See also** **QPieSlice::value** (), **QPieSlice::setValue** (), and
        **QPieSlice::percentage** ().
        """
        ...

    def take(self, slice: PySide6.QtCharts.QPieSlice) -> bool:
        """
        https://doc.qt.io/qt-6/qpieseries.html#take

        **bool QPieSeries::take(QPieSlice * slice )**

        Takes a single slice, specified by **slice** , from the series. Does not
        delete the slice object.

        **Note:** The series remains the slice's parent object. You must set the
        parent object to take full ownership.

        Returns `true` if the take operation was successful.
        """
        ...

    def type(self) -> PySide6.QtCharts.QAbstractSeries.SeriesType:
        """
        https://doc.qt.io/qt-6/qpieseries.html#type

        **[override virtual] QAbstractSeries::SeriesType QPieSeries::type()
        const**

        Reimplements an access function for property: **QAbstractSeries::type**
        .

        Returns the type of the series.
        """
        ...

    def verticalPosition(self) -> float:
        """
        https://doc.qt.io/qt-6/qpieseries.html#verticalPosition-prop

        **verticalPosition : qreal**

        This property holds the vertical position of the pie.

        The value is relative to the chart rectangle, so that:

        * 0.0 is the absolute top.
          * 1.0 is the absolute bottom.

        The default value is 0.5 (center).

        **Access functions:**

        qreal **verticalPosition** () const
        void **setVerticalPosition**
        (qreal **relativePosition** )

        **See also** **horizontalPosition** .

        **Member Function Documentation**
        """
        ...

    @property
    def added(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qpieseries.html#added

        **[signal] void QPieSeries::added(const QList<QPieSlice *> & slices )**

        This signal is emitted when the slices specified by **slices** are added
        to the series.

        **See also** **append** () and **insert** ().
        """
        ...

    @property
    def clicked(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qpieseries.html#clicked

        **[signal] void QPieSeries::clicked(QPieSlice * slice )**

        This signal is emitted when the slice specified by **slice** is clicked.

        **See also** **QPieSlice::clicked** ().
        """
        ...

    @property
    def countChanged(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qpieseries.html#countChanged

        **[signal] void QPieSeries::countChanged()**

        This signal is emitted when the slice count changes.

        **Note:** Notifier signal for property **count** .

        **See also** **count** .
        """
        ...

    @property
    def doubleClicked(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qpieseries.html#doubleClicked

        **[signal] void QPieSeries::doubleClicked(QPieSlice * slice )**

        This signal is emitted when the slice specified by **slice** is double-
        clicked.

        **See also** **QPieSlice::doubleClicked** ().
        """
        ...

    @property
    def hovered(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qpieseries.html#hovered

        **[signal] void QPieSeries::hovered(QPieSlice * slice , bool state )**

        This signal is emitted when a mouse is hovered over the slice specified
        by **slice**. When the mouse moves over the slice, **state** turns
        `true`, and when the mouse moves away again, it turns `false`.

        **See also** **QPieSlice::hovered** ().
        """
        ...

    @property
    def pressed(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qpieseries.html#pressed

        **[signal] void QPieSeries::pressed(QPieSlice * slice )**

        This signal is emitted when the user clicks the slice specified by
        **slice** and holds down the mouse button.

        **See also** **QPieSlice::pressed** ().
        """
        ...

    @property
    def released(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qpieseries.html#released

        **[signal] void QPieSeries::released(QPieSlice * slice )**

        This signal is emitted when the user releases the mouse press on the
        slice specified by **slice**.

        **See also** **QPieSlice::released** ().
        """
        ...

    @property
    def removed(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qpieseries.html#removed

        **[signal] void QPieSeries::removed(const QList<QPieSlice *> & slices
        )**

        This signal is emitted when the slices specified by **slices** are
        removed from the series.

        **See also** **remove** ().
        """
        ...

    @property
    def sumChanged(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qpieseries.html#sumChanged

        **[signal] void QPieSeries::sumChanged()**

        This signal is emitted when the sum of all slices changes.

        **Note:** Notifier signal for property **sum** .

        **See also** **sum** .
        """
        ...
