"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtCharts, except for defaults which are replaced by "...".
"""
from typing import Optional
import PySide6.QtCore
import PySide6.QtGui
import PySide6.QtWidgets
import PySide6.QtCharts

bytes = str


class QDateTimeAxis(PySide6.QtCharts.QAbstractAxis):
    """
    https://doc.qt.io/qt-6/qdatetimeaxis.html

    **Detailed Description**

    QDateTimeAxis can be set up to show an axis line with tick marks, grid
    lines, and shades. The labels can be configured by setting an appropriate
    DateTime format. QDateTimeAxis works correctly with dates from 4714 BCE to
    287396 CE. For other limitiations related to **QDateTime** , see
    **QDateTime**  documentation.

    **Note:** QDateTimeAxis is disabled on platforms that define qreal as float.

    ![](images/api_datatime_axis.png)

    QDateTimeAxis can be used with any **QXYSeries** . To add a data point to
    the series, **QDateTime::toMSecsSinceEpoch** () is used:

    **QLineSeries**  *series = new **QLineSeries** ;

        **QDateTime**
    xValue;
        xValue.setDate(**QDate** (2012, 1 , 18));
    xValue.setTime(**QTime** (9, 34));
        **qreal**  yValue = 12;
    series->append(xValue.toMSecsSinceEpoch(), yValue);
    xValue.setDate(**QDate** (2013, 5 , 11));
        xValue.setTime(**QTime** (11,
    14));
        **qreal**  yValue = 22;
    series->append(xValue.toMSecsSinceEpoch(), yValue);

    The following code snippet illustrates adding the series to the chart and
    setting up QDateTimeAxis:

    **QChartView**  *chartView = new **QChartView** ;
    chartView->chart()->addSeries(series);

        // ...
        **QDateTimeAxis**
    *axisX = new **QDateTimeAxis** ;
        axisX->setFormat("dd-MM-yyyy h:mm");
    chartView->chart()->setAxisX(axisX, series);
    """

    def __init__(self, parent: Optional[PySide6.QtCore.QObject] = ...) -> None:
        """
        https://doc.qt.io/qt-6/qdatetimeaxis.html#QDateTimeAxis

        **QDateTimeAxis::QDateTimeAxis(QObject * parent = nullptr)**

        Constructs an axis object that is a child of **parent**.
        """
        ...

    def format(self) -> str:
        """
        https://doc.qt.io/qt-6/qdatetimeaxis.html#format-prop

        **format : QString**

        This property holds the format string that is used when creating the
        label for the axis out of a **QDateTime**  object.

        See **QDateTime**  documentation for information on how the string
        should be defined.

        **Access functions:**

        QString **format** () const
        void **setFormat** (QString **format** )

        **Notifier signal:**

        void ****formatChanged** ** (QString **format** )

        **See also** **QChart::locale** .
        """
        ...

    def max(self) -> PySide6.QtCore.QDateTime:
        """
        https://doc.qt.io/qt-6/qdatetimeaxis.html#max-prop

        **max : QDateTime**

        This property holds the maximum value on the axis.

        When setting this property, the minimum value is adjusted if necessary,
        to ensure that the range remains valid.

        **Access functions:**

        QDateTime **max** () const
        void **setMax** (QDateTime **max** )

        **Notifier signal:**

        void ****maxChanged** ** (QDateTime **max** )
        """
        ...

    def min(self) -> PySide6.QtCore.QDateTime:
        """
        https://doc.qt.io/qt-6/qdatetimeaxis.html#min-prop

        **min : QDateTime**

        This property holds the minimum value on the axis.

        When setting this property, the maximum value is adjusted if necessary,
        to ensure that the range remains valid.

        **Access functions:**

        QDateTime **min** () const
        void **setMin** (QDateTime **min** )

        **Notifier signal:**

        void ****minChanged** ** (QDateTime **min** )
        """
        ...

    def setFormat(self, format: str) -> None:
        """
        https://doc.qt.io/qt-6/qdatetimeaxis.html#format-prop

        **format : QString**

        This property holds the format string that is used when creating the
        label for the axis out of a **QDateTime**  object.

        See **QDateTime**  documentation for information on how the string
        should be defined.

        **Access functions:**

        QString **format** () const
        void **setFormat** (QString **format** )

        **Notifier signal:**

        void ****formatChanged** ** (QString **format** )

        **See also** **QChart::locale** .
        """
        ...

    def setMax(self, max: PySide6.QtCore.QDateTime) -> None:
        """
        https://doc.qt.io/qt-6/qdatetimeaxis.html#max-prop

        **max : QDateTime**

        This property holds the maximum value on the axis.

        When setting this property, the minimum value is adjusted if necessary,
        to ensure that the range remains valid.

        **Access functions:**

        QDateTime **max** () const
        void **setMax** (QDateTime **max** )

        **Notifier signal:**

        void ****maxChanged** ** (QDateTime **max** )
        """
        ...

    def setMin(self, min: PySide6.QtCore.QDateTime) -> None:
        """
        https://doc.qt.io/qt-6/qdatetimeaxis.html#min-prop

        **min : QDateTime**

        This property holds the minimum value on the axis.

        When setting this property, the maximum value is adjusted if necessary,
        to ensure that the range remains valid.

        **Access functions:**

        QDateTime **min** () const
        void **setMin** (QDateTime **min** )

        **Notifier signal:**

        void ****minChanged** ** (QDateTime **min** )
        """
        ...

    def setRange(
        self, min: PySide6.QtCore.QDateTime, max: PySide6.QtCore.QDateTime
    ) -> None:
        """
        https://doc.qt.io/qt-6/qdatetimeaxis.html#setRange

        **void QDateTimeAxis::setRange(QDateTime min , QDateTime max )**

        Sets the range on the axis from **min** to **max**. If **min** is
        greater than **max** , this function returns without making any changes.
        """
        ...

    def setTickCount(self, count: int) -> None:
        """
        https://doc.qt.io/qt-6/qdatetimeaxis.html#setTickCount

        **void QDateTimeAxis::setTickCount(int count )**

        Sets the number of tick marks on the axis to **count**.

        **Note:** Setter function for property **tickCount** .

        **See also** **tickCount** ().
        """
        ...

    def tickCount(self) -> int:
        """
        https://doc.qt.io/qt-6/qdatetimeaxis.html#tickCount

        **int QDateTimeAxis::tickCount() const**

        Returns the number of tick marks on the axis.

        **Note:** Getter function for property tickCount.

        **See also** **setTickCount** ().
        """
        ...

    def type(self) -> PySide6.QtCharts.QAbstractAxis.AxisType:
        """
        https://doc.qt.io/qt-6/qdatetimeaxis.html#type

        **[override virtual] QAbstractAxis::AxisType QDateTimeAxis::type()
        const**

        Reimplements: **QAbstractAxis::type() const** .

        Returns the type of the axis.
        """
        ...

    @property
    def formatChanged(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qdatetimeaxis.html#formatChanged

        **[signal] void QDateTimeAxis::formatChanged(QString format )**

        This signal is emitted when the **format** of the axis changes.

        **Note:** Notifier signal for property **format** .
        """
        ...

    @property
    def maxChanged(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qdatetimeaxis.html#maxChanged

        **[signal] void QDateTimeAxis::maxChanged(QDateTime max )**

        This signal is emitted when the maximum value of the axis, specified by
        **max** , changes.

        **Note:** Notifier signal for property **max** .
        """
        ...

    @property
    def minChanged(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qdatetimeaxis.html#minChanged

        **[signal] void QDateTimeAxis::minChanged(QDateTime min )**

        This signal is emitted when the minimum value of the axis, specified by
        **min** , changes.

        **Note:** Notifier signal for property **min** .
        """
        ...

    @property
    def rangeChanged(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qdatetimeaxis.html#rangeChanged

        **[signal] void QDateTimeAxis::rangeChanged(QDateTime min , QDateTime
        max )**

        This signal is emitted when the minimum or maximum value of the axis,
        specified by **min** and **max** , changes.
        """
        ...

    @property
    def tickCountChanged(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qdatetimeaxis.html#tickCountChanged

        **[signal] void QDateTimeAxis::tickCountChanged(int tickCount )**

        This signal is emitted when the number of tick marks on the axis,
        specified by **tickCount** , changes.

        **Note:** Notifier signal for property **tickCount** .
        """
        ...
