"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtCharts, except for defaults which are replaced by "...".
"""
from typing import Optional
import PySide6.QtCore
import PySide6.QtGui
import PySide6.QtWidgets
import PySide6.QtCharts

bytes = str


class QCandlestickModelMapper(PySide6.QtCore.QObject):
    """
    https://doc.qt.io/qt-6/qcandlestickmodelmapper.html

    **Detailed Description**

    Model mappers allow the use of a **QAbstractItemModel** -derived model as a
    data source for a chart series, creating a connection between a
    **QCandlestickSeries**  and the model object. A model mapper maintains an
    equal size across all **QCandlestickSets** .

    **Note:** The model used must support adding and removing rows/columns and
    modifying the data of the cells.
    """

    def __init__(self, parent: Optional[PySide6.QtCore.QObject] = ...) -> None:
        """
        https://doc.qt.io/qt-6/qcandlestickmodelmapper.html#QCandlestickModelMap
        per

        **QCandlestickModelMapper::QCandlestickModelMapper(QObject * parent =
        nullptr)**

        Constructs a model mapper object as a child of **parent**.
        """
        ...

    def close(self) -> int:
        """
        https://doc.qt.io/qt-6/qcandlestickmodelmapper.html#close

        **[protected] int QCandlestickModelMapper::close() const**

        Returns the row/column of the model that contains the close values of
        the sets in the series. Default value is -1 (invalid mapping).

        **See also** **setClose** ().
        """
        ...

    def firstSetSection(self) -> int:
        """
        https://doc.qt.io/qt-6/qcandlestickmodelmapper.html#firstSetSection

        **[protected] int QCandlestickModelMapper::firstSetSection() const**

        Returns the section of the model that is used as the data source for the
        first candlestick set. Default value is -1 (invalid mapping).

        **See also** **setFirstSetSection** ().
        """
        ...

    def high(self) -> int:
        """
        https://doc.qt.io/qt-6/qcandlestickmodelmapper.html#high

        **[protected] int QCandlestickModelMapper::high() const**

        Returns the row/column of the model that contains the high values of the
        sets in the series. Default value is -1 (invalid mapping).

        **See also** **setHigh** ().
        """
        ...

    def lastSetSection(self) -> int:
        """
        https://doc.qt.io/qt-6/qcandlestickmodelmapper.html#lastSetSection

        **[protected] int QCandlestickModelMapper::lastSetSection() const**

        Returns the section of the model that is used as the data source for the
        last candlestick set. Default value is -1 (invalid mapping).

        **See also** **setLastSetSection** ().
        """
        ...

    def low(self) -> int:
        """
        https://doc.qt.io/qt-6/qcandlestickmodelmapper.html#low

        **[protected] int QCandlestickModelMapper::low() const**

        Returns the row/column of the model that contains the low values of the
        sets in the series. Default value is -1 (invalid mapping).

        **See also** **setLow** ().
        """
        ...

    def model(self) -> PySide6.QtCore.QAbstractItemModel:
        """
        https://doc.qt.io/qt-6/qcandlestickmodelmapper.html#model-prop

        **model : QAbstractItemModel***

        Defines the model that is used by the mapper.

        **Access functions:**

        QAbstractItemModel * **model** () const
        void **setModel**
        (QAbstractItemModel * **model** )

        **Notifier signal:**

        void ****modelReplaced** ** ()
        """
        ...

    def open(self) -> int:
        """
        https://doc.qt.io/qt-6/qcandlestickmodelmapper.html#open

        **[protected] int QCandlestickModelMapper::open() const**

        Returns the row/column of the model that contains the open values of the
        sets in the series. Default value is -1 (invalid mapping).

        **See also** **setOpen** ().
        """
        ...

    def orientation(self) -> PySide6.QtCore.Qt.Orientation:
        """
        https://doc.qt.io/qt-6/qcandlestickmodelmapper.html#orientation

        **[pure virtual] Qt::Orientation QCandlestickModelMapper::orientation()
        const**

        Returns the orientation that is used when **QCandlestickModelMapper**
        accesses the model. This determines whether the consecutive values of
        the set are read from rows (**Qt::Horizontal** ) or from columns
        (**Qt::Vertical** ).
        """
        ...

    def series(self) -> PySide6.QtCharts.QCandlestickSeries:
        """
        https://doc.qt.io/qt-6/qcandlestickmodelmapper.html#series-prop

        **series : QCandlestickSeries***

        Defines the **QCandlestickSeries**  object that is used by the mapper.

        **Note:** All data in the series is discarded when it is set to the
        mapper. When a new series is specified, the old series is disconnected
        (preserving its data).

        **Access functions:**

        QCandlestickSeries * **series** () const
        void **setSeries**
        (QCandlestickSeries * **series** )

        **Notifier signal:**

        void ****seriesReplaced** ** ()

        **Member Function Documentation**
        """
        ...

    def setClose(self, close: int) -> None:
        """
        https://doc.qt.io/qt-6/qcandlestickmodelmapper.html#setClose

        **[protected] void QCandlestickModelMapper::setClose(int close )**

        Sets the row/column of the model that contains the **close** values of
        the sets in the series. Default value is -1 (invalid mapping).

        **See also** **close** ().
        """
        ...

    def setFirstSetSection(self, firstSetSection: int) -> None:
        """
        https://doc.qt.io/qt-6/qcandlestickmodelmapper.html#setFirstSetSection

        **[protected] void QCandlestickModelMapper::setFirstSetSection(int
        firstSetSection )**

        Sets the section of the model that is used as the data source for the
        first candlestick set. Parameter **firstSetSection** specifies the
        section of the model. Default value is -1.

        **See also** **firstSetSection** ().
        """
        ...

    def setHigh(self, high: int) -> None:
        """
        https://doc.qt.io/qt-6/qcandlestickmodelmapper.html#setHigh

        **[protected] void QCandlestickModelMapper::setHigh(int high )**

        Sets the row/column of the model that contains the **high** values of
        the sets in the series. Default value is -1 (invalid mapping).

        **See also** **high** ().
        """
        ...

    def setLastSetSection(self, lastSetSection: int) -> None:
        """
        https://doc.qt.io/qt-6/qcandlestickmodelmapper.html#setLastSetSection

        **[protected] void QCandlestickModelMapper::setLastSetSection(int
        lastSetSection )**

        Sets the section of the model that is used as the data source for the
        last candlestick set. Parameter **lastSetSection** specifies the section
        of the model. Default value is -1.

        **See also** **lastSetSection** ().
        """
        ...

    def setLow(self, low: int) -> None:
        """
        https://doc.qt.io/qt-6/qcandlestickmodelmapper.html#setLow

        **[protected] void QCandlestickModelMapper::setLow(int low )**

        Sets the row/column of the model that contains the **low** values of the
        sets in the series. Default value is -1 (invalid mapping).

        **See also** **low** ().
        """
        ...

    def setModel(self, model: PySide6.QtCore.QAbstractItemModel) -> None:
        """
        https://doc.qt.io/qt-6/qcandlestickmodelmapper.html#model-prop

        **model : QAbstractItemModel***

        Defines the model that is used by the mapper.

        **Access functions:**

        QAbstractItemModel * **model** () const
        void **setModel**
        (QAbstractItemModel * **model** )

        **Notifier signal:**

        void ****modelReplaced** ** ()
        """
        ...

    def setOpen(self, open: int) -> None:
        """
        https://doc.qt.io/qt-6/qcandlestickmodelmapper.html#setOpen

        **[protected] void QCandlestickModelMapper::setOpen(int open )**

        Sets the row/column of the model that contains the **open** values of
        the sets in the series. Default value is -1 (invalid mapping).

        **See also** **open** ().
        """
        ...

    def setSeries(self, series: PySide6.QtCharts.QCandlestickSeries) -> None:
        """
        https://doc.qt.io/qt-6/qcandlestickmodelmapper.html#series-prop

        **series : QCandlestickSeries***

        Defines the **QCandlestickSeries**  object that is used by the mapper.

        **Note:** All data in the series is discarded when it is set to the
        mapper. When a new series is specified, the old series is disconnected
        (preserving its data).

        **Access functions:**

        QCandlestickSeries * **series** () const
        void **setSeries**
        (QCandlestickSeries * **series** )

        **Notifier signal:**

        void ****seriesReplaced** ** ()

        **Member Function Documentation**
        """
        ...

    def setTimestamp(self, timestamp: int) -> None:
        """
        https://doc.qt.io/qt-6/qcandlestickmodelmapper.html#setTimestamp

        **[protected] void QCandlestickModelMapper::setTimestamp(int timestamp
        )**

        Sets the row/column of the model that contains the **timestamp** values
        of the sets in the series. Default value is -1 (invalid mapping).

        **See also** **timestamp** ().
        """
        ...

    def timestamp(self) -> int:
        """
        https://doc.qt.io/qt-6/qcandlestickmodelmapper.html#timestamp

        **[protected] int QCandlestickModelMapper::timestamp() const**

        Returns the row/column of the model that contains the timestamp values
        of the sets in the series. Default value is -1 (invalid mapping).

        **See also** **setTimestamp** ().
        """
        ...

    @property
    def modelReplaced(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qcandlestickmodelmapper.html#modelReplaced

        **[signal] void QCandlestickModelMapper::modelReplaced()**

        Emitted when the model, to which the mapper is connected, has changed.

        **Note:** Notifier signal for property **model** .

        **See also** **model** .
        """
        ...

    @property
    def seriesReplaced(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qcandlestickmodelmapper.html#seriesReplaced

        **[signal] void QCandlestickModelMapper::seriesReplaced()**

        Emitted when the series to which mapper is connected to has changed.

        **Note:** Notifier signal for property **series** .

        **See also** **series** .
        """
        ...
