"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtCharts, except for defaults which are replaced by "...".
"""
from enum import Enum
from typing import Optional, Sequence, Union, overload
import PySide6.QtCore
import PySide6.QtGui
import PySide6.QtWidgets
import PySide6.QtCharts

bytes = str


class QBoxSet(PySide6.QtCore.QObject):
    """
    https://doc.qt.io/qt-6/qboxset.html

    **Detailed Description**

    A box-and-whiskers item is a graphical representation of a range and three
    median values that is constructed from five different values. There are two
    ways to specify the values. The first one is by using a constructor or
    stream operator (<<). The values have to be specified in the following
    order: lower extreme, lower quartile, median, upper quartile, and upper
    extreme.

    The second way is to create an empty QBoxSet instance and specify the values
    using the **setValue** () method.

    See the **box-and-whiskers chart example**  to learn how to create a box-
    and-whiskers chart.

    **See also** **QBoxPlotSeries** .
    """

    LowerExtreme: QBoxSet.ValuePositions = ...
    LowerQuartile: QBoxSet.ValuePositions = ...
    Median: QBoxSet.ValuePositions = ...
    UpperQuartile: QBoxSet.ValuePositions = ...
    UpperExtreme: QBoxSet.ValuePositions = ...

    class ValuePositions(Enum):
        LowerExtreme: QBoxSet.ValuePositions = ...
        LowerQuartile: QBoxSet.ValuePositions = ...
        Median: QBoxSet.ValuePositions = ...
        UpperQuartile: QBoxSet.ValuePositions = ...
        UpperExtreme: QBoxSet.ValuePositions = ...

    @overload
    def __init__(
        self, label: str = ..., parent: Optional[PySide6.QtCore.QObject] = ...
    ) -> None:
        """
        https://doc.qt.io/qt-6/qboxset.html#QBoxSet

        **QBoxSet::QBoxSet(const QString label = QString(), QObject * parent =
        nullptr)**

        Constructs a box-and-whiskers item with the optional label **label** and
        parent **parent**.
        """
        ...

    @overload
    def __init__(
        self,
        le: float,
        lq: float,
        m: float,
        uq: float,
        ue: float,
        label: str = ...,
        parent: Optional[PySide6.QtCore.QObject] = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qboxset.html#QBoxSet-1

        **QBoxSet::QBoxSet(const qreal le , const qreal lq , const qreal m ,
        const qreal uq , const qreal ue , const QString label = QString(),
        QObject * parent = nullptr)**

        Constructs a box-and-whiskers item with the following ordered values:
        **le** specifies the lower extreme, **lq** the lower quartile, **m** the
        median, **uq** the upper quartile, and **ue** the upper quartile.
        Optionally, the **label** and **parent** can be specified.
        """
        ...

    def __lshift__(self, value: float) -> PySide6.QtCharts.QBoxSet:
        ...

    @overload
    def append(self, value: float) -> None:
        """
        https://doc.qt.io/qt-6/qboxset.html#append

        **void QBoxSet::append(const qreal value )**

        Appends the new value specified by **value** to the end of the box-and-
        whiskers item.
        """
        ...

    @overload
    def append(self, values: Sequence[float]) -> None:
        """
        https://doc.qt.io/qt-6/qboxset.html#append-1

        **void QBoxSet::append(const QList<qreal> & values )**

        Appends a list of real values specified by **values** to the end of the
        box-and-whiskers item.

        **See also** **append** ().
        """
        ...

    def at(self, index: int) -> float:
        """
        https://doc.qt.io/qt-6/qboxset.html#at

        **qreal QBoxSet::at(const int index ) const**

        Returns the value of the box-and-whiskers item specified by **index**.
        The index can be specified by using **ValuePositions**  enumeration
        values. If the index is out of bounds, 0.0 is returned.
        """
        ...

    def brush(self) -> PySide6.QtGui.QBrush:
        """
        https://doc.qt.io/qt-6/qboxset.html#brush

        **QBrush QBoxSet::brush() const**

        Returns the brush used to fill the box-and-whiskers item.

        **Note:** Getter function for property brush.

        **See also** **setBrush** ().
        """
        ...

    def clear(self) -> None:
        """
        https://doc.qt.io/qt-6/qboxset.html#clear

        **void QBoxSet::clear()**

        Sets all the values of the box-and-whiskers item to 0.
        """
        ...

    def count(self) -> int:
        """
        https://doc.qt.io/qt-6/qboxset.html#count

        **int QBoxSet::count() const**

        Returns the number of values appended to the box-and-whiskers item.
        """
        ...

    def label(self) -> str:
        """
        https://doc.qt.io/qt-6/qboxset.html#label

        **QString QBoxSet::label() const**

        Returns the label of the category of the box-and-whiskers item.

        **See also** **setLabel** ().
        """
        ...

    def pen(self) -> PySide6.QtGui.QPen:
        """
        https://doc.qt.io/qt-6/qboxset.html#pen

        **QPen QBoxSet::pen() const**

        Returns the pen used to draw the box-and-whiskers item.

        **Note:** Getter function for property pen.

        **See also** **setPen** ().
        """
        ...

    def setBrush(
        self,
        brush: Union[
            PySide6.QtGui.QBrush,
            PySide6.QtCore.Qt.BrushStyle,
            PySide6.QtCore.Qt.GlobalColor,
            PySide6.QtGui.QColor,
            PySide6.QtGui.QGradient,
            PySide6.QtGui.QImage,
            PySide6.QtGui.QPixmap,
        ],
    ) -> None:
        """
        https://doc.qt.io/qt-6/qboxset.html#setBrush

        **void QBoxSet::setBrush(const QBrush & brush )**

        Sets the brush used to fill the box-and-whiskers item to **brush**.

        **Note:** Setter function for property **brush** .

        **See also** **brush** ().
        """
        ...

    def setLabel(self, label: str) -> None:
        """
        https://doc.qt.io/qt-6/qboxset.html#setLabel

        **void QBoxSet::setLabel(const QString label )**

        Sets the label specified by **label** for the category of the box-and-
        whiskers item.

        **See also** **label** ().
        """
        ...

    def setPen(
        self,
        pen: Union[
            PySide6.QtGui.QPen, PySide6.QtCore.Qt.PenStyle, PySide6.QtGui.QColor
        ],
    ) -> None:
        """
        https://doc.qt.io/qt-6/qboxset.html#setPen

        **void QBoxSet::setPen(const QPen & pen )**

        Sets the pen used to draw the box-and-whiskers item to **pen**.

        **Note:** Setter function for property **pen** .

        **See also** **pen** ().
        """
        ...

    def setValue(self, index: int, value: float) -> None:
        """
        https://doc.qt.io/qt-6/qboxset.html#setValue

        **void QBoxSet::setValue(const int index , const qreal value )**

        Sets the value specified by **value** in the position specified by
        **index**. The index can be specified by using the **ValuePositions**
        enumeration values.
        """
        ...

    @property
    def brushChanged(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qboxset.html#brushChanged

        **[signal] void QBoxSet::brushChanged()**

        This signal is emitted when the brush of the box-and-whiskers item
        changes.

        **Note:** Notifier signal for property **brush** .

        **See also** **brush** .
        """
        ...

    @property
    def cleared(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qboxset.html#cleared

        **[signal] void QBoxSet::cleared()**

        This signal is emitted when all the values of the box-and-whiskers item
        are set to 0.
        """
        ...

    @property
    def clicked(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qboxset.html#clicked

        **[signal] void QBoxSet::clicked()**

        This signal is emitted when the user clicks a box-and-whiskers item in
        the chart.
        """
        ...

    @property
    def doubleClicked(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qboxset.html#doubleClicked

        **[signal] void QBoxSet::doubleClicked()**

        This signal is emitted when the user double-clicks a box-and-whiskers
        item.
        """
        ...

    @property
    def hovered(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qboxset.html#hovered

        **[signal] void QBoxSet::hovered(bool status )**

        This signal is emitted when a mouse is hovered over a box-and-whiskers
        item in a chart. When the mouse moves over the item, **status** turns
        `true`, and when the mouse moves away again, it turns `false`.
        """
        ...

    @property
    def penChanged(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qboxset.html#penChanged

        **[signal] void QBoxSet::penChanged()**

        This signal is emitted when the pen of the box-and-whiskers item
        changes.

        **Note:** Notifier signal for property **pen** .

        **See also** **pen** .
        """
        ...

    @property
    def pressed(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qboxset.html#pressed

        **[signal] void QBoxSet::pressed()**

        This signal is emitted when the user clicks a box-and-whiskers item in
        the chart and holds down the mouse button.
        """
        ...

    @property
    def released(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qboxset.html#released

        **[signal] void QBoxSet::released()**

        This signal is emitted when the user releases the mouse press on a box-
        and-whiskers item.
        """
        ...

    @property
    def valueChanged(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qboxset.html#valueChanged

        **[signal] void QBoxSet::valueChanged(int index )**

        This signal is emitted when the value of the box-and-whiskers item
        specified by **index** is modified.

        **See also** **at** ().
        """
        ...

    @property
    def valuesChanged(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qboxset.html#valuesChanged

        **[signal] void QBoxSet::valuesChanged()**

        This signal is emitted when multiple values of the box-and-whiskers item
        change.

        **See also** **append** ().
        """
        ...
