"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtCharts, except for defaults which are replaced by "...".
"""
from typing import List, Optional, Sequence, overload
import PySide6.QtCore
import PySide6.QtGui
import PySide6.QtWidgets
import PySide6.QtCharts

bytes = str


class QBarCategoryAxis(PySide6.QtCharts.QAbstractAxis):
    """
    https://doc.qt.io/qt-6/qbarcategoryaxis.html

    **Detailed Description**

    QBarCategoryAxis can be set up to show an axis line with tick marks, grid
    lines, and shades. Categories are drawn between the ticks. It can be used
    also with a line series, as demonstrated by the **Line and BarChart
    Example** .

    The following code illustrates how to use QBarCategoryAxis:

    **QChartView**  *chartView = new **QChartView** ;
        **QBarSeries**
    *series = new **QBarSeries** ;
        // ...
    chartView->chart()->addSeries(series);
    chartView->chart()->createDefaultAxes();

        **QBarCategoryAxis**
    *axisX = new **QBarCategoryAxis** ;
        **QStringList**  categories;
    categories << "Jan" << "Feb" << "Mar" << "Apr" << "May" << "Jun";
    axisX->append(categories);
        axisX->setRange("Feb", "May");
    chartView->chart()->setAxisX(axisX, series);
    """

    def __init__(self, parent: Optional[PySide6.QtCore.QObject] = ...) -> None:
        """
        https://doc.qt.io/qt-6/qbarcategoryaxis.html#QBarCategoryAxis

        **QBarCategoryAxis::QBarCategoryAxis(QObject * parent = nullptr)**

        Constructs an axis object that is the child of **parent**.
        """
        ...

    @overload
    def append(self, categories: Sequence[str]) -> None:
        """
        https://doc.qt.io/qt-6/qbarcategoryaxis.html#append

        **void QBarCategoryAxis::append(const QStringList & categories )**

        Appends **categories** to an axis. The maximum value on the axis will be
        changed to match the last category in **categories**. If no categories
        were previously defined, the minimum value on the axis will also be
        changed to match the first category in **categories**.

        A category has to be a valid **QString**  and it cannot be duplicated.
        Duplicated categories will not be appended.
        """
        ...

    @overload
    def append(self, category: str) -> None:
        """
        https://doc.qt.io/qt-6/qbarcategoryaxis.html#append-1

        **void QBarCategoryAxis::append(const QString & category )**

        Appends **category** to an axis. The maximum value on the axis will be
        changed to match the last **category**. If no categories were previously
        defined, the minimum value on the axis will also be changed to match
        **category**.

        A category has to be a valid **QString**  and it cannot be duplicated.
        Duplicated categories will not be appended.
        """
        ...

    def at(self, index: int) -> str:
        """
        https://doc.qt.io/qt-6/qbarcategoryaxis.html#at

        **QString QBarCategoryAxis::at(int index ) const**

        Returns the category at **index**. The index must be valid.
        """
        ...

    def categories(self) -> List[str]:
        """
        https://doc.qt.io/qt-6/qbarcategoryaxis.html#categories

        **QStringList QBarCategoryAxis::categories()**

        Returns categories.

        **Note:** Getter function for property categories.

        **See also** **setCategories** ().
        """
        ...

    def clear(self) -> None:
        """
        https://doc.qt.io/qt-6/qbarcategoryaxis.html#clear

        **[invokable] void QBarCategoryAxis::clear()**

        Removes all categories. Sets the maximum and minimum values of the axis
        range to QString::null.

        **Note:** This function can be invoked via the meta-object system and
        from QML. See **Q_INVOKABLE** .
        """
        ...

    def count(self) -> int:
        """
        https://doc.qt.io/qt-6/qbarcategoryaxis.html#count

        **int QBarCategoryAxis::count() const**

        Returns the number of categories.

        **Note:** Getter function for property count.
        """
        ...

    def insert(self, index: int, category: str) -> None:
        """
        https://doc.qt.io/qt-6/qbarcategoryaxis.html#insert

        **void QBarCategoryAxis::insert(int index , const QString & category )**

        Inserts **category** to the axis at **index**. **category** has to be a
        valid **QString**  and it cannot be duplicated. If **category** is
        prepended or appended to other categories, the minimum and maximum
        values on the axis are updated accordingly.
        """
        ...

    def max(self) -> str:
        """
        https://doc.qt.io/qt-6/qbarcategoryaxis.html#max

        **QString QBarCategoryAxis::max() const**

        Returns the maximum category.

        **Note:** Getter function for property max.

        **See also** **setMax** ().
        """
        ...

    def min(self) -> str:
        """
        https://doc.qt.io/qt-6/qbarcategoryaxis.html#min

        **QString QBarCategoryAxis::min() const**

        Returns the minimum category.

        **Note:** Getter function for property min.

        **See also** **setMin** ().
        """
        ...

    def remove(self, category: str) -> None:
        """
        https://doc.qt.io/qt-6/qbarcategoryaxis.html#remove

        **void QBarCategoryAxis::remove(const QString & category )**

        Removes **category** from the axis. Removing a category that currently
        sets the maximum or minimum value on the axis will affect the axis
        range.
        """
        ...

    def replace(self, oldCategory: str, newCategory: str) -> None:
        """
        https://doc.qt.io/qt-6/qbarcategoryaxis.html#replace

        **void QBarCategoryAxis::replace(const QString & oldCategory , const
        QString & newCategory )**

        Replaces **oldCategory** with **newCategory**. If **oldCategory** does
        not exist on the axis, nothing is done. **newCategory** has to be a
        valid **QString**  and it cannot be duplicated. If the minimum or
        maximum category is replaced, the minimum and maximum values on the axis
        are updated accordingly.
        """
        ...

    def setCategories(self, categories: Sequence[str]) -> None:
        """
        https://doc.qt.io/qt-6/qbarcategoryaxis.html#setCategories

        **void QBarCategoryAxis::setCategories(const QStringList & categories
        )**

        Sets **categories** and discards the old ones. The axis range is
        adjusted to match the first and last category in **categories**.

        A category has to be a valid **QString**  and it cannot be duplicated.

        **Note:** Setter function for property **categories** .

        **See also** **categories** ().
        """
        ...

    def setMax(self, maxCategory: str) -> None:
        """
        https://doc.qt.io/qt-6/qbarcategoryaxis.html#setMax

        **void QBarCategoryAxis::setMax(const QString & max )**

        Sets the maximum category to **max**.

        **Note:** Setter function for property **max** .

        **See also** **max** ().
        """
        ...

    def setMin(self, minCategory: str) -> None:
        """
        https://doc.qt.io/qt-6/qbarcategoryaxis.html#setMin

        **void QBarCategoryAxis::setMin(const QString & min )**

        Sets the minimum category to **min**.

        **Note:** Setter function for property **min** .

        **See also** **min** ().
        """
        ...

    def setRange(self, minCategory: str, maxCategory: str) -> None:
        """
        https://doc.qt.io/qt-6/qbarcategoryaxis.html#setRange

        **void QBarCategoryAxis::setRange(const QString & minCategory , const
        QString & maxCategory )**

        Sets the axis range from **minCategory** to **maxCategory**.
        """
        ...

    def type(self) -> PySide6.QtCharts.QAbstractAxis.AxisType:
        """
        https://doc.qt.io/qt-6/qbarcategoryaxis.html#type

        **[override virtual] QAbstractAxis::AxisType QBarCategoryAxis::type()
        const**

        Reimplements: **QAbstractAxis::type() const** .

        Returns the type of the axis.
        """
        ...

    @property
    def categoriesChanged(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qbarcategoryaxis.html#categoriesChanged

        **[signal] void QBarCategoryAxis::categoriesChanged()**

        This signal is emitted when the categories of the axis change.

        **Note:** Notifier signal for property **categories** .
        """
        ...

    @property
    def countChanged(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qbarcategoryaxis.html#countChanged

        **[signal] void QBarCategoryAxis::countChanged()**

        This signal is emitted when the number of categories of an axis changes.

        **Note:** Notifier signal for property **count** .
        """
        ...

    @property
    def maxChanged(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qbarcategoryaxis.html#maxChanged

        **[signal] void QBarCategoryAxis::maxChanged(const QString & max )**

        This signal is emitted when the **max** value of the axis changes.

        **Note:** Notifier signal for property **max** .
        """
        ...

    @property
    def minChanged(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qbarcategoryaxis.html#minChanged

        **[signal] void QBarCategoryAxis::minChanged(const QString & min )**

        This signal is emitted when the **min** value of the axis changes.

        **Note:** Notifier signal for property **min** .
        """
        ...

    @property
    def rangeChanged(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qbarcategoryaxis.html#rangeChanged

        **[signal] void QBarCategoryAxis::rangeChanged(const QString & min ,
        const QString & max )**

        This signal is emitted when **min** or **max** value of the axis
        changes.
        """
        ...
