"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtCharts, except for defaults which are replaced by "...".
"""
from typing import Any, Optional, Sequence, Union, overload
import PySide6.QtCore
import PySide6.QtGui
import PySide6.QtWidgets
import PySide6.QtCharts

bytes = str


class QAreaSeries(PySide6.QtCharts.QAbstractSeries):
    """
    https://doc.qt.io/qt-6/qareaseries.html

    **Detailed Description**

    An area series is used to show quantitative data. It is based on a line
    series, in the way that the area between the boundary lines is emphasized
    with color. Since the area series is based on the line series, the
    QAreaSeries constructor needs a **QLineSeries**  instance, which defines the
    **upper** boundary of the area. The area chart is drawn using the bottom of
    the plot area as the **lower** boundary by default. Instead of the bottom of
    the plot area, the lower boundary can be specified by another line. In that
    case, QAreaSeries should be initialized with two **QLineSeries**  instances.

    **Note:** The terms **upper** and **lower** boundary can be misleading in
    cases where the value of the lower boundary is greater than that of the
    upper boundary. The main point is that the area between these two boundary
    lines will be filled.

    See the **area chart example**  to learn how to create a simple area chart.

    ![](images/examples_areachart.png)
    """

    @overload
    def __init__(self, parent: Optional[PySide6.QtCore.QObject] = ...) -> None:
        """
        https://doc.qt.io/qt-6/qareaseries.html#QAreaSeries

        **QAreaSeries::QAreaSeries(QObject * parent = nullptr)**

        Constructs an area series object without an upper or a lower series with
        the **parent** object.
        """
        ...

    @overload
    def __init__(
        self,
        upperSeries: PySide6.QtCharts.QLineSeries,
        lowerSeries: Optional[PySide6.QtCharts.QLineSeries] = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qareaseries.html#QAreaSeries-1

        **QAreaSeries::QAreaSeries(QLineSeries * upperSeries , QLineSeries *
        lowerSeries = nullptr)**

        Constructs an area series object that will be spanned between an
        **upperSeries** line and a **lowerSeries** line. If no **lowerSeries**
        is passed to the constructor, the x-axis is used as the lower bound
        instead.

        The QAreaSeries does not own the upper or lower series, but the
        ownership stays with the caller. When the series object is added to
        **QChartView**  or **QChart** , the instance ownership is transferred.
        """
        ...

    def borderColor(self) -> PySide6.QtGui.QColor:
        """
        https://doc.qt.io/qt-6/qareaseries.html#borderColor-prop

        **borderColor : QColor**

        This property holds the line (pen) color of the series. This is a
        convenience property for modifying the color of the pen.

        **Access functions:**

        QColor **borderColor** () const
        void **setBorderColor** (const QColor
        & **color** )

        **Notifier signal:**

        void ****borderColorChanged** ** (QColor **color** )

        **See also** **QAreaSeries::pen** ().
        """
        ...

    def brush(self) -> PySide6.QtGui.QBrush:
        """
        https://doc.qt.io/qt-6/qareaseries.html#brush

        **QBrush QAreaSeries::brush() const**

        Returns the brush used to draw the line for this series.

        **See also** **setBrush** ().
        """
        ...

    def color(self) -> PySide6.QtGui.QColor:
        """
        https://doc.qt.io/qt-6/qareaseries.html#color-prop

        **color : QColor**

        This property holds the fill (brush) color of the series. This is a
        convenience property for modifying the color of the brush.

        **Access functions:**

        QColor **color** () const
        void **setColor** (const QColor & **color**
        )

        **Notifier signal:**

        void ****colorChanged** ** (QColor **color** )

        **See also** **QAreaSeries::brush** ().
        """
        ...

    def lowerSeries(self) -> PySide6.QtCharts.QLineSeries:
        """
        https://doc.qt.io/qt-6/qareaseries.html#lowerSeries-prop

        **[read-only] lowerSeries : QLineSeries* const**

        This property holds the lower one of the two line series used to define
        area series boundaries.

        **Note:** If **QAreaSeries**  was constructed without a lowerSeries,
        this is null.

        **Access functions:**

        QLineSeries * **lowerSeries** () const
        """
        ...

    def pen(self) -> PySide6.QtGui.QPen:
        """
        https://doc.qt.io/qt-6/qareaseries.html#pen

        **QPen QAreaSeries::pen() const**

        Returns the pen used to draw the line for this series.

        **See also** **setPen** ().
        """
        ...

    def pointLabelsClipping(self) -> bool:
        """
        https://doc.qt.io/qt-6/qareaseries.html#pointLabelsClipping-prop

        **pointLabelsClipping : bool**

        This property holds the clipping for data point labels. True by default.
        The labels on the edge of the plot area are cut when clipping is
        enabled.

        **Access functions:**

        bool **pointLabelsClipping** () const
        void **setPointLabelsClipping**
        (bool **enabled** = true)

        **Notifier signal:**

        void ****pointLabelsClippingChanged** ** (bool **clipping** )

        **See also** **pointLabelsVisible** .
        """
        ...

    def pointLabelsColor(self) -> PySide6.QtGui.QColor:
        """
        https://doc.qt.io/qt-6/qareaseries.html#pointLabelsColor-prop

        **pointLabelsColor : QColor**

        This property holds the color used for data point labels. By default,
        the color is the color of the brush defined for labels in the theme.

        **Access functions:**

        QColor **pointLabelsColor** () const
        void **setPointLabelsColor**
        (const QColor & **color** )

        **Notifier signal:**

        void ****pointLabelsColorChanged** ** (const QColor & **color** )

        **See also** **QAreaSeries::pointLabelsFormat** .
        """
        ...

    def pointLabelsFont(self) -> PySide6.QtGui.QFont:
        """
        https://doc.qt.io/qt-6/qareaseries.html#pointLabelsFont-prop

        **pointLabelsFont : QFont**

        This property holds the font used for data point labels.

        **Access functions:**

        QFont **pointLabelsFont** () const
        void **setPointLabelsFont** (const
        QFont & **font** )

        **Notifier signal:**

        void ****pointLabelsFontChanged** ** (const QFont & **font** )

        **See also** **QAreaSeries::pointLabelsFormat** .
        """
        ...

    def pointLabelsFormat(self) -> str:
        """
        https://doc.qt.io/qt-6/qareaseries.html#pointLabelsFormat-prop

        **pointLabelsFormat : QString**

        This property holds the format used for showing labels with series
        points.

        **QAreaSeries**  supports the following format tags:

        @xPointThe x value of the data point
        @yPointThe y value of the data
        point

        For example, the following usage of the format tags would produce labels
        that have the data point (x, y) shown inside brackets separated by a
        comma:

        series->setPointLabelsFormat("(@xPoint, @yPoint)");

        By default, the label format is set to `@xPoint, @yPoint`. The labels
        are shown on the plot area, whereas labels on the edge of the plot area
        are cut. If the points are close to each other, the labels may overlap.

        **Access functions:**

        QString **pointLabelsFormat** () const
        void **setPointLabelsFormat**
        (const QString & **format** )

        **Notifier signal:**

        void ****pointLabelsFormatChanged** ** (const QString & **format** )

        **See also** **QAreaSeries::pointLabelsVisible** ,
        **QAreaSeries::pointLabelsFont** , and **QAreaSeries::pointLabelsColor**
        .
        """
        ...

    def pointLabelsVisible(self) -> bool:
        """
        https://doc.qt.io/qt-6/qareaseries.html#pointLabelsVisible-prop

        **pointLabelsVisible : bool**

        This property holds the visibility of data point labels. False by
        default.

        **Access functions:**

        bool **pointLabelsVisible** () const
        void **setPointLabelsVisible**
        (bool **visible** = true)

        **Notifier signal:**

        void ****pointLabelsVisibilityChanged** ** (bool **visible** )

        **See also** **QAreaSeries::pointLabelsFormat**  and
        **QAreaSeries::pointLabelsClipping** .
        """
        ...

    def pointsVisible(self) -> bool:
        """
        https://doc.qt.io/qt-6/qareaseries.html#pointsVisible

        **bool QAreaSeries::pointsVisible() const**

        Returns whether the points are drawn for this series.

        **See also** **setPointsVisible** ().
        """
        ...

    def setBorderColor(
        self,
        color: Union[
            PySide6.QtGui.QColor,
            PySide6.QtGui.QRgba64,
            Any,
            PySide6.QtCore.Qt.GlobalColor,
            str,
            int,
        ],
    ) -> None:
        """
        https://doc.qt.io/qt-6/qareaseries.html#borderColor-prop

        **borderColor : QColor**

        This property holds the line (pen) color of the series. This is a
        convenience property for modifying the color of the pen.

        **Access functions:**

        QColor **borderColor** () const
        void **setBorderColor** (const QColor
        & **color** )

        **Notifier signal:**

        void ****borderColorChanged** ** (QColor **color** )

        **See also** **QAreaSeries::pen** ().
        """
        ...

    def setBrush(
        self,
        brush: Union[
            PySide6.QtGui.QBrush,
            PySide6.QtCore.Qt.BrushStyle,
            PySide6.QtCore.Qt.GlobalColor,
            PySide6.QtGui.QColor,
            PySide6.QtGui.QGradient,
            PySide6.QtGui.QImage,
            PySide6.QtGui.QPixmap,
        ],
    ) -> None:
        """
        https://doc.qt.io/qt-6/qareaseries.html#setBrush

        **void QAreaSeries::setBrush(const QBrush & brush )**

        Sets the **brush** used for filling the area.

        **See also** **brush** ().
        """
        ...

    def setColor(
        self,
        color: Union[
            PySide6.QtGui.QColor,
            PySide6.QtGui.QRgba64,
            Any,
            PySide6.QtCore.Qt.GlobalColor,
            str,
            int,
        ],
    ) -> None:
        """
        https://doc.qt.io/qt-6/qareaseries.html#color-prop

        **color : QColor**

        This property holds the fill (brush) color of the series. This is a
        convenience property for modifying the color of the brush.

        **Access functions:**

        QColor **color** () const
        void **setColor** (const QColor & **color**
        )

        **Notifier signal:**

        void ****colorChanged** ** (QColor **color** )

        **See also** **QAreaSeries::brush** ().
        """
        ...

    def setLowerSeries(self, series: PySide6.QtCharts.QLineSeries) -> None:
        """
        https://doc.qt.io/qt-6/qareaseries.html#setLowerSeries

        **void QAreaSeries::setLowerSeries(QLineSeries * series )**

        Sets the **series** that is to be used as the area chart lower series.

        **See also** **lowerSeries** ().
        """
        ...

    def setPen(
        self,
        pen: Union[
            PySide6.QtGui.QPen, PySide6.QtCore.Qt.PenStyle, PySide6.QtGui.QColor
        ],
    ) -> None:
        """
        https://doc.qt.io/qt-6/qareaseries.html#setPen

        **void QAreaSeries::setPen(const QPen & pen )**

        Sets the **pen** used for drawing the area outline.

        **See also** **pen** ().
        """
        ...

    def setPointLabelsClipping(self, enabled: bool = ...) -> None:
        """
        https://doc.qt.io/qt-6/qareaseries.html#pointLabelsClipping-prop

        **pointLabelsClipping : bool**

        This property holds the clipping for data point labels. True by default.
        The labels on the edge of the plot area are cut when clipping is
        enabled.

        **Access functions:**

        bool **pointLabelsClipping** () const
        void **setPointLabelsClipping**
        (bool **enabled** = true)

        **Notifier signal:**

        void ****pointLabelsClippingChanged** ** (bool **clipping** )

        **See also** **pointLabelsVisible** .
        """
        ...

    def setPointLabelsColor(
        self,
        color: Union[
            PySide6.QtGui.QColor,
            PySide6.QtGui.QRgba64,
            Any,
            PySide6.QtCore.Qt.GlobalColor,
            str,
            int,
        ],
    ) -> None:
        """
        https://doc.qt.io/qt-6/qareaseries.html#pointLabelsColor-prop

        **pointLabelsColor : QColor**

        This property holds the color used for data point labels. By default,
        the color is the color of the brush defined for labels in the theme.

        **Access functions:**

        QColor **pointLabelsColor** () const
        void **setPointLabelsColor**
        (const QColor & **color** )

        **Notifier signal:**

        void ****pointLabelsColorChanged** ** (const QColor & **color** )

        **See also** **QAreaSeries::pointLabelsFormat** .
        """
        ...

    def setPointLabelsFont(
        self, font: Union[PySide6.QtGui.QFont, str, Sequence[str]]
    ) -> None:
        """
        https://doc.qt.io/qt-6/qareaseries.html#pointLabelsFont-prop

        **pointLabelsFont : QFont**

        This property holds the font used for data point labels.

        **Access functions:**

        QFont **pointLabelsFont** () const
        void **setPointLabelsFont** (const
        QFont & **font** )

        **Notifier signal:**

        void ****pointLabelsFontChanged** ** (const QFont & **font** )

        **See also** **QAreaSeries::pointLabelsFormat** .
        """
        ...

    def setPointLabelsFormat(self, format: str) -> None:
        """
        https://doc.qt.io/qt-6/qareaseries.html#pointLabelsFormat-prop

        **pointLabelsFormat : QString**

        This property holds the format used for showing labels with series
        points.

        **QAreaSeries**  supports the following format tags:

        @xPointThe x value of the data point
        @yPointThe y value of the data
        point

        For example, the following usage of the format tags would produce labels
        that have the data point (x, y) shown inside brackets separated by a
        comma:

        series->setPointLabelsFormat("(@xPoint, @yPoint)");

        By default, the label format is set to `@xPoint, @yPoint`. The labels
        are shown on the plot area, whereas labels on the edge of the plot area
        are cut. If the points are close to each other, the labels may overlap.

        **Access functions:**

        QString **pointLabelsFormat** () const
        void **setPointLabelsFormat**
        (const QString & **format** )

        **Notifier signal:**

        void ****pointLabelsFormatChanged** ** (const QString & **format** )

        **See also** **QAreaSeries::pointLabelsVisible** ,
        **QAreaSeries::pointLabelsFont** , and **QAreaSeries::pointLabelsColor**
        .
        """
        ...

    def setPointLabelsVisible(self, visible: bool = ...) -> None:
        """
        https://doc.qt.io/qt-6/qareaseries.html#pointLabelsVisible-prop

        **pointLabelsVisible : bool**

        This property holds the visibility of data point labels. False by
        default.

        **Access functions:**

        bool **pointLabelsVisible** () const
        void **setPointLabelsVisible**
        (bool **visible** = true)

        **Notifier signal:**

        void ****pointLabelsVisibilityChanged** ** (bool **visible** )

        **See also** **QAreaSeries::pointLabelsFormat**  and
        **QAreaSeries::pointLabelsClipping** .
        """
        ...

    def setPointsVisible(self, visible: bool = ...) -> None:
        """
        https://doc.qt.io/qt-6/qareaseries.html#setPointsVisible

        **void QAreaSeries::setPointsVisible(bool visible = true)**

        Determines whether data points are **visible** and should be drawn on
        the line.

        **See also** **pointsVisible** ().
        """
        ...

    def setUpperSeries(self, series: PySide6.QtCharts.QLineSeries) -> None:
        """
        https://doc.qt.io/qt-6/qareaseries.html#setUpperSeries

        **void QAreaSeries::setUpperSeries(QLineSeries * series )**

        Sets the **series** that is to be used as the area chart upper series.
        If the upper series is null, the area chart is not drawn, even if it has
        a lower series.

        **See also** **upperSeries** ().
        """
        ...

    def type(self) -> PySide6.QtCharts.QAbstractSeries.SeriesType:
        """
        https://doc.qt.io/qt-6/qareaseries.html#type

        **[override virtual] QAbstractSeries::SeriesType QAreaSeries::type()
        const**

        Reimplements an access function for property: **QAbstractSeries::type**
        .

        Returns **QAbstractSeries::SeriesTypeArea** .
        """
        ...

    def upperSeries(self) -> PySide6.QtCharts.QLineSeries:
        """
        https://doc.qt.io/qt-6/qareaseries.html#upperSeries-prop

        **[read-only] upperSeries : QLineSeries* const**

        This property holds the upper one of the two line series used to define
        area series boundaries.

        **Access functions:**

        QLineSeries * **upperSeries** () const

        **Member Function Documentation**
        """
        ...

    @property
    def borderColorChanged(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qareaseries.html#borderColorChanged

        **[signal] void QAreaSeries::borderColorChanged(QColor color )**

        This signal is emitted when the line (pen) color changes to **color**.

        **Note:** Notifier signal for property **borderColor** .
        """
        ...

    @property
    def clicked(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qareaseries.html#clicked

        **[signal] void QAreaSeries::clicked(const QPointF & point )**

        This signal is emitted when the user triggers a press on **point** by
        clicking it in an area chart.

        **See also** **pressed** , **released** , and **doubleClicked** .
        """
        ...

    @property
    def colorChanged(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qareaseries.html#colorChanged

        **[signal] void QAreaSeries::colorChanged(QColor color )**

        This signal is emitted when the fill (brush) color changes to **color**.

        **Note:** Notifier signal for property **color** .
        """
        ...

    @property
    def doubleClicked(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qareaseries.html#doubleClicked

        **[signal] void QAreaSeries::doubleClicked(const QPointF & point )**

        This signal is emitted when the user triggers the first press in an area
        chart by doubleclicking **point**.

        **See also** **pressed** , **released** , and **clicked** .
        """
        ...

    @property
    def hovered(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qareaseries.html#hovered

        **[signal] void QAreaSeries::hovered(const QPointF & point , bool state
        )**

        This signal is emitted when the user hovers the mouse cursor over a
        series or moves it away from the series. **point** shows the origin
        (coordinate) of the hover event. **state** is `true` when the cursor
        hovers over the series and turns **false** when it moves away from the
        series.
        """
        ...

    @property
    def pointLabelsClippingChanged(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qareaseries.html#pointLabelsClippingChanged

        **[signal] void QAreaSeries::pointLabelsClippingChanged(bool clipping
        )**

        This signal is emitted when the clipping of the data point labels
        changes to **clipping**.

        **Note:** Notifier signal for property **pointLabelsClipping** .
        """
        ...

    @property
    def pointLabelsColorChanged(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qareaseries.html#pointLabelsColorChanged

        **[signal] void QAreaSeries::pointLabelsColorChanged(const QColor &
        color )**

        This signal is emitted when the color used for data point labels changes
        to **color**.

        **Note:** Notifier signal for property **pointLabelsColor** .
        """
        ...

    @property
    def pointLabelsFontChanged(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qareaseries.html#pointLabelsFontChanged

        **[signal] void QAreaSeries::pointLabelsFontChanged(const QFont & font
        )**

        This signal is emitted when the font used for data point labels changes
        to **font**.

        **Note:** Notifier signal for property **pointLabelsFont** .
        """
        ...

    @property
    def pointLabelsFormatChanged(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qareaseries.html#pointLabelsFormatChanged

        **[signal] void QAreaSeries::pointLabelsFormatChanged(const QString &
        format )**

        This signal is emitted when the **format** of data point labels is
        changed.

        **Note:** Notifier signal for property **pointLabelsFormat** .
        """
        ...

    @property
    def pointLabelsVisibilityChanged(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qareaseries.html#pointLabelsVisibilityChanged

        **[signal] void QAreaSeries::pointLabelsVisibilityChanged(bool visible
        )**

        This signal is emitted when the visibility of the data point labels
        changes to **visible**.

        **Note:** Notifier signal for property **pointLabelsVisible** .
        """
        ...

    @property
    def pressed(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qareaseries.html#pressed

        **[signal] void QAreaSeries::pressed(const QPointF & point )**

        This signal is emitted when the user presses the point specified by
        **point** in an area chart.

        **See also** **clicked** , **released** , and **doubleClicked** .
        """
        ...

    @property
    def released(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qareaseries.html#released

        **[signal] void QAreaSeries::released(const QPointF & point )**

        This signal is emitted when the user releases a press that was triggered
        on **point** in an area chart.

        **See also** **pressed** , **clicked** , and **doubleClicked** .
        """
        ...
