"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtBluetooth, except for defaults which are replaced by "...".
"""
from typing import List, Sequence, Union, overload
import PySide6.QtCore
import PySide6.QtBluetooth

bytes = str


class QLowEnergyCharacteristicData(object):
    """
    https://doc.qt.io/qt-6/qlowenergycharacteristicdata.html

    **Detailed Description**

    An Object of this class provides a characteristic to be added to a
    **QLowEnergyServiceData**  object via
    **QLowEnergyServiceData::addCharacteristic** ().

    **See also** **QLowEnergyServiceData**  and
    **QLowEnergyController::addService** .
    """

    @overload
    def __init__(self) -> None:
        """
        https://doc.qt.io/qt-6/qlowenergycharacteristicdata.html#QLowEnergyChara
        cteristicData

        **QLowEnergyCharacteristicData::QLowEnergyCharacteristicData()**

        Creates a new invalid object of this class.
        """
        ...

    @overload
    def __init__(self, other: PySide6.QtBluetooth.QLowEnergyCharacteristicData) -> None:
        """
        https://doc.qt.io/qt-6/qlowenergycharacteristicdata.html#QLowEnergyChara
        cteristicData-1

        **QLowEnergyCharacteristicData::QLowEnergyCharacteristicData(const
        QLowEnergyCharacteristicData & other )**

        Constructs a new object of this class that is a copy of **other**.
        """
        ...

    def addDescriptor(
        self, descriptor: PySide6.QtBluetooth.QLowEnergyDescriptorData
    ) -> None:
        """
        https://doc.qt.io/qt-6/qlowenergycharacteristicdata.html#addDescriptor

        **void QLowEnergyCharacteristicData::addDescriptor(const
        QLowEnergyDescriptorData & descriptor )**

        Adds **descriptor** to the list of descriptors of this characteristic,
        if it is valid.

        **See also** **setDescriptors** ().
        """
        ...

    def descriptors(self) -> List[PySide6.QtBluetooth.QLowEnergyDescriptorData]:
        """
        https://doc.qt.io/qt-6/qlowenergycharacteristicdata.html#descriptors

        **QList<QLowEnergyDescriptorData>
        QLowEnergyCharacteristicData::descriptors() const**

        Returns the descriptors of this characteristic.

        **See also** **setDescriptors** ().
        """
        ...

    def isValid(self) -> bool:
        """
        https://doc.qt.io/qt-6/qlowenergycharacteristicdata.html#isValid

        **bool QLowEnergyCharacteristicData::isValid() const**

        Returns true if and only if this characteristic is valid, that is, it
        has a non-null UUID.
        """
        ...

    def maximumValueLength(self) -> int:
        """
        https://doc.qt.io/qt-6/qlowenergycharacteristicdata.html#maximumValueLen
        gth

        **int QLowEnergyCharacteristicData::maximumValueLength() const**

        Returns the maximum length in bytes that the value of this
        characteristic can have. By default, there is no limit beyond the
        constraints of the data type.
        """
        ...

    def minimumValueLength(self) -> int:
        """
        https://doc.qt.io/qt-6/qlowenergycharacteristicdata.html#minimumValueLen
        gth

        **int QLowEnergyCharacteristicData::minimumValueLength() const**

        Returns the minimum length in bytes that the value of this
        characteristic can have. The default is zero.
        """
        ...

    def properties(self) -> PySide6.QtBluetooth.QLowEnergyCharacteristic.PropertyTypes:
        """
        https://doc.qt.io/qt-6/qlowenergycharacteristicdata.html#properties

        **QLowEnergyCharacteristic::PropertyTypes
        QLowEnergyCharacteristicData::properties() const**

        Returns the properties of this characteristic.

        **See also** **setProperties** ().
        """
        ...

    def readConstraints(self) -> PySide6.QtBluetooth.QBluetooth.AttAccessConstraints:
        """
        https://doc.qt.io/qt-6/qlowenergycharacteristicdata.html#readConstraints

        **QBluetooth::AttAccessConstraints
        QLowEnergyCharacteristicData::readConstraints() const**

        Returns the constraints needed for a client to read the value of this
        characteristic. If **properties** () does not include
        **QLowEnergyCharacteristic::Read** , this value is irrelevant. By
        default, there are no read constraints.

        **See also** **setReadConstraints** ().
        """
        ...

    def setDescriptors(
        self, descriptors: Sequence[PySide6.QtBluetooth.QLowEnergyDescriptorData]
    ) -> None:
        """
        https://doc.qt.io/qt-6/qlowenergycharacteristicdata.html#setDescriptors

        **void QLowEnergyCharacteristicData::setDescriptors(const
        QList<QLowEnergyDescriptorData> & descriptors )**

        Sets the descriptors of this characteristic to **descriptors**. Only
        valid descriptors are considered.

        **See also** **descriptors** () and **addDescriptor** ().
        """
        ...

    def setProperties(
        self, properties: PySide6.QtBluetooth.QLowEnergyCharacteristic.PropertyTypes
    ) -> None:
        """
        https://doc.qt.io/qt-6/qlowenergycharacteristicdata.html#setProperties

        **void QLowEnergyCharacteristicData::setProperties(QLowEnergyCharacteris
        tic::PropertyTypes properties )**

        Sets the properties of this characteristic to **properties**.

        **See also** **properties** ().
        """
        ...

    def setReadConstraints(
        self, constraints: PySide6.QtBluetooth.QBluetooth.AttAccessConstraints
    ) -> None:
        """
        https://doc.qt.io/qt-6/qlowenergycharacteristicdata.html#setReadConstrai
        nts

        **void QLowEnergyCharacteristicData::setReadConstraints(QBluetooth::AttA
        ccessConstraints constraints )**

        Specifies that clients need to fulfill **constraints** to read the value
        of this characteristic.

        **See also** **readConstraints** ().
        """
        ...

    def setUuid(
        self,
        uuid: Union[
            PySide6.QtBluetooth.QBluetoothUuid.CharacteristicType,
            PySide6.QtBluetooth.QBluetoothUuid.DescriptorType,
            PySide6.QtBluetooth.QBluetoothUuid.ProtocolUuid,
            PySide6.QtBluetooth.QBluetoothUuid.ServiceClassUuid,
            PySide6.QtCore.QUuid,
        ],
    ) -> None:
        """
        https://doc.qt.io/qt-6/qlowenergycharacteristicdata.html#setUuid

        **void QLowEnergyCharacteristicData::setUuid(const QBluetoothUuid & uuid
        )**

        Sets the UUID of this characteristic to **uuid**.

        **See also** **uuid** ().
        """
        ...

    def setValue(self, value: Union[PySide6.QtCore.QByteArray, bytes]) -> None:
        """
        https://doc.qt.io/qt-6/qlowenergycharacteristicdata.html#setValue

        **void QLowEnergyCharacteristicData::setValue(const QByteArray & value
        )**

        Sets the value of this characteristic to **value**.

        **See also** **value** ().
        """
        ...

    def setValueLength(self, minimum: int, maximum: int) -> None:
        """
        https://doc.qt.io/qt-6/qlowenergycharacteristicdata.html#setValueLength

        **void QLowEnergyCharacteristicData::setValueLength(int minimum , int
        maximum )**

        Specifies **minimum** and **maximum** to be the smallest and largest
        length, respectively, that the value of this characteristic can have.
        The unit is bytes. If **minimum** and **maximum** are equal, the
        characteristic has a fixed-length value.
        """
        ...

    def setWriteConstraints(
        self, constraints: PySide6.QtBluetooth.QBluetooth.AttAccessConstraints
    ) -> None:
        """
        https://doc.qt.io/qt-6/qlowenergycharacteristicdata.html#setWriteConstra
        ints

        **void QLowEnergyCharacteristicData::setWriteConstraints(QBluetooth::Att
        AccessConstraints constraints )**

        Specifies that clients need to fulfill **constraints** to write the
        value of this characteristic.

        **See also** **writeConstraints** ().
        """
        ...

    def swap(self, other: PySide6.QtBluetooth.QLowEnergyCharacteristicData) -> None:
        """
        https://doc.qt.io/qt-6/qlowenergycharacteristicdata.html#swap

        **void QLowEnergyCharacteristicData::swap(QLowEnergyCharacteristicData &
        other )**

        Swaps this object with **other**.
        """
        ...

    def uuid(self) -> PySide6.QtBluetooth.QBluetoothUuid:
        """
        https://doc.qt.io/qt-6/qlowenergycharacteristicdata.html#uuid

        **QBluetoothUuid QLowEnergyCharacteristicData::uuid() const**

        Returns the UUID of this characteristic.

        **See also** **setUuid** ().
        """
        ...

    def value(self) -> PySide6.QtCore.QByteArray:
        """
        https://doc.qt.io/qt-6/qlowenergycharacteristicdata.html#value

        **QByteArray QLowEnergyCharacteristicData::value() const**

        Returns the value of this characteristic.

        **See also** **setValue** ().
        """
        ...

    def writeConstraints(self) -> PySide6.QtBluetooth.QBluetooth.AttAccessConstraints:
        """
        https://doc.qt.io/qt-6/qlowenergycharacteristicdata.html#writeConstraint
        s

        **QBluetooth::AttAccessConstraints
        QLowEnergyCharacteristicData::writeConstraints() const**

        Returns the constraints needed for a client to write the value of this
        characteristic. If **properties** () does not include either of
        **QLowEnergyCharacteristic::Write** ,
        **QLowEnergyCharacteristic::WriteNoResponse**  and
        **QLowEnergyCharacteristic::WriteSigned** , this value is irrelevant. By
        default, there are no write constraints.

        **See also** **setWriteConstraints** ().
        """
        ...
