"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtBluetooth, except for defaults which are replaced by "...".
"""
from enum import Enum
from typing import Dict, List, Sequence, Union, overload
import PySide6.QtCore
import PySide6.QtBluetooth

bytes = str


class QBluetoothDeviceInfo(object):
    """
    https://doc.qt.io/qt-6/qbluetoothdeviceinfo.html

    **Detailed Description**

    QBluetoothDeviceInfo provides information about a Bluetooth device's name,
    address and class of device.
    """

    UnknownCoreConfiguration: QBluetoothDeviceInfo.CoreConfiguration = ...
    LowEnergyCoreConfiguration: QBluetoothDeviceInfo.CoreConfiguration = ...
    BaseRateCoreConfiguration: QBluetoothDeviceInfo.CoreConfiguration = ...
    BaseRateAndLowEnergyCoreConfiguration: QBluetoothDeviceInfo.CoreConfiguration = ...
    MiscellaneousDevice: QBluetoothDeviceInfo.MajorDeviceClass = ...
    ComputerDevice: QBluetoothDeviceInfo.MajorDeviceClass = ...
    PhoneDevice: QBluetoothDeviceInfo.MajorDeviceClass = ...
    NetworkDevice: QBluetoothDeviceInfo.MajorDeviceClass = ...
    AudioVideoDevice: QBluetoothDeviceInfo.MajorDeviceClass = ...
    PeripheralDevice: QBluetoothDeviceInfo.MajorDeviceClass = ...
    ImagingDevice: QBluetoothDeviceInfo.MajorDeviceClass = ...
    WearableDevice: QBluetoothDeviceInfo.MajorDeviceClass = ...
    ToyDevice: QBluetoothDeviceInfo.MajorDeviceClass = ...
    HealthDevice: QBluetoothDeviceInfo.MajorDeviceClass = ...
    UncategorizedDevice: QBluetoothDeviceInfo.MajorDeviceClass = ...
    UncategorizedAudioVideoDevice: QBluetoothDeviceInfo.MinorAudioVideoClass = ...
    WearableHeadsetDevice: QBluetoothDeviceInfo.MinorAudioVideoClass = ...
    HandsFreeDevice: QBluetoothDeviceInfo.MinorAudioVideoClass = ...
    Microphone: QBluetoothDeviceInfo.MinorAudioVideoClass = ...
    Loudspeaker: QBluetoothDeviceInfo.MinorAudioVideoClass = ...
    Headphones: QBluetoothDeviceInfo.MinorAudioVideoClass = ...
    PortableAudioDevice: QBluetoothDeviceInfo.MinorAudioVideoClass = ...
    CarAudio: QBluetoothDeviceInfo.MinorAudioVideoClass = ...
    SetTopBox: QBluetoothDeviceInfo.MinorAudioVideoClass = ...
    HiFiAudioDevice: QBluetoothDeviceInfo.MinorAudioVideoClass = ...
    Vcr: QBluetoothDeviceInfo.MinorAudioVideoClass = ...
    VideoCamera: QBluetoothDeviceInfo.MinorAudioVideoClass = ...
    Camcorder: QBluetoothDeviceInfo.MinorAudioVideoClass = ...
    VideoMonitor: QBluetoothDeviceInfo.MinorAudioVideoClass = ...
    VideoDisplayAndLoudspeaker: QBluetoothDeviceInfo.MinorAudioVideoClass = ...
    VideoConferencing: QBluetoothDeviceInfo.MinorAudioVideoClass = ...
    GamingDevice: QBluetoothDeviceInfo.MinorAudioVideoClass = ...
    UncategorizedComputer: QBluetoothDeviceInfo.MinorComputerClass = ...
    DesktopComputer: QBluetoothDeviceInfo.MinorComputerClass = ...
    ServerComputer: QBluetoothDeviceInfo.MinorComputerClass = ...
    LaptopComputer: QBluetoothDeviceInfo.MinorComputerClass = ...
    HandheldClamShellComputer: QBluetoothDeviceInfo.MinorComputerClass = ...
    HandheldComputer: QBluetoothDeviceInfo.MinorComputerClass = ...
    WearableComputer: QBluetoothDeviceInfo.MinorComputerClass = ...
    UncategorizedHealthDevice: QBluetoothDeviceInfo.MinorHealthClass = ...
    HealthBloodPressureMonitor: QBluetoothDeviceInfo.MinorHealthClass = ...
    HealthThermometer: QBluetoothDeviceInfo.MinorHealthClass = ...
    HealthWeightScale: QBluetoothDeviceInfo.MinorHealthClass = ...
    HealthGlucoseMeter: QBluetoothDeviceInfo.MinorHealthClass = ...
    HealthPulseOximeter: QBluetoothDeviceInfo.MinorHealthClass = ...
    HealthDataDisplay: QBluetoothDeviceInfo.MinorHealthClass = ...
    HealthStepCounter: QBluetoothDeviceInfo.MinorHealthClass = ...
    UncategorizedImagingDevice: QBluetoothDeviceInfo.MinorImagingClass = ...
    ImageDisplay: QBluetoothDeviceInfo.MinorImagingClass = ...
    ImageCamera: QBluetoothDeviceInfo.MinorImagingClass = ...
    ImageScanner: QBluetoothDeviceInfo.MinorImagingClass = ...
    ImagePrinter: QBluetoothDeviceInfo.MinorImagingClass = ...
    UncategorizedMiscellaneous: QBluetoothDeviceInfo.MinorMiscellaneousClass = ...
    NetworkFullService: QBluetoothDeviceInfo.MinorNetworkClass = ...
    NetworkLoadFactorOne: QBluetoothDeviceInfo.MinorNetworkClass = ...
    NetworkLoadFactorTwo: QBluetoothDeviceInfo.MinorNetworkClass = ...
    NetworkLoadFactorThree: QBluetoothDeviceInfo.MinorNetworkClass = ...
    NetworkLoadFactorFour: QBluetoothDeviceInfo.MinorNetworkClass = ...
    NetworkLoadFactorFive: QBluetoothDeviceInfo.MinorNetworkClass = ...
    NetworkLoadFactorSix: QBluetoothDeviceInfo.MinorNetworkClass = ...
    NetworkNoService: QBluetoothDeviceInfo.MinorNetworkClass = ...
    UncategorizedPeripheral: QBluetoothDeviceInfo.MinorPeripheralClass = ...
    JoystickPeripheral: QBluetoothDeviceInfo.MinorPeripheralClass = ...
    GamepadPeripheral: QBluetoothDeviceInfo.MinorPeripheralClass = ...
    RemoteControlPeripheral: QBluetoothDeviceInfo.MinorPeripheralClass = ...
    SensingDevicePeripheral: QBluetoothDeviceInfo.MinorPeripheralClass = ...
    DigitizerTabletPeripheral: QBluetoothDeviceInfo.MinorPeripheralClass = ...
    CardReaderPeripheral: QBluetoothDeviceInfo.MinorPeripheralClass = ...
    KeyboardPeripheral: QBluetoothDeviceInfo.MinorPeripheralClass = ...
    PointingDevicePeripheral: QBluetoothDeviceInfo.MinorPeripheralClass = ...
    KeyboardWithPointingDevicePeripheral: QBluetoothDeviceInfo.MinorPeripheralClass = (
        ...
    )
    UncategorizedPhone: QBluetoothDeviceInfo.MinorPhoneClass = ...
    CellularPhone: QBluetoothDeviceInfo.MinorPhoneClass = ...
    CordlessPhone: QBluetoothDeviceInfo.MinorPhoneClass = ...
    SmartPhone: QBluetoothDeviceInfo.MinorPhoneClass = ...
    WiredModemOrVoiceGatewayPhone: QBluetoothDeviceInfo.MinorPhoneClass = ...
    CommonIsdnAccessPhone: QBluetoothDeviceInfo.MinorPhoneClass = ...
    UncategorizedToy: QBluetoothDeviceInfo.MinorToyClass = ...
    ToyRobot: QBluetoothDeviceInfo.MinorToyClass = ...
    ToyVehicle: QBluetoothDeviceInfo.MinorToyClass = ...
    ToyDoll: QBluetoothDeviceInfo.MinorToyClass = ...
    ToyController: QBluetoothDeviceInfo.MinorToyClass = ...
    ToyGame: QBluetoothDeviceInfo.MinorToyClass = ...
    UncategorizedWearableDevice: QBluetoothDeviceInfo.MinorWearableClass = ...
    WearableWristWatch: QBluetoothDeviceInfo.MinorWearableClass = ...
    WearablePager: QBluetoothDeviceInfo.MinorWearableClass = ...
    WearableJacket: QBluetoothDeviceInfo.MinorWearableClass = ...
    WearableHelmet: QBluetoothDeviceInfo.MinorWearableClass = ...
    WearableGlasses: QBluetoothDeviceInfo.MinorWearableClass = ...
    NoService: QBluetoothDeviceInfo.ServiceClass = ...
    PositioningService: QBluetoothDeviceInfo.ServiceClass = ...
    NetworkingService: QBluetoothDeviceInfo.ServiceClass = ...
    RenderingService: QBluetoothDeviceInfo.ServiceClass = ...
    CapturingService: QBluetoothDeviceInfo.ServiceClass = ...
    ObjectTransferService: QBluetoothDeviceInfo.ServiceClass = ...
    AudioService: QBluetoothDeviceInfo.ServiceClass = ...
    TelephonyService: QBluetoothDeviceInfo.ServiceClass = ...
    InformationService: QBluetoothDeviceInfo.ServiceClass = ...
    AllServices: QBluetoothDeviceInfo.ServiceClass = ...

    class CoreConfiguration(Enum):
        UnknownCoreConfiguration: QBluetoothDeviceInfo.CoreConfiguration = ...
        LowEnergyCoreConfiguration: QBluetoothDeviceInfo.CoreConfiguration = ...
        BaseRateCoreConfiguration: QBluetoothDeviceInfo.CoreConfiguration = ...
        BaseRateAndLowEnergyCoreConfiguration: QBluetoothDeviceInfo.CoreConfiguration = (
            ...
        )

    class CoreConfigurations(object):
        ...

    class Field(Enum):
        None_: QBluetoothDeviceInfo.Field = ...
        RSSI: QBluetoothDeviceInfo.Field = ...
        ManufacturerData: QBluetoothDeviceInfo.Field = ...
        All: QBluetoothDeviceInfo.Field = ...

    class Fields(object):
        ...

    class MajorDeviceClass(Enum):
        MiscellaneousDevice: QBluetoothDeviceInfo.MajorDeviceClass = ...
        ComputerDevice: QBluetoothDeviceInfo.MajorDeviceClass = ...
        PhoneDevice: QBluetoothDeviceInfo.MajorDeviceClass = ...
        NetworkDevice: QBluetoothDeviceInfo.MajorDeviceClass = ...
        AudioVideoDevice: QBluetoothDeviceInfo.MajorDeviceClass = ...
        PeripheralDevice: QBluetoothDeviceInfo.MajorDeviceClass = ...
        ImagingDevice: QBluetoothDeviceInfo.MajorDeviceClass = ...
        WearableDevice: QBluetoothDeviceInfo.MajorDeviceClass = ...
        ToyDevice: QBluetoothDeviceInfo.MajorDeviceClass = ...
        HealthDevice: QBluetoothDeviceInfo.MajorDeviceClass = ...
        UncategorizedDevice: QBluetoothDeviceInfo.MajorDeviceClass = ...

    class MinorAudioVideoClass(Enum):
        UncategorizedAudioVideoDevice: QBluetoothDeviceInfo.MinorAudioVideoClass = ...
        WearableHeadsetDevice: QBluetoothDeviceInfo.MinorAudioVideoClass = ...
        HandsFreeDevice: QBluetoothDeviceInfo.MinorAudioVideoClass = ...
        Microphone: QBluetoothDeviceInfo.MinorAudioVideoClass = ...
        Loudspeaker: QBluetoothDeviceInfo.MinorAudioVideoClass = ...
        Headphones: QBluetoothDeviceInfo.MinorAudioVideoClass = ...
        PortableAudioDevice: QBluetoothDeviceInfo.MinorAudioVideoClass = ...
        CarAudio: QBluetoothDeviceInfo.MinorAudioVideoClass = ...
        SetTopBox: QBluetoothDeviceInfo.MinorAudioVideoClass = ...
        HiFiAudioDevice: QBluetoothDeviceInfo.MinorAudioVideoClass = ...
        Vcr: QBluetoothDeviceInfo.MinorAudioVideoClass = ...
        VideoCamera: QBluetoothDeviceInfo.MinorAudioVideoClass = ...
        Camcorder: QBluetoothDeviceInfo.MinorAudioVideoClass = ...
        VideoMonitor: QBluetoothDeviceInfo.MinorAudioVideoClass = ...
        VideoDisplayAndLoudspeaker: QBluetoothDeviceInfo.MinorAudioVideoClass = ...
        VideoConferencing: QBluetoothDeviceInfo.MinorAudioVideoClass = ...
        GamingDevice: QBluetoothDeviceInfo.MinorAudioVideoClass = ...

    class MinorComputerClass(Enum):
        UncategorizedComputer: QBluetoothDeviceInfo.MinorComputerClass = ...
        DesktopComputer: QBluetoothDeviceInfo.MinorComputerClass = ...
        ServerComputer: QBluetoothDeviceInfo.MinorComputerClass = ...
        LaptopComputer: QBluetoothDeviceInfo.MinorComputerClass = ...
        HandheldClamShellComputer: QBluetoothDeviceInfo.MinorComputerClass = ...
        HandheldComputer: QBluetoothDeviceInfo.MinorComputerClass = ...
        WearableComputer: QBluetoothDeviceInfo.MinorComputerClass = ...

    class MinorHealthClass(Enum):
        UncategorizedHealthDevice: QBluetoothDeviceInfo.MinorHealthClass = ...
        HealthBloodPressureMonitor: QBluetoothDeviceInfo.MinorHealthClass = ...
        HealthThermometer: QBluetoothDeviceInfo.MinorHealthClass = ...
        HealthWeightScale: QBluetoothDeviceInfo.MinorHealthClass = ...
        HealthGlucoseMeter: QBluetoothDeviceInfo.MinorHealthClass = ...
        HealthPulseOximeter: QBluetoothDeviceInfo.MinorHealthClass = ...
        HealthDataDisplay: QBluetoothDeviceInfo.MinorHealthClass = ...
        HealthStepCounter: QBluetoothDeviceInfo.MinorHealthClass = ...

    class MinorImagingClass(Enum):
        UncategorizedImagingDevice: QBluetoothDeviceInfo.MinorImagingClass = ...
        ImageDisplay: QBluetoothDeviceInfo.MinorImagingClass = ...
        ImageCamera: QBluetoothDeviceInfo.MinorImagingClass = ...
        ImageScanner: QBluetoothDeviceInfo.MinorImagingClass = ...
        ImagePrinter: QBluetoothDeviceInfo.MinorImagingClass = ...

    class MinorMiscellaneousClass(Enum):
        UncategorizedMiscellaneous: QBluetoothDeviceInfo.MinorMiscellaneousClass = ...

    class MinorNetworkClass(Enum):
        NetworkFullService: QBluetoothDeviceInfo.MinorNetworkClass = ...
        NetworkLoadFactorOne: QBluetoothDeviceInfo.MinorNetworkClass = ...
        NetworkLoadFactorTwo: QBluetoothDeviceInfo.MinorNetworkClass = ...
        NetworkLoadFactorThree: QBluetoothDeviceInfo.MinorNetworkClass = ...
        NetworkLoadFactorFour: QBluetoothDeviceInfo.MinorNetworkClass = ...
        NetworkLoadFactorFive: QBluetoothDeviceInfo.MinorNetworkClass = ...
        NetworkLoadFactorSix: QBluetoothDeviceInfo.MinorNetworkClass = ...
        NetworkNoService: QBluetoothDeviceInfo.MinorNetworkClass = ...

    class MinorPeripheralClass(Enum):
        UncategorizedPeripheral: QBluetoothDeviceInfo.MinorPeripheralClass = ...
        JoystickPeripheral: QBluetoothDeviceInfo.MinorPeripheralClass = ...
        GamepadPeripheral: QBluetoothDeviceInfo.MinorPeripheralClass = ...
        RemoteControlPeripheral: QBluetoothDeviceInfo.MinorPeripheralClass = ...
        SensingDevicePeripheral: QBluetoothDeviceInfo.MinorPeripheralClass = ...
        DigitizerTabletPeripheral: QBluetoothDeviceInfo.MinorPeripheralClass = ...
        CardReaderPeripheral: QBluetoothDeviceInfo.MinorPeripheralClass = ...
        KeyboardPeripheral: QBluetoothDeviceInfo.MinorPeripheralClass = ...
        PointingDevicePeripheral: QBluetoothDeviceInfo.MinorPeripheralClass = ...
        KeyboardWithPointingDevicePeripheral: QBluetoothDeviceInfo.MinorPeripheralClass = (
            ...
        )

    class MinorPhoneClass(Enum):
        UncategorizedPhone: QBluetoothDeviceInfo.MinorPhoneClass = ...
        CellularPhone: QBluetoothDeviceInfo.MinorPhoneClass = ...
        CordlessPhone: QBluetoothDeviceInfo.MinorPhoneClass = ...
        SmartPhone: QBluetoothDeviceInfo.MinorPhoneClass = ...
        WiredModemOrVoiceGatewayPhone: QBluetoothDeviceInfo.MinorPhoneClass = ...
        CommonIsdnAccessPhone: QBluetoothDeviceInfo.MinorPhoneClass = ...

    class MinorToyClass(Enum):
        UncategorizedToy: QBluetoothDeviceInfo.MinorToyClass = ...
        ToyRobot: QBluetoothDeviceInfo.MinorToyClass = ...
        ToyVehicle: QBluetoothDeviceInfo.MinorToyClass = ...
        ToyDoll: QBluetoothDeviceInfo.MinorToyClass = ...
        ToyController: QBluetoothDeviceInfo.MinorToyClass = ...
        ToyGame: QBluetoothDeviceInfo.MinorToyClass = ...

    class MinorWearableClass(Enum):
        UncategorizedWearableDevice: QBluetoothDeviceInfo.MinorWearableClass = ...
        WearableWristWatch: QBluetoothDeviceInfo.MinorWearableClass = ...
        WearablePager: QBluetoothDeviceInfo.MinorWearableClass = ...
        WearableJacket: QBluetoothDeviceInfo.MinorWearableClass = ...
        WearableHelmet: QBluetoothDeviceInfo.MinorWearableClass = ...
        WearableGlasses: QBluetoothDeviceInfo.MinorWearableClass = ...

    class ServiceClass(Enum):
        NoService: QBluetoothDeviceInfo.ServiceClass = ...
        PositioningService: QBluetoothDeviceInfo.ServiceClass = ...
        NetworkingService: QBluetoothDeviceInfo.ServiceClass = ...
        RenderingService: QBluetoothDeviceInfo.ServiceClass = ...
        CapturingService: QBluetoothDeviceInfo.ServiceClass = ...
        ObjectTransferService: QBluetoothDeviceInfo.ServiceClass = ...
        AudioService: QBluetoothDeviceInfo.ServiceClass = ...
        TelephonyService: QBluetoothDeviceInfo.ServiceClass = ...
        InformationService: QBluetoothDeviceInfo.ServiceClass = ...
        AllServices: QBluetoothDeviceInfo.ServiceClass = ...

    class ServiceClasses(object):
        ...

    @overload
    def __init__(self) -> None:
        """
        https://doc.qt.io/qt-6/qbluetoothdeviceinfo.html#QBluetoothDeviceInfo

        **QBluetoothDeviceInfo::QBluetoothDeviceInfo()**

        Constructs an invalid QBluetoothDeviceInfo object.
        """
        ...

    @overload
    def __init__(
        self,
        address: PySide6.QtBluetooth.QBluetoothAddress,
        name: str,
        classOfDevice: int,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qbluetoothdeviceinfo.html#QBluetoothDeviceInfo-1

        **QBluetoothDeviceInfo::QBluetoothDeviceInfo(const QBluetoothAddress &
        address , const QString & name , quint32 classOfDevice )**

        Constructs a QBluetoothDeviceInfo object with Bluetooth address
        **address** , device name **name** and the encoded class of device
        **classOfDevice**.

        The **classOfDevice** parameter is encoded in the following format

        BitsSizeDescription
        0 - 12Unused, set to 0.
        2 - 76Minor device
        class.
        8 - 125Major device class.
        13 - 2311Service class.
        """
        ...

    @overload
    def __init__(self, other: PySide6.QtBluetooth.QBluetoothDeviceInfo) -> None:
        """
        https://doc.qt.io/qt-6/qbluetoothdeviceinfo.html#QBluetoothDeviceInfo-2

        **[since 5.5] QBluetoothDeviceInfo::QBluetoothDeviceInfo(const
        QBluetoothUuid & uuid , const QString & name , quint32 classOfDevice )**

        Constructs a QBluetoothDeviceInfo object with unique **uuid** , device
        name **name** and the encoded class of device **classOfDevice**.

        This constructor is required for Low Energy devices on macOS and iOS.
        CoreBluetooth API hides addresses and provides unique UUIDs to identify
        a device. This UUID is not the same thing as a service UUID and is
        required to work later with CoreBluetooth API and discovered devices.

        This function was introduced in Qt 5.5.
        """
        ...

    @overload
    def __init__(
        self,
        uuid: Union[
            PySide6.QtBluetooth.QBluetoothUuid.CharacteristicType,
            PySide6.QtBluetooth.QBluetoothUuid.DescriptorType,
            PySide6.QtBluetooth.QBluetoothUuid.ProtocolUuid,
            PySide6.QtBluetooth.QBluetoothUuid.ServiceClassUuid,
            PySide6.QtCore.QUuid,
        ],
        name: str,
        classOfDevice: int,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qbluetoothdeviceinfo.html#QBluetoothDeviceInfo-3

        **QBluetoothDeviceInfo::QBluetoothDeviceInfo(const QBluetoothDeviceInfo
        & other )**

        Constructs a QBluetoothDeviceInfo that is a copy of **other**.
        """
        ...

    @staticmethod
    def __copy__() -> None:
        ...

    def address(self) -> PySide6.QtBluetooth.QBluetoothAddress:
        """
        https://doc.qt.io/qt-6/qbluetoothdeviceinfo.html#address

        **QBluetoothAddress QBluetoothDeviceInfo::address() const**

        Returns the address of the device.

        **Note:** On iOS and macOS this address is invalid. Instead
        **deviceUuid** () should be used. Those two platforms do not expose
        Bluetooth addresses for found Bluetooth devices and utilize unique
        device identifiers.

        **See also** **deviceUuid** ().
        """
        ...

    def coreConfigurations(
        self,
    ) -> PySide6.QtBluetooth.QBluetoothDeviceInfo.CoreConfigurations:
        """
        https://doc.qt.io/qt-6/qbluetoothdeviceinfo.html#coreConfigurations

        **[since 5.4] QBluetoothDeviceInfo::CoreConfigurations
        QBluetoothDeviceInfo::coreConfigurations() const**

        Returns the configuration of the device. If device configuration is not
        set, basic rate device configuration will be returned.

        This function was introduced in Qt 5.4.

        **See also** **setCoreConfigurations** ().
        """
        ...

    def deviceUuid(self) -> PySide6.QtBluetooth.QBluetoothUuid:
        """
        https://doc.qt.io/qt-6/qbluetoothdeviceinfo.html#deviceUuid

        **[since 5.5] QBluetoothUuid QBluetoothDeviceInfo::deviceUuid() const**

        Returns a unique identifier for a Bluetooth device without an address.

        In general, this uuid is invalid on every platform but macOS and iOS. It
        is used as a workaround for those two platforms as they do not provide
        Bluetooth addresses for found Bluetooth Low Energy devices. Every other
        platform uses **address** () instead.

        This function was introduced in Qt 5.5.

        **See also** **setDeviceUuid** ().
        """
        ...

    def isCached(self) -> bool:
        """
        https://doc.qt.io/qt-6/qbluetoothdeviceinfo.html#isCached

        **bool QBluetoothDeviceInfo::isCached() const**

        Returns true if the **QBluetoothDeviceInfo**  object is created from
        cached data.
        """
        ...

    def isValid(self) -> bool:
        """
        https://doc.qt.io/qt-6/qbluetoothdeviceinfo.html#isValid

        **bool QBluetoothDeviceInfo::isValid() const**

        Returns true if the **QBluetoothDeviceInfo**  object is valid, otherwise
        returns false.
        """
        ...

    def majorDeviceClass(
        self,
    ) -> PySide6.QtBluetooth.QBluetoothDeviceInfo.MajorDeviceClass:
        """
        https://doc.qt.io/qt-6/qbluetoothdeviceinfo.html#majorDeviceClass

        **QBluetoothDeviceInfo::MajorDeviceClass
        QBluetoothDeviceInfo::majorDeviceClass() const**

        Returns the major device class of the device.
        """
        ...

    @overload
    def manufacturerData(self) -> Dict[int, PySide6.QtCore.QByteArray]:
        """
        https://doc.qt.io/qt-6/qbluetoothdeviceinfo.html#manufacturerData

        **[since 5.12] QByteArray QBluetoothDeviceInfo::manufacturerData(quint16
        manufacturerId ) const**

        Returns the data associated with the given **manufacturerId**.

        Manufacturer data is defined by the Supplement to the Bluetooth Core
        Specification and consists of two segments:

        * Manufacturer specific identifier code from the **Assigned Numbers**
        Company Identifiers document
          * Sequence of arbitrary data octets

        The interpretation of the data octets is defined by the manufacturer
        specified by the company identifier.

        **Note:** The remote device may provide multiple data entries per
        manufacturerId. This function only returns the first entry. If all
        entries are needed use **manufacturerData** () which returns a multi
        hash.

        This function was introduced in Qt 5.12.

        **See also** **manufacturerIds** () and **setManufacturerData** ().
        """
        ...

    @overload
    def manufacturerData(self, manufacturerId: int) -> PySide6.QtCore.QByteArray:
        """
        https://doc.qt.io/qt-6/qbluetoothdeviceinfo.html#manufacturerData-1

        **[since 5.12] QMultiHash<quint16, QByteArray>
        QBluetoothDeviceInfo::manufacturerData() const**

        Returns the complete set of all manufacturer data.

        Some devices may provide multiple manufacturer data entries per
        manufacturer ID. An example might be a Bluetooth Low Energy device that
        sends a different manufacturer data via advertisement packets and scan
        response packets respectively. Therefore the returned hash table may
        have multiple entries per manufacturer ID or hash key.

        This function was introduced in Qt 5.12.

        **See also** **setManufacturerData** .
        """
        ...

    def manufacturerIds(self) -> List[int]:
        """
        https://doc.qt.io/qt-6/qbluetoothdeviceinfo.html#manufacturerIds

        **[since 5.12] QList<quint16> QBluetoothDeviceInfo::manufacturerIds()
        const**

        Returns all manufacturer ids attached to this device information.

        This function was introduced in Qt 5.12.

        **See also** **manufacturerData** () and **setManufacturerData** ().
        """
        ...

    def minorDeviceClass(self) -> int:
        """
        https://doc.qt.io/qt-6/qbluetoothdeviceinfo.html#minorDeviceClass

        **quint8 QBluetoothDeviceInfo::minorDeviceClass() const**

        Returns the minor device class of the device. The actual information is
        context dependent on the value of **majorDeviceClass** ().

        **See also** **MinorAudioVideoClass** , **MinorComputerClass** ,
        **MinorHealthClass** , **MinorImagingClass** ,
        **MinorMiscellaneousClass** , **MinorNetworkClass** ,
        **MinorPeripheralClass** , **MinorPhoneClass** , **MinorToyClass** , and
        **MinorWearableClass** .
        """
        ...

    def name(self) -> str:
        """
        https://doc.qt.io/qt-6/qbluetoothdeviceinfo.html#name

        **QString QBluetoothDeviceInfo::name() const**

        Returns the name assigned to the device.

        **See also** **setName** ().
        """
        ...

    def rssi(self) -> int:
        """
        https://doc.qt.io/qt-6/qbluetoothdeviceinfo.html#rssi

        **qint16 QBluetoothDeviceInfo::rssi() const**

        Returns the signal strength when the device was last scanned

        **See also** **setRssi** ().
        """
        ...

    def serviceClasses(self) -> PySide6.QtBluetooth.QBluetoothDeviceInfo.ServiceClasses:
        """
        https://doc.qt.io/qt-6/qbluetoothdeviceinfo.html#serviceClasses

        **QBluetoothDeviceInfo::ServiceClasses
        QBluetoothDeviceInfo::serviceClasses() const**

        Returns the service class of the device.
        """
        ...

    def serviceUuids(self) -> List[PySide6.QtBluetooth.QBluetoothUuid]:
        """
        https://doc.qt.io/qt-6/qbluetoothdeviceinfo.html#serviceUuids

        **[since 6.0] QList<QBluetoothUuid> QBluetoothDeviceInfo::serviceUuids()
        const**

        Returns the list of service UUIDS supported by the device. Most commonly
        this list of uuids represents custom uuids or a uuid value specified by
        **QBluetoothUuid::ServiceClassUuid** .

        This function was introduced in Qt 6.0.

        **See also** **setServiceUuids** () and serviceUuids().
        """
        ...

    def setCached(self, cached: bool) -> None:
        """
        https://doc.qt.io/qt-6/qbluetoothdeviceinfo.html#setCached

        **void QBluetoothDeviceInfo::setCached(bool cached )**

        Used by the system to set the **cached** flag if the
        **QBluetoothDeviceInfo**  is created from cached data. Cached
        information may not be as accurate as data read from an active device.

        **See also** **isCached** ().
        """
        ...

    def setCoreConfigurations(
        self, coreConfigs: PySide6.QtBluetooth.QBluetoothDeviceInfo.CoreConfigurations
    ) -> None:
        """
        https://doc.qt.io/qt-6/qbluetoothdeviceinfo.html#setCoreConfigurations

        **[since 5.4] void QBluetoothDeviceInfo::setCoreConfigurations(QBluetoot
        hDeviceInfo::CoreConfigurations coreConfigs )**

        Sets the **CoreConfigurations**  of the device to **coreConfigs**. This
        will help to make a difference between regular and Low Energy devices.

        This function was introduced in Qt 5.4.

        **See also** **coreConfigurations** ().
        """
        ...

    def setDeviceUuid(
        self,
        uuid: Union[
            PySide6.QtBluetooth.QBluetoothUuid.CharacteristicType,
            PySide6.QtBluetooth.QBluetoothUuid.DescriptorType,
            PySide6.QtBluetooth.QBluetoothUuid.ProtocolUuid,
            PySide6.QtBluetooth.QBluetoothUuid.ServiceClassUuid,
            PySide6.QtCore.QUuid,
        ],
    ) -> None:
        """
        https://doc.qt.io/qt-6/qbluetoothdeviceinfo.html#setDeviceUuid

        **[since 5.5] void QBluetoothDeviceInfo::setDeviceUuid(const
        QBluetoothUuid & uuid )**

        Sets the unique identifier **uuid** for Bluetooth devices, that do not
        have addresses. This happens on macOS and iOS, where the CoreBluetooth
        API hides addresses, but provides UUIDs to identify devices/peripherals.

        This uuid is invalid on any other platform.

        This function was introduced in Qt 5.5.

        **See also** **deviceUuid** ().
        """
        ...

    def setManufacturerData(
        self, manufacturerId: int, data: Union[PySide6.QtCore.QByteArray, bytes]
    ) -> bool:
        """
        https://doc.qt.io/qt-6/qbluetoothdeviceinfo.html#setManufacturerData

        **[since 5.12] bool QBluetoothDeviceInfo::setManufacturerData(quint16
        manufacturerId , const QByteArray & data )**

        Sets the advertised manufacturer **data** for the given
        **manufacturerId**. Returns `true` if it was inserted, `false` if it was
        already known.

        Since Qt 5.14, different values for **data** and the same
        **manufacturerId** no longer replace each other but are accumulated for
        the duration of a device scan.

        This function was introduced in Qt 5.12.

        **See also** **manufacturerData** .
        """
        ...

    def setName(self, name: str) -> None:
        """
        https://doc.qt.io/qt-6/qbluetoothdeviceinfo.html#setName

        **[since 6.2] void QBluetoothDeviceInfo::setName(const QString & name
        )**

        Sets the **name** of the device.

        This function was introduced in Qt 6.2.

        **See also** **name** ().
        """
        ...

    def setRssi(self, signal: int) -> None:
        """
        https://doc.qt.io/qt-6/qbluetoothdeviceinfo.html#setRssi

        **void QBluetoothDeviceInfo::setRssi(qint16 signal )**

        Set the **signal** strength value, used internally.

        **See also** **rssi** ().
        """
        ...

    def setServiceUuids(
        self, uuids: Sequence[PySide6.QtBluetooth.QBluetoothUuid]
    ) -> None:
        """
        https://doc.qt.io/qt-6/qbluetoothdeviceinfo.html#setServiceUuids

        **[since 5.13] void QBluetoothDeviceInfo::setServiceUuids(const
        QList<QBluetoothUuid> & uuids )**

        Sets the list of service UUIDs to **uuids**.

        This function was introduced in Qt 5.13.

        **See also** **serviceUuids** ().
        """
        ...
