# -*- coding: utf-8 -*-
#
# Copyright (C) 2023 - 2025 ANSYS, Inc. and/or its affiliates.
# SPDX-License-Identifier: MIT
#
# Permission is hereby granted, free of charge, to any person obtaining a copy
# of this software and associated documentation files (the "Software"), to deal
# in the Software without restriction, including without limitation the rights
# to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
# copies of the Software, and to permit persons to whom the Software is
# furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice shall be included in all
# copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
# AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
# OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
# SOFTWARE.

"""
PyAEDT Common Toolkit constants.
"""


# Mapping from name to its associated AEDT application
NAME_TO_AEDT_APP = {
    "Circuit Design": "Circuit",
    "Circuit": "Circuit",
    "HFSS": "Hfss",
    "Hfss": "Hfss",
    "EMIT": "Emit",
    "HFSS 3D Layout Design": "Hfss3dLayout",
    "Hfss3dLayout": "Hfss3dLayout",
    "Hfss3DLayout": "Hfss3dLayout",
    "Icepak": "Icepak",
    "Maxwell 2D": "Maxwell2d",
    "Maxwell2D": "Maxwell2d",
    "Maxwell 3D": "Maxwell3d",
    "Maxwell3D": "Maxwell3d",
    "Maxwell Circuit": "MaxwellCircuit",
    "2D Extractor": "Q2d",
    "Q2D": "Q2d",
    "Q2d": "Q2d",
    "Q3D Extractor": "Q3d",
    "Q3D": "Q3d",
    "Q3d": "Q3d",
    "RMxprt": "Rmxprt",
    "TwinBuilder": "TwinBuilder",
    "Twin Builder": "TwinBuilder",
    "Simplorer": "TwinBuilder",
    "Mechanical": "Mechanical",
}
