/*
 * Decompiled with CFR 0.152.
 */
package libpadeldescriptor;

import java.util.ArrayList;
import java.util.List;
import libpadeldescriptor.PaDELChiIndexUtils;
import org.openscience.cdk.DefaultChemObjectBuilder;
import org.openscience.cdk.annotations.TestClass;
import org.openscience.cdk.annotations.TestMethod;
import org.openscience.cdk.atomtype.CDKAtomTypeMatcher;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.exception.InvalidSmilesException;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IAtomType;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.isomorphism.matchers.QueryAtomContainer;
import org.openscience.cdk.isomorphism.matchers.QueryAtomContainerCreator;
import org.openscience.cdk.qsar.DescriptorSpecification;
import org.openscience.cdk.qsar.DescriptorValue;
import org.openscience.cdk.qsar.IMolecularDescriptor;
import org.openscience.cdk.qsar.result.DoubleArrayResult;
import org.openscience.cdk.qsar.result.DoubleArrayResultType;
import org.openscience.cdk.qsar.result.IDescriptorResult;
import org.openscience.cdk.smiles.SmilesParser;
import org.openscience.cdk.tools.CDKHydrogenAdder;
import org.openscience.cdk.tools.manipulator.AtomContainerManipulator;
import org.openscience.cdk.tools.manipulator.AtomTypeManipulator;

@TestClass(value="org.openscience.cdk.qsar.descriptors.molecular.ChiPathDescriptorTest")
public class PaDELChiPathDescriptor
implements IMolecularDescriptor {
    private SmilesParser sp = new SmilesParser(DefaultChemObjectBuilder.getInstance());

    @Override
    @TestMethod(value="testGetSpecification")
    public DescriptorSpecification getSpecification() {
        return new DescriptorSpecification("http://www.blueobelisk.org/ontologies/chemoinformatics-algorithms/#chiPath", this.getClass().getName(), "$Id: c08e389f50666cdeec7578b2c60e803823d78270 $", "The Chemistry Development Kit");
    }

    @Override
    @TestMethod(value="testGetParameterNames")
    public String[] getParameterNames() {
        return null;
    }

    @Override
    @TestMethod(value="testGetParameterType_String")
    public Object getParameterType(String string) {
        return null;
    }

    @Override
    @TestMethod(value="testSetParameters_arrayObject")
    public void setParameters(Object[] objectArray) throws CDKException {
    }

    @Override
    @TestMethod(value="testGetParameters")
    public Object[] getParameters() {
        return null;
    }

    @Override
    @TestMethod(value="testNamesConsistency")
    public String[] getDescriptorNames() {
        String[] stringArray = new String[32];
        for (int i = 0; i < 8; ++i) {
            stringArray[i] = "SP-" + i;
            stringArray[i + 8] = "ASP-" + i;
            stringArray[i + 16] = "VP-" + i;
            stringArray[i + 24] = "AVP-" + i;
        }
        return stringArray;
    }

    @Override
    @TestMethod(value="testCalculate_IAtomContainer")
    public DescriptorValue calculate(IAtomContainer iAtomContainer) {
        Object cDKException;
        IAtomContainer iAtomContainer2 = AtomContainerManipulator.removeHydrogens(iAtomContainer);
        CDKAtomTypeMatcher cDKAtomTypeMatcher = CDKAtomTypeMatcher.getInstance(iAtomContainer.getBuilder());
        for (IAtom object22 : iAtomContainer2.atoms()) {
            try {
                cDKException = cDKAtomTypeMatcher.findMatchingAtomType(iAtomContainer2, object22);
                AtomTypeManipulator.configure(object22, (IAtomType)cDKException);
            }
            catch (Exception list) {
                return this.getDummyDescriptorValue(new CDKException("Error in atom typing: " + list.getMessage()));
            }
        }
        CDKHydrogenAdder cDKHydrogenAdder = CDKHydrogenAdder.getInstance(iAtomContainer.getBuilder());
        try {
            cDKHydrogenAdder.addImplicitHydrogens(iAtomContainer2);
        }
        catch (CDKException cDKException2) {
            return this.getDummyDescriptorValue(new CDKException("Error in hydrogen addition: " + cDKException2.getMessage()));
        }
        try {
            cDKException = this.order0(iAtomContainer2);
            List<List<Integer>> list = this.order1(iAtomContainer2);
            List<List<Integer>> list2 = this.order2(iAtomContainer2);
            List<List<Integer>> list3 = this.order3(iAtomContainer2);
            List<List<Integer>> list4 = this.order4(iAtomContainer2);
            List<List<Integer>> list5 = this.order5(iAtomContainer2);
            List<List<Integer>> list6 = this.order6(iAtomContainer2);
            List<List<Integer>> list7 = this.order7(iAtomContainer2);
            double d = PaDELChiIndexUtils.evalSimpleIndex(iAtomContainer2, (List<List<Integer>>)cDKException);
            double d2 = PaDELChiIndexUtils.evalSimpleIndex(iAtomContainer2, list);
            double d3 = PaDELChiIndexUtils.evalSimpleIndex(iAtomContainer2, list2);
            double d4 = PaDELChiIndexUtils.evalSimpleIndex(iAtomContainer2, list3);
            double d5 = PaDELChiIndexUtils.evalSimpleIndex(iAtomContainer2, list4);
            double d6 = PaDELChiIndexUtils.evalSimpleIndex(iAtomContainer2, list5);
            double d7 = PaDELChiIndexUtils.evalSimpleIndex(iAtomContainer2, list6);
            double d8 = PaDELChiIndexUtils.evalSimpleIndex(iAtomContainer2, list7);
            double d9 = PaDELChiIndexUtils.evalValenceIndex(iAtomContainer2, (List)cDKException);
            double d10 = PaDELChiIndexUtils.evalValenceIndex(iAtomContainer2, list);
            double d11 = PaDELChiIndexUtils.evalValenceIndex(iAtomContainer2, list2);
            double d12 = PaDELChiIndexUtils.evalValenceIndex(iAtomContainer2, list3);
            double d13 = PaDELChiIndexUtils.evalValenceIndex(iAtomContainer2, list4);
            double d14 = PaDELChiIndexUtils.evalValenceIndex(iAtomContainer2, list5);
            double d15 = PaDELChiIndexUtils.evalValenceIndex(iAtomContainer2, list6);
            double d16 = PaDELChiIndexUtils.evalValenceIndex(iAtomContainer2, list7);
            DoubleArrayResult doubleArrayResult = new DoubleArrayResult();
            doubleArrayResult.add(d);
            doubleArrayResult.add(d2);
            doubleArrayResult.add(d3);
            doubleArrayResult.add(d4);
            doubleArrayResult.add(d5);
            doubleArrayResult.add(d6);
            doubleArrayResult.add(d7);
            doubleArrayResult.add(d8);
            doubleArrayResult.add(cDKException.isEmpty() ? 0.0 : d / (double)cDKException.size());
            doubleArrayResult.add(list.isEmpty() ? 0.0 : d2 / (double)list.size());
            doubleArrayResult.add(list2.isEmpty() ? 0.0 : d3 / (double)list2.size());
            doubleArrayResult.add(list3.isEmpty() ? 0.0 : d4 / (double)list3.size());
            doubleArrayResult.add(list4.isEmpty() ? 0.0 : d5 / (double)list4.size());
            doubleArrayResult.add(list5.isEmpty() ? 0.0 : d6 / (double)list5.size());
            doubleArrayResult.add(list6.isEmpty() ? 0.0 : d7 / (double)list6.size());
            doubleArrayResult.add(list7.isEmpty() ? 0.0 : d8 / (double)list7.size());
            doubleArrayResult.add(d9);
            doubleArrayResult.add(d10);
            doubleArrayResult.add(d11);
            doubleArrayResult.add(d12);
            doubleArrayResult.add(d13);
            doubleArrayResult.add(d14);
            doubleArrayResult.add(d15);
            doubleArrayResult.add(d16);
            doubleArrayResult.add(cDKException.isEmpty() ? 0.0 : d9 / (double)cDKException.size());
            doubleArrayResult.add(list.isEmpty() ? 0.0 : d10 / (double)list.size());
            doubleArrayResult.add(list2.isEmpty() ? 0.0 : d11 / (double)list2.size());
            doubleArrayResult.add(list3.isEmpty() ? 0.0 : d12 / (double)list3.size());
            doubleArrayResult.add(list4.isEmpty() ? 0.0 : d13 / (double)list4.size());
            doubleArrayResult.add(list5.isEmpty() ? 0.0 : d14 / (double)list5.size());
            doubleArrayResult.add(list6.isEmpty() ? 0.0 : d15 / (double)list6.size());
            doubleArrayResult.add(list7.isEmpty() ? 0.0 : d16 / (double)list7.size());
            return new DescriptorValue(this.getSpecification(), this.getParameterNames(), this.getParameters(), doubleArrayResult, this.getDescriptorNames());
        }
        catch (CDKException cDKException3) {
            return this.getDummyDescriptorValue(new CDKException(cDKException3.getMessage()));
        }
    }

    private DescriptorValue getDummyDescriptorValue(Exception exception) {
        int n = this.getDescriptorNames().length;
        DoubleArrayResult doubleArrayResult = new DoubleArrayResult(n);
        for (int i = 0; i < n; ++i) {
            doubleArrayResult.add(Double.NaN);
        }
        return new DescriptorValue(this.getSpecification(), this.getParameterNames(), this.getParameters(), doubleArrayResult, this.getDescriptorNames(), exception);
    }

    @Override
    @TestMethod(value="testGetDescriptorResultType")
    public IDescriptorResult getDescriptorResultType() {
        return new DoubleArrayResultType(32);
    }

    private List<List<Integer>> order0(IAtomContainer iAtomContainer) {
        ArrayList<List<Integer>> arrayList = new ArrayList<List<Integer>>();
        for (IAtom iAtom : iAtomContainer.atoms()) {
            ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
            arrayList2.add(iAtomContainer.getAtomNumber(iAtom));
            arrayList.add(arrayList2);
        }
        return arrayList;
    }

    private List<List<Integer>> order1(IAtomContainer iAtomContainer) throws CDKException {
        ArrayList<List<Integer>> arrayList = new ArrayList<List<Integer>>();
        for (IBond iBond : iAtomContainer.bonds()) {
            if (iBond.getAtomCount() != 2) {
                throw new CDKException("We only consider 2 center bonds");
            }
            ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
            arrayList2.add(iAtomContainer.getAtomNumber(iBond.getAtom(0)));
            arrayList2.add(iAtomContainer.getAtomNumber(iBond.getAtom(1)));
            arrayList.add(arrayList2);
        }
        return arrayList;
    }

    private List<List<Integer>> order2(IAtomContainer iAtomContainer) {
        QueryAtomContainer[] queryAtomContainerArray = new QueryAtomContainer[1];
        try {
            queryAtomContainerArray[0] = QueryAtomContainerCreator.createAnyAtomAnyBondContainer(this.sp.parseSmiles("CCC"), false);
        }
        catch (InvalidSmilesException invalidSmilesException) {
            invalidSmilesException.printStackTrace();
        }
        return PaDELChiIndexUtils.getFragments(iAtomContainer, queryAtomContainerArray);
    }

    private List<List<Integer>> order3(IAtomContainer iAtomContainer) {
        QueryAtomContainer[] queryAtomContainerArray = new QueryAtomContainer[1];
        try {
            queryAtomContainerArray[0] = QueryAtomContainerCreator.createAnyAtomAnyBondContainer(this.sp.parseSmiles("CCCC"), false);
        }
        catch (InvalidSmilesException invalidSmilesException) {
            invalidSmilesException.printStackTrace();
        }
        return PaDELChiIndexUtils.getFragments(iAtomContainer, queryAtomContainerArray);
    }

    private List<List<Integer>> order4(IAtomContainer iAtomContainer) {
        QueryAtomContainer[] queryAtomContainerArray = new QueryAtomContainer[1];
        try {
            queryAtomContainerArray[0] = QueryAtomContainerCreator.createAnyAtomAnyBondContainer(this.sp.parseSmiles("CCCCC"), false);
        }
        catch (InvalidSmilesException invalidSmilesException) {
            invalidSmilesException.printStackTrace();
        }
        return PaDELChiIndexUtils.getFragments(iAtomContainer, queryAtomContainerArray);
    }

    private List<List<Integer>> order5(IAtomContainer iAtomContainer) {
        QueryAtomContainer[] queryAtomContainerArray = new QueryAtomContainer[1];
        try {
            queryAtomContainerArray[0] = QueryAtomContainerCreator.createAnyAtomAnyBondContainer(this.sp.parseSmiles("CCCCCC"), false);
        }
        catch (InvalidSmilesException invalidSmilesException) {
            invalidSmilesException.printStackTrace();
        }
        return PaDELChiIndexUtils.getFragments(iAtomContainer, queryAtomContainerArray);
    }

    private List<List<Integer>> order6(IAtomContainer iAtomContainer) {
        QueryAtomContainer[] queryAtomContainerArray = new QueryAtomContainer[1];
        try {
            queryAtomContainerArray[0] = QueryAtomContainerCreator.createAnyAtomAnyBondContainer(this.sp.parseSmiles("CCCCCCC"), false);
        }
        catch (InvalidSmilesException invalidSmilesException) {
            invalidSmilesException.printStackTrace();
        }
        return PaDELChiIndexUtils.getFragments(iAtomContainer, queryAtomContainerArray);
    }

    private List<List<Integer>> order7(IAtomContainer iAtomContainer) {
        QueryAtomContainer[] queryAtomContainerArray = new QueryAtomContainer[1];
        try {
            queryAtomContainerArray[0] = QueryAtomContainerCreator.createAnyAtomAnyBondContainer(this.sp.parseSmiles("CCCCCCCC"), false);
        }
        catch (InvalidSmilesException invalidSmilesException) {
            invalidSmilesException.printStackTrace();
        }
        return PaDELChiIndexUtils.getFragments(iAtomContainer, queryAtomContainerArray);
    }
}

