/*
 * Decompiled with CFR 0.152.
 */
package libpadeldescriptor;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openscience.cdk.config.IsotopeFactory;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.graph.PathTools;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.qsar.DescriptorSpecification;
import org.openscience.cdk.qsar.DescriptorValue;
import org.openscience.cdk.qsar.IMolecularDescriptor;
import org.openscience.cdk.qsar.result.DoubleArrayResult;
import org.openscience.cdk.qsar.result.DoubleArrayResultType;
import org.openscience.cdk.qsar.result.IDescriptorResult;

public class InformationContentDescriptor
implements IMolecularDescriptor {
    public static final String[] names = new String[]{"IC0", "IC1", "IC2", "IC3", "IC4", "IC5", "TIC0", "TIC1", "TIC2", "TIC3", "TIC4", "TIC5", "SIC0", "SIC1", "SIC2", "SIC3", "SIC4", "SIC5", "CIC0", "CIC1", "CIC2", "CIC3", "CIC4", "CIC5", "BIC0", "BIC1", "BIC2", "BIC3", "BIC4", "BIC5", "MIC0", "MIC1", "MIC2", "MIC3", "MIC4", "MIC5", "ZMIC0", "ZMIC1", "ZMIC2", "ZMIC3", "ZMIC4", "ZMIC5"};

    @Override
    public DescriptorSpecification getSpecification() {
        return new DescriptorSpecification("InformationContent", this.getClass().getName(), "$Id: InformationContentDescriptor.java 1 2014-06-03 15:00:00Z yapchunwei $", "PaDEL");
    }

    @Override
    public String[] getParameterNames() {
        return null;
    }

    @Override
    public Object getParameterType(String string) {
        return null;
    }

    @Override
    public void setParameters(Object[] objectArray) throws CDKException {
    }

    @Override
    public Object[] getParameters() {
        return null;
    }

    @Override
    public String[] getDescriptorNames() {
        return names;
    }

    @Override
    public DescriptorValue calculate(IAtomContainer iAtomContainer) {
        HashMap<ArrayList<Coordinate>, Integer> hashMap = this.getClasses(iAtomContainer, 0);
        HashMap<ArrayList<Coordinate>, Integer> hashMap2 = this.getClasses(iAtomContainer, 1);
        HashMap<ArrayList<Coordinate>, Integer> hashMap3 = this.getClasses(iAtomContainer, 2);
        HashMap<ArrayList<Coordinate>, Integer> hashMap4 = this.getClasses(iAtomContainer, 3);
        HashMap<ArrayList<Coordinate>, Integer> hashMap5 = this.getClasses(iAtomContainer, 4);
        HashMap<ArrayList<Coordinate>, Integer> hashMap6 = this.getClasses(iAtomContainer, 5);
        double d = this.evalInfoContent(hashMap, iAtomContainer);
        double d2 = this.evalInfoContent(hashMap2, iAtomContainer);
        double d3 = this.evalInfoContent(hashMap3, iAtomContainer);
        double d4 = this.evalInfoContent(hashMap4, iAtomContainer);
        double d5 = this.evalInfoContent(hashMap5, iAtomContainer);
        double d6 = this.evalInfoContent(hashMap6, iAtomContainer);
        int n = iAtomContainer.getAtomCount();
        double d7 = (double)n * d;
        double d8 = (double)n * d2;
        double d9 = (double)n * d3;
        double d10 = (double)n * d4;
        double d11 = (double)n * d5;
        double d12 = (double)n * d6;
        double d13 = Math.log(n) / Math.log(2.0);
        double d14 = d / d13;
        double d15 = d2 / d13;
        double d16 = d3 / d13;
        double d17 = d4 / d13;
        double d18 = d5 / d13;
        double d19 = d6 / d13;
        double d20 = d13 - d;
        double d21 = d13 - d2;
        double d22 = d13 - d3;
        double d23 = d13 - d4;
        double d24 = d13 - d5;
        double d25 = d13 - d6;
        double d26 = 0.0;
        for (IBond iBond : iAtomContainer.bonds()) {
            IBond.Order order = iBond.getOrder();
            if (iBond.getFlag(5)) {
                d26 += 1.5;
                continue;
            }
            if (order == IBond.Order.SINGLE) {
                d26 += 1.0;
                continue;
            }
            if (order == IBond.Order.DOUBLE) {
                d26 += 2.0;
                continue;
            }
            if (order == IBond.Order.TRIPLE) {
                d26 += 3.0;
                continue;
            }
            if (order != IBond.Order.QUADRUPLE) continue;
            d26 += 4.0;
        }
        d26 = Math.log(d26) / Math.log(2.0);
        double d27 = d / d26;
        double d28 = d2 / d26;
        double d29 = d3 / d26;
        double d30 = d4 / d26;
        double d31 = d5 / d26;
        double d32 = d6 / d26;
        double d33 = this.evalModInfoContent(hashMap, iAtomContainer);
        double d34 = this.evalModInfoContent(hashMap2, iAtomContainer);
        double d35 = this.evalModInfoContent(hashMap3, iAtomContainer);
        double d36 = this.evalModInfoContent(hashMap4, iAtomContainer);
        double d37 = this.evalModInfoContent(hashMap5, iAtomContainer);
        double d38 = this.evalModInfoContent(hashMap6, iAtomContainer);
        double d39 = this.evalZModInfoContent(hashMap, iAtomContainer);
        double d40 = this.evalZModInfoContent(hashMap2, iAtomContainer);
        double d41 = this.evalZModInfoContent(hashMap3, iAtomContainer);
        double d42 = this.evalZModInfoContent(hashMap4, iAtomContainer);
        double d43 = this.evalZModInfoContent(hashMap5, iAtomContainer);
        double d44 = this.evalZModInfoContent(hashMap6, iAtomContainer);
        DoubleArrayResult doubleArrayResult = new DoubleArrayResult();
        doubleArrayResult.add(d);
        doubleArrayResult.add(d2);
        doubleArrayResult.add(d3);
        doubleArrayResult.add(d4);
        doubleArrayResult.add(d5);
        doubleArrayResult.add(d6);
        doubleArrayResult.add(d7);
        doubleArrayResult.add(d8);
        doubleArrayResult.add(d9);
        doubleArrayResult.add(d10);
        doubleArrayResult.add(d11);
        doubleArrayResult.add(d12);
        doubleArrayResult.add(d14);
        doubleArrayResult.add(d15);
        doubleArrayResult.add(d16);
        doubleArrayResult.add(d17);
        doubleArrayResult.add(d18);
        doubleArrayResult.add(d19);
        doubleArrayResult.add(d20);
        doubleArrayResult.add(d21);
        doubleArrayResult.add(d22);
        doubleArrayResult.add(d23);
        doubleArrayResult.add(d24);
        doubleArrayResult.add(d25);
        doubleArrayResult.add(d27);
        doubleArrayResult.add(d28);
        doubleArrayResult.add(d29);
        doubleArrayResult.add(d30);
        doubleArrayResult.add(d31);
        doubleArrayResult.add(d32);
        doubleArrayResult.add(d33);
        doubleArrayResult.add(d34);
        doubleArrayResult.add(d35);
        doubleArrayResult.add(d36);
        doubleArrayResult.add(d37);
        doubleArrayResult.add(d38);
        doubleArrayResult.add(d39);
        doubleArrayResult.add(d40);
        doubleArrayResult.add(d41);
        doubleArrayResult.add(d42);
        doubleArrayResult.add(d43);
        doubleArrayResult.add(d44);
        return new DescriptorValue(this.getSpecification(), this.getParameterNames(), this.getParameters(), doubleArrayResult, this.getDescriptorNames());
    }

    private HashMap<ArrayList<Coordinate>, Integer> getClasses(IAtomContainer iAtomContainer, Integer n) {
        HashMap<ArrayList<Coordinate>, Integer> hashMap = new HashMap<ArrayList<Coordinate>, Integer>();
        for (IAtom iAtom : iAtomContainer.atoms()) {
            List<List<IAtom>> list = PathTools.getPathsOfLength(iAtomContainer, iAtom, n);
            if (list.isEmpty()) continue;
            ArrayList<Coordinate> arrayList = new ArrayList<Coordinate>();
            for (List<IAtom> list2 : list) {
                IAtom iAtom2 = null;
                for (IAtom iAtom3 : list2) {
                    if (iAtom2 != null) {
                        Coordinate coordinate = new Coordinate();
                        coordinate.a = iAtom3.getAtomicNumber();
                        coordinate.delta = iAtomContainer.getConnectedAtomsCount(iAtom3);
                        coordinate.pi = iAtomContainer.getBond(iAtom3, iAtom2).getOrder();
                        arrayList.add(coordinate);
                    }
                    iAtom2 = iAtom3;
                }
            }
            Collections.sort(arrayList);
            ArrayList arrayList2 = new ArrayList();
            Coordinate object2 = new Coordinate();
            object2.a = iAtom.getAtomicNumber();
            arrayList2.add(object2);
            arrayList2.addAll(arrayList);
            if (hashMap.containsKey(arrayList2)) {
                hashMap.put(arrayList2, hashMap.get(arrayList2) + 1);
                continue;
            }
            hashMap.put(arrayList2, 1);
        }
        return hashMap;
    }

    private double evalInfoContent(HashMap<ArrayList<Coordinate>, Integer> hashMap, IAtomContainer iAtomContainer) {
        int n = iAtomContainer.getAtomCount();
        double d = 0.0;
        for (Integer n2 : hashMap.values()) {
            double d2 = n2.doubleValue() / (double)n;
            d += d2 * Math.log(d2) / Math.log(2.0);
        }
        return -d;
    }

    private double evalModInfoContent(HashMap<ArrayList<Coordinate>, Integer> hashMap, IAtomContainer iAtomContainer) {
        int n = iAtomContainer.getAtomCount();
        double d = 0.0;
        for (ArrayList<Coordinate> arrayList : hashMap.keySet()) {
            Integer n2 = hashMap.get(arrayList);
            double d2 = n2.doubleValue() / (double)n;
            double d3 = 0.0;
            try {
                d3 = IsotopeFactory.getInstance(iAtomContainer.getBuilder()).getMajorIsotope(arrayList.get((int)0).a).getExactMass();
            }
            catch (IOException iOException) {
                Logger.getLogger(InformationContentDescriptor.class.getName()).log(Level.SEVERE, null, iOException);
            }
            d += d3 * d2 * Math.log(d2) / Math.log(2.0);
        }
        return -d;
    }

    private double evalZModInfoContent(HashMap<ArrayList<Coordinate>, Integer> hashMap, IAtomContainer iAtomContainer) {
        int n = iAtomContainer.getAtomCount();
        double d = 0.0;
        for (ArrayList<Coordinate> arrayList : hashMap.keySet()) {
            Integer n2 = hashMap.get(arrayList);
            double d2 = n2.doubleValue() / (double)n;
            d += (double)(arrayList.get((int)0).a * n2) * d2 * Math.log(d2) / Math.log(2.0);
        }
        return -d;
    }

    @Override
    public IDescriptorResult getDescriptorResultType() {
        return new DoubleArrayResultType(names.length);
    }

    private class Coordinate
    implements Comparable<Coordinate> {
        public int a = 0;
        public int delta = 0;
        public IBond.Order pi = null;

        private Coordinate() {
        }

        public boolean equals(Object object) {
            if (!(object instanceof Coordinate)) {
                return false;
            }
            Coordinate coordinate = (Coordinate)object;
            return this.a == coordinate.a && this.delta == coordinate.delta && this.pi == coordinate.pi;
        }

        public int hashCode() {
            int n = 3;
            n = 31 * n + this.a;
            n = 31 * n + this.delta;
            n = 31 * n + (this.pi != null ? this.pi.hashCode() : 0);
            return n;
        }

        @Override
        public int compareTo(Coordinate coordinate) {
            int n = this.a - coordinate.a;
            if (n == 0) {
                n = this.delta - coordinate.delta;
            }
            if (n == 0 && this.pi != null && coordinate.pi != null) {
                n = this.pi.compareTo(coordinate.pi);
            }
            return n;
        }
    }
}

