/*
 * Decompiled with CFR 0.152.
 */
package ambit2.core.io;

import ambit2.base.data.ILiteratureEntry;
import ambit2.base.data.LiteratureEntry;
import ambit2.base.data.Property;
import ambit2.core.io.IteratingFilesWithHeaderReader;
import ambit2.core.io.XLSFileFormat;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.TreeMap;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Sheet;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.exception.InvalidSmilesException;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IMolecule;
import org.openscience.cdk.io.formats.IResourceFormat;
import org.openscience.cdk.io.setting.IOSetting;
import org.openscience.cdk.io.setting.StringIOSetting;
import org.openscience.cdk.silent.SilentChemObjectBuilder;

public class IteratingXLSReader
extends IteratingFilesWithHeaderReader<Property> {
    protected HSSFWorkbook workbook;
    protected HSSFSheet sheet;
    protected Iterator iterator;
    protected InputStream input;
    protected int sheetIndex = 0;

    public IteratingXLSReader(InputStream inputStream, int n) throws CDKException {
        this.sheetIndex = n;
        this.setReader(inputStream);
    }

    @Override
    protected ArrayList<Property> createHeader() {
        return new ArrayList<Property>();
    }

    @Override
    protected Property createPropertyByColumnName(String string) {
        return Property.getInstance((String)string, (ILiteratureEntry)this.getReference());
    }

    public void setReader(InputStream inputStream) throws CDKException {
        try {
            this.input = inputStream;
            this.workbook = new HSSFWorkbook(inputStream);
            this.sheet = this.workbook.getSheetAt(this.sheetIndex);
        }
        catch (Exception exception) {
            throw new CDKException(exception.getMessage(), (Throwable)exception);
        }
    }

    public void setReader(Reader reader) throws CDKException {
        throw new CDKException("Not implemented");
    }

    @Override
    protected LiteratureEntry getReference() {
        return LiteratureEntry.getInstance((String)this.workbook.getSheetName(this.workbook.getSheetIndex((Sheet)this.sheet)), (String)((Object)((Object)this)).getClass().getName());
    }

    public void processHeader() {
        this.iterator = this.sheet.rowIterator();
        this.processHeader((HSSFRow)this.iterator.next());
        for (int i = 1; i < this.getNumberOfHeaderLines(); ++i) {
            this.processHeader((HSSFRow)this.iterator.next());
        }
    }

    public void close() throws IOException {
        this.input.close();
        this.input = null;
        this.iterator = null;
        this.sheet = null;
        this.workbook = null;
    }

    public boolean hasNext() {
        if (this.isHeaderEmpty()) {
            this.fireIOSettingQuestion((IOSetting)new StringIOSetting("", 1, Property.IO_QUESTION.IO_START.toString(), ""));
            this.processHeader();
            this.fireIOSettingQuestion((IOSetting)new StringIOSetting("", 1, Property.IO_QUESTION.IO_STOP.toString(), ""));
        }
        try {
            return this.iterator.hasNext();
        }
        catch (Exception exception) {
            logger.error((Object)exception);
            return false;
        }
    }

    protected void processRow(IAtomContainer iAtomContainer) {
    }

    public Object next() {
        IMolecule iMolecule = null;
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        try {
            HSSFRow hSSFRow = (HSSFRow)this.iterator.next();
            for (int i = 0; i < this.getNumberOfColumns(); ++i) {
                HSSFCell hSSFCell = hSSFRow.getCell(i);
                Object object = null;
                if (hSSFCell != null) {
                    switch (hSSFCell.getCellType()) {
                        case 4: {
                            object = hSSFCell.getBooleanCellValue();
                            break;
                        }
                        case 0: {
                            object = hSSFCell.getNumericCellValue();
                            break;
                        }
                        case 1: {
                            object = hSSFCell.getStringCellValue();
                            break;
                        }
                        case 3: {
                            object = "";
                            break;
                        }
                        case 5: {
                            object = "";
                            break;
                        }
                        case 2: {
                            try {
                                object = hSSFCell.getStringCellValue();
                                break;
                            }
                            catch (Exception exception) {
                                try {
                                    object = hSSFCell.getNumericCellValue();
                                    break;
                                }
                                catch (Exception exception2) {
                                    exception.printStackTrace();
                                }
                            }
                        }
                    }
                } else {
                    object = "";
                }
                try {
                    if (this.smilesIndex == i) {
                        try {
                            iMolecule = this.sp.parseSmiles(object.toString());
                            hashtable.put("SMILES", object.toString());
                        }
                        catch (InvalidSmilesException invalidSmilesException) {
                            logger.warn((Object)("Invalid SMILES!\t" + object));
                            hashtable.put("SMILES", "Invalid SMILES");
                        }
                        continue;
                    }
                    if (i >= this.getNumberOfColumns()) continue;
                    hashtable.put((String)this.getHeaderColumn(i), object);
                    continue;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            if (iMolecule == null) {
                iMolecule = (IMolecule)SilentChemObjectBuilder.getInstance().newInstance(IMolecule.class, new Object[0]);
            }
            iMolecule.setProperties(hashtable);
            this.processRow((IAtomContainer)iMolecule);
        }
        catch (Exception exception) {
            logger.error((Object)exception);
        }
        return iMolecule;
    }

    protected void processHeader(HSSFRow hSSFRow) {
        Iterator iterator = hSSFRow.cellIterator();
        TreeMap<Integer, Object> treeMap = new TreeMap<Integer, Object>();
        while (iterator.hasNext()) {
            HSSFCell hSSFCell = (HSSFCell)iterator.next();
            Object object = hSSFCell.getStringCellValue();
            if (((String)object).equals(defaultSMILESHeader)) {
                this.smilesIndex = hSSFCell.getColumnIndex();
            }
            treeMap.put(new Integer(hSSFCell.getColumnIndex()), object);
        }
        for (Object object : treeMap.keySet()) {
            this.setHeaderColumn((Integer)object, treeMap.get(object).toString());
        }
    }

    public String toString() {
        return "Reads Microsoft Office Excel file (*.xls) ";
    }

    public IResourceFormat getFormat() {
        return new XLSFileFormat();
    }
}

